// CM11
#include <stdio.h>
#include <comm.h>
#include <window.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	ITEMS	16
#define	IEXEC	0x5A

#define	TICK	peekw(0x40,0x6C)
#define	RDEL	100					// Reset delay
#define	POOL	8192

#define	VNOR	0x07
#define	VHIL	0x0A
#define	VSEL	0x10

#define	O_AOE	0x01	// AllOff on Exit
#define	O_PAUSE	0x02	// Pause after >
#define	O_HC	0x80	// H= was supplied

unsigned
	Line,
	Cport = 1,
	Lgc,
	Ctime = 18*3,	// COM timeout (first)
	Ctime1 = 10,	// COM timeout
	Ktime = 200,	// Key timeout
	Sel,
	Itop,
	Ptop;
FILE
	*fp;
unsigned char
	*Ptr,
	*Itext[ITEMS],
	Opt = O_PAUSE,
	Act,
	Dbg,	// 01=Rx/Tx 02=Chk 04=Wait
	Reset = 0xFF,
	House,
	In[ITEMS],
	Obuf[256],
	Buffer[128],
	Pool[POOL];

unsigned char Code[] = {
//A	B	C	D	E	F	G	H	I	J	K	L	M	N	O	P
0x6,0xE,0x2,0xA,0x1,0x9,0x5,0xD,0x7,0xF,0x3,0xB,0x0,0x8,0x4,0xC };

//ChtTxt R:\Help.h
#include "R:\\Help.h"

unsigned char Xkey[] = { 'X'&31, 'Y'&31, 'Z'&31, 'Z'&31, 'Y'&31 };

void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Sp(void)				{	Pc(' ');			}
void Nl(void)				{	Pc('\n');			}

void Xhelp(unsigned char *p)
{
	unsigned char c;
	while(c = *p++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				Sp();
			continue; }
		Pc(c); }
	exit(0);
}
void DoHelp(void)	{	Xhelp(Chelp);	}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
	if(Line) printf("%u: ", Line);
	if(Act & 0x0C)
		wclose();
	Ps(buf);
	if(Act & 3)
		Cclose();
	if(*buf == '!')
		Xhelp(Ehelp);
	exit(-1);
}
void X10err(unsigned c)
{
	Error("!X10 error: %u\n", c);
/*ChtTxt Ehelp
	1	No/Bad checksum
	2	No acknowlege
*/
}

register Dprintf(unsigned args)
{
	unsigned char buf[200];
	unsigned *ap;
	if( *(unsigned char*)*(ap = (nargs()-1) * 2 + &args) & Dbg) {
		_format_(ap+2, buf);
		if(Act & 0xC0) {
			wputs(buf+1);
			return; }
		Ps(buf+1); }
}

void Abort(void)
{
	if(kbtst() == 0x1B)
		Error("?ESCabort");
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?PoolOverflow"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

void Wait(unsigned ms)
{
	Dprintf("\x04{Wait%u}", ms);
	delay(ms);
	Abort();
}

void Cflush(void)
{
	unsigned i, j, t;
	Cputc(0xC3);
	t = 5;
	for(;;) {
		if(i = Ctestc())
			Dprintf("\x02{pf%02x}");
		if( (i = TICK) != j) {
			j = i;
			if(!--t)
				return; } }
}

void X10pc(unsigned char c)
{
	unsigned i;
	switch(i = Ctestc()) {
	case 0xA5:
		if(Reset & 0xF0) {
			Dprintf("\x02{pRST}");
			Abort();
			Cputc(0x9B);
			Reset = 0x00;
			Wait(RDEL);
			return; }
	case 0x5A:	Cflush();
	default	:	Dprintf("\x02{pt%02x}", i);
	case -1	:	; }
	if(Reset & 0x0F) {
		Dprintf("\x01{p%02x}", c);
		Cputc(c); }
}

unsigned X10gc(void)
{
	unsigned i, j, k;
	i = Ctime;
	for(;;) {
		switch(Lgc = Ctestc()) {
		case 0xA5:
			if(Reset & 0xF0) {
				Dprintf("\x02{gRST}");
				Abort();
				Cputc(0x9B);
				Reset = 0x00;
				Wait(RDEL); }
		default	:	return Lgc;
		case -1	:	; }
		if( (j = TICK) != k) {
			Dprintf("\x01.");
			if(!--i) {
				Dprintf("\x01\n");
				Abort();
				return -1; }
			k = j; } }
}

void Ob(unsigned char b)
{
	Obuf[++*Obuf] = b;
}
void Ow(unsigned w)
{
	Ob(w & 255);
	Ob(w >> 4);
}
void X10o(unsigned char *p, unsigned ti)
{
	unsigned i, j, l, r, r1;
	unsigned char ck, c;
	l = *p++;
	r1 = 3;
a0:	r = 3;
a1:	ck = i = 0;
	while(i < l) {
		X10pc(c = p[i++]);
		if(!Reset) {
			Reset = 0xFF;
			goto a0; }	//A1
		ck += c; }
	Dprintf("\x02[%02x", ck);
	X10gc();
	if(!Reset) {
		Reset = 0xFF;
		goto a1; }	//A1
	Dprintf("\x02%02x]", Lgc);
	Reset = 7;
	Ctime = Ctime1;
	if(Lgc != ck) {
		if(--r)
			goto a1;
		X10err(1); }
	X10pc(0);
	r = ti;
	do {
		if( (i = TICK) != j) {
			if(!--r) {
				if(--r1)
					goto a0;
				X10err(2); }
			j = i; } }
	while(Ctestc() != 0x55);
	Dprintf("\x01\n");
}

void Addr(unsigned u)
{
	*Obuf = 0;
	Ob(0x04);
	Ob(Code[u & 127]|House);
	X10o(Obuf, 10);
}
void On(void)
{
	*Obuf = 0;
	Ob(0x86);
	Ob(House|2);
	X10o(Obuf, 100);
}
void Off(void)
{
	*Obuf = 0;
	Ob(0x86);
	Ob(House|3);
	X10o(Obuf, 100);
}
/*void AllOn(void)
{
	*Obuf = 0;
	Ob(0x86);
	Ob(House|1);
	X10o(Obuf, 100);
}*/
void AllOff(void)
{
	*Obuf = 0;
	Ob(0x86);
	Ob(House|0);
	X10o(Obuf, 100);
}

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

//Trim spaces from string
unsigned Trim(void)
{
	unsigned i;
	i = 0;
	while(Ptr[i])					++i;
	while(i && isspace(Ptr[i-1]))	--i;
	Ptr[i] = 0;
	return i;
}

unsigned Value(void)
{
	unsigned v, c;
	Skip();
	v = 0;
a1:	switch(*Ptr) {
	default	:
		if( (c = *Ptr++ - '0') >= 10)
			Error("?BadValue");
		v = (v * 10) + c;
		goto a1;
	case ' ':
	case'\t':
	case 0	:	; }
	return v;
}

unsigned Wgetc(void)
{
	unsigned i, j, r, s;
	static unsigned X;
a1:	r = Ktime;
	s = 18;
	for(;;) {
		switch(i = wtstc()) {
		default	:
			if(i == Xkey[X]) {
				if(++X >= sizeof(Xkey)) {
					wclose();
					Cclose();
					exit(55); }
				break; }
			X = 0;
			return toupper(i);
		case ' ':	goto a1;
		case 0	:	; }
		switch(Ctestc()) {
		case 0x5A:	Cflush(); }
		if( (i = TICK) != j) {
			j = i;
			if(!--s) {
				wgotoxy(76, 24);
				wprintf("%4u", r);
				s = 18;
				if(!--r)
					return 0x1B; } } }
}

unsigned Interactive(void)
{
	unsigned i;
	unsigned char c;
	wgotoxy(0, 24);
	wputs(
"\x18\x19=PICK Enter=TOGGLE \x1B',<'=OFF \x1A'.>'=ON Esc'X'=EXIT");
	wgotoxy(72, 24); wputs("' '=");
a1:	for(i=0; i <= Itop; ++i) {
		wgotoxy(5, i+2);
		wputc(i+'A');
		wputs(": ");
		c = (In[i] & 0x80) ? VHIL : VNOR;		
		*W_OPEN = (i == Sel) ? c|VSEL : c;
		wputs((i < Itop) ? Itext[i] : "** All Off **");
		*W_OPEN = VNOR;
		wcleol(); }
b1:	switch(i = Wgetc()) {
	default	:
		if( (i-='A') <= Itop) {
			Sel = i;
			goto a1; }
		goto b1;
	case _KUA:	i = Sel-1; goto b2;
	case _KDA:	i = Sel+1;
b2:		if(i <= Itop) {
			Sel = i;
			goto a1; }
		goto b1;
	case _KHO:
	case _KPU:	Sel = 0;		goto a1;
	case _KEN:
	case _KPD:	Sel = Itop-1;	goto a1;
	case '\n':
	case '\r':
		if(In[Sel] & 0x80)
			goto off;
	case _KRA:
	case '.':
	case '>':
		return 0x0C;
	case _KLA:
	case ',':
	case '<':
off:	return 0x03;
	case 'X':
	case 0x1B:	return 0; }
}

void Wtitle(unsigned char *p)
{
	wclwin();
	wgotoxy((80-strlen(p))/2, 0);
	wputs(p);
}

void Wdebug(void)
{
	wgotoxy(0, Itop+3);
	wcleow();
}


void ComST1(void)
{
	if(Copen(Cport, _4800, PAR_NO|DATA_8|STOP_1, /*SET_RTS|SET_DTR|*/OUTPUT_2))
		Error("?COM%u: fail to open", Cport);
	Cflags |= TRANSPARENT;
	Act = 3;
}
void ComStart(void)
{
	if(!(Opt & O_HC))
		DoHelp();
	if(House & 0xFFF0)
		Error("?BadHouseCode");
	House = Code[House] << 4;
//*/Error("C=%u H=%x\n", Cport, House);
	ComST1();
}

main(int argc, char *argv[])
{
	unsigned i, j;
	unsigned char c;

	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(c = toupper(*Ptr++)) {
			default	:	DoHelp();
/*ChtTxt Chelp
X10/CM11 control			Dave Dunfield	https://dunfield.themindfactory.com

use:	CM11	[file[.INI]] [optiopns]

opts:	-C{1-4}		set COM port				[1]
		-Tn			""	""	tineout				(55ms ticks)
		-Kn			"" Key	""					(Seconds)
		-H{A-P}		"" Housecode				\	Must be supplied for
		-N{1-16}	turn oN unit				 >	-N or -F, if neither
		-F{0-16}	""  oFf	""	 (0=all)		/	assumes  interactive
		-E			"" ""	all	units at Exit
		-Dn			set Debug

Performs X10 operations via a CM11/HD11 comnected to a COM (serial) port.

If file, interactive session.
*/
			case 'D':
				if(!(Dbg = Value()))
					Error("-D 01=X10 02=Wait");
				continue;
			case 'T':
				Ctime1 = Value();
				continue;
			case 'K':
				Ktime = Value();
				continue;
			case 'N':	// On
				j = Value();
				c = 0;
				goto o3;
			case 'F':	// Off
				c = 0x80;
				if(!(j = Value()))
					j = 255;
				else {
o3:					if((j-1) & 0xFFF0) {
bu:						Error("?BadUnit{1-16}"); } }
				Pool[Ptop++] = j | c;
				continue;
			case 'C':
				if( (j = *Ptr++ - '1') > 3)
					DoHelp();
				Cport = j+1;
				break;
			case 'H':
				House = toupper(*Ptr++) - 'A';
				c = O_HC;
				goto o2;
			case 'P':	c = O_PAUSE;	goto o2;
			case 'E':	c = O_AOE;
o2:				Opt |= c; }
			if(*Ptr) goto o1;
			continue; }
		if(*Buffer) DoHelp();
		strcpy(Buffer, Ptr); }


	if(Ptop) {	// Command Line on/off
		if(*Buffer)
			DoHelp();
		ComStart();
		for(i=0; i < Ptop; ++i) {
			if( (c = Pool[i]) & 0x80) {
				if(--c & 0x70) {
					AllOff();
					continue; }
				Addr(c);
				Off();
				continue; }
			Addr(c-1);
			On(); }
		Cclose();
		return; }

	if(!*Buffer)
		DoHelp();

	i = 0;
a1:	j = 0;
a2:	switch(Buffer[i++]) {
	case ':':
	case'\\':	goto a1;
	case '.':	j = i;
	default	:	goto a2;
	case 0	:	; }
	if(!j)
		strcpy(Buffer+i-1, ".INI");

	fp = fopen(Buffer, "rvq");
	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
		++Line;
		switch(Skip()) {
		case '=':
			if(!(Opt & O_HC)) {
				House = toupper(Ptr[1]) - 'A';
				Opt |= O_HC; }
		case ';':
		case 0	:	continue;
		case '>':	++Ptr; i = IEXEC; break;
		default	:
			if( (i = Value() - 1) & 0xFFF0)
				goto bu; }
		Skip(); Trim();
		if(Itop >= ITEMS)
			Error("?TooManyItems");
//		if(i & 1) i ^= 0x80;
		In[Itop] = i;
		Itext[Itop++] = Pstring(Ptr); }
	fclose(fp); Line = 0;
	if(!Itop)
		Error("?No.INIdefs");

	ComStart();
#if 7
b1:	wopen(0, 0, 80, 25, WSAVE|VNOR);
	Act = 255;
	wcursor_off();
	for(;;) {
		Wtitle("** X10 control **");
		if(!(i = Interactive())) {
			if(Opt & O_AOE) {
				Wtitle("** Exiting ** AllOff **");
				AllOff(); }
			wclose();
			Cclose();
			return; }
		wgotoxy(0, 0);
		wcleol();
		if(Sel < Itop) {
			if((j = In[Sel] & 0x7F) > 15) {
				if(j != IEXEC) continue;
				wclose();
				Cclose();
				Pc('>');  Ps(Ptr = Itext[Sel]); Nl();
				system(Ptr);
				if(Opt & O_PAUSE) {
					Pc('?');
b2:					switch(toupper(kbget())) {
					default	:	goto b2;
					case 0x1B:	Error("?ESCabort");
					case'\r':
					case ' ':	Nl(); } }
				ComST1();
				goto b1; }
			if(i & 0x03) {
				wprintf("Turning OFF %s\n", Itext[Sel]);
				Wdebug();
				Addr(In[Sel] &= 0x7F);
				Off(); }
			if(i & 0x0C) {
				wprintf("Turning ON %s\n", Itext[Sel]);
				Wdebug();
				Addr(In[Sel] |= 0x80);
				On(); }
		} else {
			wprintf("All OFF\n");
			for(i = 0; i < Itop; ++i)
				In[i] &= 0x7F;
			Wdebug();
			AllOff(); } }
#endif

#if 0
	i = 100;
	do {
		if( (c = Ctestc()) != -1) {
			printf("{%x}\n", c);
			if(c == 0xA5)
				break; }
		if( (j = TICK) != k) {
			k = j;
			--i; } }
	while(i);

	X10pc(0x9B);
	delay(200);

	Ob(0x9B);
//	s		m		h		d	mtw
	Ob(1); Ob(1); Ob(1); Ob(1); Ob(1); Ob(House|7);
	X10o(Obuf, 100);
#endif

	Addr(0);
	On();
	Wait(1000);
	Addr(0);
	AllOff();

	Cclose();
}
/*	 7         6         5         4         3         2         1         0
	109876543210987654321098765432109876543210987654321098765432109876543210
	<------><------><------><------><------><------><------><------><------>
St					10011011ssssssssmmmmmmmmhhhhhhhhddddddddDSMTWTFSHHHH-tbm
*/
