/* TIMER
 * Someone I was helping posted samples of programs he had done and I kinda
 * liked his TIMER - he'd used"TrueBasic" and the .EXE was 101,554 bytes.
 * To show there might be better ways, I tossed together this little edition
 * in Micro-C (with improvements like large-digit countdown) < 1/20 size! */
#include <stdio.h>
#include <window.h>

#define	O_REPT	0x01

unsigned
	Sel,			// Selected entry
	Ndig,			// # digits
	BeepF,			// BeepFrequency
	BeepL,			// BeepLength
	BeepN,			// NumberBeeps
	TimeS,			// TimeSelected
	Tk, Tx;			// Tick manipulation
unsigned char
	*Ptr,			// General pointer
	Opt,			// Command line options
	Temp[16];		// Temp string
unsigned Times[] = {
	5, 10, 20, 30, 45, 60, 90,
	120, 180, 240, 300, 360, 420, 480, 540, 600,
	900, 1200, 1500, 1800, 2100, 2400, 2700, 3000, 3300, 3600,
	4500, 5400, 6300, 7200, 8100, 9000,9900, 10800, 11700, 12600,
	13500, 14400, 15300, 16200, 17100, 18000,
	0 };

unsigned char Cgen[10][8] = {
	0x3C, 0x42, 0x81, 0x81, 0x81, 0x81, 0x42, 0x3C,
	0x08, 0x18, 0x38, 0x18, 0x18, 0x18, 0x18, 0xFF,
	0x1C, 0x36, 0x63, 0x06, 0x0C, 0x18, 0x18, 0xFF,
	0x7C, 0x82, 0x01, 0x3E, 0x01, 0x01, 0x82, 0x7C,
	0x0C, 0x14, 0x24, 0x44, 0xFF, 0x04, 0x04, 0x04,
	0xFE, 0x80, 0x80, 0xBE, 0xC1, 0x01, 0x81, 0x7E,
	0x7E, 0x80, 0x80, 0xFE, 0x81, 0x81, 0x81, 0x7E,
	0xFF, 0x01, 0x02, 0x04, 0x08, 0x08, 0x08, 0x08,
	0x7E, 0x81, 0x81, 0x7E, 0x81, 0x81, 0x81, 0x7E,
	0x7E, 0x81, 0x81, 0x7F, 0x01, 0x01, 0x01, 0x7E }

#define	NTIME	((sizeof(Times)-4)/2)
//ChtTxt R:\Help.H
#include "R:\\Help.H"

#define	TICK	peekw(0x40, 0x6C)

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}

// Wait 1 second
void Wait1(void)
{
	unsigned i, j;
	i = 18;
	do {
		while((j = TICK) == Tk);
		Tk = j;
	} while --i;
}

// Get value
unsigned Value(unsigned char e)
{
	unsigned i, v;
	unsigned char *p;
	p = Ptr;
	v = 0;
	while((i = *Ptr - '0') < 10) {
		v = (v * 10) + i;
		++Ptr; }
	if((Ptr == p) || (*Ptr != e))
		Error("?BadNumber'%s'\n", p);
	if(e) ++Ptr;
	return v ;
}

void ShowDigit(unsigned x, unsigned v)
{
	unsigned i;
	unsigned char b, c;
	for(i=0; i < 8; ++i) {
		wgotoxy(x, i+5);
		c = Cgen[v][i];
		for(b = 0x80; b; b >>= 1)
			wputc((c & b) ? 0xDB : ' '); }

}
void ShowNum(unsigned v)
{
	unsigned i, j, x;
	x = (Ndig*4)+38;
	i = Ndig;
	while(i) {
		if((j = v%10) != Temp[--i])
			ShowDigit(x, Temp[i] = j);
		x -= 10;
		v /= 10; }
}

main(int argc, char *argv[])
{
	unsigned i, j, k, s, m;
	unsigned char c;
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default :	goto he;
/*ChtTxt Chelp
use:	TIMER [seconds] [options]

opts:	-Bcycles,msec		Beep parameters							  [500,100]
		-Nn					Number of beeps						   [continuous]
		-R					Repeat prompt after after expiry

If seconds is not given, TIMER prompts with a menu of common times.

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'B':
				BeepF = Value(',');
				BeepL = Value(0);
				continue;
			case 'N':
				BeepN = Value(0);
				continue;
			case 'R':	c = O_REPT;
				Opt ^= c;
			} if(*Ptr) goto o1;
			continue; }
		if(TimeS) {
he:			Ptr = Chelp;
			while(c = *Ptr++) {
				if(c & 0x80) {
					while(c-- & 0x7F)
						putc(' ', stdout);
					continue; }
				putc(c, stdout); }
			return; }
		TimeS = Value(0); }

	if(BeepF < 100)	BeepF = 500;
	if(BeepL < 55)	BeepL = 55*3;

	wopen(0, 0, 80, 25, WSAVE|WCOPEN|0x07);
	wgotoxy(68, 0); wputs("cmd help: -?");
a0:	wgotoxy(36, 0); wputs("TIMER");
	wcursor_off();
	if(s = TimeS)
		goto a3;
	wgotoxy(15, 24); wputs("RUN = ENTER");
	wgotoxy(55, 24); wputs("QUIT =  ESC");
a1:	if(Sel & 0x8000)
		Sel = 0;
	if(Sel > NTIME)
		Sel = NTIME;
	j = 10;
	k = 2;
	*W_OPEN = c = 0x02;
	for(i=0; s = Times[i]; ++i) {
		if(k > 22) {
			j = 50;
			k = 2; }
		wgotoxy(j, k++);
		switch(s) {
		case 60	:
		case 600:
		case 3600:
		case 7200:
		case 10800:
		case 14400:
		case 18000:
			c ^= 0x01; }
		*W_OPEN = (i == Sel) ? (c|0x70) : c;
		wprintf("%5us", s);
		if(m = s / 60) {
			sprintf(Temp, (s%60) ? "%u.5" : "%u", m);
			wprintf("  (%3sm)", Temp); } }
a2:	switch(wgetc()) {
	default	:	goto a2;
	case _KUA:	--Sel;			goto a1;
	case _KLA:	Sel -= 21;		goto a1;
	case _KDA:	++Sel;			goto a1;
	case _KRA:	Sel += 21;		goto a1;
	case _KPU:
	case _KHO:	Sel = 0;		goto a1;
	case _KPD:
	case _KEN:	Sel = NTIME;	goto a1;
	case 0x1B:	goto ex;
	case'\n':	s = Times[Sel]; }
a3:	Ndig = 0;
	i = s;
	do { ++Ndig; } while(i /= 10);
	*W_OPEN = 0x07;
	wclwin();
	wgotoxy(40, 24); wputs("STOP =  ESC");
	Tk = TICK;
	Tx=i=0;
	memset(Temp, 0xFF, 6);
	do {
		ShowNum(s-i);
		if(wtstc() == 0x1B)
			goto b1;
		wgotoxy(28, 17);
		k = (j = ++i / 60) / 60;
		wprintf("%5u of %u sec (%2u:%02u:%02u)", i, s, k, j%60, i%60);
		Wait1();
	} while i < s;
	ShowNum(0);
	wgotoxy(40, 14);
	*W_OPEN = 0x47;
	wputs(" ***ALERT*** ");
	i = BeepL*3;
	j = BeepN;
	do {
		beep(BeepF, BeepL);
		if(j && !--j) break;
		delay(i);
	} while(wtstc() != 0x1B);
b1:	if(Opt & O_REPT) {
		TimeS = 0;
		*W_OPEN = 0x07;
		wclwin();
		goto a0; }
ex:	wclose();
}
