/* IDFSC
 * THis came from someone asking how to "read bytes at offsets in .EXE file"
 * into a .BAT file - basically he was looking for a way to determine if
 * certain patches has been applied to the game he was running....
 * I offered this as a way to tell very similar files apart.
 * It worked well for him! */
#include <stdio.h>
#include <file.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	IDS		32
#define	POOL	8192

#define	O_VERB	0x01
#define	O_TEST	0x02

unsigned
	IDtop,				// Top of ID list
	Lbase[2],			// Long number base
	CSo,				// CharacterSet Offset
	Size,				// Calculated file Size
	Crc,				// Computed CRC value
	CrcTable[256];		// CRC calculation table
HANDLE
	fh;
unsigned char
	*Ptr,				// General pointer
	*IDval[IDS],		// IDstrings to test
	Opt,				// Command line options
	Cset[257],			// ID character set (+z for dispaly)
	Buffer[8192];		// General buffer
extern unsigned Longreg[];

//ChtTxt R:\Help.H
#include "R:\\Help.H"

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
	fputs(buf, stdout);
	exit(-1);
}

// Print only if -V
register Printf(unsigned args)
{
	unsigned n;
	unsigned char buf[200];
	n = nargs();
	if(Opt & O_VERB) {
		_format_(n*2+&args, buf);
		fputs(buf, stdout); }
}

// Build the pre-calculated CRC table
void BuildCrcTable(void)
{
	unsigned c, i, j;
	// Build the pre-computed CRC table
	for(i=0; i < 256; ++i) {
		c = i << 8;
		for(j=0; j < 8; ++j)
			c = ((c & 0x8000) ? 0x1021 : 0) ^ (c << 1);
		CrcTable[i] = c; }
}

// Compute a CRC over a buffer
void DoCrc(unsigned char *data, unsigned len)
{
	unsigned i;
	for(i = 0; i < len; ++i)
		Crc = CrcTable[Crc >> 8] ^ (Crc << 8) ^ *data++;
}

// Set CharacterSet entries
void SetCS(unsigned v, unsigned n)
{
	do {
		Cset[CSo++] = v++;
	} while --n;
}

// ConVerT a h:l value into an IDstring
void CVTval(unsigned char *dst, unsigned h, unsigned l)
{
	unsigned lv[2];
	lv[1] = h; *lv = l;
	do {
		longdiv(lv, Lbase);
		*dst++ = Cset[*Longreg]; }
	while(longtst(lv));
	*dst = 0;
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;

	// Create the charactr set
	SetCS('0', 10);
	Cset[CSo++] = '_';
	SetCS('a', 26);
	Cset[CSo++]	= '.';
	SetCS('A', 26);
	longset(Lbase, CSo);

	// Parse command arguments
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
/*ChtTxt Chelp
IDentify File by Size and Crc

use: IDFSC filename [idstring]... [options]

opts:	-T		Test (show Progress, allow ESC to exit)
		-V		Verbise (show progress)

Calculates an idstring based on size/CRC to identify the specified file.

If [idstring]s are given, return ERRORLEVEL indicatine which [idstring]
matches the file [1+], or 0 if no match was found!

If no [idstring] is given, the calculated idstring for the file is displayed.

IDstring may contain only the following characters:
	~$80

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'T':	c = O_TEST;	goto o2;
			case 'V':	c = O_VERB;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		if(!*Buffer) {		// Filename
			strcpy(Buffer, Ptr);
			continue; }
		if(IDtop >= IDS)	// IDstring
			Error("?IDvalues");
		IDval[IDtop++] = Ptr;
		while(c = *Ptr++) {
			if(!strchr(Cset, c))
				goto he; } }

	if(!*Buffer) {	// No filename, show help
he:		Ptr = Chelp;
		while(c = *Ptr++) {
			if(c == 0x80) {
				fputs(Cset, stdout);
				continue; }
			if(c & 0x80) {
				while(c-- & 0x7F)
					putc(' ', stdout);
				continue; }
			putc(c, stdout); }
		return; }

	BuildCrcTable();
	// Read file & generate size:CRC
	if(!(fh = open(Buffer, F_READ|F_BINARY)))
		Error("?OoenFail: %s\n", Buffer);
	Crc = -1;	// Initial CRC all 1s
	while(i = read(Buffer, sizeof(Buffer), fh)) {
		Size += i;
		DoCrc(Buffer, i);
		if(!--c) {
			if(Opt & O_TEST) {
				putc('.', stdout);
				if(kbtst() == 0x1B)
					Error("?Abort"); } } }
	close(fh);
	CVTval(Buffer, Size, Crc);
	Debug(("%04x-%04x\n", Size, Crc))

	if(!IDtop) {	// No IDstrings given - show calculated
		printf("%s\n", Buffer);
		return; }

	// Lookup IDstring in those given
	Printf("ID= %s\n", Buffer);
	i = 0;
	while(i < IDtop) {
		Debug(("TstID%u'%s'\n", i, IDval[i]))
		if(!strcmp(IDval[i++], Buffer)) {
			Printf("Match %u\n", i);
			exit(i); } }
	Printf("NoMatch!\n");
	// Micro-C will exit ERRORLEVEL=0 when main() returns
}
