/* CMDOSS
 * Somone looking for help in .BAT files wanted a way to tell if a command not
 * supporting ERRORLEVEL in the way he liked had succeded (or performed other
 * actions) - I suggested writing a tool to "scan for output on the screen".
 * Recalling that I had once done this, I dug through my archives, and found
 * this - which I cleaned up and made available. */
#include <stdio.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	MemTst(a)

#define	MAXH	64
#define	MAXW	200
#define	MAXF	16
#define	POOL	8192

#define	O_VERB	0x01

unsigned
	Height = 25,			// Screen height
	Width = 80,				//  "" width
	Dline = 1,				// Drop Lines (SCRLST command)
	Nline,					// Last # lines to check
	Ftop,					// Top of Find list
	Ptop;					// Top of string pool
unsigned char
	*Ptr,					// General pointer
	*Find[MAXF],			// Find list
	Opt = O_VERB,			// Command line options
	Screen[MAXH][MAXW+1],	// Saved screen
	Pool[POOL];				// String pool
//ChtTxt R:\Help.h
#include "R:\\Help.h"

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}

// Print only if !Quiet
register Printf(unsigned args)
{
	unsigned n;
	unsigned char buf[200];
	n = nargs();
	if(Opt & O_VERB) {
		_format_(n*2+&args, buf);
		fputs(buf, stdout); }
}

// Capture screen
unsigned Capture(unsigned seg)
{
	unsigned o, x, y;
	unsigned char c;
	Debug(("%04x ", seg))
	for(y=o=0; y < Height; ++y) {
		for(x=0; x < Width; ++x) {
			if(!(c = peek(seg, o))) {
				Debug(("!%u\n", o >> 2))
				return 0; }
			Screen[y][x] = c;
			o += 2; } }
	Debug(("%u\n", o / 2))
	return 7;
}

#ifdef DEBUG
FILE *fp;
void DumpLine(unsigned l)
{
	unsigned char buf[MAXW+1];
	strcpy(buf, Screen[l]);
	fprintf(fp, "%-5u", l);
	buf[72] = 0;
	fputs(buf, fp);
	putc('\n', fp);
}
void DumpScreen(void)
{
	unsigned y;
	fp = fopen("R:\SCR", "wvq");
	for(y=0; y < Height; ++y)
		DumpLine(y);
	fclose(fp);
}
#endif

// Get value
unsigned Value(unsigned char e)
{
	unsigned i, v;
	unsigned char *p;
	p = Ptr;
	v = 0;
	while((i = *Ptr - '0') < 10) {
		v = (v * 10) + i;
		++Ptr; }
	if((Ptr == p) || (*Ptr != e))
		Error("?BadNumber'%s'\n", p);
	if(e) ++Ptr;
	return v ;
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

// Get Find string (with ~substitutions)
void GetFind(void)
{
	unsigned char *p, c, buf[200];
	if(Ftop >= MAXF) Error("?#finds");
	p = buf;
	while(c = *Ptr++) {
		if(c == '~') {
			switch(c = *Ptr++) {
			default:
				(p = buf)[1] = 0;
				if(!(*p = c)) p = "<EOL>";
				Error("?~%s", p);
//ChtArg -E
/*ChtTxt Shelp
Strings to search for may contain:

	~{ = '<'		~! = '|'		\ These are difficult/impossible
	~} = '>'		~_ = ' '		/ to enter on the command line!
	~~ = '~'
*/
			case '{':	c = '<';	break;
			case '}':	c = '>';	break;
			case '!':	c = '|';	break;
			case '_':	c = ' ';	break;
			case '~':	; } }
		*p++ = c; }
	*p = 0;
	Find[Ftop++] = Pstring(buf);
}

main(int argc, char *argv[])
{
	unsigned i, e;
	unsigned char c;
	MemTst(7);
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
			case '?':
				switch(toupper(*Ptr)) {
				case 'S':	Ptr = Shelp;	goto he1;
				} goto he;
/*ChtTxt Chelp
CoMmanD Output Screen Scan

use:	CMDOSS nlines strings... [options]

opts:	-Dn		Drop this many lines from end								[0]
		-Q		Quiet - no output
		-Sx-y	Screen dimemsions										[80-25]

Scans last nlines of output to screen (starting at last non-blank line) looking
for the specified string(s) - if any found, returns ERRORLEVEL(1+) indicating
which string was found first (last on screen), or (0) if none were found!

-D causes it to ignore that last 'n' lines, normally used to ignore commands
which follow the one you are interested in (like CMDOSS itself).

use: -S if you run a different screen layout that the default DOS/PC 80-25.
use: CMDOSS -?S		to see details on specifying strings to seach for.

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'D':
				Dline = Value(0);
				continue;
			case 'S':
				Width	= Value('-');
				Height	= Value(0);
				continue;
			case 'Q':	c = O_VERB;
				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		if(!Nline) {
			Nline = Value(0);
			continue; }
		GetFind(); }
	if(!(Nline && Ftop)) {
he:		Ptr = Chelp;
he1:	while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					putc(' ', stdout);
				continue; }
			putc(c, stdout); }
		return; }

	if((Width  > MAXW) || !Width ) Error("?Width must be 1-%u\n", MAXW);
	if((Height > MAXH) || !Height) Error("?Height must be 1-%u\n", MAXH);
#if 0
	for(i=0; i < Ftop; ++i)
		printf("'%s'\n", Find[i]);
	return;
#endif

	if(!Capture(0xB800)) {
		memset(Screen, 0, sizeof(Screen));
		if(!Capture(0xB000))
			Error("?CaptureFail"); }
#ifdef DEBUG
	DumpScreen();
	fp = stdout;
#endif
	e = Height;
	while(--e) {
		i = Width;
		do {
			if(Screen[e][--i] != ' ')
				goto a1;
		} while i; }
a1:	Debug(("EndLine=%u\n", e))

	Nline += Dline;
	if((e -= Dline) & 0x8000)
		goto ex;
	while(Nline) {
#ifdef DEBUG
		DumpLine(e);
#endif
		Ptr = Screen[e];
		while(*Ptr) {
			i = 0;
			while(i < Ftop) {
				if(strbeg(Ptr, Find[i++])) {
					Printf("Found(%u) line %u\n", i, e);
#ifdef DEBUG
					Screen[e][75] = 0;
					printf("'%s'\n", Screen[e]);
#endif
					MemTst(0);
					exit(i); } }
			++Ptr; }
		if(--e & 0x8000)
			break;
		--Nline; }
ex:	Printf("NoneFound!\n");
	MemTst(0);
}
