/*
 * Tranz330 Dial-up Download Server
 *
 * ?COPY.TXT 2003-2011 Dave Dunfield
 *  -- see COPY.TXT --.
 *
 * Compile with DDS Micro-C/PC: cc tranzdds -pof
 */
#include <stdio.h>
#include <comm.h>
#include <keys.h>
#include <window.h>

#define	TIMEOUT		(18*5)		// General timeout
#define	PACKET_SIZE	250			// Maximum packet size
#define	MAX_MSG		100			// Maximum messages
#define	MAX_VAR		10			// Maximum variables
#define	VAR_SIZE	50			// Maximum variable size
//#define	CRCP		0xA001		// CRC polynomial
#define	CRCP		0x8005			// CRC polynomial (A001 reversed)

/* Comm control characters */
#define	SOH			0x01		/* Start of header */
#define	STX			0x02		/* Start of text */
#define	ETX			0x03		/* End of text */
#define	EOT			0x04		/* End of transmission */
#define	ENQ			0x05		/* Enquiry */
#define	ACK			0x06		/* Positive acknowlegement */
#define	NAK			0x15		/* Negative acknowlegement */
#define	FS			0x1C		/* Field separator */
#define	GS			0x1D		/* Group separator */

#define	BIOS_TICK	peekw(0x40, 0x6C)

unsigned
	Comport = 1,						// Comm port to use
	Comspeed = _1200,					// Serial speed
	Comfmt = DATA_8|PAR_NO|STOP_1,		// Serial format
	connect_delay = 100,				// Delay after connect
	hangup_delay = 3000,				// Delay to allow for hangup
	line,								// Line number of INI file
	crc;								// Working  CRC

struct WINDOW
	*mwin,					// Main window
	*cwin,					// Communication window
	*swin;					// Status window

unsigned char
	*ptr,								// General pointer
	xdata,								// Hex data mode
	partial,							// Partial download
	init_string[100],					// Modem init string
	buffer[256],						// Temp buffer
	rx_packet[PACKET_SIZE+1],			// Receive packet
	Mflag = 255,						// Modem mode
	Cflag = 255,						// Connect mode flag
	Hflag = 255,						// Hangup flag
	Rmask = 0x7F,						// Receive mask
	Utype,								// Upload type
	Serial[50],							// Terminal serial number
	Version[50],						// Terminal version
	App[50],							// Application ID
	pending_rx_char = 0;				// Input character pending

FILE
	*fp;

extern char *ARGV[];

unsigned crctab[256] = {
	0x0000, 0x8005, 0x800F, 0x000A, 0x801B, 0x001E, 0x0014, 0x8011,
	0x8033, 0x0036, 0x003C, 0x8039, 0x0028, 0x802D, 0x8027, 0x0022,
	0x8063, 0x0066, 0x006C, 0x8069, 0x0078, 0x807D, 0x8077, 0x0072,
	0x0050, 0x8055, 0x805F, 0x005A, 0x804B, 0x004E, 0x0044, 0x8041,
	0x80C3, 0x00C6, 0x00CC, 0x80C9, 0x00D8, 0x80DD, 0x80D7, 0x00D2,
	0x00F0, 0x80F5, 0x80FF, 0x00FA, 0x80EB, 0x00EE, 0x00E4, 0x80E1,
	0x00A0, 0x80A5, 0x80AF, 0x00AA, 0x80BB, 0x00BE, 0x00B4, 0x80B1,
	0x8093, 0x0096, 0x009C, 0x8099, 0x0088, 0x808D, 0x8087, 0x0082,
	0x8183, 0x0186, 0x018C, 0x8189, 0x0198, 0x819D, 0x8197, 0x0192,
	0x01B0, 0x81B5, 0x81BF, 0x01BA, 0x81AB, 0x01AE, 0x01A4, 0x81A1,
	0x01E0, 0x81E5, 0x81EF, 0x01EA, 0x81FB, 0x01FE, 0x01F4, 0x81F1,
	0x81D3, 0x01D6, 0x01DC, 0x81D9, 0x01C8, 0x81CD, 0x81C7, 0x01C2,
	0x0140, 0x8145, 0x814F, 0x014A, 0x815B, 0x015E, 0x0154, 0x8151,
	0x8173, 0x0176, 0x017C, 0x8179, 0x0168, 0x816D, 0x8167, 0x0162,
	0x8123, 0x0126, 0x012C, 0x8129, 0x0138, 0x813D, 0x8137, 0x0132,
	0x0110, 0x8115, 0x811F, 0x011A, 0x810B, 0x010E, 0x0104, 0x8101,
	0x8303, 0x0306, 0x030C, 0x8309, 0x0318, 0x831D, 0x8317, 0x0312,
	0x0330, 0x8335, 0x833F, 0x033A, 0x832B, 0x032E, 0x0324, 0x8321,
	0x0360, 0x8365, 0x836F, 0x036A, 0x837B, 0x037E, 0x0374, 0x8371,
	0x8353, 0x0356, 0x035C, 0x8359, 0x0348, 0x834D, 0x8347, 0x0342,
	0x03C0, 0x83C5, 0x83CF, 0x03CA, 0x83DB, 0x03DE, 0x03D4, 0x83D1,
	0x83F3, 0x03F6, 0x03FC, 0x83F9, 0x03E8, 0x83ED, 0x83E7, 0x03E2,
	0x83A3, 0x03A6, 0x03AC, 0x83A9, 0x03B8, 0x83BD, 0x83B7, 0x03B2,
	0x0390, 0x8395, 0x839F, 0x039A, 0x838B, 0x038E, 0x0384, 0x8381,
	0x0280, 0x8285, 0x828F, 0x028A, 0x829B, 0x029E, 0x0294, 0x8291,
	0x82B3, 0x02B6, 0x02BC, 0x82B9, 0x02A8, 0x82AD, 0x82A7, 0x02A2,
	0x82E3, 0x02E6, 0x02EC, 0x82E9, 0x02F8, 0x82FD, 0x82F7, 0x02F2,
	0x02D0, 0x82D5, 0x82DF, 0x02DA, 0x82CB, 0x02CE, 0x02C4, 0x82C1,
	0x8243, 0x0246, 0x024C, 0x8249, 0x0258, 0x825D, 0x8257, 0x0252,
	0x0270, 0x8275, 0x827F, 0x027A, 0x826B, 0x026E, 0x0264, 0x8261,
	0x0220, 0x8225, 0x822F, 0x022A, 0x823B, 0x023E, 0x0234, 0x8231,
	0x8213, 0x0216, 0x021C, 0x8219, 0x0208, 0x820D, 0x8207, 0x0202 };

/*
 * Build the fast CRC encoding table
 *
void build_crc_table(unsigned poly)
{
	unsigned i, j, k;

	for(i=0; i < 256; ++i) {
		k = i << 8;
		for(j=0; j < 8; ++j)
			k = ((k & 0x8000) ? poly : 0) ^ (k << 1);
		crctab[i] = k; }
} */

/*
 * Terminate the simulator
 * Close watchfile (if open), comm line and terminate.
 */
void terminate(char *s)
{
	wclose();
	wclose();
	wclose();

	printf(s);
	if(!Copen(Comport, Comspeed, Comfmt, OUTPUT_2))
		Cclose();
	exit(-1);
}

/*
 * Test for ESCAPE key and if found - exit
 */
void test_exit(void)
{
	if(kbtst() == 0x1B)
		terminate("USER EXIT");
}

/*
 * Translate control char into printable string
 */
char *control_char(unsigned char c)
{
	static char x[10];

	switch(c) {
		case 0 : return "<NULL>";
		case SOH : return "<SOH>";
		case STX : return "<STX>";
		case ETX : return "<ETX>";
		case EOT : return "<EOT>";
		case ENQ : return "<ENQ>";
		case ACK : return "<ACK>";
		case NAK : return "<NAK>";
		case FS  : return "<FS>";
		case GS  : return "<GS>";
		case '\n' : if(!xdata) return "\n";
			break;
		case '\r' : if(!xdata) return "\r"; }
	sprintf(x, "<%02x>", c);
	return x;
}

/*
 * Expect the indicated character from the input stream
 */
int expect(unsigned char c)
{
	if(*ptr != c) {
		wprintf("\nExpected: %s", control_char(c));
		return -1; }
	++ptr;
	return 0;
}

/*
 * Display a packet
 */
void show_packet(unsigned char *msg, unsigned char *p)
{
	unsigned char c;
	wprintf("\n%s: ", msg);
	while(c = *p++) {
		if((c < ' ') || (c >= 0x7F)) {
			wputs(control_char(c));
			continue; }
		wputc(c); }
}

/*
 * Skip blanks in the input stream
 */
int skip_blanks()
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

/*
 * Parse an item from the input
 */
int parse(unsigned char dest[], unsigned length, unsigned char delimit)
{
	unsigned l;
	l = 0;
	while(*ptr) {
		if(*ptr == delimit)
			break;
		dest[l++] = *ptr++;
		if(l >= length)
			break; }
	dest[l] = 0;
	return l;
}

/*
 * Parse a whitespace delimited word from the input stream
 */
word(unsigned char *dest)
{
	if(!skip_blanks())
		return 0;
	while(*ptr && !isspace(*ptr))
		*dest++ = toupper(*ptr++);
	*dest = 0;
	return -1;
}

/*
 * Execute a sub-shell
 *
void doshell(command)
	char *command;
{
	char comspec[65], tail[80];

	if(!getenv("COMSPEC", comspec)) {
		printf("Cannot locate COMSPEC\n");
		return; }
	*tail = 0;
	if(command)
		concat(tail, "/C ", command);
	exec(comspec, tail);
} */

void set_comm(unsigned char a)
{
	if(*cwin != a) {
		w_putc('\n', cwin);
		*cwin = a; }
}

/*
 * Get a character from the serial stream with timeout
 *
 * Input: Time to wait in 1/18 second intervals.
 * Return: Character read (0-255) or -1 for timeout.
 */
int Cgett(unsigned timeout)
{
	unsigned t;
	int c;

	/* If a char is pending, report it */
	t = BIOS_TICK;
	do {
		if(c = pending_rx_char) {
			pending_rx_char = 0;
			return c; }

		if((c = Ctestc()) != -1) {
			set_comm(0x47);
			c &= Rmask;
			if((c < ' ') || (c >= 0x7F))
				w_puts(control_char(c), cwin);
			else
				w_putc(c, cwin);
			return c; }
		test_exit(); }
	while((BIOS_TICK - t) < timeout);
	return -1;
}

/*
 * Flush the input stream ... wait for 1/2 second of no data
 */
void Cflush(void)
{
	while(Cgett(9) != -1);
}

/*
 * Write data to host
 */
Xputc(unsigned c)
{
	set_comm(0x42);
	if((c < ' ') ||  (c >= 0x7F))
		w_puts(control_char(c), cwin);
	else
		w_putc(c, cwin);
	Cputc(c & 255);
}
		
/*
 * Write a string to the serial port
 */
void Cputs(char *s)
{
	while(*s) {
		Xputc(*s++);
		delay(55); }
}

/*
 * Send ENQ to target
 */
void send_enq(void)
{
	wprintf("Send ENQ!");
	Xputc(ENQ);
}

scan(unsigned char *s)
{
	unsigned char *p;
	p = buffer;
	while(*p) {
		if(strbeg(p, s))
			return -1;
		++p; }
	return 0;
}

capture(unsigned timeout)
{
	unsigned c, p;
	p = 0;
	while((c = Cgett(timeout)) != -1) {
		if(p < (sizeof(buffer)-1))
			buffer[p++] = toupper(c & 0x7F); }
	buffer[p] = 0;
	return p;
}

/*
 * Wait for carrier to stabalize, and issue ENQ
 */
void wait_carrier(void)
{
	unsigned t, c, x;

	if(Cflag) {		// Hardware carrier detect
htop:	wprintf("\nWait carrier..");
		do {
			test_exit(); }
		while(!(Csignals() & CD));
		w_gotoxy(0, 1, swin);
		w_cleow(swin);
		wprintf("Debounce..");
		c = BIOS_TICK;
htop1:	t = BIOS_TICK;
		do {
			x = BIOS_TICK;
			if(!(Csignals() & CD)) {
				if((x-c) >= (18)) {
					wprintf("LOST!");
					goto htop; }
				goto htop1; }
			c = x; }
		while((c-t) < (18));
		delay(100); }

	else {			// Software carrier detect
stop:	wprintf("\nWait connect..");
stop1:	while(!capture(5));
		if(scan("RING")) {
			wprintf("RING");
			goto stop; }
		if(!scan("CONNECT")) goto stop1; }

	wprintf("Connect..");
	delay(connect_delay);
	Cflush();
}

/*
 * Hang up the modem and wait for next call (carrier)
 */
void hangup_modem(void)
{
	unsigned t;
	unsigned char h;
	static unsigned char e;
	if(h = Hflag) {
		if(Copen(Comport, Comspeed, Comfmt, OUTPUT_2))
			abort("Comm port not available");
		Cflags |= TRANSPARENT;
		t = BIOS_TICK;
		if(Cflag) {
			do {
				test_exit();
				if((BIOS_TICK-t) > (18*3)) {
					if(e) {
						wprintf("\nModem failed to disconnect.");
						beep(500, 500); }
					e = 255;
					h = 0;
					break; } }
			while(Csignals() & CD);
			delay(100); }
		else
			delay(hangup_delay);
		Cflush(); }

	if(Copen(Comport, Comspeed, Comfmt, SET_DTR|SET_RTS|OUTPUT_2))
		abort("Comm port not available");
	Cflags |= TRANSPARENT;

	if(!h) {
		Cflush();
		delay(1200);
		Cputs("+++");
		delay(1500);
		Cflush();
		Cputs("ATH0\r");
		delay(500);
		Cflush(); }
}

/*
 * Add character to running CRC value
 */
void addcrc(unsigned char c)
{
	crc = crctab[((crc >> 8) ^ c) & 255] ^ (crc << 8);
}

/*
 * Receive a packet from the terminal and decode the
 * Download request
 */
int receive_packet(void)
{
	unsigned c;
	unsigned retry_count, index;
	unsigned char lrc;
//FILE *fpx;

	wprintf("\nWait packet..");
retry:
	retry_count = 3;
	index = crc = 0;
	lrc = ETX;

	/* Wait for STX to occur */
	Rmask = 0x7F;
	while(retry_count) {
		test_exit();
		c = Cgett(TIMEOUT);
		if(c == STX) {
			wprintf("STX.. ");
			goto receive; }
		if(c == SOH) {
			wprintf("SOH.. ");
			goto receive; }
		if(c == -1) {
			if(Mflag)
				send_enq();
			--retry_count; }
		else
			control_char(c); }
	return 255;

receive:
	while((c = Cgett(18)) != ETX) {
		if(c == -1) {
			wprintf("Timeout!");
			goto fail; }
		if(index >= PACKET_SIZE) {
			wprintf("Overflow!");
			Cflush();
			goto fail; }
		lrc ^= (rx_packet[index++] = c);
		addcrc(c); }
	rx_packet[index] = 0;
	addcrc(ETX);

/*	if(fpx = fopen("D:X", "wb")) {
		fputs(rx_packet, fpx);
		fclose(fpx); } */

	// Examine packet type
	ptr = rx_packet;
	if(parse(buffer, 3, 0) != 3) {
fail:	if(--retry_count) {
			Xputc(NAK);
			goto retry; }
		wprintf("\nComm error");
		return 255; }

	if(!strcmp(buffer, "55.")) {		// TRANZ-330 format
		Utype = 0;
		c = Cgett(18);
		if(c != lrc) {
			wprintf("\nLRC mismatch (rx:%02x calc:%02x)", c, lrc);
			goto fail; }
		wprintf("length=%u", index);
		rx_packet[index] = 0;

		parse(Serial, sizeof(Serial)-1, FS);
		if(expect(FS)) {
	rfe:	show_packet("Request format error", rx_packet);
			return 255; }

		parse(App, sizeof(App)-1, FS);
		if(expect(FS)) goto rfe;

		parse(buffer, 50, 0);
		ptr = buffer;
		while(*ptr) ++ptr;
		switch(*--ptr) {
		default: goto rfe;
		case 'd' : partial = 255; break;
		case 'D' : partial = 0; }
		*ptr = 0;
		strcpy(Version, buffer);

		return 0; }

	if(strcmp(buffer,"VFI")) goto fail;
	Utype = Rmask = 0xFF;
	c = Cgett(18) << 8;
	c = Cgett(10) | c;
	Rmask = 0x7F;
	if(c != crc) {
		wprintf("\nCRC mismatch (rx:%04x calc:%04x)", c, crc);
		goto fail; }
	if(expect(',')) goto rfe;

	// VFI,TRANZ-380,XDL,F,1,7896,9EAEU1.41,
	parse(buffer, 50, ',');		// Skip platform
	if(expect(',')) goto rfe;
	parse(buffer, 50, ',');		// Skip request type
	if(expect(',')) goto rfe;

	parse(buffer, 50, ',');		// Get request type
	if(expect(',')) goto rfe;
	switch(*buffer) {
	default: goto rfe;
	case 'F' : partial = 0;	break;
	case 'P' : partial = 255; }

	parse(App, sizeof(App)-1, ',');
	if(expect(',')) goto rfe;
	parse(Serial, sizeof(Serial)-1, ',');
	if(expect(',')) goto rfe;
	parse(Version, sizeof(Version)-1, ',');
	if(expect(',')) goto rfe;

	return 0;
}

/*
 * Build the header, and send a packet to the terminal
 */
int send_packet(unsigned char *packet)
{
	unsigned char c, r, *p;
	r = 3;
top:
//	show_packet("TX", packet);
	p = packet;
	crc = 0;
	Xputc(STX);
	while(c = *p++) {
		Xputc(c);
		addcrc(c); }
	Xputc(c = Utype ? (ETX|0x80) : ETX);
	addcrc(c);
	Xputc((crc >> 8)|0x100);
	Xputc(crc|0x100);
wait:
	switch(Cgett(18*3)) {
	default: goto wait;
	case ACK: return 0;
	case -1 : wprintf("\nTx Ack-Timeout!"); goto retx;
	case NAK: wprintf("\nTx NAK!");
	retx:
		if(--r) goto top; }
	wprintf("\nTx Retry count exceeded!");
	return -1;
}

/*
 * Issue an error message for INI file processing & terminate
 */
register error(unsigned args)
{
	char buffer[81];
	_format_(nargs() * 2 + &args, buffer);
	printf("[%u]: %s\n", line, buffer);
	exit(-1);
}

/*
 * Parse a number from the input line
 */
unsigned number(void)
{
	unsigned char temp[50], *p;
	word(p = temp);
	do {
		if(!isdigit(*p))
			error("Numeric value required"); }
	while(*++p);
	return atoi(temp);
}

/*
 * Lookup a keyword entry from the input line
 */
unsigned lookup(unsigned char *list[])
{
	unsigned i;
	unsigned char temp[50], *p;
	word(temp);
	for(i=0; p = list[i]; ++i) {
		if(!strcmp(temp, p))
			return i; }
	error("Unexpected keyword: %s", temp);
}

/*
 * Parse a delimited strings from the input line
 */
void string(unsigned char *dest)
{
	unsigned char c, d;
	switch(d = skip_blanks()) {
	default: error("Bad string delimiter,  use: ' ` \" / \\ or |");
	case '\'' :
	case '`' :
	case '"' :
	case '|' :
	case '/' :
	case '\\' : }
	++ptr;
	while((c = *ptr++) != d) {
		if(!c)
			error("Improperly delimited string");
		*dest++ = c; }
	*dest = 0;
}

/*
 * Confirm that parsing pointer is at end of line
 */
void eol(void)
{
	switch(skip_blanks()) {
	case ';' :
	case 0 : return; }
	error("Too many parameters");
}

/*
 * Load the modem initialization file
 */
void load_ini(void)
{
	unsigned i;
	static char *keywords[] = {
		"PORT",		// 0
		"SPEED",	// 1
		"FORMAT",	// 2
		"INIT",		// 3
		"CONNECT",	// 4
		"HANGUP",	// 5
		0 };
	static char *parity[] =
		{ "NO", "ODD", "EVEN", "MARK", "SPACE", 0 };
	static unsigned char pardata[] =
		{ PAR_NO, PAR_ODD, PAR_EVEN, PAR_MARK, PAR_SPACE };
	static unsigned char *ctext[] = { "CD", "TEXT", 0 };
	static unsigned char *htext[] = { "DTR", "+++", 0 };

	strcpy(ptr = buffer, ARGV[0]);
	while(*ptr) ++ptr;
	if(*(ptr-=4) != '.') {
		printf("Cannot determine INI filename\n");
		return; }
	strcpy(ptr, ".INI");

	if(!(fp = fopen(buffer, "rv")))
		return;
	line = 0;
	while(fgets(ptr = buffer, sizeof(buffer)-1, fp)) {
		++line;
		switch(skip_blanks()) {
		case ';' :				// Comment
		case 0 : continue; }	// Null line
		switch(lookup(keywords)) {
		case 0 :				// Comport
			Comport = number();
			if((Comport < 1) || (Comport > 4))
				error("PORT must be 1-4");
			break;
		case 1 :				// Speed
			i = number()/2;
			Comspeed = 57600 / i;
			if((Comspeed * i) != 57600)
				error("Bad SPEED value (%u), use %u or %u\n", i*2,
					(57600/(Comspeed+1))*2, (57600/Comspeed)*2);
			break;
		case 2 :				// Format
			Comfmt = 0;
			switch(number()) {
			default: error("Data bits must be 7-8");
			case 7 : Comfmt |= DATA_7; break;
			case 8 : Comfmt |= DATA_8; }
			Comfmt |= pardata[lookup(parity)];
			switch(number()) {
			default: error("Stop bits must be 1-2");
			case 1 : Comfmt |= STOP_1; break;
			case 2 : Comfmt |= STOP_2; }
			break;
		case 3 :				// INIT
			string(init_string);
			break;
		case 4 :				// CONNECT
			switch(lookup(ctext)) {
			case 0 : Cflag = 255; break;
			case 1 :
				Cflag = 0;
				hangup_delay = number(); }
			if(skip_blanks())
				connect_delay = number();
			break;
		case 5 :				// Hangup
			switch(lookup(htext)) {
			case 0 : Hflag = 255; break;
			case 1 : Hflag = 0; } }
		eol(); }
	fclose(fp);
}

/*
 * Transmit a UDL file to the terminal
 */
int send_udl()
{
	unsigned i, line, locn;
	unsigned char *p, *p1, buf[256];

	line = 0;
	sprintf(buffer, "%s.UDL", App);
	if(!(fp = fopen(buffer, "r"))) {
		wprintf("\nApplication '%s' not found!\n", App);
		sprintf(buffer, Utype ? "MNO APP: %s" : "*MNO APP: %s", App);
						// ----------------
		send_packet(buffer);
		return -2; }
	wprintf("\nSending %s", buffer);
	sprintf(buffer, Utype ? "MLOADING %s" : "*MLOADING %s", App);
	send_packet(buffer);
	while(fgets(p = buffer, sizeof(buffer)-1, fp)) {
//wprintf("\n%s", buffer); delay(55);
		++line;
		while(isspace(*p)) ++p;
//wputc('1');
		if(*p++ != '"')
			continue;
//wputc('2');
		switch(*p++) {
		default: badudl:
			wprintf("\nBad UDL record, line %u", line);
			beep(500, 500);
			send_packet(Utype ? "MHOST ERROR" : "*MHOST ERROR");
			fclose(fp);
			return -3;
		case '0' : if(partial) continue;
		case '1' : }
//wputc('3');
		locn = 0;
		if(*p == ',') {	// Long format file
			while(isdigit(*++p))
				locn = (locn * 10) + (*p - '0');
			if(*p++ != ',')
				goto badudl; }
		else {			// Short format file
			for(i=0; i < 3; ++i) {
				if(!isdigit(*p))
					goto badudl;
				locn = (locn * 10) + (*p++ - '0'); } }
		w_gotoxy(5, 8, swin);
		w_printf(swin, "Line %-5u Locn %u", line, locn);
		sprintf(p1=buf, Utype ? "L%u,\x1C" : "%03u", locn);
		while(*p1) ++p1;
		while(*p) *p1++ = *p++;
		while(isspace(*--p1));
		if(*p1 != '"')
			goto badudl;
		*p1 = 0;
		if(send_packet(buf)) {
			fclose(fp);
			return -1; } }
	fclose(fp);
	return 0;
}

main()
{
/*	fp = fopen("TEST.UDL", "rvq");
	check_udl();
	fclose(fp);
	return; */

	strcpy(init_string, "E0 Q0 V1 X1 S0=1 &C1 &D2");
	load_ini();

	swin = wopen( 0,  0, 40, 10, WSAVE|WCOPEN|0x67);
	wgotoxy(3, 0); wputs("TRANZ Dial-up Download Server  1.0");
	cwin = wopen(40,  0, 40, 10, WSAVE|WCOPEN|0x43|WWRAP|WSCROLL);
	wgotoxy(8, 0); wputs("http://www.dunfield.com");
	mwin = wopen( 0, 10, 80, 15, WSAVE|WCOPEN|0x17|WSCROLL);
	wputs("?COPY.TXT 2003-2011 Dave Dunfield -  -- see COPY.TXT --.  Press ESC to exit.");
	wcursor_off();
#ifdef XDEMO
	wputs("\nDEMO version - preloaded application: "#XDEMO"");
#endif
restart:
	xdata = partial = 0;
	hangup_modem();
	if(Mflag) {
		Cputs("AT\r");
		Cflush();
		Cputs("AT");
		Cputs(init_string);
		Cputc('\r');
		capture(18);
		if(!scan("OK")) {
			wprintf("\nModem failed to respond!");
			beep(500, 500); } }
	xdata = 255;

	if(Mflag) {
		wait_carrier();
		send_enq(); }

	if(receive_packet())
		goto restart;

	w_gotoxy(5, 3, swin); w_printf(swin, "S/N: %s", Serial);
	w_gotoxy(5, 5, swin); w_printf(swin, "App: %s", App);
	w_gotoxy(5, 2, swin); w_printf(swin, "Ver: %s", Version);
	w_gotoxy(5, 6, swin); w_printf(swin, "%s download.", partial ? "Partial" : "Full");

	switch(send_udl()) {
	case -3 :
	case -2 :
		send_packet(Utype ? "U" : "*S");
		Cputc(EOT);
	case -1 : goto restart; }

	if(send_packet(Utype ? "MDOWNLOAD DONE" : "*MDOWNLOAD DONE"))
		goto restart;
	if(send_packet(Utype ? "S" : "*S"))
		goto restart;
	wprintf("\nSend EOT.");
	Xputc(EOT);
	if(Mflag)
		delay(1000);

	goto restart;
}
