#include <stdio.h>
#include <comm.h>
#include <keys.h>
#include <window.h>

#define	LL		50
#define	LINES	512

unsigned
	Cport = 1,			// COM port
	Baud = _9600,		// Baud rate
	Format = DATA_7|STOP_1|PAR_EVEN,
	Line,				// Lines
	Ev,					// Escape value
	Margin,				// Margin position
	wptr,				// Line write pointer (line #)
	rpos;				// Line write position (column)

unsigned char
	Ec,					// Escape command
	Dw,					// Double width
	Pnul = 255,			// Print null lines
	rstate,				// Receive state
	rattr[LINES],		// Receive attributes
	rx[LINES][LL+1];	// Receive buffer

FILE *fp;

struct WINDOW
	*mwin;

void reset()
{
	rpos = Dw = 0;
	while(rpos < Margin)
		rx[wptr][rpos++] = ' ';
	rattr[wptr] = REVERSE;
}

void feed()
{
	rx[wptr][rpos] = 0;
	wptr = (wptr + 1) & (LINES-1);
	++Line;
	reset();
}

void poll_rx(void)
{
	int c;

	for(;;) {
		if((c = Ctestc()) == -1)
			return;

		if(rstate) {
			if(rstate == 255) {	// Initial command
				rstate = Ev = 0;
				switch(Ec = c) {
				case 'a' :
				case 'b' :
				case 'e' :
				case 'f' : rstate = 15;	continue;
				} continue; }
			if(rstate == 15) {	// Subsequent command
				if(c == ';') {
					rstate = 0;
					switch(Ec) {
					case 'b' :
						for(c=0; c < Ec; ++c)
							feed();
						continue;
					case 'e' : Margin = Ev;	reset();	continue;
					} continue; }
				if((c -= '0') > 9) {
					rstate = 0;
					continue; }
				Ev = (Ev * 10) + Ec;
				continue; } }

		switch(c) {
		case '\n': if(Pnul || rpos) feed();		continue;	// LF
		case 0x1B: rstate=255;					continue;	// ESC
		case 0x0C: for(c=0;c<4;++c) feed();		continue;	// FF
		case 0x1C:											// FS
		case 0x1D:											// GS
		case 0x18: reset();						continue;	// CAN
		case 0x1E: Dw = 255;					continue;	// RS
		case 0x1F: Dw = 0;						continue;	// US
		case 0x12:
			rattr[wptr] = (rattr[wptr] == REVERSE) ? 0x74 : REVERSE;
			continue;
		}

		if((c >= ' ') && (rpos < LL)) {
			rx[wptr][rpos++] = c;
			if(Dw && (rpos < LL))
				rx[wptr][rpos++] = ' '; } }
}

sflag(unsigned l, unsigned char *p, unsigned char flag)
{
	wgotoxy(2, l);
	wputs(p);
	wgotoxy(25, l);
	wputs(": ");
	wputs(flag ? "Yes" : "No ");
}

status()
{
	wgotoxy(5, 1); wputs("TRANZ printer Simulator");
	wgotoxy(5, 2); wputs("http://www.dunfield.com");
	wgotoxy(2, 10);
	wprintf("COM%u: %-5u", Cport, (57600 / Baud)*2);
	if(Format & 0x08)
		wputc("OEMS"[(Format >> 4) & 3]);
	else
		wputc('N');
	wputc((Format & 3)+'5');
	wputc((Format & STOP_2) ? '2' : '1');

	wgotoxy(4, 16); wputs("F2: Feed paper");
	wgotoxy(4, 17); wputs("Up: Back    1  line");
	wgotoxy(4, 18); wputs("Dn: Advance 1  line");
	wgotoxy(2, 19); wputs("PgUp: Back    24 lines");
	wgotoxy(2, 20); wputs("PgDn: Advance 24 lines");
	wgotoxy(2, 21); wputs("Home: Reset to bottom line");
	wgotoxy(3, 22); wputs("ESC: Exit");
}

status1()
{
	sflag(15, "  F1: Print blank lines", Pnul);
}

unsigned char help[] = { "\n\
TRANZ Printer Simulator\n\n\
Simulates TRANZ printer on PC screen connected via download cable.\n\n\
Use:	TPSIM [options]\n\n\
Opts:	C=1-4		= Select COM port\n\
	S=speed[pds]	= Select COM speed [data format]	(9600E71)\n\
	 Parity		p: N=none E=even O=odd M=mark S=space\n\
	 Data-bits	d: 5-8				eg: S=2400\n\
	 Stop-bits	s: 1-2				eg: S=1200N81\n\
\n\?COPY.TXT 2000-2006 Dave Dunfield -  -- see COPY.TXT --.\n" };

main(int argc, char *argv[])
{
	unsigned i, p, xw, yw;
	unsigned char *ptr;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
		case 'C=' :
			Cport = atoi(ptr);
			if((Cport < 1) || (Cport > 4))
				abort("Com port must be 1-4\n");
			continue;
		case 'S=' :
			if(!(p = atoi(ptr)/2)) {
		bb: 	abort("Bad speed"); }
			Baud = 57600 / p;
			if((Baud * p) != 57600) goto bb;
			while(isdigit(*ptr)) ++ptr;
			if(*ptr) {
				switch(toupper(*ptr++)) {
				default: abort("Bad parity");
				case 'E' : Format = PAR_EVEN;	break;
				case 'O' : Format = PAR_ODD;	break;
				case 'M' : Format = PAR_MARK;	break;
				case 'S' : Format = PAR_SPACE;	break;
				case 'N' : Format = PAR_NO; }
				p = *ptr++ - '5';
				if(p >  3) abort("Bad data-bits");
				Format = (Format & ~3) | p;
				switch(*ptr++) {
				default: abort("Bad stop-bits");
				case '2' : Format |= STOP_2;
				case '1' : } }
			continue; }
		abort(help); }

	if(Copen(Cport, Baud, DATA_7|STOP_1|PAR_EVEN, SET_RTS|SET_DTR|OUTPUT_2))
		abort("Cannot open COM port");
	Cflags |= TRANSPARENT;

	p = xw = yw = wptr;
	mwin = wopen(0, 0, 42+5, 25, WSAVE|WCOPEN|WSCROLL|0x17);
	wopen(42+5, 0, 80-(42+5), 25, WSAVE|WCOPEN|0x17);
	wcursor_off();
	status();
	status1();
	memset(rattr, REVERSE, sizeof(rattr));
redraw:
	p &= (LINES-1);
	for(i=0; i < 25; ++i) {
		w_gotoxy(0, 24-i, mwin);
		poll_rx();
//		w_printf(mwin, "%3u: %s", ((xw - p) + i)&(LINES-1), 
		*mwin = 0x17;
		w_printf(mwin, "%3u: ", ((xw - p) + i) & (LINES-1));
		*mwin = rattr[(p-i) & (LINES-1)];
		w_puts(rx[(p-i) & (LINES-1)], mwin);
		w_cleol(mwin); }
	for(;;) {
		poll_rx();
		switch(wtstc()) {
		case 0 :
			if(yw != wptr) {
				yw = wptr;
				wgotoxy(2, 5); wprintf("%-6u", Line);
				if(p != xw)
					wprintf("%3u", (wptr - p) & (LINES-1));
				else
					wputs("   "); }
			if(p == xw) {
				if(xw != wptr) {
					p = xw = yw = (xw + 1) & (LINES-1);
					goto redraw; }
				continue; }
			continue;
		case _KUA : --p; goto redrawx;
		case _KDA : ++p; goto redrawx;
		case _KPU : p -= 24; goto redrawx;
		case _KPD : p += 24; goto redrawx;
		case _KHO : p = xw; goto redrawx;
redrawx: yw = -1; goto redraw;
		case _K1 : Pnul = Pnul ? 0 : 255;
		upstat: status1();	continue;
		case _K2 : feed();	continue;
		case 0x1B : wclose(); wclose(); Cclose(); return; } }

}
