/*
 * SIM330 TCL execution module
 *
 * ?COPY.TXT 2000-2003 Dave Dunfield
 *  -- see COPY.TXT --.
 *
 * Do not compile this directly, it is #included from SIM330.C
 */
xgo(unsigned l)
{
	if(l > 999) dump_state(MEMOUT, l);
	exec_locn = l;
}

execute()
{
	unsigned value, value1, repeat, c, c1, c2;
	unsigned char p, mflag;

	repeat = 1;
new_exec:
	cmd_ptr = command_buffer;
old_exec:
	read_memory(exec_locn, exec_ptr = command_buffer);
restart:
	if(log_fp)
		fprintf(log_fp, "\n%03u ", exec_locn);
	if(break_top) {
		for(value = 0; value < break_top; ++value)
			if(breakpoint[value] == exec_locn) {
				poll_input();
				dump_state("BREAKPOINT");
				goto skip_poll; } }
	for(;;) {
		poll_input();
		if(!step_mode)
			dump_state("STEP");
skip_poll:
		cmd1 = ' ';
		switch(cmd = *cmd_ptr) {
			case '*' :
			case '+' :
				cmd1 = *++cmd_ptr; }
		if(log_fp) {
			if(cmd) putc(cmd, log_fp);
			if(cmd1 != ' ') putc(cmd1, log_fp); }
		memset(parameters, 0, sizeof(parameters));
		memset(parm_type, 0, sizeof(parm_type));
		parm_count = 0;
	next_parm:
		value = p = mflag = 0;
	next_char:
		switch(c = *++cmd_ptr) {
		case '0' :		// Simple number
		case '1' :
		case '2' :
		case '3' :
		case '4' :
		case '5' :
		case '6' :
		case '7' :
		case '8' :
		case '9' :
			value = (value * 10) + (c - '0');
			p = P_NUM;
			goto next_char;
		case '#' :		// Variable
			p = 0;
			if(isdigit(*(cmd_ptr+1)))
				p = *++cmd_ptr - '0';
			value = variables[p];
			p += P_VAR;
			goto next_char;
		case '-' :		// Negative number
			mflag = -1;
			goto next_char;
		case '\'' :		// Quoted string
			value = 0;
			ptr = buffer;
			while((p = *++cmd_ptr) && (p != '\''))
				*ptr++ = p;
			*ptr = 0;
			p = P_STR;
			goto next_char;
		default:
			parameters[parm_count] = mflag ? -value : value;
			parm_type[parm_count++] = p;
			if((c == '.') || (c == ','))
				goto next_parm; }

		switch(cmd) {
		case 'A' :	// Append to buffer
			if(!read_memory(parameters[0], ptr1 = buffer)) {
				do_skip(parameters[1]);
				continue; }
		xappend:
			ptr = bwptr[dest_buf];
			while(*ptr1)
				*ptr++ = *ptr1++;
			*(bwptr[dest_buf] = ptr) = 0;
			check_dest();
			continue;
		case 'B' :	// Select buffers
			if(value = parameters[0]) {		// Source buffer selected
				if(value <= 5)
					src_buf = value - 1;
				else
					check(value == 9, "BAD BUFFER");
				brptr = buffers[src_buf]; }
			if(value = parameters[1]) {		// Dest buffer selected
				check(value <= 5, "BAD BUFFER");
				dbptr = buffers[dest_buf = value - 1]; }
			continue;
		case 'C' :	// Verify check digit
			switch(parameters[0]) {
			default: goto badcmd;
			case 0 : ptr = buffer;	// LUHN from last entry
				do {
					if(*ptr == '=')
						*ptr = 0; }
				while(*ptr++);
				value = do_luhn(buffer);
				break;
			case 1 :				// LUHN from dest buffer
				value = do_luhn(dbptr);
				break;
			case 2 :				// MOD11 from dest buffer
				value = do_mod11(dbptr); }
			if(!value) {
				if(value = parameters[1])
					do_skip(value);
				else {
					write_display("BAD ACC'T NUMBER");
					goto abort_display; } }
			continue;
		case 'D' :	// Delete characters from destination
			value = parameters[0] || 1;
			ptr = bwptr[dest_buf];
			ptr1 = dbptr;
			do {
				if(ptr <= ptr1)
					break;
				--ptr; }
			while(--value);
			*(bwptr[dest_buf] = ptr) = 0;
			check_dest();
			continue;
		case 'E' :	// Keypad or card reader
		Eretry:
			switch(do_input(parameters[1], parameters[2], parameters[4], 3)) {
			case 3 : goto Eretry;
			case 0 : do_skip(parameters[3]); continue;
			case 2 : do_skip(parameters[0]); }
			continue;
		case 'F' :	// Display fixed prompt
			if(value = parameters[0]) {
				if((value < 128) || Host_key) {
					ptr1 = fixed_prompts[value-1];
					if(parameters[1])
						goto xappend;
					write_display(ptr1); } }
			continue;
		case 'G' :	// Clear dest buffer
			*(bwptr[dest_buf] = dbptr) = 0;
			check_dest();
			continue;
		case 'H' :	// Search for string or character
			ptr = value = brptr;
			value1 = parameters[0];	// Skip target
			p = parm_type[1];		// Type of search
			c = parameters[1];		// Character to search
			c1 = parameters[2];		// Count to search
			c2 = parameters[3];		// End sentinal
			while(*ptr && (*ptr != c2)) {
				if(p == P_STR) {	// String search
					ptr1 = buffer;
					while(*ptr1) {
						if(*ptr1++ != *ptr++)
							goto Hnotf; }
					goto Hfound; }
				else if(*ptr == c)
					goto Hfound;
			Hnotf:
				ptr = ++value;
				if(!--c1)
					break; }
			do_skip(value1);
			continue;
		Hfound:
			brptr = value;
			continue;
		case 'I' :	// Compare/Jump s.a.c
			if(c1 = parameters[1]) {		// Conditional
				c = *(ptr = brptr);
				if((c1 != 7) && !c) goto doskip;
				if(parm_type[2] == P_STR) {	// String comparison
					ptr1 = buffer;
					while(*ptr1)
						if(*ptr1++ != *ptr++)
							goto Inotf;
					// Buffers match
					if(c1 != 1)
						continue;
					goto doskip;
				Inotf:
					if(c1 != 2)
						continue;
					goto doskip; }
				c2 = parameters[2];
				switch(c1) {
				case 1 : if(c == c2) break;	continue;
				case 2 : if(c != c2) break;	continue;
				case 3 : if(c <  c2) break;	continue;
				case 4 : if(c >  c2) break;	continue;
				case 7 : value = parm_type[2] - P_VAR;
						 if(!--variables[value]) continue; } }
		doskip:
			do_skip(parameters[0]);
			continue;
		case 'J' :	// Time & Date
			do_date(parm_type[0]);
			continue;
		case 'K' :	// Keypad input
			if(!do_input(parameters[0], parameters[1], parameters[3], 1))
				do_skip(parameters[2]);
			continue;
		case 'L' :	// Link control string
			if(parm_type[0]) {
				xgo(parameters[0]);
				goto new_exec; }
			cmd_ptr = command_buffer;
			continue;
		case 'M' :	// Read data from card reader only
			value = 3;
	Mretry:	if(do_input(0, 0, 0, 2) == 3) {
				if(--value) goto Mretry;
				do_skip(parameters[0]); }
			continue;
		case 'N' :	// Send dest buffer to printer
			if(value = parameters[0]) {
				ptr = bwptr[dest_buf];
				while(value--)
					*ptr++ = '\n';
				*(bwptr[dest_buf] = ptr) = 0;
				check_dest(); }
			ptr = dbptr;
			while(p = *ptr++) {
				if(p < ' ') switch(p) {
					case 18 : *pwin = (*pwin == REVERSE) ? 0x74 : REVERSE;
					default: continue;
					case '\f' :
//						for(value=0; value < 5; ++value)
						value=0; do {
							w_putc(p = '\n', pwin); }
						while(++value < 5);
					case '\n' : *pwin = REVERSE; }
				w_putc(p, pwin); }
			xdelay(1);
			continue;
		case 'O' :	// Move extraction pointer in source buffer
			ptr1 = buffers[src_buf];
			value = parameters[0] || 1;
			if(value & 0x8000) {
				value = -value;
				do {
					if(brptr <= ptr1)
						break;
					--brptr; }
				while(--value); }
			else do {
				if(!*brptr)
					break;
				++brptr; }
			while(--value);
			continue;
		case 'P' :	// Display custom prompt
			read_memory(parameters[0], buffer);
			write_display("%s", buffer);
			continue;
		case 'Q' :	// Append WCC
			p = parameters[0] | 0x40;
			if(!inp_source)
				p |= 1;
			*bwptr[dest_buf]++ = p;
			*bwptr[dest_buf] = 0;
			check_dest();
			continue;
		case 'R' :	// Append value to buffer
			if(parm_type[0] == P_STR) {
				ptr1 = buffer;
				goto xappend; }
			if(value = parameters[0]) {
				ptr = bwptr[dest_buf];
				*ptr++ = value & 0x7F;
				*(bwptr[dest_buf] = ptr) = 0;
				check_dest(); }
			continue;
		case 'S' :	// Dial number
			value = (Host_tran && !parm_type[1]) ? Host_tran : parameters[1];
			switch(parameters[0]) {
			default: goto badcmd;
			case 0 :	// Start dialing
				if(Modem_state != M_IDLE) {
					Copen(Comport, Baud, Parity, Comset &= ~SET_DTR);
					Mtimer = 0;
					Modem_state = M_RESET;
					while(!Modem_state) poll_input(); }
				if(read_memory(value, buffer)) {
					sprintf(Modem_string, "ATDT%s\r", buffer);
			Dial:	Mtimer = 0;
					Modem_state = M_DIAL; }
				continue;
			case 3 :	// Off hook immediately
				strcpy(Modem_string, "ATH1\r");
				goto Dial; }
			continue;
		case 'T' :	// Arithmetic operations
			arithmetic(parameters[0], parameters[1]);
			continue;
		case 'U' :	// Write buffer to memory
			value = dest_buf;
			if(parameters[1])
				value = parameters[1]-1;
			write_memory(parameters[0], buffers[value]);
			continue;
		case 'V' :	// Display buffer
			strcpy(buffer, buffers[(parameters[0] || (dest_buf+1))-1]);
			switch(parameters[1]) {
			case 0 :
			case 1 :
				value = strlen(buffer);
				c1 = 0;
				write_display("%s", buffer);
				for(;;) {
					while(!(c = test_key())) if(poll_input()) return;
					switch(c) {
					case '#' : display_pos += 8; update_display(); continue;
					case '*' : display_pos -= 8; update_display(); continue;
					case 'D' : goto Vexit; } }
			case 2 :
				write_display("%s", buffer);
				c2 = BIOS_TICK;
				value = (parameters[2] || 7000) * 9;
				while((BIOS_TICK-c2) < value) {
					if(poll_input()) return;
					if(krptr != kwptr)
						break; }
			Vexit:	continue; }
			goto badcmd;
		case 'W' :	// Wait for printer ready
			if(parameters[0])
				do_skip(parameters[1]);
			continue;
		case 'X' :	// Append source to dest
			value = parameters[0];
			c1 = parameters[1];
			ptr1 = bwptr[dest_buf];
			do {
				if((*brptr == c1) || !*brptr)
					break;
				*ptr1++ = *brptr++; }
			while(--value);
			*(bwptr[dest_buf] = ptr1) = 0;
			check_dest();
			continue;
		case 'Y' : 	// Append next non-blank
			while(mem_dump < 1000) {
				if(read_memory(mem_dump, ptr = buffer)) {
					ptr1 = bwptr[dest_buf];
					sprintf(ptr1, "%u=", mem_dump++);
					while(*ptr1) ++ptr1;
					goto append_print; }
				++mem_dump; }
			do_skip(parameters[0]);
			continue;
		case 'Z' :	// Pad dest buffer
			value = parameters[0];
			p = parameters[1] || 32;
			value1 = parameters[2];
			ptr = dbptr;
			if((c1 = strlen(ptr)) >= value)
				continue;
			strcpy(buffer, ptr);
			if(value1) {
				c = value - c1;
				if(value1 != 1)
					c /= 2;
				while(c) {
					*ptr++ = p;
					++c1;
					--c; } }
			strcpy(ptr, buffer);
			find_end();
			if(value1 != 1) {
				while(c1 < value) {
					*ptr++ = p;
					++c1; } }
			*(bwptr[dest_buf] = ptr) = 0;
			check_dest();
			continue;
		case 0 :
		do_exit:
			if(repeat > 1) {
				--repeat;
				cmd_ptr = command_buffer;
				goto restart; }
			if(sp) {
				cmd_ptr = p_stack[--sp];
				xgo(l_stack[sp]);
				repeat = r_stack[sp];
				goto old_exec; }
			exec_locn = -1;
			return; }

	if(cmd == '*') {
		switch(cmd1) {
		case 'N' :
		case 'O' :
		case 'Q' :
			c1 = parm_type[0];
			if(!check((c1 >= P_VAR) && (c1 < P_STR), "VARIABLE REQUIRED"))
				continue;
			c1 -= P_VAR; }
		switch(cmd1) {
		case 'A' :		// Open new batch
			batch_error = 2;
			bc_addr = bc_link = bc_index = -1;
			ptr = dbptr;
			if((value = find_batch(ptr)) == -1) {
				if(batch_top >= BSIZE) {
					dump_state("BATCH LIST FULL");
					batch_error = 1;
					continue; }
				batch_list[value = batch_top++] = write_batch(-1, -1, ptr); }
			else
				find_batch_last();
			bc_index = value;
			do_skip(parameters[0]);
			goto batchok;
		case 'B' :		// Select batch for read
			bc_addr = bc_link = bc_index = -1;
			batch_error = 2;
			if(!batch_top)
				continue;
			switch(parameters[0]) {
			default: goto badcmd;
			case 0 : value = 0; goto Bopen;				// Youngest
			case 1 : value = batch_top-1; goto Bopen;	// Oldest
			case 2 :									// Next batch
				if((value = bc_index+1) >= batch_top)
					continue;
			Bopen:
				if(!read_batch(batch_list[value], buffer))
					continue;
				break;
			case 3 :									// Matching header
				if((value = find_batch(dbptr)) == -1)
					continue; }
			bc_index = value;
			do_skip(parameters[1]);
		batchok:
			batch_error = 0;
			continue;
		case 'C' :		// Copy destination buffer to batch
			batch_error = 2;
			if(bc_addr == -1) {
				dump_state("NO OPEN BATCH");
				continue; }
			ptr = dbptr;
			switch(parameters[0]) {
			default: goto badcmd;
			case 0 :	// Append to batch
			Cappend:
				find_batch_last();
				write_batch(bc_link, bc_addr, dbptr);
				break;
			case 1 :	// Replace current record
				value1 = compress(ptr, buffer);
				if(value1 != bc_size) {
					dump_state("BATCH REPLACE MISMATCH (%u-%u)", value1, bc_size);
					continue; }
				for(c=0; c < value1; ++c)
					poke(memory_seg, bc_addr+c+4, buffer[c]); }
			do_skip(parameters[1]);
			goto batchok;
		case 'D' :		// Delete batch
			batch_error = 2;
			if(parameters[0] != 2) {
				if(bc_addr == -1) {
					dump_state("NO OPEN BATCH");
					continue; }
				ptr1 = batch_list[value = bc_index]; }
			switch(parameters[0]) {
			default: goto badcmd;
			case 0 :	// Delete entire batch
				if(!delete_batch(ptr1)) continue;
				bc_index = bc_addr = bc_link = -1;
				while(value < batch_top) {
					batch_list[value] = batch_list[value+1];
					++value; }
				--batch_top;
				break;
			case 1 :	// Delete detail records only
				if(!read_batch(ptr1, buffer)) continue;
				if(!delete_batch(bc_link)) continue;
				poke(memory_seg, ++ptr1, 3);
				poke(memory_seg, ++ptr1, 0x7F);
				poke(memory_seg, ++ptr1, 0x7F);
				read_batch(ptr1, buffer);
				break;
			case 2 :	// Delete all batches
				for(value1 = 1; value1 < batch_top; ++value1)
					delete_batch(batch_list[value1]);
				bc_index = bc_addr = bc_link = -1;
				batch_top = 0;
				break;
			case 3 :	// Delete selected record
				ptr = value1 = locate_batch_record(ptr1, bc_addr);
				if(ptr == -1) {
					dump_state("RECORD NOT FOUND %u", value);
					continue; }
				free_memory(bc_addr, bc_size+4);
				c = 0;
				if(bc_link & 0x8000) c |= 2;
				if(bc_link & 0x0080) c |= 1;
				poke(memory_seg, ++ptr, c);
				poke(memory_seg, ++ptr, bc_link & 0x7F);
				poke(memory_seg, ++ptr, (bc_link >> 8) & 0x7F);
				read_batch(value1, buffer); }
			do_skip(parameters[1]);
			goto batchok;
		case 'E' :		// Read batch record
			batch_error = 2;
			if(bc_addr == -1) {
				dump_state("NO OPEN BATCH");
				continue; }
			switch(c = parameters[0]) {
			case 1 :			// First detail record in batch
			case 2 : 			// Batch header
				if(!read_batch(batch_list[bc_index], buffer))
					continue;
			case 0 :			// Next detail record
				if(c != 2) {
					if(!read_batch(bc_link, buffer))
						continue; }
				goto Eret;
			case 3 :			// Matching detail record
				batch_error = 3;
			Elook:
				ptr = brptr;
				if(!read_batch(bc_link, ptr1 = buffer))
					continue;
				while(*ptr) {
					if(*ptr1++ != *ptr++)
						goto Elook; }
			Eret:
				ptr1 = buffer;
				do_skip(parameters[1]);
				batch_error=0;
				goto xappend;
				goto Eret; }
			goto badcmd;
		case 'F' :		// Detect batch errors
			if(parameters[1] != batch_error)
				do_skip(parameters[0]);
			continue;
		case 'G' :		// Terminal beep
			switch(parameters[0]) {
			case 2 :
				read_memory(9, buffer);
				if(*buffer && (*buffer != '0'))
					continue;
			case 0 : xbeep(); continue;
			case 1 : beep(500, 500); continue; }
		badcmd:
			dump_state("BAD COMMAND FORMAT");
			continue;
		case 'H' :		// Pinpad input
			ptr = d6buf;
			*ptr++ = STX;
			Lrc = 0;
			append("70.");
			append(buffers[src_buf]);
			Lrc ^= (*ptr++ = FS);
			read_memory(16, ptr1 = buffer);
			while(*ptr1 && (*ptr1 != '-'))
				Lrc ^= (*ptr++ = *ptr1++);
			append(dbptr);
			Lrc ^= (*ptr++ = ETX);
			*ptr++ = Lrc;
			*ptr = 0;
			run_din6();
			ptr = d6buf;
			expect(ACK);
			d6ptr = 1;
			goto waitpin;
		case 'I' :
			character_io(parameters[0], parameters[1], parameters[2], parameters[3], 1);
			continue;
		case 'J' :
			display_mode = parameters[0] ? -1 : 0;
			continue;
		case 'K' :		// Abort
			switch(parameters[0]) {
			case 0 : process_abort(-1); continue;
		abort_display:
			case 1 : process_abort(-1); Host_tran = -1; continue;
			case 2 :
			case 3 : process_abort(0); continue; }
			goto badcmd;
		case 'L' :		// Call subroutine
			if(check(sp < STACK, "STACK OVERFLOW")) {
				r_stack[sp] = repeat;
				l_stack[sp] = exec_locn;
				p_stack[sp++] = cmd_ptr;
				xgo(parameters[0]);
				repeat = parameters[1] || 1;
				goto new_exec; }
			continue;
		case 'M' :		// Exit control string
			goto do_exit;
		case 'N' :		// Set variable
			variables[c1] = parameters[1];
			continue;
		case 'O' :		// Arithmetic on variables
			value = parameters[0];
			c = parameters[1];
			value1 = (parm_type[2]) ? parameters[2] : (c < 5);
			switch(c) {
			default: goto badcmd;
			case 0 : value += value1;	break;	// +
			case 1 : value -= value1;	break;	// -
			case 2 : value *= value1;	break;	// *
			case 3 : value /= value1;	break;	// /
			case 4 : value %= value1;	break;	// %
			case 5 : value &= value1;	break;	// AND
			case 6 : value |= value1;	break;	// OR
			case 7 : value ^= value1; }			// XOR
			if(!(variables[c1] = value))
				do_skip(parameters[3]);
			continue;
		case 'P' :		// Communications parameters
			if(parameters[0]) Etx = parameters[0];
			if(parameters[1]) Stx = parameters[1];
			if(parameters[2]) Nak_limit = parameters[2];
			if(parameters[3]) switch(parameters[3]) {
				default: goto badcmd;
				case 1 : Multi_ack = 0; break;
				case 2 : Multi_ack = -1; }
			if(parameters[4]) {
				switch(parameters[4]) {
				default: goto badcmd;
				case 1 : Baud = 384; break;	// 300 Bps
				case 2 : Baud = 96; }		// 1200 Bps
				Copen(Comport, Baud, Parity, Comset); }
			continue;
		case 'Q' :		// Set variable to content of buffer
			value = parameters[1] || dest_buf+1;
			ptr = buffers[value-1];
			if(parameters[2]) {
				value = *ptr++;
				if(*ptr)
					value = (value << 8) + *ptr; }
			else {
				extract_number(ptr, buffer);
				value = atoi(buffer); }
			variables[c1] = value;
			continue;
		case 'R' :		// Communications device speed
			switch(parameters[0]) {
			default: goto badcmd;
			case 0 : Baud = 384; break;	// 300
			case 1 : Baud = 192; break;	// 600
			case 2 : Baud = 96;  break;	// 1200
			case 3 : Baud = 48;  break;	// 2400
			case 4 : Baud = 24;  break;	// 4800
			case 5 : Baud = 12;  break;	// 9600
			case 6 : Baud = 6; }	 	// 19200
			switch(parameters[1]) {
			default: goto badcmd;
			case 1 : Com_handshake = 0; break;
			case 2 : Com_handshake = 1; break;
			case 3 : Com_handshake = 2;
			case 0 : }
			switch(parameters[2]) {
			default: goto badcmd;
			case 1 : Parity = PAR_EVEN|DATA_7|STOP_2;	break;
			case 2 : Parity = PAR_NO|DATA_8|STOP_2;
			case 0 : }
			Copen(Comport, Baud, Parity, Comset);
			continue;
		case 'S' :		// Verify free memory
			if(get_free_size() > parameters[1])
				do_skip(parameters[0]);
			continue;
		case 'T' :		// Communications timeouts
			if(parameters[0]) Tmo_carrier	= parameters[0];
			if(parameters[1]) Tmo_enq		= parameters[1];
			if(parameters[2]) Tmo_resp		= parameters[2];
			if(parameters[3]) Tmo_rperiods	= parameters[3];
			if(parameters[4]) Tmo_eot		= parameters[4];
			switch(parameters[5]) {
			default: goto badcmd;
			case 1 : Eot_enable = -1; break;
			case 2 : Eot_enable = 0;
			case 0 : }
			continue;
		case 'V' :		// Append phone status
			while(!Modem_state) {
				if(poll_input())
					return; }
			*bwptr[dest_buf]++ = Modem_state + '0';
			*bwptr[dest_buf] = 0;
			check_dest();
			continue;
		case 'W' :		// General wait
			value = parameters[0] * 18;
			value1 = BIOS_TICK;
			if((c = parameters[2]) > 3) goto badcmd;
			for(;;) {
				if(poll_input()) return;
				if(c < 3) {
					if(c1 = test_key()) {
						switch(c1) {
						case 'D' : if(c == 1) goto Wtmo;
						case 'B' :
						case 'C' : if(c < 2) continue; }
						*bwptr[dest_buf]++ = c1;
						*bwptr[dest_buf] = 0;
						check_dest();
						goto Wexit; } }
				if(value) {
					if((BIOS_TICK - value1) > value)
						break; } }
		Wtmo: do_skip(parameters[1]);
		Wexit:
			continue;
		case 'X' :		// Account number range
			if(check_account_range(parameters[0] || 40, parameters[1] || 59))
				do_skip(parameters[2]);
			continue;
		case 'Y' :		// Poll input devices
			value = (parameters[0] * 18);
			value1 = BIOS_TICK;
			for(;;) {
				if(c = parameters[1]) {		// Card reader
					if(*cbuf) break; }
				if(c = parameters[2]) {		// Keyboard
					if(krptr != kwptr) break; }
				if(c = parameters[4]) {		// Serial
					if((Cpending != -1) || ((Cpending = Ctestc()) != -1))
						break; }
				if(c = parameters[5]) { 	// Modem
					if((Cpending != -1) || ((Cpending = Ctestc()) != -1))
						break; }
				if(c = parameters[6]) {		// PInPad
					if((*d6buf) && d6buf[d6ptr])
						break; }
				if(value) {
					if((BIOS_TICK - value1) > value)
						{ c = 0; break; } }
				if(poll_input()) return; }
			do_skip(c);
			continue;
		case 'Z' :		// Calculate free space
			sprintf(ptr1 = buffer, "%u", get_free_size());
			goto xappend;
		} }

		if(cmd == '+') switch(cmd1) {
		case 'A' :		// Compare variable
			value = parameters[0];
			value1 = parameters[2];
			switch(parameters[1]) {
			default: goto badcmd;
			case 0 : if(value != value1) continue; break;	// ==
			case 1 : if(value <= value1) continue; break;	// >
			case 2 : if(value >= value1) continue; }		// <
			do_skip(parameters[3]);
			continue;
		case 'B' :		// Calculate CRC
			value = parameters[0];
			switch(parameters[1]) {
			default: goto badcmd;
			case 0 : value &= 255; ptr = dbptr; while(*ptr) value ^= *ptr++; break;
			case 1 : value = do_crc(dbptr, value); }
			variables[parm_type[0]-P_VAR] = value;
			continue;
		case 'C' :		// Buffer comparison
			value = strcmp(buffers[src_buf], dbptr);
			switch(parameters[0]) {
			default: goto badcmd;
			case 0 : if(value)		continue; break;		// ==
			case 1 : if(value != 1) continue; break;		// >
			case 2 : if(value !=-1) continue; }				// <
			do_skip(parameters[1]);
			continue;
		case 'D' :		// Dial
			sprintf(Modem_string, "AT%s;\r", dbptr);
			goto Dial;
		case 'E' :
			do_e_input(parameters[0] || 2, parameters[1] || 9, parameters[2]);
			continue;
		case 'F' :		// Enable/Disable/Send ACK
			if(parameters[0] == 5)
				Cput_c(ACK);
			continue;
		case 'G' :		// Append detail record to batch
			batch_error = 2;
			if(bc_addr == -1) {
				dump_state("NO OPEN BATCH");
				continue; }
			if(parameters[0] != 1) goto Cappend;
			ptr = locate_batch_record(batch_list[value = bc_index], bc_addr);
			if(ptr == -1) {
				dump_state("RECORD NOT FOUND %u", value );
				continue; }
			write_batch(bc_addr, ptr, dbptr);
			do_skip(parameters[1]);
			goto batchok;
		case 'H' :		// Wait for pin block
		waitpin:
			ptr = d6buf + d6ptr;
			expect(Lrc = STX);
			expect_string("71.0");
			extract(buffer, 2);
			expect_string("01");
			extract(ptr1 = dbptr, 16);
			expect(ETX);
			if(*ptr++ != Lrc)
				dump_state("BAD RESPONSE LRC");
			ptr = ptr1;
			bwptr[dest_buf] = find_end();
			check_dest();
			continue;
		case 'I' :
			character_io(parameters[0], parameters[1], parameters[2], parameters[3], 2);
			continue;
		case 'J' :		// Buffer modification
			ptr = brptr;
			ptr1 = dbptr;
			switch(parameters[0]) {
			default: goto badcmd;
			case 0 : ptr1 = bwptr[dest_buf];
				do {
					p = *ptr++;
					if((p != '.') && (p != ','))
						*ptr1++ = p; }
				while(p);
				break;
			case 1 :
				ptr1 = format_money(ptr, bwptr[dest_buf], 2, F_DOLLAR); break;
			case 2 : ptr1 = bwptr[dest_buf];
			append_print:
				while(p = *ptr++) {
					if(p < ' ') {
						*ptr1++ = '^';
						p += 0x40; }
					*ptr1++ = p; }
				*ptr1 = 0;
				break;
			case 3 :
				while(*ptr && *ptr1) {
					p = *ptr++;
					if(*ptr1 == ' ')
						*ptr1 = p;
					++ptr1; }
				*ptr1 = 0;
				break;
			case 4 :
				while(*ptr && *ptr1)
					*ptr1++ &= *ptr++;
				break;
			case 5 :
				while(*ptr && *ptr1)
					*ptr1++ |= *ptr++;
				break;
			case 6 :
				while(*ptr && *ptr1)
					*ptr1++ ^= *ptr++; }
			*(bwptr[dest_buf] = ptr1) = 0;
			check_dest();
			continue;
		case 'K' :		// Carrier control
		switch(parameters[0]) {
		default: goto badcmd;
		case 0 :		// Raise carrier
			if(Modem_state == M_IDLE) {
				strcpy(Modem_string, "ATO\r");
				goto Dial; }
			if(Modem_state == M_RING) {
		case 2 :		// Raise answer tone
				strcpy(Modem_string, "ATA\r");
				goto Dial; }
			continue;
		case 1 :	// Drop carrier
			Copen(Comport, Baud, Parity, Comset &= ~SET_DTR);
			Mtimer = 0;
			Modem_state = M_RESET;
			continue;
		case 5 :
		case 6 :
			value = value1 = BIOS_TICK;
			do {
				c = BIOS_TICK;
				c1 = Ctestc();
				if(c1 != -1) {
					Cpending = c1;
					value = c; }
				if((c - value) > 3)
					goto Kcontinue; }
			while((c - value1) <= (12*18));
			write_display("CANNOT CONNECT");
			xdelay(20);
			process_abort(-1);
		Kcontinue: continue;
			case 7 : if(Modem_state == M_CNCT) do_skip(parameters[1]); }
			continue;
		case 'L' :		// Lock/Unlock keyboard
			kbd_enable = parameters[0] ? -1 : 0;
			continue;
		case 'M' :		// Set modem parameters
			switch(parameters[0]) {		// Modem mode
				default: goto badcmd;
				case 1 : modem_dir = -1; break;
				case 2 : modem_dir = 0;
				case 0 : }
			switch(parameters[1]) {		// Serial format
				default: goto badcmd;
				case 1 : Parity = PAR_EVEN|DATA_7|STOP_2; goto Mopen;
				case 2 :
				case 3 : Parity = PAR_NO|DATA_8|STOP_2;
				Mopen: Copen(Comport, Baud, Parity, Comset);
				case 0 : }
			switch(parameters[2]) {		// Re-transmit on NAK
				default: goto badcmd;
				case 1 : rtx_nak = -1;	break;
				case 2 : rtx_nak = 0;
				case 0 : }
			switch(parameters[3]) {		// Re-transmit on ENQ
				default: goto badcmd;
				case 1 : rtx_enq = -1;	break;
				case 2 : rtx_enq = 0;
				case 0 : }
			continue;
		case 'P' :		// Delay in millisconds
			xdelay((value=parameters[0]) ? (value+25) / 55 : 18);
			continue;
		case 'Q' :		// Append variable to buffer
			value = parameters[0];
			if(parameters[1]) {
				if(value & 0xFF00)
					*bwptr[dest_buf]++ = value >> 8;
				*bwptr[dest_buf]++ = value;
				*bwptr[dest_buf] = 0;
				check_dest();
				continue; }
			sprintf(ptr1 = buffer, "%u", parameters[0]);
			goto xappend;
		case 'R' :		// Get/Set RS-232 handshake
			switch(parameters[0]) {
			case 0 :	// Drop Handshake
				if(!com_handshake) continue;
				Comset &= ~SET_RTS;
				goto Rsetx;
			case 1 :	// Raise Handshake
				if(!com_handshake) continue;
				Comset |= SET_RTS;
			Rsetx:
				Copen(Comport, Baud, Parity, Comset);
				continue;
			case 5 :	// Test DSR
				value = DSR;
				goto Rcheckx;
			case 6 :	// Test CTS
				value = CTS;
				goto Rcheckx;
			case 7 :	// Test CTS & RTS
				value = DSR|CTS;
			Rcheckx:
				if(((Csignals() & value) == value) || !com_handshake)
					do_skip(parameters[1]);
				continue; }
			goto badcmd;
		case 'S' :		// Get dest buffer size
			value = (parameters[0] || (dest_buf+1))-1;
			switch(parameters[1]) {
			default: goto badcmd;
			case 0 : c = bwptr[value] - buffers[value]; break;
			case 1 : c = compress(buffers[value], buffer); }
			value1 = parm_type[2];
			check((value1 >= P_VAR) && (value1 < P_STR), "VARIABLE REQUIRED");
			variables[value1 - P_VAR] = c;
			continue;
		case 'T' :		// Din6 IO
			character_io(parameters[0], parameters[1], parameters[2], parameters[3], 0);
		case 'U' :		// Set Din6 comm parms
			continue;
		case 'V' :		// Append signon message
			ptr1 = signon;
			goto xappend;
		case 'X' :		// Send network data
			if(value = parameters[0]) {
				if(parm_type[0] == P_STR) {
					ptr = buffer;
					while(*ptr)
						Cput_c(*ptr++); }
				else if(value)
					Cput_c(value); }
			continue;
		case 'Y' :		// Receive network data
			if(parm_type[0] == P_STR)
				ptr = parameters[0];
			else {
				buffer[0] = parameters[0] || 13;
				buffer[1] = 0;
				ptr = buffer; }
			if(network_rx(ptr, parameters[1] || 30000, parameters[2] || 1))
				do_skip(parameters[3]);
			continue;
		case 'Z' :		// Special command
			if(Host_key) switch(parameters[0]) {
				case 1 :
					variables[1] = Tmo_carrier;
					variables[2] = Tmo_enq;
					variables[3] = Tmo_resp;
					variables[4] = Tmo_rperiods;
					variables[5] = Tmo_eot;
					continue; }
		}
		dump_state("UNRECOGNIZED COMMAND"); }
}

/*
 * Verify that an account number is within range
 */
check_account_range(unsigned mem, unsigned end)
{
	unsigned char low[11], high[11], *p, *p1, c;

next:
	if((mem > end) || !read_memory(mem, ptr = buffer))
		return 0;

	ptr1 = low;
	while((c = *ptr++) != '.') {
		if(!isdigit(c)) {
			dump_state("BAD RANGE TABLE at %u", mem);
			return 0; }
		*ptr1++ = c; }
	*ptr1 = 0;

	ptr1 = high;
	while((c = *ptr++) != '.') {
		if(!isdigit(c)) {
			dump_state("BAD RANGE TABLE at %u", mem);
			return 0; }
		*ptr1++ = c; }
	*ptr1 = 0;

	p = p1 = brptr;

	ptr1 = low;
	while(*ptr1) {
		if(*p < *ptr1) {
			++mem;
			goto next; }
		if(*p++ > *ptr1++)
			break; }

	ptr1 = high;
	while(*ptr1) {
		if(*p1 > *ptr1) {
			++mem;
			goto next; }
		if(*p1++ < *ptr1++)
			break; }

	ptr1 = bwptr[dest_buf];
	while(*ptr)
		*ptr1++ = *ptr++;
	*(bwptr[dest_buf] = ptr1) = 0;
	check_dest();
	return -1;
}

/*
 * Read a batch entry into the working buffer
 *
 * On success:
 *  bc_addr = address of record
 *  bc_size = size of record
 *  bc_link = link to next record
 *  return !0
 * On failure:
 *  return 0
 */
read_batch(unsigned a, char *dest)
{
	unsigned h, l, s, f;

	Debug(("\nRb:%04x", a))
	if(a >= 0x8000)
		return 0;
	s = peek(memory_seg, a);
	Debug((" s=%u", s))
	if(s == 0xFF) {
		batch_error = 2;
		return 0; }
	bc_addr = a;
	bc_size = s;
	f = peek(memory_seg, ++a);
	l = peek(memory_seg, ++a);
	h = peek(memory_seg, ++a);

	if(f & 1) l |= 0x80;
	if(f & 2) h |= 0x80;
	bc_link = (h << 8) | l;
	Debug((" l=%04x", bc_link))

	decompress(a+1, dest, s);
	Debug((" '%s'", dest))

	return -1;
}

/*
 * Follow a batch chain to the end
 */
find_batch_last()
{
	char temp[256];

	Debug(("\nFind_batch_last:"))
	while(bc_link != -1) {
		if(!(read_batch(bc_link, temp))) {
			dump_state("Batch read failed!");
			return; } }
}

/*
 * Delete a batch record and all subsequent records
 */
delete_batch(unsigned locn)
{
	unsigned char temp[256];

	Debug(("\nDb:%04x", locn))
	if(locn >= 0x8000) {
		batch_error = 2;
		dump_state("BAD BATCH DELETE");
		return 0; }
	while(locn < 0x8000) {
	Debug(("\nLocn: %04x", locn))
		if(!read_batch(locn, temp)) {
			batch_error = 2;
			dump_state("BATCH READ FAILED");
			return 0; }
		free_memory(locn, bc_size+4);
		locn = bc_link; }
	return -1;
}

/*
 * Locate a specific record
 */
locate_batch_record(unsigned locn, unsigned look)
{
	unsigned addr, size, link, r;
	char temp[256];

	addr = bc_addr;
	size = bc_size;
	link = bc_link;

	Debug(("\nLb:%04x %04x", locn, look))
	if(locn >= 0x8000) {
		batch_error = 2;
		dump_state("BAD BATCH LOCATE");
		return -1; }
	do {
		if(!read_batch(locn, temp)) {
			batch_error = 2;
			dump_state("BATCH READ FAILED");
			r = -1;
			goto exit; }
		if(bc_link == look) {
			r = locn;
			goto exit; } }
	while((locn = bc_link) < 0x8000);
	r = -1;
exit:
	Debug(("\nFound:%04x", r))
	bc_addr = addr;
	bc_size = size;
	bc_link = link;
	return r;
}

/*
 * Write a batch entry
 */
write_batch(unsigned link, unsigned parent, unsigned char *source)
{
	unsigned s, f, addr, asave;
	char buffer[256], *p;

	Debug(("\nWb:%04x %04x %s", link, parent, source))
	s = compress(source, p = buffer);
	asave = addr = find_free(s+4);
	Debug((" s=%u a=%04x", s, asave))
	if(addr == -1) {
		batch_error = 1;
		dump_state("Failed to allocate");
		return -1; }

	bc_size = s;
	bc_addr = addr;
	bc_link = link;

	poke(memory_seg, addr, s);
	f = 0;
	if(link & 0x8000) f |= 2;
	if(link & 0x0080) f |= 1;
	poke(memory_seg, ++addr, f);
	poke(memory_seg, ++addr, link & 0x7F);
	poke(memory_seg, ++addr, (link >> 8) & 0x7F);
	while(s) {
		poke(memory_seg, ++addr, *p++);
		--s; }
	if(parent != -1) {
		f = 0;
		if(asave & 0x8000) f |= 2;
		if(asave & 0x0080) f |= 1;
		poke(memory_seg, ++parent, f);
		poke(memory_seg, ++parent, asave & 0x7F);
		poke(memory_seg, ++parent, (asave >> 8) & 0x7F); }
	return asave;
}

/*
 * Find batch entry pointed to by dest
 */
find_batch(char *name)
{
	unsigned i, m;
	Debug(("\nFb:%s", name))
	for(i=0; i < batch_top; ++i) {
		if((m = batch_list[i]) == -1)
			continue;
		read_batch(m, buffer);
		if(!strcmp(name, buffer))
			return i; }
	return -1;
}

batch_debug()
{
	unsigned i, a, a1, sp, x, stack[100];
	unsigned char *p;

	wopen(i = 0, 7, 80, 7, WSAVE|WBOX2|WCOPEN|NORMAL);
	if(!batch_top) {
		wprintf("No BATCH entries!");
		wgetc();
		wclose();
		return; }
	for(;;) {
		sp = 0;
		a1 = a = batch_list[i];
	reshow:
		wclwin();
		wprintf("BATCH #%u @%04x - Record #%u @%04x\n--Raw (compressed) memory:\n", i, a, sp, a1);
//		for(x=0; x < 26; ++x)
		x = 0; do {
			wprintf("%02x ", peek(memory_seg, a1+x)); }
		while(++x < 26);
		if(read_batch(a1, p = buffer)) {
			wprintf("\n--Record content (Size=%u Addr=%04x Link=%04x):\n", bc_size, bc_addr, bc_link);
//			for(x = 0; x < 78; ++x)
			x=0; do {
				wputc(*p ? ((int)*p++ | 0x100) : ' '); }
			while(++x < 78); }
		else
			wprintf("\nRead error!\n");
		switch(wgetc()) {
		case _KUA: if(i) --i; continue;
		case _KDA: if((i+1) < batch_top) ++i; continue;
		case _KHO: i = 0; continue;
		case _KEN: i = batch_top-1; continue;
		case _KRA:
			if(bc_link != -1) {
				stack[sp++] = bc_addr;
				a1 = bc_link; }
			goto reshow;
		case _KLA :
			if(sp)
				a1 = stack[--sp];
			goto reshow;
		case _K10 :
			wclose();
			return;
		case '?' : help(4); goto reshow; } }
}

/*
 * Wait for string from network
 */
network_rx(unsigned char *term, unsigned timeout, unsigned tries)
{
	unsigned c, ts, p, p1, i, l;
	unsigned char *b;

	l = strlen(term);	// Length of desired string
	timeout /= 55;		// Convert to 55 ms ticks.
	ts = BIOS_TICK;		// Get current system time
	b = buffer+2;		// Skip possible char use of buffer
	p = 0;				// Reset our position
	do {
		if((c = Ctestc()) != -1) {
			buffer[p++] = c;
			p1 = (p &= 0x7F);
			i = l;
			while(i) {
				if(buffer[--p1 & 0x7F] != term[--i])
					goto nomatch; }
			if(--tries)
				goto nomatch;
			while(Ctestc() != -1);
			return -1;
		nomatch: } }
	while((BIOS_TICK - ts) < timeout);
	while(Ctestc() != 01);
	return 0;
}

/*
 * Handle keypad input functions
 */
do_input(unsigned itype, unsigned max, unsigned min, char src)
{
	unsigned i, j;
	unsigned char c, n[4], n1[4], af, nf, xf, *dest, *dest1;
	static char *xkeys[] = {
		"0- +", "1QZ.", "2ABC", "3DEF", "4GHI", "5JKL", "6MNO",
		"7PRS", "8TUV", "9WXY", "*,'\"", "#:;@", 0 };

	dest1 = dest = bwptr[dest_buf];
	*buffer = 0;

	if(!itype)
		itype = 3;
	if(!max)
		max = (itype == 4) ? 9 : 60;
	if(min > max)
		min = 0;
	longset(n, i=af=nf=xf=0);
	switch(itype) {
	case 1 :
	case 3 : af = 255; break;
	case 4 : nf = 255; break;
	case 5 : af = 255;
	case 6 :
	case 7 : xf = '*'; }

	for(;;) {
		for(;;) {
			if(src & 1) {
				if(c = test_key())
					break; }
			if((src & 2) && !i) {
				if(*cbuf) {
					if(*cbuf == 0xFF) {
						write_display("Bad Card");
						*cbuf = 0;
						return 3; }
					ptr = cbuf;
					while(*ptr)
						*dest++ = *ptr++;
					*dest = 0;
					strcpy(buffer, dest1);
					*dest++ = FS;
					*(bwptr[dest_buf] = dest) = *cbuf = 0;
					check_dest();
					return 2; } }
			if(poll_input())
				return; }
		switch(c) {
			case 'B' :				// Backspace
				if(!i) { xbeep(); continue; }
				--i;
				if(nf) {
					longset(n1, 10);
					slongdiv(n, n1);
					goto update_display; }
				dest[i] = 0;
				goto update_display;
			case 'C' :				// ALPHA
				if(!i) { xbeep(); continue; }
				if(!af) { xbeep(); continue; }
				c = dest[i-1];
				for(j=0; ptr = xkeys[j]; ++j) {
					while(*ptr) if(*ptr++ == c) {
						c = *ptr ? *ptr : *xkeys[j];
						--i;
						goto store_char; } }
				xbeep();
				continue;
			case 'D' :				// ENTER
				if(*dest) {
					if(i < min) { xbeep(); continue; }
					while(*dest) ++dest;
					strcpy(buffer, dest1);
					if(!nf)
						*dest++ = FS;
					*(bwptr[dest_buf] = dest) = 0;
					check_dest();
					return 1; }
				return 0;
			case '*' :
				if(nf) {
					longcpy(n1, n);
					longset(n, 0);
					longsub(n, n1);
					goto update_display; }
			case '#' :
				if(!af) { xbeep(); continue; }
			default:
				if(i >= max) { xbeep(); continue; }
				if(nf) {
					longset(n1, 10);
					longmul(n, n1);
					longset(n1, c-'0');
					if(n[LSIZE-1] & 0x80)
						longsub(n, n1);
					else
						longadd(n, n1);
					++i; }
				else {
		store_char:
					dest[i] = c;
					dest[++i] = 0; }
		update_display:
				if(nf) {
					sltoa(n, buffer, 10);
					format_money(buffer, dest, 2, F_LEAD0); }
				display_mask = xf;
				write_display(dest);
		}
		// update display
	}
}

do_e_input(unsigned decpts, unsigned max, unsigned radix)
{
	unsigned i;
	unsigned char *dest, c, n[LSIZE], n1[LSIZE];

	switch(radix) {
		case 0 : radix = F_LEAD0; break;
		case 1 : radix = F_LEAD0|F_COMMA; break;
		case 2 : radix = F_LEAD0|F_LATIN; break;
		case 3 : radix = F_LEAD0|F_LATIN|F_COMMA; }

	dest = bwptr[dest_buf];

	longset(n, i = 0);
	strcpy(dest, "0");
	for(;;) {
		while(!(c = test_key())) if(poll_input()) return;
		switch(c) {
		case 'C' :
		case '#' : xbeep(); continue;
		case 'B' : if(!i) { xbeep(); continue; }
			--i;
			longset(n1, 10);
			slongdiv(n, n1);
			goto update_display;
		case '*' :
			longcpy(n1, n);
			longset(n, 0);
			longsub(n, n1);
			goto update_display;
		case 'D' :
			sltoa(n, buffer, 10);
			format_money(buffer, dest, decpts, radix & ~F_COMMA);
			while(*dest) ++dest;
			bwptr[dest_buf] = dest;
			check_dest();
			return; }
		if(i >= max) { xbeep(); continue; }
		++i;
		longset(n1, 10);
		longmul(n, n1);
		longset(n1, c-'0');
		if(n[LSIZE-1] & 0x80)
			longsub(n, n1);
		else
			longadd(n, n1);
	update_display:
		sltoa(n, dest, 10);
		format_money(dest, buffer, decpts, radix);
		write_display(buffer); }
}

/*
 * Handle date processing commands
 */
do_date(unsigned char type)
{
	unsigned h, mi, s, d, mo, y, w, x;
	unsigned char *p;

	if(type == P_STR) {
		w = get_date(&d, &mo, &y);
		get_time(&h, &mi, &s);
		ptr1 = bwptr[dest_buf];
		ptr = buffer;
		while(x = *ptr++) {
			p = "%c";
			switch(x) {
			case 'A' : x=y % 100;					goto u2;
			case 'B' : x = mo;						goto u2;
			case 'C' : x = d;						goto u2;
			case 'D' : if(!(x = h)) x = 12;
					   if(x > 12) x -= 12;			goto u2;
			case 'E' : x = mi;						goto u2;
			case 'F' : x = s;
			u2: 	p = "%02u"; 					break;
			case 'G' : x = (h > 11) ? 'P' : 'A';	break;
			case 'H' : x = y; p="%04u";				break;
			case 'I' : x = mons[mo];				goto st;
			case 'J' : x = monl[mo];				goto st;
			case 'K' : x = h;						goto u2;
			case 'L' : x = days[w];					goto st;
			case 'M' : x = 'M';						break;
			case 'N' : x = dayl[w];
			st:		p = "%s";						break;
			case 'O' : x = ':';						break;
			case 'P' : x = '=';						break;
			case 'Q' : x = w; p = "%u";				break; }
			sprintf(ptr1, p, x);
			while(*ptr1) ++ptr1; }
		bwptr[dest_buf] = ptr1;;
		check_dest();
		return; }
	if(type == P_NUM) {
		strcpy(ptr = buffer, dbptr);
		find_end();
		ptr -= 2;	s  = atoi(ptr);	*ptr = 0;
		ptr -= 2;	mi = atoi(ptr);	*ptr = 0;
		ptr -= 2;	h  = atoi(ptr);	*ptr = 0;
		ptr -= 2;	d  = atoi(ptr);	*ptr = 0;
		ptr -= 2;	mo = atoi(ptr);	*ptr = 0;
		ptr -= 2;	y = atoi(ptr) + 2000;
		set_date(d, mo, y);
		set_time(h, mi, s); }
}

/*
 * Calculate LHUN (mod 10) check digit and verify
 */
do_luhn(unsigned char *card)
{
	unsigned x, v, t;
	unsigned char c;

	x = (strlen(card) & 1) ? 1 : 2;
	t = 0;
	while(card[1]) {
		if(!isdigit(c = *card++))
			return 0;
		v = (c - '0') * x;
		t += v % 10;
		t += v / 10;
		x = (x == 2) ? 1 : 2; }
	return (((10000-t)%10) + '0') == *card;
}

/*
 * Calculate MOD11 check digit and verify
 */
do_mod11(unsigned char *card)
{
	unsigned i, t;
	unsigned char c;

	t = 0;
	i = 1;
	while(card[1]) {
		if(!isdigit(c = *card++))
			return 0;
		t += (c - '0') * ++i; }
	if(i != 9)
		return 0;
	return ((t%11) + '0') == *card;
}

/*
 * Calculate the CRC of a block
 */
do_crc(unsigned char *p, unsigned crc)
{
	crc = (crc >> 8) | (crc << 8);
	while(*p)		/* Calculate the CRC value */
		crc = crctab[((crc >> 8) ^ *p++) & 0xff] ^ (crc << 8);
	return (crc << 8) | (crc >> 8);
}
