/*
 * TRANZ-330 Simulator
 *
 * ?COPY.TXT 2000-2006 Dave Dunfield
 *  -- see COPY.TXT --.
 *
 * SIM330  is compiled with DDS Micro-C/PC: http://www.dunfield.com
 * Compile command: cc SIM330 -fop
 *
 * Note: The intermediate .ASM output file produced during compilation
 * was too large for Microsofts MASM 4.0, however Borlands TASM 1.0
 * had no problems with it!
 */
#include <stdio.h>
#include <window.h>
#include <comm.h>
#define	OLD_COMPRESS
// #define	STACK_CHECK

#define	ILOC		991

#define Debug(a)
#define	BIOS_TICK	peekw(0x40,0x6C)

#define	BUFSIZE	251		// Size of a buffer
#define	LSIZE	4		// Size of "long" number
#define	KSIZE	16		// Size of keypad buffer
#define	CSIZE	91		// Size of Card data buffer
#define	DWIDTH	73		// Dump width
#define	DUMPMAX	200		// Maximum dump
#define	STACK	10		// Depth of call stack
#define	BSIZE	25		// Max. number of batches

#define	MAXMEM	32768		// Maximum external memory
#define	MEMFAIL	"Failed to allocate memory"
#define	MEMOUT	"BAD MEM LOC %u"

// Parameters types
#define	P_NONE	0		// No parameter
#define	P_NUM	1		// Simple number
#define	P_VAR	2		// Variable: 10 values from 2-12
#define	P_STR	13		// String

// Format specifiers
#define	F_DOLLAR	1	// Add leading '$'
#define	F_LEAD0		2	// Add leading 0
#define	F_COMMA		4	// Add ',' separators
#define	F_LATIN		8	// Latin (',' instead of '.')

// Common control characters
#define	SOH			0x01		/* Start of header */
#define	STX			0x02		/* Start of text */
#define	ETX			0x03		/* End of text */
#define	EOT			0x04		/* End of transmission */
#define	ENQ			0x05		/* Enquiry */
#define	ACK			0x06		/* Positive acknowlegement */
#define	NAK			0x15		/* Negative acknowlegement */
#define	FS			0x1C		/* Field separator */
#define	GS			0x1D		/* Group separator */
#define	CR			0x0D		/* Carriage return */
#define	vACK		0x07		/* Visa ACK1 */
#define	vWACK		0x11		/* Visa Wait ACK */
#define	vWAIT		0x12		/* Visa WAIT */

// Modem states
#define	M_RESET		0			// Phone line is resetting
#define	M_OFHK		1			// Phone line is off-hook
#define	M_IDLE		3			// Phone line is idle
#define	M_RING		5			// Phone line is ringing
#define	M_DIAL		7			// Phone line is dialing
#define	M_WAITC		8			// Phone is waiting for carrier
#define	M_CNCT		2			// Carrier is present

unsigned
	Baud = 96,			// Comm baudrate (1200)
	Host_tran,			// Host transaction id
	kwptr,				// Keypad write pointer
	krptr,				// Keypad read pointer
	dump_pos,			// Dump position
	exec_locn = -1,		// Execution location
	src_buf,			// Source buffer
	dest_buf,			// Destination buffer
	d6ptr,				// Din6 input pointer
	sp,					// Stack pointer
	Modem_state = M_IDLE,// Current modem state
	Mtimer,				// Modem timer
	Tmo_carrier = 45,	// Carrier detect timeout
	Tmo_enq = 30,		// ENQ detect timeout
	Tmo_resp = 30,		// Response timeout
	Tmo_rperiods = 1,	// Enq response periods
	Tmo_eot = 2,		// Eot timeout
	l_stack[STACK],		// Location stack
	r_stack[STACK],		// Repeat stack
	variables[10],		// #0-#9 variables
	parameters[10],		// Command parameters
	parm_count,			// Parameter count
	mem_dump,			// Memory dump location
	memory_seg,			// External memory segment
	memory[1000],		// T330 memory address list
	msize[1000],		// T330 memory sizes
	breakpoint[10],		// Breakpoint locations
	break_top,			// Highest breakpoint
	batch_top,			// Pointer to highest batch
	batch_error,		// Indicates batch error type
	bc_index = -1,		// Batch current header index
	bc_addr = -1,		// Batch current record address
	bc_size = -1,		// Batch current record size
	bc_link = -1,		// Batch current record link
	batch_list[BSIZE];	// T330 batch files

unsigned char
	Stx = STX,			// STX character
	Etx = ETX,			// ETX character
	Nak_limit = 3,		// Number of retransmits
	Eot_enable,			// EOT timer enable
	Com_handshake,		// Communications handshake
	Multi_ack,			// Multi-ACK protocol specifier
	Host_key,			// Host transaction key
	rtx_nak = -1,		// Rexmit on NAK
	rtx_enq = -1,		// Rexmit on ENQ
	modem_dir = -1,		// Modem direction
	home[65],			// Home directory
	kbd_enable = -1,	// Keyboard enable
	inp_source = -1,	// Input source
#ifdef OLD_COMPRESS
//	case_convert = -1,	// Convert to upper
#endif
	Comport=1,			// Comm port for serial/modem
	com_handshake = -1,	// Comm port handshake enable
	Parity = PAR_EVEN|DATA_7|STOP_2, // Comm parity/data/stop
	Comset,				// Comm setup
	*d6cmd = "PINPAD.COM",	// DIN-6 peripheral file
	*crdrd = "SIM330.CRD",	// Card reader input file
	Cpending = -1,		// Pending comm char
	step_mode = -1,		// Run or step
	display_mode,		// Display Justification
	display_mask,		// Display overwrite mask
	cmd,				// Current command (byte1)
	cmd1,				// Current command (byte1)
	*memfile,			// Memory image filename
	*p_stack[STACK],	// Position stack
	command_buffer[256],// Command buffer
	Modem_string[51],	// Modem output string
	*exec_ptr,			// Execution pointer
	*cmd_ptr,			// Pointer to active command
	parm_type[10],		// Type of parameter
	buffers[5][256],	// T330 buffers
	d6buf[500],			// Din6 command buffer
	buffer[256],		// General buffer
	*dbptr,				// Destination buffer pointer
	*brptr,				// Buffer input pointer
	*bwptr[5],			// Buffer write pointers
	kbuf[KSIZE],		// Keypad input buffer
	cbuf[CSIZE],		// Card data buffer
	Lrc,				// Computed LRC
	*ptr,				// General pointer
	*ptr1,				// General pointer
	display_buf[256];	// Display buffer

int
	display_len,		// Display size
	display_pos;		// Current position

struct WINDOW
	*pwin,				// Printer window
	*twin,				// Terminal window
	*dwin,				// Display window
	*dbwin;				// Debug window

FILE
	*log_fp;			// Fp to log terminal activity

unsigned memory_save[] = {
	sizeof(memory), &memory,
	sizeof(msize), &msize,
	sizeof(batch_top), &batch_top,
	sizeof(batch_list), &batch_list };

char *vform[] = {		// Form for variable modification
	(13<<8)+12,
	"\x01\x00\x85#0=",
	"\x01\x01\x85#1=",
	"\x01\x02\x85#2=",
	"\x01\x03\x85#3=",
	"\x01\x04\x85#4=",
	"\x01\x05\x85#5=",
	"\x01\x06\x85#6=",
	"\x01\x07\x85#7=",
	"\x01\x08\x85#8=",
	"\x01\x09\x85#9=",
	0 };

char *bform[] = {		// Form for breakpoints
	(10<<8)+12,
	"\x01\x00\x83>",
	"\x01\x01\x83>",
	"\x01\x02\x83>",
	"\x01\x03\x83>",
	"\x01\x04\x83>",
	"\x01\x05\x83>",
	"\x01\x06\x83>",
	"\x01\x07\x83>",
	"\x01\x08\x83>",
	"\x01\x09\x83>",
	0 };

static char *monl[] = { "???", "JANUARY", "FEBRUARY", "MARCH", "APRIL",
	"MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER",
	"DECEMBER" };
static char *mons[] = { "???", "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
	"JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };
static char *dayl[] = { "SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY",
	"THURSDAY", "FRIDAY", "SATURDAY" };
static char *days[] = { "SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT" };

static char signon[] = { "TZ 330 Sim 1.3" };

static char cmdhelp[] = { "TRANZ 330 Simulator\n\n\
use:	SIM330 <file>.TCL|.UDL|.330 [options]\n\n\
opts:	-F		= Force Din8 signals\n\
	-H		= access Help\n\
	-S		= start with Single-Step enabled\n\
	C=1-4		= specify COM port for Din8/Modem\n\
	B=speed[PDS]	= specify Baudrate and comm parms for Din8/Modem\n\
		P:O/E/M/S/N	(Odd/Even/Mark/Space/No parity)\n\
		 D:5/6/7/8	(# Data bits)\n\
		  S:1/2		(# Stop bits)\n\
	E=locn		= begin Executing this location\n\
	L=filename	= record TCL execution Log\n\
	P=file		= specify handler for Peripheral (Din6)\n\
	R=file		= specify cardReader data file\n\
\n\?COPY.TXT 2000-2006 Dave Dunfield\n -- see COPY.TXT --.\n" };

unsigned crctab[256] = {
	0x0000, 0x8005, 0x800F, 0x000A, 0x801B, 0x001E, 0x0014, 0x8011,
	0x8033, 0x0036, 0x003C, 0x8039, 0x0028, 0x802D, 0x8027, 0x0022,
	0x8063, 0x0066, 0x006C, 0x8069, 0x0078, 0x807D, 0x8077, 0x0072,
	0x0050, 0x8055, 0x805F, 0x005A, 0x804B, 0x004E, 0x0044, 0x8041,
	0x80C3, 0x00C6, 0x00CC, 0x80C9, 0x00D8, 0x80DD, 0x80D7, 0x00D2,
	0x00F0, 0x80F5, 0x80FF, 0x00FA, 0x80EB, 0x00EE, 0x00E4, 0x80E1,
	0x00A0, 0x80A5, 0x80AF, 0x00AA, 0x80BB, 0x00BE, 0x00B4, 0x80B1,
	0x8093, 0x0096, 0x009C, 0x8099, 0x0088, 0x808D, 0x8087, 0x0082,
	0x8183, 0x0186, 0x018C, 0x8189, 0x0198, 0x819D, 0x8197, 0x0192,
	0x01B0, 0x81B5, 0x81BF, 0x01BA, 0x81AB, 0x01AE, 0x01A4, 0x81A1,
	0x01E0, 0x81E5, 0x81EF, 0x01EA, 0x81FB, 0x01FE, 0x01F4, 0x81F1,
	0x81D3, 0x01D6, 0x01DC, 0x81D9, 0x01C8, 0x81CD, 0x81C7, 0x01C2,
	0x0140, 0x8145, 0x814F, 0x014A, 0x815B, 0x015E, 0x0154, 0x8151,
	0x8173, 0x0176, 0x017C, 0x8179, 0x0168, 0x816D, 0x8167, 0x0162,
	0x8123, 0x0126, 0x012C, 0x8129, 0x0138, 0x813D, 0x8137, 0x0132,
	0x0110, 0x8115, 0x811F, 0x011A, 0x810B, 0x010E, 0x0104, 0x8101,
	0x8303, 0x0306, 0x030C, 0x8309, 0x0318, 0x831D, 0x8317, 0x0312,
	0x0330, 0x8335, 0x833F, 0x033A, 0x832B, 0x032E, 0x0324, 0x8321,
	0x0360, 0x8365, 0x836F, 0x036A, 0x837B, 0x037E, 0x0374, 0x8371,
	0x8353, 0x0356, 0x035C, 0x8359, 0x0348, 0x834D, 0x8347, 0x0342,
	0x03C0, 0x83C5, 0x83CF, 0x03CA, 0x83DB, 0x03DE, 0x03D4, 0x83D1,
	0x83F3, 0x03F6, 0x03FC, 0x83F9, 0x03E8, 0x83ED, 0x83E7, 0x03E2,
	0x83A3, 0x03A6, 0x03AC, 0x83A9, 0x03B8, 0x83BD, 0x83B7, 0x03B2,
	0x0390, 0x8395, 0x839F, 0x039A, 0x838B, 0x038E, 0x0384, 0x8381,
	0x0280, 0x8285, 0x828F, 0x028A, 0x829B, 0x029E, 0x0294, 0x8291,
	0x82B3, 0x02B6, 0x02BC, 0x82B9, 0x02A8, 0x82AD, 0x82A7, 0x02A2,
	0x82E3, 0x02E6, 0x02EC, 0x82E9, 0x02F8, 0x82FD, 0x82F7, 0x02F2,
	0x02D0, 0x82D5, 0x82DF, 0x02DA, 0x82CB, 0x02CE, 0x02C4, 0x82C1,
	0x8243, 0x0246, 0x024C, 0x8249, 0x0258, 0x825D, 0x8257, 0x0252,
	0x0270, 0x8275, 0x827F, 0x027A, 0x826B, 0x026E, 0x0264, 0x8261,
	0x0220, 0x8225, 0x822F, 0x022A, 0x823B, 0x023E, 0x0234, 0x8231,
	0x8213, 0x0216, 0x021C, 0x8219, 0x0208, 0x820D, 0x8207, 0x0202 };
		
extern unsigned char
	Longreg[];

extern register dump_state();

#include "fixed.h"
#include "sim330s.c"

update_display()
{
	int i;
	unsigned char *p;


	if((i = display_len - 16) < display_pos)
		display_pos = i;

	if(display_pos < 0)
		display_pos = 0;

	i = 16;
	p = display_buf+display_pos;
	w_putc('\r', dwin);
	do {
		if(*p) {
			w_putc((unsigned)(display_mask || *p) | 0x0100, dwin);
			++p; }
		else
			w_putc(' ', dwin); }
	while(--i);

	display_mask = 0;
}

/*
 * Write data to the display
 */
register write_display(unsigned args)
{
	display_len = _format_(nargs()*2+&args, display_buf);
	display_pos = display_mode ? 0 : sizeof(display_buf);
	update_display();
}

/*
 * Warn of an error occuring in operation
 */
register warn(unsigned args)
{
	char dbuffer[81];
	_format_(nargs() * 2 + &args, dbuffer);
	w_putc('\n', dbwin);
	if(exec_locn != -1)
		w_printf(dbwin, "%u-", exec_locn);
	w_puts(dbuffer, dbwin);
}

/*
 * Abort the terminal
 */
process_abort(char m)
{
	Copen(Comport, Baud, Parity, Comset &= ~SET_DTR);
	*d6buf = *cbuf = d6ptr = krptr = kwptr = mem_dump = Mtimer =
	display_mode = Com_handshake = 0;
	Modem_state = M_RESET;
	kbd_enable = inp_source = 255;
	if(m) {
		sp = Host_tran = Host_key = 0;
		read_memory(exec_locn = 979, exec_ptr = cmd_ptr = command_buffer); }
}

/*
 * Write a character to the serial_port
 */
Cput_c(unsigned char c)
{
	switch(Com_handshake) {
	case 1 : while(!Csignals() & CTS) {
		if(poll_input())
			return; }
		break;
	case 2 : while(Csignals() & CTS) {
		if(poll_input())
			return; } }
	Cputc(c);
}

/*
 * Standard "beep"
 */
void xbeep()
{
	beep(1000, 100);
}

/*
 * Perform memory->memory compression to encode numeric data
 * returns size of compressed data
 */
#ifdef OLD_COMPRESS
unsigned compress(char *source, char *dest)
{
	unsigned char c, h, l;
	unsigned size;

	size = 0;
	while(c = *source++) {
		if(c < '0') {		/* Controls */
			h = c / 5;
			l = (c % 5) + 0x0B; }
		else if(c < ':') {	/* Numeric digits */
			h = (c-'0');
			l = 0x0A;
			if(isdigit(*source))
				l = *source++ - '0'; }
		else {				/* Remaining ASCII */
//			if(case_convert)
//				c = toupper(c);
//			c -= ':';
			c = toupper(c) - ':';
			h = (c >> 4) + 0x0A;
			l = c & 0x0F; }
		*dest++ = (h << 4) | l;
		++size; }
	return size;
}
void decompress(unsigned char *source, unsigned char *dest, unsigned size)
{
	unsigned c, h, l;

	while(size) {
		c = peek(memory_seg, source++);
		h = (c & 0xF0) >> 4;
		l = c & 0x0F;
		if(h >= 0x0A)
			c = (c - 0xA0) + ':';
		else if(l >= 0x0B)
			c = (h*5) + (l - 0x0B);
		else {
			c = h + '0';
			if(l < 0x0A) {
				*dest++ = c;
				c = l + '0'; } }
		*dest++ = c;
		--size; }
	*dest = 0;
}
#else
int toupper(unsigned c)
{
	if(c >= 0x60) c &= 0x5F;
	return c;
}

unsigned compress(unsigned char *source, unsigned char *dest)
{
	unsigned size;
	unsigned char c, d;

	size = 0;
	while(c = *source++) {
		if(isdigit(c)) {
			c -= '0';
			d = 255; }
		else {
			if((c = toupper(c)) >= '0')
				c -= 10;
			d = c & 0x0F;
			c = (c >> 4) + 0x0A; }
		do {
			if(size & 1)
				dest[size>>1] |= c;
			else
				dest[size>>1] = c << 4;
			++size;
			c = d; d = 255; }
		while(c != 255); }
	if(size & 1)
		dest[size++>>1] |= 0x0F;

	return size>>1;
}
void decompress(unsigned char *source, unsigned char *dest, unsigned size)
{
	unsigned s;
	unsigned char c, d;

	s = d = 0;
	size *= 2;
	while(s < size) {
		c = peek(memory_seg, (s/2)+source);
		c = (s++ & 1) ? c & 0x0F : c >> 4;
		if(d) {
			if((d = ((d - 10) << 4) | c) >= '0')
				d += 10;
			*dest++ = d;
			d = 0; }
		else if(c < 10)
			*dest++ = c + '0';
		else
			d = c; }
	*dest = 0;
}
#endif

/*
 * Locate a free block in external memory
 */
unsigned find_free(size) asm
{
		MOV		ES,DGRP:_memory_seg	; Address segment
		XOR		SI,SI				; Offset 0
ff1:	MOV		AL,0FFh				; Looking for free
ff2:	CMP		AL,ES:[SI]			; Is this free?
		JZ		ff5					; Yes, try this one
ff3:	INC		SI					; Skip to next
		CMP		SI,MAXMEM			; Are we over?
		JB		ff2					; No, keep looking
ff4:	MOV		AX,-1				; Indicate failed
		JMP	SHORT ff8				; And exit
; We found at least one free byte
ff5:	MOV		CX,4[BP]			; Get size
		MOV		BX,SI				; Copy address
		CMP		CX,2				; < 2
		ADC		CX,0				; Adjust
ff6:	DEC		CX					; Are we at size?
		JZ		ff7					; We found it
		INC		SI					; Advance to next
		CMP		AL,ES:[SI]			; Is this free?
		JZ		ff6					; Yes, keep looking
		JMP	SHORT ff3				; No, try next
ff7:	CMP		SI,MAXMEM			; Are we over?
		JAE		ff4					; Failed
		MOV		AX,BX				; Get address
ff8:
}

/*
 * Release a block in external memory
 */
void free_memory(addr, size) asm
{
		MOV		ES,DGRP:_memory_seg	; Address memory
		MOV		DI,6[BP]			; Get address
		MOV		CX,4[BP]			; Get size
		AND		CX,CX				; Zero?
		JZ		fm2					; Special case
		MOV		AL,0FFh				; Get clear value
fm1:	MOV		ES:[DI],AL			; Write memory
		INC		DI					; Advance address
		DEC		CX					; Reduce count
		JNZ		fm1					; Do it all
fm2:
}

/*
 * Get number of free bytes in memory
 */
get_free_size() asm
{
		MOV		ES,DGRP:_memory_seg	; Address segment
		XOR		CX,CX				; Zero count
		XOR		BX,BX				; Zero pointer
		MOV		AL,0FFh				; Get free indicator
gf1:	CMP		AL,ES:[BX]			; This one match?
		JNZ		gf2					; No, skip
		INC		CX					; Advance count
gf2:	INC		BX					; Advance pointer
		CMP		BX,MAXMEM			; Past end?
		JB		gf1					; No, keep looking
		MOV		AX,CX				; Get count
}

/*
 * Write a data string to memory
 */
void write_memory(unsigned location, char *source)
{
	unsigned m, s, s1;
	unsigned char buffer[200], *ptr;

	if(location > 999) {
		dump_state(MEMOUT, location);
		return; }
	switch(location) {
		case 2 : strcpy(buffers[0], source); return;
		case 3 : strcpy(buffers[1], source); return; }

	m = memory[location];
	s = msize[location];

	if(!*source) { /* erasing memory */
		if(s) {
			Debug(("free_memory(%u,%u)\n", m, s))
			free_memory(m, s); }
		memory[location] = msize[location] = 0;
		return; }

	s1 = compress(source, ptr = buffer);

	if(s) {
		if(s < s1) {
			Debug(("free_memory(%u,%u)\n", m, s))
			free_memory(m, s);
			m = find_free(s1);
			Debug(("find_free(%u)==%u\n", s1, m))
			if(m == -1) {
				dump_state(MEMFAIL);
				return; }
			memory[location] = m;
			msize[location] = s1; }
		else if(s > s1) {
			Debug(("free_memory(%u,%u)\n", m+s1, s-s1))
			free_memory(m+s1, s - s1);
			msize[location] = s1; } }
	else {
		m = find_free(s1);
		Debug(("find_free(%u)==%u\n", s1, m))
		if(m == -1) {
			dump_state(MEMFAIL);
			return; }
		memory[location] = m;
		msize[location] = s1; }
	while(s1) {
		poke(memory_seg, m++, *ptr++);
		--s1; }
}

unsigned char *Itranz[] = {
"B1.1GR2A@04R28*L@07H4.28OI1.1.255I-3D*L992+A#...5B.2G+Q#*L990*K1B2.3*L@10*L@11*K1",
"+Z1F128S*N#.#1*W1B2.2G*VI6.1.50I3.1.56I-6.7,#F133*K1F129I-4F130B2G+I5.#2.3F131*N#.2*MI-6.2.5F131+I1B1.3GXF132L993",
"B2.2G+I7.#3.12I3.7.#4F135*N#.4*MB.1GR5+IB3GXI-14I-15.2.2B2.3GXB.1GR6+IB.2G+I7.#5.1I1I-2.2.4B3.2GXB2*N#"
};

/*
 * Read a data string from external memory
 * Returns 0 if memory location is empty
 */
int read_memory(unsigned location, char *dest)
{
	unsigned source, size;

	if(location > 999) {
		dump_state(MEMOUT, location);
		return *dest = 0; }

	switch(location) {
		case 2 : strcpy(dest, buffers[0]); return *dest;
		case 3 : strcpy(dest, buffers[1]); return *dest; }

	source = memory[location];
	size = msize[location];
	if(Host_key && (location >= ILOC) && (location < (ILOC+sizeof(Itranz)/2) )) {
		if(size)
			decompress(source, dest, size);
		else
			strcpy(dest, Itranz[location-ILOC]);
		for(;;) switch(*++dest) {
			case '@' : *dest = Host_key; continue;
			case 0 : return -1; } }

	if(!size)
		return *dest = 0;
	decompress(source, dest, size);
	return 255;
}

/*
 * Display a memory image in a defined field
 */
dump_buffer(char *ptr, char *mark)
{
	unsigned i;
	i = dump_pos;
	while(i--) {
		if(*ptr) {
			++ptr;
			continue; }
		mark = 0;
		break; }

//	for(i=0; i < DWIDTH; ++i) {
	i = DWIDTH; do {
		if(ptr == mark) {
			*W_OPEN = REVERSE;
			mark = 0; }
		wputc(*ptr ? *ptr++ : ' ');
		*W_OPEN = NORMAL; }
	while(--i);
}

edit_long(unsigned char *ptr, unsigned y)
{
	int i;
	unsigned p, sd;
	unsigned char c, *pp, buffer[256];
	static char insert;

	p = 0;
	sd = dump_pos;
	dump_pos = 0;

	strcpy(buffer, ptr);

upcursor:
	if(insert)
		wcursor_block();
	else
		wcursor_line();

	for(;;) {
		wgotoxy(0, y);
		wprintf("%-3u:", dump_pos+p+1);
		dump_buffer(buffer, 0);
		wgotoxy(4+p, y);
		switch(i = wgetc()) {
		case _KBS :
		case _KLA :
			if(p)
				--p;
			else {
				if(dump_pos)
					--dump_pos;
				else
					continue; }
			if(i != _KBS) continue;
		case _KDL :
			pp = &buffer[dump_pos + p];
			while(*pp) {
				*pp = *(pp+1);
				++pp; }
			continue;
		case _KIN :
			insert = insert ? 0 : 255;
			goto upcursor;
		default:
			if(i & 0xFF00) {
				xbeep();
				continue; }
			pp = &buffer[dump_pos + p];
			if(insert) {
				do {
					c = *pp;
					*pp++ = i; }
				while(i = c);
				*pp = 0; }
			else {
				c = *pp;
				*pp = i;
				if(!c) *(pp+1) = 0; }
		case _KRA :
			if(buffer[dump_pos+p]) {
				if(p < (DWIDTH-1)) ++p;
				else ++dump_pos; }
			continue;
		case _KHO :
			dump_pos = p = 0;
			continue;
		case _KEN :
			dump_pos = 0;
			if((p = strlen(buffer)) >= DWIDTH) {
				dump_pos = p - (DWIDTH-1);
				p = (DWIDTH-1); }
			continue;
		case _KPU :
			dump_pos = p = 0;
		case _KPD :
			buffer[dump_pos+p] = 0;
			continue;
		case _K10:
			strcpy(ptr, buffer);
//			for(i=0; i < 5; ++i) {
			i=0; do {
				if(buffers[i] == ptr)
					bwptr[i] = ptr + strlen(ptr); }
			while(++i < 5);
		case _K9:
			dump_pos = sd;
			wcursor_off();
			return;
		case _K1 :
		case _K2 :
		case _K3 :
		case _K4 :
		case _K5 :
		case _K6 :
		case _K7 :
		case _K8 : help(3); } }
}

/*
 * Dump the state of the TRANZ interpreter
 */
register dump_state(unsigned args)
{
	int i1;
	unsigned i, j, x, y;
	unsigned char *ptr, dbuffer[81]
	static unsigned m = 0;
	static char ptypes[] = {"NV0123456789\"???"};
	static char Bindicators[] = { ' ', 'd', 's', 'b' };

	_format_(nargs() * 2 + &args, dbuffer);

redraw:
	wopen(0, 0, 80, 25, WSAVE|WCOPEN|WBOX1|NORMAL);
	wputs(dbuffer);

draw_all:
//	for(i=0; i < 10; ++i) {
	i=0; do {
		wgotoxy(x = ((i%5)*12)+20, y = (i/5)+1);
		wprintf("P%u=%c/%-5u", i, ptypes[parm_type[i]], parameters[i]);
		wgotoxy(x, y+2);
		wprintf("#%u=%-5u", i, variables[i]); }
	while(++i < 10);

	wgotoxy(0, 1);
	wprintf("Last command: %c%c\nFree memory : %-5u\nModem state : %u\nKeypad %sabled",
		(unsigned)cmd|0x100, (unsigned)cmd1|0x100,
 		get_free_size(),
		Modem_state,
		kbd_enable ? "en" : "dis");

//	for(i=0; i < 9; ++i) {
	i = 0; do {
		i1 = sp-(i+1);
		if(i1 >= 0) {
			wgotoxy(i*8, 5);
			wprintf("%3u:%03u", i1, l_stack[i1]); } }
	while(++i < 9);

draw_buf:
	if(exec_locn < 1000) {
		wgotoxy(0, 6);
		wprintf("%03u:", exec_locn);
		dump_buffer(exec_ptr, cmd_ptr); }

//	for(i=0; i < 5; ++i) {
	i=0; do {
		wgotoxy(0, i+7);
		wprintf("B%u%c:", i+1, Bindicators[((i == src_buf)*2)+(i == dest_buf)]);
		dump_buffer(buffers[i], bwptr[i]);
		wcleol(); }
	while(++i < 5);

	wgotoxy(0, 12);
	wprintf("%-3u ", dump_pos);
	ptr = buffers[src_buf];
	x = brptr;
//	for(i=0; i < dump_pos; ++i) {
	i = dump_pos;
	while(i--) {
		if(*ptr) {
			++ptr;
			continue; }
		x = 0;
		break; }

//	for(i=0; i < DWIDTH; ++i) {
	i=0; do {
		if(ptr == x) {
			*W_OPEN = REVERSE;
			x = 0; }
		if(*ptr) ++ptr;
		if(!(j = (y = dump_pos + i) % 10))
			wprintf("%u", (y / 10)%10);
		else if(j == 5)
			wputc(0x04);
		else
			wputc(0xFA);
		*W_OPEN = NORMAL; }
	while(++i < DWIDTH);

draw_mem:
//	for(i=0; i < 10; ++i) {
	i=0; do {
		j = (m + i) % 1000;
		wgotoxy(0, i+13);
		wprintf("%03u:", j);
		read_memory(j, buffer);
		dump_buffer(buffer, 0);
		wcleol(); }
	while(++i < 10);

	for(;;) {
		switch(i = wgetc()) {
		case ' ' :
			step_mode = 0;
			goto xit;
		case '\n' :
			step_mode = 255;
	xit:	wclose();
			return;
		case '\t': wclose(); wgetc(); goto redraw;
		case _K1 : edit_long(buffers[0], 7); goto draw_buf;
		case _K2 : edit_long(buffers[1], 8); goto draw_buf;
		case _K3 : edit_long(buffers[2], 9); goto draw_buf;
		case _K4 : edit_long(buffers[3],10); goto draw_buf;
		case _K5 : edit_long(buffers[4],11); goto draw_buf;
		case _K6 :
			read_memory(m, buffer);
			edit_long(buffer, 13);
			write_memory(m, buffer);
			goto draw_all;
		case _K7 :
			wform(32, 5, WSAVE|WCOPEN|WBOX1|REVERSE, vform,
				&variables[0], &variables[1], &variables[2], &variables[3],
				&variables[4], &variables[5], &variables[6], &variables[7],
				&variables[8], &variables[9]);
			goto draw_all;
		case _K8 :
			wform(32, 5, WSAVE|WCOPEN|WBOX1|REVERSE, bform,
				&breakpoint[0], &breakpoint[1], &breakpoint[2], &breakpoint[3],
				&breakpoint[4], &breakpoint[5], &breakpoint[6], &breakpoint[7],
				&breakpoint[8], &breakpoint[9]);
//			for(break_top=i=0; i < 10; ++i) {
			break_top=i=0; do {
				if(j = breakpoint[i]) {
					breakpoint[i] = 0;
					breakpoint[break_top++] = j; } }
			while(++i < 10);
			continue;
		case _K9 : batch_debug(); continue;
		case _K10 : wclose(); terminate();
		case _KRA : if(dump_pos < DUMPMAX) ++dump_pos; goto draw_buf;
		case _KLA : if(dump_pos) --dump_pos; goto draw_buf;
		case _CHO : dump_pos = 0; goto draw_buf;
		case _CEN : dump_pos = DUMPMAX; goto draw_buf;
		case _KHO : dump_pos = (dump_pos > 10) ? dump_pos - 10 : 0; goto draw_buf;
		case _KEN : dump_pos = (dump_pos < (DUMPMAX-10)) ? dump_pos+10 : DUMPMAX; goto draw_buf;
		case _KUA : m += 999;	goto move_mem;
		case _KDA : ++m;		goto move_mem;
		case _KPU : m += 990;	goto move_mem;
		case _KPD : m += 10;
			move_mem: m %= 1000; goto draw_buf;
		case _ALT+'S' : save_memory(); continue;
		case '?' : help(2); continue; }
	if(isdigit(i)) {
		m = m * 10 + (i-'0');
		m %= 1000;
		goto draw_mem; }
	xbeep(); }
}

/*
 * Simple functions using the global pointer
 */
append(char *p)
{
	while(*p)
		Lrc ^= (*ptr++ = *p++);
	*ptr = 0;
}
extract(char *dest, unsigned l)
{
	while(*ptr && (*ptr != FS) && l) {
		Lrc ^= (*dest++ = *ptr++);
		--l; }
	*dest = 0;
}
expect(char c)
{
	if(*ptr != c)
		dump_state("BAD RESPONSE, Expected:%02x - Got:%02x", c, *ptr);
	Lrc ^= *ptr++;
}
expect_string(char *s)
{
	extract(buffer, strlen(s));
	if(strcmp(buffer, s))
		dump_state("BAD RESPONSE, Expected:'%s' - Got:'%s'", s, buffer);
}
char *find_end()
{
	while(*ptr) ++ptr;
	return ptr;
}

/*
 * Draw a key on the terminal window in specified color
 */
void draw_t_key(unsigned k, unsigned char attr)
{
	unsigned x, y;
	unsigned char a;

	static char *keys1[] = {
	"qz.", "abc", "def", "CLR",
	"ghi", "jkl", "mno", "BAK",
	"prs", "tuv", "wxy", "ALP",
	",'\""," - ", "   ", "FUN" };

	static char *keys2[] = {
	" 1 ", " 2 ", " 3 ", "   ",
	" 4 ", " 5 ", " 6 ", "SPC",
	" 7 ", " 8 ", " 9 ", " HA",
	" * ", " 0 ", " # ", "ENT" };

	x = ((k % 4) * 7) + 2;
	y = ((k / 4) * 2) + 1;

	a = *twin;
	*twin = attr;
	w_gotoxy(x, y, twin); w_printf(twin, "\xDA%s\xBF", keys1[k]);
	w_gotoxy(x,++y,twin); w_printf(twin, "\xC0%s\xD9", keys2[k]);
	*twin = a;
}

#ifdef STACK_CHECK
asm " EXTRN ?heap:near";
unsigned getheap() asm
{
	MOV	SI,OFFSET DGRP:?heap
gh1:	CMP	BYTE PTR [SI],1
	JB	gh2
	MOV	BX,1[SI]
	LEA	SI,3[BX+SI]
	JMP	SHORT	gh1
gh2:	MOV	AX,SI
}
#endif

/*
 * Poll for input from devices
 */
poll_input()
{
	static int c, d;
	static unsigned i, ts;
	static FILE *fp;
	static char name[31];
	static unsigned char ttran[] = { 13, 0, 1, 2, 4, 5, 6, 8, 9, 10 };

	if(c = wtstc()) {
		beep(1000, 50);
		switch(c) {
#ifdef STACK_CHECK
			case _CHO:
				ptr = getheap();
				i = ts = 0;
				while(++ptr < 0xFF00) {
					if(*ptr == 0x55) {
						if(++i > ts)
							ts = i; }
					else
						i = 0; }
			wprintf("\n%u", ts);
			return 0;
#endif
			case _K1 :
			case _K2 :
			case _K3 :
			case _K4 :
			case _K5 :
			case _K6 :
			case _K7 :
			case _K8 :
				warn("CARD%u: ", c -= (_K1-1));
				if(!(fp = fopen(crdrd, "r"))) {
					sprintf(cbuf, "%s%s", home, crdrd);
					if(!(fp = fopen(cbuf, "r"))) {
				cfail:	wputs("not found");
//						cbuf[0] = 0xFF;
//						cbuf[1] = 0;
						return *cbuf = 0; } }
				i = "swiped";
				do {
			cloop:	if(!fgets(cbuf, sizeof(cbuf)-1, fp)) {
						fclose(fp);
						goto cfail; }
					if(*cbuf == ';') switch(cbuf[1]) {
						case '=' :	strcpy(i=name, cbuf+2);
						default:	goto cloop;
						case ';' :	strcpy(cbuf, cbuf+1); } }
				while(--c);
				fclose(fp);
				wputs(i);
				return inp_source = 0;
			case _K9 : dump_state("USER REQUEST"); return 0;
			case _K10: terminate();
			case '~' :
				display_mode = display_mode ? 0 : 255;
				update_display();
				return 0;
			case '?' : help(1); return 0; }
		if(kbd_enable) switch(c) {
			case 'c' :
			case 'C' :		// Abort key
			case '/' :
				draw_t_key(3, REVERSE);
				process_abort(255);
				delay(100);
				draw_t_key(3, NORMAL);
				return -1;
			case 'b' :
			case 'B' :
			case _KKM:
			case _KBS: c = 'B'; d = 7;	goto wkey1;
			case _KKP :
			case 'a' :
			case 'A' : c = 'C'; d = 11;	goto wkey1;
			case '\n':
			case 'f' :
			case 'F' : c = 'D'; d=15;	goto wkey1;
			case _KLA: c = '*';
			case '*' : d=12;			goto wkey1;
			case '.':
			case _KRA: c = '#';
			case '#' : d=14;			goto wkey1;
			default:
				if(!isdigit(c)) {
					xbeep();
					break; }
				d = ttran[c-'0'];
		wkey1:	draw_t_key(d, REVERSE);
				kbuf[kwptr] = c;
				kwptr = (kwptr + 1) % KSIZE;
				delay(100);
				draw_t_key(d, NORMAL); } }

	if((i = BIOS_TICK) != ts) {
		ts = i;
		switch(Modem_state) {
		case M_IDLE :	// Phone line is idle
			if(Csignals() & RI) {
				Mtimer = 0;
				Modem_state = M_RING; }
			break;
		case M_RING :	// Phone is ringing
			if(Csignals() & RI) {	// Ringing
				Mtimer = 0;
				break; }
			if(++Mtimer > 60)		// More than 3.5sec silence
				Modem_state = M_IDLE;
			break;
		case M_DIAL :	// Phone is dialing
			if(c = Modem_string[Mtimer]) {
				Cput_c(c);
				++Mtimer;
				break; }
			Mtimer = Tmo_carrier * 18;	// Set carrier timeout
			Modem_state = M_WAITC;
			break;
		case M_WAITC:	// Waiting for carrier
			if(Csignals() & CD) {
				Mtimer = 0 ;
				Modem_state = M_CNCT;
				break; }
			if(!--Mtimer)
				goto mreset;
			break;
		case M_CNCT:	// Connected
			if(Csignals() & CD) {
				Mtimer = 0;
				break; }
			if(++Mtimer > 18) {
				Mtimer = 0;
	mreset:		Copen(Comport, Baud, Parity, Comset &= ~SET_DTR);
				Modem_state = M_RESET; }
			break;
		case M_RESET :
			if(++Mtimer > 25) {
				Modem_state = M_IDLE;
				Copen(Comport, Baud, Parity, Comset |= SET_DTR); } } }

	return 0;
}

/*
 * Test for an error condition
 */
int check(unsigned c, char *msg)
{
	if(!c) {
		dump_state(msg);
		return 0; }
	return -1;
}
int check_dest()
{
	if((bwptr[dest_buf] - dbptr) > BUFSIZE)
		dump_state("BUFFER OVERFLOW");
}

/*
 * Dump an audit of the external memory blocks
 *
audit_free()
{
	unsigned a, f, u, fs, us;

	a = f = u = fs = us = 0;
	while(a < MAXMEM) {
		if(peek(memory_seg, a) == 0xFF) {	/* Free */
			if(us) {
				w_printf(pwin, "%-5u: used %u\n", u, us);
				us = 0;
				f = a; }
			++fs; }
		else {								/* Used */
			if(fs) {
				w_printf(pwin, "%-5u: free %u\n", f, fs);
				fs = 0;
				u = a; }
			++us; }
		++a; }
} */

load_tcl()
{
	unsigned locn, count;
	char line[150], *ptr, *ptr1, *lptr, c;
	char sflag, qflag;
	FILE *fp;

	fp = fopen(cmd_ptr, "rvq");

	locn = -1;
read_next:
	while(fgets(ptr = buffer, sizeof(buffer)-1, fp)) {
		while(isspace(*ptr)) ++ptr;
		switch(*ptr) {
		case ';':
		case '%':	continue; }
		if(isdigit(*(ptr1 = ptr))) {
			while(isdigit(*++ptr));
			switch(c = *ptr) {
				case '$' : sflag = 0; goto doit;
				case '=' : sflag = 255;
				doit:
					if(locn != -1) {
						if(count > 120)
							abort(" >120 characters.\n");
						while((lptr > line) && isspace(*(lptr-1)))
							--lptr;
						*lptr = 0;
						write_memory(locn, line); }
					if(!c)
						return;
					qflag = count = 0;
					locn = atoi(ptr1);
					printf("\r%u", locn);
					if(locn > 999) {
						fclose(fp);
						abort(" out of range"); }
					lptr = line;
					++ptr; } }
		while(c = *ptr++) {
			switch(c) {
			case ' ' :
			case '\t':
				if(sflag || qflag)
					break;
				continue;
			case '\'':
				qflag = qflag ? 0 : 255;
				break;
			case ';' :
				if(!qflag)
					goto read_next; }
			if(++count <= 120)
				*lptr++ = c; } }

	fclose(fp);
	c =  0;
	goto doit;
}

load_udl()
{
	unsigned i, locn;
	char *ptr;
	FILE *fp;

	fp = fopen(cmd_ptr, "rvq");
	while(fgets(ptr = buffer, sizeof(buffer)-1, fp)) {
		while(*ptr)
			++ptr;
		while(isspace(*--ptr));
		if((*buffer != '"') || (*ptr != '"')) {
			fclose(fp);
	badudl:	abort("Invalid record\n"); }
		*ptr = locn = 0;
		ptr = buffer;
		switch(*++ptr) {
		default: goto badudl;
		case '0' :
		case '1' : }
		if(*++ptr == ',') {
			while(isdigit(*++ptr))
				locn = (locn * 10) + (*ptr - '0');
			if(*ptr++ != ',')
				goto badudl; }
		else {
//			for(i=0; i < 3; ++i) {
			i=3; do {
				if(!isdigit(*ptr))
					goto badudl;
				locn = (locn * 10) + (*ptr++ - '0'); }
			while(--i); }
		printf("\r%u", locn);
		if(locn > 999) {
			fclose(fp);
			abort(" out of range"); }
		write_memory(locn, ptr);
	} fclose(fp);
}

load_memory()
{
	unsigned a, b;
	FILE *fp;
	fp = fopen(cmd_ptr, "rvqb");
	a = sizeof(memory_save)/2;
	do
		fget(memory_save[--a], memory_save[--a], fp);
	while(a);
	while((b = getc(fp)) != EOF)
		poke(memory_seg, a++, b);
	fclose(fp);
}

save_memory()
{
	unsigned a, i;
	FILE *fp;
	static char *form[] = {
		72<<8|3,
		"\x00\x00\x40File:",
		0 };
	strcpy(buffer, memfile);
	if(wform(3, 10, WSAVE|WCOPEN|WBOX1|REVERSE, form, buffer))
		return;
	wopen(28, 10, 22, 3, WSAVE|WCOPEN|WBOX1|REVERSE);
	if(fp = fopen(buffer, "wb")) {
		wputs("Saving memory image");
		a = sizeof(memory_save)/2;
		do
			fput(memory_save[--a], memory_save[--a], fp);
		while(a);
		i = 0;
		do {
			if(peek(memory_seg, i-1) != 0xFF)
				break; }
		while(--i);
		while(i--)
			putc(peek(memory_seg, a++), fp);
		fclose(fp);
		goto quit; }
	wputs("Unable to write file");
	xbeep();
quit:
	delay(1000);
	wclose();
}

terminate()
{
	if(log_fp)
		fclose(log_fp);
	if(dbwin) {
		wclose();
		wclose();
		wclose();
		wclose();
		wclose(); }
	Cclose();
	exit(0);
}

skip_cmd(unsigned n, int i)
{
	char c, qf;
	qf = 1;
	while((c = *cmd_ptr) && (cmd_ptr > exec_ptr)) {
		if(c == '\'')
			qf = qf ? 0 : 255;
		else if((c >= 'A') && (c <= 'Z') && qf && !--n)
			break;
		cmd_ptr += i; }
	if(cmd_ptr > exec_ptr) switch(*(cmd_ptr-1)) {
		case '+' :
		case '*' :
			--cmd_ptr; }
}

do_skip(int offset)
{
	if(offset > 0)
		skip_cmd(offset+1, 1);
	else if(offset < 0) {
		--cmd_ptr;
		skip_cmd(1 + -offset, -1); }
}

/*
 * Signed long division function
 *
 * Divide absolute value of numbers, then negate if only one
 * of the input quantities was negative.
 */
void slongdiv(char *num1, char *num2)
{
	char flag, lt[LSIZE];
	flag = 0;
	if(num1[LSIZE-1] & 0x80) {		/* Numerator is negative */
		longcpy(lt, num1);
		longset(num1, 0);
		longsub(num1, lt);
		flag = 1; }
	if(num2[LSIZE-1] & 0x80) {		/* Denominator is negative */
		longset(lt, 0);
		longsub(lt, num2);
		longdiv(num1, lt);
		flag ^= 1; }
	else
		longdiv(num1, num2);
	if(flag) {						/* Result should be negative */
		longcpy(lt, num1);
		longset(num1, 0);
		longsub(num1, lt); }
}

/*
 * Signed long comparison function
 *
 * If signs are different, return -1/1 based on which one is negative.
 *
int slongcmp(char *num1, char *num2)
{
	if((num1[LSIZE-1] ^ num2[LSIZE-1]) & 0x80)	/* Signs differ */
		return (num1[LSIZE-1] & 0x80) ? -1 : 1;
	return longcmp(num1, num2);
} */

/*
 * Signed ASCII to LONG function
 *
 * If leading '-' : negate number after conversion
 */
int satol(char *buffer, char *num, int radix)
{
	int r;
	char lt[LSIZE], string[20];

	extract_number(buffer, string);
	if(*string == '-') {			/* Input is negative */
		r = atol(string+1, lt, radix);
		longset(num, 0);
		longsub(num, lt);
		return r; }
	return atol(string, num, radix);
}

/*
 * Signed LONG to ASCII function
 *
 * If number is negative, output '-' and negate before conversion
 */
char *sltoa(char *num, char *string, int radix)
{
	char lt[LSIZE];
	if(num[LSIZE-1] & 0x80) {		/* Number is negative */
		*string++ = '-';
		longset(lt, 0);
		longsub(lt, num);
		return ltoa(lt, string, radix); }
	return ltoa(num, string, radix);
}

/*
 * Extract a number from a data field
 */
extract_number(char *ptr, char *dest)
{
	char c;
	while(c = *ptr++) {
		if(isdigit(c) || (c == '-'))
			*dest++ = c; }
	*dest = 0;
}

/*
 * Perform arithmetic on a memory location and the destination buffer
 */
arithmetic(unsigned locn, unsigned oper)
{
	unsigned char buffer[151], n1[LSIZE], n2[LSIZE];

	read_memory(locn, ptr = buffer);
	satol(buffer, n1, 10);
	satol(dbptr, n2, 10);

	switch(oper) {
	case 0 : longadd(n1, n2);	break;
	case 1 : longsub(n1, n2);	break;
	case 2 : longmul(n1, n2);	break;
	case 3 : slongdiv(n1, n2);	break;
	case 4 : slongdiv(n1, n2);	memcpy(n1, Longreg, LSIZE); }

	sltoa(n1, buffer, 10);
	write_memory(locn, buffer);
}

test_key()
{
	unsigned char c;
	if(krptr != kwptr) {
		c = kbuf[krptr];
		krptr = (krptr+1) % KSIZE;
		return c; }
	return 0;
}

char *format_money(char *s, char *d, unsigned dp, unsigned char f)
{
	int i, l, l1;
	char temp[65], c, m;
	m = l = 0;
	while(c = *s++) {
		if(c == '-') {
			m = 255;
			continue; }
		if(isdigit(c))
			temp[l++] = c; }
	temp[l] = 0;
	l1 = l-dp;
	s = temp;
	if(f & F_DOLLAR)
		*d++ = '$';
	if(m)
		*d++ = '-';
	if(f & F_LEAD0) {
		if(l <= dp)
			*d++ = '0'; }
	for(i=0; i < l1; ++i) {
		if(f & F_COMMA) {
			if(i && !((l1-i)%3))
				*d++ = ','; }
		*d++ = *s++; }
	*d++ = (f & F_LATIN) ? ',' : '.';
	while(++l <= dp) *d++ = '0';
	while(*d++ = *s++);
	return d-1;
}

#include "sim330e.c"

main(int argc, char *argv[])
{
	unsigned i, x;

	printf("%s\n", signon);

	if(argc < 2)
		abort(cmdhelp);

#ifdef STACK_CHECK
	ptr = getheap();
	while(++ptr < 0xFF00)
		*ptr = 0x55;
#endif

	/* Determine location of home directory */
	ptr = argv[i=x=0];
	while(home[i++] = *ptr) {
		if(*ptr++ == '\\')
			x = i; }
	home[x] = 0;

	for(i=1; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
#ifdef OLD_COMPRESS
//		case '-L' :
//		case '/L' : case_convert = 0;				continue;
#endif
		case '-H' :
		case '/H' : help(0);						return;
		case '-S' :
		case '/S' : step_mode = 0;					continue;
		case 'E=' : exec_locn = atoi(ptr);			continue;
		case 'L=' : log_fp = fopen(ptr, "wvq");		continue;
		case '-F' :
		case '/F' : com_handshake = 0;				continue;
		case 'C=' : Comport = atoi(ptr);			continue;
		case 'B=' :
			if(!(x = atoi(ptr)/2)) {
			badbaud: abort("Bad BAUD rate"); }
			Baud = 57600 / x;
			if((Baud * x) != 57600) goto badbaud;
			Baud *= 2;
			while(isdigit(*ptr)) ++ptr;
			switch(toupper(*ptr++)) {	// Set parity
			case 0 : continue;
			default: abort("Bad PARITY\n");
			case 'E' : Parity = PAR_EVEN; break;
			case 'O' : Parity = PAR_ODD; break;
			case 'S' : Parity = PAR_SPACE; break;
			case 'M' : Parity = PAR_MARK; };
			switch(x = *ptr++) {		// Set DATA BITS
				default: abort("Bad DATA BITS\n");
				case '5' :
				case '6' :
				case '7' :
				case '8' : Parity = (Parity & ~3) | (x-'5'); }
			switch(*ptr) {				// Set STOP bits
				default: abort("Bad STOP BITS\n");
				case '2' : Parity |= STOP_2;
				case '1' : }
				continue;
		case 'P=' : d6cmd = ptr; continue;
		case 'R=' : crdrd = ptr; continue;
		case '?'<<8:
		case '-?' :
		case '/?' : fputs(cmdhelp, stdout); return; }
		if(sp >= STACK)
			abort("Too many filenames!\n");
		p_stack[sp++] = argv[i]; }

	if(!sp)
		abort("Filename is required!\n");

	memory_seg = alloc_seg(4096);

//	for(i=0; i < 5; ++i)
	i=0; do {
		bwptr[i] = buffers[i]; }
	while(++i <  5);
	brptr = dbptr = buffers[0];

	memset(batch_list, 255, sizeof(batch_list));

	i = 0; do {
		pokew(memory_seg, i, -1); }
	while(i += 2);

//	build_crc_table();

	for(i=0; i < sp; ++i) {
		ptr = cmd_ptr = p_stack[i];
		ptr1 = "";
		while(*ptr) {
			if((*ptr = toupper(*ptr)) == '.')
				ptr1 = ptr+1;
			++ptr; }
		printf("Loading: %s\n", cmd_ptr);
		if(!strcmp(ptr1, "TCL"))
			load_tcl();
		else if(!strcmp(ptr1, "UDL"))
			load_udl();
		else if(!strcmp(ptr1, "330")) {
			load_memory(); }
		else
			abort("File type must be 'TCL', 'UDL' or '330'\n");
		if(!memfile) {
			memfile = cmd_ptr;
			strcpy(ptr1, "330"); }
		putc('\n', stdout); }

	if(Copen(Comport, Baud, Parity, Comset = SET_RTS|OUTPUT_2))
		abort("Cannot open COM port\n");

	wopen(0, 0, 80, 25, WSAVE|WCOPEN|NORMAL);
	twin = wopen(1, 0, 32, 11, WCOPEN|WBOX2|NORMAL);
	wgotoxy(23, 0); wprintf("TZ330");
	dwin = wopen(6, 1, 16, 1, WCOPEN|REVERSE);
	wputs(signon);
	pwin = wopen(40, 0, 40, 25, WCOPEN|WSCROLL|REVERSE);
	W_OPEN->WINcury = 24;
	dbwin = wopen(0, 11, 40, 14, WCOPEN|WWRAP|WSCROLL|NORMAL);
	wprintf("%s - Press '?' for help.", signon);
	wcursor_off();

//	for(i=sp=0; i < 16; ++i)
	i=sp=0; do {
		draw_t_key(i, *twin); }
	while(++i < 16);

	for(;;) {
		if(exec_locn != -1)
			execute();
		idle_loop(); }
}

idle_loop()
{
	unsigned idelay, ts;
	unsigned d, mo, y, h, mi, s;
	unsigned char c, m, x;

	h = Host_tran;
	process_abort(0);
	m = x = '-';

	read_memory(980, buffer);
	idelay = atoi(buffer);

top1:
	if(h == -1)
		goto top3;
	if(m = read_memory(30, buffer))
		write_display("%s", buffer);
	else {
top2:
		ts = get_date(&d, &mo, &y);
		get_time(&h, &mi, &s);
		if(!(c = h)) c = 12;
		else if(c > 12) c -= 12;
		x = (s & 1) ? ((s < 30) ? 0xF9 : '.') : ':';
		write_display("%s %02u/%02u %2u%c%02u%c", days[ts], mo, d, c, x,
			mi, (h > 11) ? 'P' : 'A'); }
top3:
	ts = BIOS_TICK;
	do {
		if(exec_locn != -1)
			return;
		poll_input();
		switch(c = test_key()) {
		case 'D' :
			h = 0;
			write_display("Function?");
			while(!(c = test_key())) if(poll_input()) return;
			switch(c) {
			case 'D' : goto top1;
			case '7' :
			case '8' :
			case '0' :
			case '*' :
			case '#' :
			case 'B' :
			case 'C' : dump_state("TERMINAL COMMAND"); continue; }
			exec_locn = (c - '0') + 30;
			return;
		case '*' : display_pos -= 8; update_display(); goto top3;
		case '#' : display_pos += 8; update_display(); goto top3;
		case '0' :
		case 'B' :
		case 'C' : h = 0; goto top1;
		case 0 :
			if(!*cbuf) continue;
			if(read_memory(985, buffer))
				 c = *buffer;
			if((c < '1') || (c > '9'))
				c = '1';
		default:
			Host_key = c;
			Host_tran = (c - '0') * 100;
			if(!read_memory(Host_tran+4, buffer)) {
				h = "NO MERCHANT ID";
		itfail:	write_display(h);
				Host_key = 0;
				Host_tran = exec_locn = -1;
				return; }
			if(!read_memory(Host_tran, buffer)) {
				h = "NO PHONE NUMBER";
				goto itfail; }
			if(read_memory(Host_tran+8, buffer)) {
				write_display(buffer);
				delay(1000); }
			exec_locn = ILOC; // Host_tran + 5;
			return; } }
	while((BIOS_TICK - ts) < 18);

	if(idelay && !--idelay) {
		exec_locn = 981;
		return; }
	if(!m) goto top2;
	goto top3;
}

run_din6()
{
	unsigned char cmd[65], tail[50], rc;

	sprintf(cmd, "%s%s", home, d6cmd);
	sprintf(tail, " %u %u", get_ds(), d6buf);
	if(rc = exec(cmd, tail)) {
		*d6buf = d6ptr = 0;
		dump_state("%s failed(%u)", cmd, rc); }
	d6ptr = 0;
}

Cputtx()
{
	char *p;
	p = buffers[0];
	while(p < bwptr[0])
			Cput_c(*p++);
}

character_io(unsigned cx, unsigned t, unsigned s, unsigned m, char f)
{
	int c;
	unsigned ts, tnaks, rnaks;
	unsigned char lrc, *ptr, xx;

	m = m || 1;

	xx = tnaks = rnaks = 0;
	switch(cx) {
	case 1 :	// Append ETX + LRC and xmit
		ptr = buffers[0];
		while(*ptr && (*ptr++ != Stx));
		lrc = Etx;
		while(*ptr)
			lrc ^= *ptr++;
		*ptr++ = Etx;
		*ptr++ = lrc;
		*(bwptr[0] = ptr) = 0;
	case 0 :	// Xmit "raw"
		switch(f) {
		case 0 :	// Din6
			strcpy(d6buf, buffers[0]);
			run_din6();
			return;
		case 1 :	// Din8
		case 2 :	// Modem
			Cputtx();
			return; }
	default: dump_state("BAD IO PARM");
		return;
	case 5 :
	case 6 :
	case 7 : }

	// Receiving modes */
reset:
	ptr = bwptr[dest_buf];
	ts = BIOS_TICK;
	t *= 18;

loop:
	c = -1;
	switch(f) {
	case 0 :	// Din6
		if((*d6buf) && d6buf[d6ptr])
			c = d6buf[d6ptr++];
		break;
	case 1 :	// Din8
	case 2 :	// Modem
		if(Cpending != -1) {
			c = Cpending;
			Cpending = -1; }
		else
			c = Ctestc(); }
	if(c != -1)	switch(cx) {
		case 5 :
			*ptr++ = c;
			if(--m) goto loop;
		retx:
			*(bwptr[dest_buf] = ptr) = 0;
			check_dest();
			do_skip(s);
			return;
		case 7 :
			if(!xx) switch(c) {
				default: goto loop;
				case STX :
				case ACK :
				case NAK :
				case ENQ :
				case EOT :
				case CR  :
				case vACK :
				case vWACK:
				case vWAIT: }
		case 6 :
			if(f == 2) {	// Special cases for modem
				switch(c) {
				case NAK : if(!rtx_nak) break;
					if(rnaks++ > Nak_limit) {
						write_display("BAD TX COMMUN");
						process_abort(255);
						Host_tran = -1;
						return; }
					goto rtxok;
				case ENQ : if(!rtx_enq) break;
				rtxok: Cputtx(); goto reset; } }
			*ptr++ = c;
			if(!xx) {
				if(c != Stx) goto retx;
				xx = 1;
				lrc = Stx; }
			if(xx == 2) {
				if(lrc == c) goto retx;
				switch(f) {
				case 0 : dump_state("BAD DIN6 LRC"); goto retx;
				case 1 :
				case 2 :
					if(tnaks++ >= Nak_limit) {
						write_display("BAD RX COMMUN");
						process_abort(255);
						Host_tran = -1;
						return; }
					Cput_c(NAK); }
				goto reset; }
			lrc ^= c;
			if(c == Etx)
				xx = 2;
			goto loop; }

	if(poll_input())
		return;
	if(t && ((BIOS_TICK - ts) <= t))
		goto loop;

	*bwptr[dest_buf] = 0;
}

xdelay(unsigned t)
{
	unsigned ts;
	ts = BIOS_TICK;
	do {
		if(poll_input())
			return; }
	while((BIOS_TICK - ts) <= t);
}
