// based on code provided by: D. Litchinsky, DG Systems

// des constants
static char DesPC1[] = {
	57,	49,	41,	33,	25,	17,	9,
	1,	58,	50,	42,	34,	26,	18,
	10,	2,	59,	51,	43,	35,	27,
	19,	11,	3,	60,	52,	44,	36,
	63,	55,	47,	39,	31,	23,	15,
	7,	62,	54,	46,	38,	30,	22,
	14,	6,	61,	53,	45,	37,	29,
	21,	13,	5,	28,	20,	12,	4 };

static char DesPC2[] = {
	14,	17,	11,	24,	1,	5,
	3,	28,	15,	6,	21,	10,
	23,	19,	12,	4,	26,	8,
	16,	7,	27,	20,	13,	2,
	41,	52,	31,	37,	47,	55,
	30,	40,	51,	45,	33,	48,
	44,	49,	39,	56,	34,	53,
	46,	42,	50,	36,	29,	32 };

// unexpand and permut - final
static char UnEXP[] = {
	13,	13+48,	25,	25+48,	37,	37+48,	47,	47+48,
	10,	10+48,	22,	22+48,	34,	34+48,	46,	46+48,
	9,	9+48,	21,	21+48,	33,	33+48,	45,	45+48,
	8,	8+48,	20,	20+48,	32,	32+48,	44,	44+48,
	7,	7+48,	19,	19+48,	31,	31+48,	43,	43+48,
	4,	4+48,	16,	16+48,	28,	28+48,	40,	40+48,
	3,	3+48,	15,	15+48,	27,	27+48,	39,	39+48,
	48,	48+48,	14,	14+48,	26,	26+48,	38,	38+48 };

// expand from 32 to 48 bits
static char Des3248L[] = {
	8,	58,	50,	42,	34,	26,
	34,	26,	18,	10,	2,	60,
	2,	60,	52,	44,	36,	28,
	36,	28,	20,	12,	4,	62,
	4,	62,	54,	46,	38,	30,
	38,	30,	22,	14,	6,	64,
	6,	64,	56,	48,	40,	32,
	40,	32,	24,	16,	8,	58 };

// expand from 32 to 48 bits
static char Des3248R[] = {
	7,	57,	49,	41,	33,	25,
	33,	25,	17,	9,	1,	59,
	1,	59,	51,	43,	35,	27,
	35,	27,	19,	11,	3,	61,
	3,	61,	53,	45,	37,	29,
	37,	29,	21,	13,	5,	63,
	5,	63,	55,	47,	39,	31,
	39,	31,	23,	15,	7,	57 };

// expand from 32 to 48 bits
static char Des3248P[] = {
	25,	16,	7,	20,	21,	29,
	21,	29,	12,	28,	17,	1,
	17,	1,	15,	23,	26,	5,
	26,	5,	18,	31,	10,	2,
	10,	2,	8,	24,	14,	32,
	14,	32,	27,	3,	9,	19,
	9,	19,	13,	30,	6,	22,
	6,	22,	11,	4,	25,	16 };

static char DesSUBtab[] = {
	14,	4,	13,	1,	2,	15,	11,	8,	3,	10,	6,	12,	5,	9,	0,	7,
	0,	15,	7,	4,	14,	2,	13,	1,	10,	6,	12,	11,	9,	5,	3,	8,
	4,	1,	14,	8,	13,	6,	2,	11,	15,	12,	9,	7,	3,	10,	5,	0,
	15,	12,	8,	2,	4,	9,	1,	7,	5,	11,	3,	14,	10,	0,	6,	13,

	15,	1,	8,	14,	6,	11,	3,	4,	9,	7,	2,	13,	12,	0,	5,	10,
	3,	13,	4,	7,	15,	2,	8,	14,	12,	0,	1,	10,	6,	9,	11,	5,
	0,	14,	7,	11,	10,	4,	13,	1,	5,	8,	12,	6,	9,	3,	2,	15,
	13,	8,	10,	1,	3,	15,	4,	2,	11,	6,	7,	12,	0,	5,	14,	9,

	10,	0,	9,	14,	6,	3,	15,	5,	1,	13,	12,	7,	11,	4,	2,	8,
	13,	7,	0,	9,	3,	4,	6,	10,	2,	8,	5,	14,	12,	11,	15,	1,
	13,	6,	4,	9,	8,	15,	3,	0,	11,	1,	2,	12,	5,	10,	14,	7,
	1,	10,	13,	0,	6,	9,	8,	7,	4,	15,	14,	3,	11,	5,	2,	12,

	7,	13,	14,	3,	0,	6,	9,	10,	1,	2,	8,	5,	11,	12,	4,	15,
	13,	8,	11,	5,	6,	15,	0,	3,	4,	7,	2,	12,	1,	10,	14,	9,
	10,	6,	9,	0,	12,	11,	7,	13,	15,	1,	3,	14,	5,	2,	8,	4,
	3,	15,	0,	6,	10,	1,	13,	8,	9,	4,	5,	11,	12,	7,	2,	14,

	2,	12,	4,	1,	7,	10,	11,	6,	8,	5,	3,	15,	13,	0,	14,	9,
	14,	11,	2,	12,	4,	7,	13,	1,	5,	0,	15,	10,	3,	9,	8,	6,
	4,	2,	1,	11,	10,	13,	7,	8,	15,	9,	12,	5,	6,	3,	0,	14,
	11,	8,	12,	7,	1,	14,	2,	13,	6,	15,	0,	9,	10,	4,	5,	3,

	12,	1,	10,	15,	9,	2,	6,	8,	0,	13,	3,	4,	14,	7,	5,	11,
	10,	15,	4,	2,	7,	12,	9,	5,	6,	1,	13,	14,	0,	11,	3,	8,
	9,	14,	15,	5,	2,	8,	12,	3,	7,	0,	4,	10,	1,	13,	11,	6,
	4,	3,	2,	12,	9,	5,	15,	10,	11,	14,	1,	7,	6,	0,	8,	13,

	4,	11,	2,	14,	15,	0,	8,	13,	3,	12,	9,	7,	5,	10,	6,	1,
	13,	0,	11,	7,	4,	9,	1,	10,	14,	3,	5,	12,	2,	15,	8,	6,
	1,	4,	11,	13,	12,	3,	7,	14,	10,	15,	6,	8,	0,	5,	9,	2,
	6,	11,	13,	8,	1,	4,	10,	7,	9,	5,	0,	15,	14,	2,	3,	12,

	13,	2,	8,	4,	6,	15,	11,	1,	10,	9,	3,	14,	5,	0,	12,	7,
	1,	15,	13,	8,	10,	3,	7,	4,	12,	5,	6,	11,	0,	14,	9,	2,
	7,	11,	4,	1,	9,	12,	14,	2,	0,	6,	10,	13,	15,	3,	5,	8,
	2,	1,	14,	7,	4,	10,	8,	13,	15,	12,	9,	0,	3,	5,	6,	11 };

static unsigned DesKSFtab[] = {
	1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1 };

// des variables
static char
	DesKStab[800];

static void DesPerm(char *dest, char *src, char *table, unsigned len)
{
	unsigned i;
	for(i = 0;i < len; ++i)
		*dest++ = *(src+((*table++)-1));
}

static void DesSetKey(char *akey)
{
	unsigned i, j;
	char *ccd, *cpt, ct, dt, DesCDtab[56];

	DesPerm(DesCDtab, akey, DesPC1, 56);
	for(i = 0; i < 16; ++i) {
		for(j = 0; j < DesKSFtab[i]; ++j) {
			ct = DesCDtab[0];
			dt = DesCDtab[28];
			memcpy(DesCDtab, (DesCDtab+1), 56);
			DesCDtab[27] = ct;
			DesCDtab[55] = dt; }
		ccd = &DesKStab[i*48];
		cpt = DesPC2;
		for(j = 0; j < 48; ++j)
			*ccd++ = DesCDtab[(*cpt++)-1]; }
}

static void DesExpand(char *dest, char *src, char *table, unsigned len)
{
	unsigned i;
	for(i = 0; i < len; ++i)
		*dest++ = *(src+(*table++)-1);
}

static void DesXor(char *dest, char *src, unsigned len)
{
	unsigned i;
	for(i = 0; i < len; ++i) {
		*dest ^= *src++;
		++dest; }
}

static void DesH2B(unsigned char *s, unsigned char *d, unsigned l)
{
	unsigned i;
	unsigned char c;

	while(l--) {
		c = (*s > '9') ? (*s & 0x5F)-('A'-10) : *s - '0';
		i = 3; do {
			*d++ = (c >> i) & 1;
		} while(i--);
		++s; }
}

static void DesB2H(char *s, char *d, unsigned l)
{
	unsigned i;

	unsigned char c;
	while(l--) {
		c = 0;
		i = 3; do {
			if(*s++)
				c |= (1 << i);
		} while(i--);
		*d++ = (c > 9) ? c + ('A'-10) : c + '0'; }
	*d = 0;
}

/********************************************************/
/* encrypt function (type=1 for encrypt, 0 for decrypt) */
/********************************************************/
void DesEncrypt(char *dest, char *data, char *ikey, unsigned type)
{
	unsigned j, n;
	char *ppt, *val, *exr, in, sub, templ[48], exl[96], f[32], edata[64], ekey[64];

	DesH2B(data, edata, 16);
	DesH2B(ikey, ekey, 16);

	DesSetKey(ekey);

	exr = &exl[48];

	DesExpand(&exl[48], edata, Des3248R, 48);
	DesExpand(exl, edata, Des3248L, 48);

	for(n = 0; n < 16; n += 2) {
		memcpy(templ, exr, 48);
		DesXor(exr, type ? &DesKStab[n*48] : &DesKStab[(15-n)*48], 48);
		val = f;
		for(j = 0;j <= 7; ++j) {
			ppt = &exr[j*6];
			in = (*ppt*32) + (*(ppt+5)*16) + (*(ppt+1)*8) + (*(ppt+2)*4)
				+ (*(ppt+3)*2) + (*(ppt+4));
			sub = DesSUBtab[(j*64)+in];
			*val++ = (sub>>3) & 0x01;
			*val++ = (sub>>2) & 0x01;
			*val++ = (sub>>1) & 0x01;
			*val++ = sub & 0x01; }
		DesExpand(exr, f, Des3248P, 48);
		DesXor(exl, exr, 48);
		memcpy(exr, templ, 48);

		// second trial
		memcpy(templ, exl, 48);
		DesXor(exl, type ? &DesKStab[(n+1)*48] : &DesKStab[(15-(n+1))*48], 48);
		val=f;
		for(j = 0; j <= 7; ++j) {
			ppt = &exl[j*6];
			in = (*ppt*32) + (*(ppt+5)*16) + (*(ppt+1)*8) + (*(ppt+2)*4)
				+ (*(ppt+3)*2)+(*(ppt+4));
			sub = DesSUBtab[(j*64)+in];
			*val++ = (sub>>3) & 0x01;
			*val++ = (sub>>2) & 0x01;
			*val++ = (sub>>1) & 0x01;
			*val++ = sub & 0x01; }
		DesExpand(exl, f, Des3248P, 48);
		DesXor(exr, exl, 48);
		memcpy(exl, templ, 48); }
	DesPerm(edata, exl, UnEXP, 64);
	DesB2H(edata, dest, 16);
}

#ifndef EOF
#include <stdio.h>
main()
{
	unsigned char *p, dest[64];
	DesEncrypt(dest, p="041234FeDcBa9876", "7359B2163E4EDC58", 1);
	printf("Result: '%s'\n", dest);
	DesEncrypt(dest, dest, "7359B2163E4EDC58", 0);
	printf("Result: '%s'\n", dest);
	printf("        '%s'\n", p);
}
#endif
