/*
 * Convert a text file into a series of assembly language 'DB' statements
 */
#include <stdio.h>

unsigned
	line_number;		/* Track current line number */

char
	delim,					/* String delimiter */
	strip_trailing = -1,	/* Strip trailing whitespace */
	allow_double = -1,		/* Allow double quotes */
	allow_control = -1;		/* Allow control characters */

/*
 * Formatted print of error message
 */
register error(args)
	unsigned args;
{
	char buf[81];

	_format_(nargs() * 2 + &args, buf);
	fprintf(stderr, "%u: %s\n", line_number, buf);
	exit(-1);
}

/*
 * Read a line from the input
 */
read_line(char *buffer, unsigned size, FILE *fp)
{
	int c;
	unsigned i;

	i = 0;
	while((c = getc(fp)) != EOF) {
		if(c < ' ') switch(c) {
			case '\n' :
				buffer[i] = 0;
				return -1;
			default:
				if(!allow_control)
					continue;
			case '\t' : }
		buffer[i++] = c;
		if(i >= size)
			error("Line too long!"); }
	buffer[i] = 0;
	return *buffer;
}

test_special(char c)
{
	if(c < ' ')
		return c != '\t';
	if(c == '\\')
		return -1;
	return c == delim;
}

/*
 * Write a line to the output
 */
write_line(char *text)
{
	unsigned char c;

	fputs("DB", stdout);
	if(c = *text) {
		if(test_special(c)) {
			++text;
			putc(' ', stdout);
			goto another_special; }
		putc(delim, stdout);
		while(c = *text++) {
			if(test_special(c)) {
				putc(delim, stdout);
				putc(',', stdout);
			another_special:
				fprintf(stdout, "%u,", c);
				if(!(c = *text))
					goto exit_now;
				if(test_special(c)) {
					++text;
					goto another_special; }
				putc(delim, stdout);
				continue; }
			putc(c, stdout); }
		putc(delim, stdout);
		putc(',', stdout); }
	else
		putc(' ', stdout);
exit_now:
	fputs("10\n", stdout);
}

main(int argc, char *argv[])
{
	unsigned i;
	char buffer[300], s, d, *ptr;
	FILE *fp;

	if(argc < 2)
		abort("Use: makedb filename [-c -d -s]");

	for(i=2; i < argc; ++i) {
		ptr = argv[i];
		switch((toupper(*ptr++) << 8) | toupper(*ptr++)) {
			case ('-'<<8)|'C' :
			case ('/'<<8)|'C' :	allow_control = 0;	continue;
			case ('-'<<8)|'D' :
			case ('/'<<8)|'D' :	allow_double = 0;	continue;
			case ('-'<<8)|'S' :
			case ('/'<<8)|'S' :	strip_trailing = 0;	continue; }
		fprintf(stderr, "Bad option: %s\n", argv[i]);
		exit(-1); }
		

	fp = fopen(argv[1], "rvq");
	while(read_line(buffer, sizeof(buffer)-1, fp)) {
		++line_number;
		i = s = d = 0;
		delim = '\'';
		while(buffer[i]) switch(buffer[i++]) {
		case '\'' : s = -1; continue;
		case '"'  : d = -1; }
		if(s && allow_double && !d)
			delim = '"';
		if(strip_trailing) {
			while(i && isspace(buffer[i-1]))
				--i;
			buffer[i] = 0; }
		write_line(buffer); }
	fclose(fp);
}
