// ScanSys
#include <stdio.h>
#include <file.h>
#include <dvmvideo.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	MemTst(a)

#define	OUTF	"R:\\SSU.TXT"	// report
#define	VSFIL	"R:\\SSU.SEL"	// Remember/return to lase select
// Significant mounted drives which contain source code
#define	SDRV	"YWV"

#define	POOL	16384
#define	FILES	1024

#define	O_GO	0x01
#define	O_VERB	0x02
#define	O_VIEW	0x04

unsigned
	Seg, Stop,				// external segment
	Sh, Sl, At, Ti, Da,		// find_... variabkes
	Xsh, Xsl, Xda, Xti,		// "" for selected file
	Xno,					//			"" name offset
	Mext,					// Index to extensions that "matter"
	Dlevel,					// Directory scan lenel
	Dtop,					// Position in Dir[]
	Ftop,					// Top of file list
	Ptop,					// "" string pool growing up
	Pend = POOL,			//	""	""	""	""	""	  down
	Fname[FILES],			// Seg offset of file name
	Fsh[FILES],				// Files Size High
	Fsl[FILES],				//	""	  ""  Low
	Fda[FILES],				//	""	 Date
	Fti[FILES];				//	""	 Time
	L10[] = { 10, 0 };		// Lone10 - used by ShowLN
FILE
	*fpo;
unsigned char
	*Ptr,
	*Ptr1,					// General pointer
	*Ptr2,
	Opt = (O_GO|O_VERB),	// command line Options
	_vcl_,					// Video Color selected
	ABtst,					// AbortTestCounter
	Function,				// DoDir function selected
	Home[128],				// Home location
	Dir[128],				// ActiveScan directory
	Xname[128],				// Axtive name
	Fno[FILES],				// File name offsets
	Temp[128],				// Temp buffer
	Pool[POOL];				// String pool
extern unsigned Longreg[];

unsigned char *Ext[] = {
	// These are the extensions which "matter" (Check these)
	"C", "CH", "ASM", "MAC", "UAS", "UAC", "SRC", "DOC", "DWG", "1", "2", 
	"CC1", "CH1", "MCO", "FNT", "EQU", "MSG", "BAS", "S",
	// Extensions which done "" (report if unrecognized EXT fount)
	"DAT", "PRJ", "TXT", "H", "BAT", "CRD", "TCP", "ROM", "INI", "SCR", "VGA",
	"INT", "MOT", "SYM", "DLF", "PCL", "DLM", "LCD", "LCG", "TOL",
	"MAT", "IDE", "DEF", "DCT", "SYS", "HEX", "OS", "DTS",
	"NRO", "HLP", "CFG", "ESL", "VIA", "RL", "MDT", "UDL",
	"@", "", 0 };
#ifdef ETEST	// defined during initial testing
	unsigned char Ett[sizeof(Ext)/2];
#endif

// View() information & definitons
#define	VNOR	0x17
#define	VHIL1	0x71
#define	VHIL2	0x31
#define	LINES	24
// Some variables are "doubled up" to reduce memory
unsigned
//	Vpos,
//	Vsel,
//	Vtop,
	*Index;
#define	Vpos	Sh
#define	Vsel	Sl
#define	Vip		At
#define	Vtop	Da
//FILE
//	*fp;
#define	fp		fpo
unsigned char
	*Pbuf,
	*Sbuf;
//Buffer[128];
#define	Buffer	Xname

//ChtTxt R:\Help.H
#include "R:\\Help.H"

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	if(_vcl_) Vclose();
	fputs(buf, stdout);
	if(fpo) fclose(fpo);
	MemTst(0);
	exit(-1);
}

// Print -V
register Printf(unsigned args)
{
	unsigned n;
	unsigned char buf[200];
	n = nargs();
	if(Opt & O_VERB) {
		_format_(n*2+&args, buf);
		fputs(buf, stdout); }
}

// Output to Video/stdout/Report
void Pc(unsigned char c)
{
	if(_vcl_) {
		Vputc(c);
		return; }
	putc(c, stdout);
	if(fpo) putc(c, fpo);
}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Sp(void)				{	Pc(' ');			}
void Nl(void)				{	Pc('\n');			}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}

void Help(unsigned char *p)
{
	unsigned char c;
	while(c = *p++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				Pc(' ');
			continue; }
		Pc(c); }
}

void Abort(void)
{
	if(kbtst() == 0x1B)
		Error("?abort");
}

unsigned char SegPutc(unsigned char c)
{
	poke(Seg, Stop++, c);
	if(!Stop) Error("?SegOver");
	return c ;
}
void SegPuts(unsigned char *s)
{
	while(SegPutc(*s++));
}
void SegGets(unsigned char *dst, unsigned sp)
{
	while(*dst++ = peek(Seg, sp++));
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= Pend)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}
unsigned char *PEstring(unsigned char *p)
{
	if((Pend -= (strlen(p)+1)) < Ptop)
		Error("?Punder[%u %u]", Pend, Ptop);
	strcpy(Pool+Pend, p);
	return Pool+Pend;
}

void ShowLN(unsigned h, unsigned l)
{
	unsigned i, lv[2];
	unsigned char buf[13];
	buf[i = sizeof(buf)-1] = 0;
	lv[1] = h;
	*lv = l;
	do {
		longdiv(lv, L10);
		buf[--i] = *Longreg + '0'; }
	while longtst(lv);
	while(i) buf[--i] = ' ';
	Ps(buf);
}

void ShowDT(unsigned da, unsigned ti)
{
	Pr("%04u-%02u-%02u", (da>>9)+1980,	(da>>5)&15,		da&31);
	Pr(" %3u:%02u:%02u", ti>>11, 		(ti>>5)&63,		(ti&31)*2);
}

void DoFile1(void)
{
	unsigned i, e;
	unsigned char *p;
	if(!Dlevel)
		return;

	i = e  = 0;
a1:	switch(Temp[i++]) {
	case '.':	e = i;
	default	:	goto a1;
	case 0	:
		if(!e) e = i-1; }
	for(i=0; p = Ext[i]; ++i) {
		if(!strcmp(Temp+e, p)) {
#ifdef ETEST
			Ett[i] = 7;
#endif
			goto b1; } }
	strcpy(Dir+Dtop, Temp);
	Pc('?');
	ShowDT(Da, Ti);
	ShowLN(Sh, Sl);
	Sp();
	Ps(Dir);
	Nl();
	return;
b1:	if(i >= Mext) return;
	if(Ftop >= FILES)	Error("?#files");
	Fname[Ftop] = Stop;
	strcpy(Dir+Dtop, Temp);
	Fsh[Ftop] = Sh;
	Fsl[Ftop] = Sl;
	Fda[Ftop] = Da;
	Fti[Ftop] = Ti;
	Fno[Ftop++] = Dtop;
	SegPuts(Dir);
}

void DoFile2(void)
{
	static unsigned char nlf;
	Debug(("'%s'%s'\n", Xname+Xno, Temp))
	if(strcmp(Xname+Xno, Temp))
		return;
	if(Da > Xda)	goto a1;
	if(Da < Xda)	return;
	if(Ti <=Xti)	return;
a1:	if((Xsh&Xsl) != -1) {
		if(nlf) Nl();
		Pc(nlf = '=');
		ShowDT(Xda, Xti);
		ShowLN(Xsh, Xsl);
		Sp();
		Ps(Xname);
		Nl();
		Xsh = Xsl = -1; }
	strcpy(Dir+Dtop, Temp);
	Sp();
	ShowDT(Da, Ti);
	ShowLN(Sh, Sl);
	Sp();
	Ps(Dir);
	Nl();
}

void DoDir(void)
{
	unsigned i, dt, pt;
	pt = Ptop;
	dt = Dtop;
	while(Dir[Dtop]) ++Dtop;
	if(Dir[Dtop-1] != '\\')
		Dir[Dtop++] = '\\';
	strcpy(Dir+Dtop, "*.*");
	Debug(("D'%s'", Dir))

	if(find_first(Dir, 0x3F, Temp, &Sh, &Sl, &At, &Ti, &Da)) {
		Debug1(("?nf'%s'\n", Dir))
		goto ex; }
	Debug(("\n"))
	do {
		if(!--ABtst) {
a1:			switch(kbtst()) {
			default	:	goto a1;
			case 0x1B:	Error("?abort");
			case 0	:	; } }
		if(At &= (DIRECTORY|VOLUME|HIDDEN|SYSTEM)) {
			if((At == DIRECTORY) && (*Temp != '.'))
				Pstring(Temp);
			continue; }
		switch(Function) {
		default	:	Error("?func%u", Function);
		case 0	:	DoFile1();	continue;
		case 0x55:	DoFile2();	}
	} while !find_next(Temp, &Sh, &Sl, &At, &Ti, &Da);
	i = pt;
	while(i < Ptop) {
		strcpy(Dir+Dtop, Pool+i);
		while(Pool[i++]);
		++Dlevel;
		DoDir();
		--Dlevel; }
ex:	Dtop = dt;
	Ptop = pt;
}

void SetColor(unsigned char c)
{
	if(c != _vcl_)
		Vcolor(_vcl_ = c);
}

unsigned Value(void)
{
	unsigned v, c;
	while(*Ptr == ' ')
		++Ptr;
	v = 0;
	while((c = *Ptr - '0') < 10) {
		v = (v * 10) + c;
		++Ptr; }
	return v;
}

// Exgract only the Directory from full filename
void DirOnly(unsigned char p[])
{
	unsigned i, j;
	j = i = 0;
a1:	switch(p[i]) {
	case'\\':	j = i;
	default	:	++i; goto a1;
	case 0	:	; }
	if(j < 3)	// E:\xxx
		++j;
	p[j] = 0;
//	Error("Do'%s'%u\n", p, j);
}

// Change to drive:directory
unsigned Xcd(unsigned char *p)
{
	unsigned d;
	if(p[1] == ':') {
		set_drive(d = toupper(*p) - 'A');
		if(get_drive() != d)
			goto e1; }
	if(cd(p)) {
e1:		return 7; }
	return 0;
}

// Save ViewSelect
void VSsave(void)
{
	fp = fopen(VSFIL, "wvq");
	fprintf(fp, "%u %u %u\n", Vsel, Vpos, Vip);
	fclose(fp);
}

// View mode
void View(void)
{
	unsigned i, j, idx, ml;
	unsigned char c, eof;
	if(fp = fopen(VSFIL, "r")) {
		fgets(Ptr = Buffer, sizeof(Buffer)-1, fp);
		Vsel = Value();
		Vpos = Value();
		Vip	 = Value();
		fclose(fp); }

a0:	ml = idx = 0;
	Index = (Sbuf = (Pbuf = Pool) + 128) + 128;
	fp = fopen(OUTF, "rvq");
	while(fgets(Buffer, sizeof(Buffer)-1, fp)) {
		if(*Buffer == '=')
			Index[idx++] = ml;
		++ml; }
	Vopen(_vcl_ = VNOR);
a1:	if(Vpos & 0x8000)			Vpos = 0;
	if(Vpos > ml)				Vpos = ml;
	if(Vpos < Vtop)				Vtop = Vpos;
	if((Vtop+LINES) <= Vpos)	Vtop = Vpos-(LINES-1);
a2:	rewind(fp);
	for(i=eof=0; i < Vtop; ++i) {
		if(!fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
			eof = 0x55;
			break; } }
	*Pbuf = *Sbuf = 0;
	for(i=0; i < LINES; ++i) {
		Vgotoxy(0, i);
		if((j = Vtop+i) == Vpos)
			SetColor(VHIL1);
		else if(j == Vsel)
			SetColor(VHIL2);
		switch(eof) {
		case 0	: //  2			3
//0123456789012345678901234567890123456789
//=2023-12-11  16:33:30        9709 E:\BLDTOOL\BLD.C
// 2024-02-25  12:21:20        9637 Y:\C\SRC\UTIL7\BLD.C
			if(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
				if(*Buffer) {
					if(j == Vpos)		strcpy(Pbuf, Buffer+34);
					else if(j == Vsel)	strcpy(Sbuf, Buffer+34);
				} break; }
		case 0x55:
			Vputs("[EOF]");
			eof = 0xAA;
		case 0xAA:
			goto a9; }
		Vputs(Buffer);
a9:		Vcleol();
		SetColor(VNOR); }
//	Vgotoxy(0, LINES);
b1:	switch(i = toupper(Vgetk())) {
	default	:	goto b1;
	case _KUA:	i = 1;	goto b2;
	case _KPU:	i = LINES-1;
b2:		Vpos -= i;
		goto a1;
	case _KDA:	i = 1;	goto b3;
	case _KPD:	i = LINES-1;
b3:		Vpos += i;
		goto a1;
	case _KHO:	Vpos = 0;	goto a1;
	case _KEN:	Vpos = ml;	goto a1;
/*ChtTxt Vhelp

	   ~^/~v		Move libe
	PgUp/PgDn	"" by screen
		=		Find/Select next '='
		-			""	  Previous ""
		L		position to Last select
		S		Select at position
		T		View corrent			(Text)
		B		view current			(Binary)
		C		Compare select/current	(Text)
		K			""		 ""			(binary)
		G		Go to Current directory
		F		  "" selecte/current ""s
	   Esc		Quit
*/
	case '-':	i = 0;
	case '=':
		if((Index[Vip]) != Vpos) {
b4:			Vpos = Vsel = Index[Vip];
			goto a1; }
		if(!i) {
			if(Vip)			{ --Vip; goto b4; }
			goto b1; }
		if((Vip+1) < idx)	{ ++Vip; goto b4; }
		goto b1;
	case 'L':	Vpos = Vsel; goto a2;
	case 'S':	Vsel = Vpos; goto a2;
	case '?':
		wclwin();
		Help(Vhelp);
		Vgetc();
		goto a1;
	case 'K':	Ptr = "fcb \xA2 \xA1";		goto b5;
	case 'C':	Ptr = "fct -S \xA2 \xA1";
b5:		if(!*Sbuf)	goto b1;
b6:		if(!*Pbuf) goto b1;
		eof = 0;
		break;
	case 'T':	Ptr = "fvt \xA1";			goto b6;
	case 'B':	Ptr = "fvb \xA1";			goto b6;
	case 'F':
		if(!*Sbuf)	goto b1;
		strcpy(Pool+16000, Sbuf);
		DirOnly(Sbuf);
		if(Xcd(Sbuf)) {
			Xcd(Home);
			goto b1; }
	case 'G':
		if(!*Pbuf) goto b1;
		strcpy(Pool+16128, Pbuf);
		DirOnly(Pbuf);
		if(Xcd(Pbuf)) {
			Xcd(Home);
			goto a1; }
		Vclose(); _vcl_ = 0;
		fclose(fp);
		if(i == 'F') {
			set_drive(*Sbuf-'A');
			Ps(Pool+16000);
			Nl(); }
		Ps(Pool+16128); Nl();
		VSsave();
		return;
	case 0x1B:
		eof = 7; }
	Vclose();
	fclose(fp);
	VSsave();
	if(!eof) {
		Ptr1 = Dir;
c1:		switch(c = *Ptr++) {
		default	:
			*Ptr1++ = c;
			goto c1;
		case	0	:
			*Ptr1 = 0;
			system(Dir);
			goto a0;
		case 0xA1:	Ptr2 = Pbuf;	break;
		case 0xA2:	Ptr2 = Sbuf;	}
		while(*Ptr2) *Ptr1++ = *Ptr2++;
		goto c1; }
Debug(("\nMl%u Idx%u %04x %04x %04x\n", ml, idx, Pbuf, Sbuf, Index))
Debug(("S%u'%s'\n", Vsel, Sbuf))
Debug(("P%u'%s'\n", Vpos, Pbuf))
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char *p, c;

	MemTst(7);
	strcpy(Home, "::\\");
	*Home = get_drive() + 'A';
	getdir(Home+3);
	Debug1(("H'%s'\n", Home))

	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:
he:				Help(Chelp);
				goto ex;
/*ChtTxt Chelp
ScanSystemUpdates

use:	SSU	[options]

opts:	-G		Go
		-Q		Quiet
		-V		View

ScanSystem for same nane files newer than those below here,
and builds: R:\SSU.TXT
*/
			case 'G':	c = O_GO;	goto o2;
			case 'Q':	c = O_VERB;	goto o2;
			case 'V':	c = O_VIEW;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		goto he; }
	if(Opt & O_VIEW) {
		View();
		return; }
	if(Opt & O_GO)	goto he;

	Seg = alloc_seg(4096);
	for(i=0; p = Ext[i]; ++i) {
		if(!strcmp(p, "DAT")) {
			Mext = i;
			break; } }
	Debug(("%u'%s'\n", Mext, p))

	strcpy(Dir, Home);
	DoDir();

	Printf("F%u S%u\n", Ftop, Stop);
#ifdef ETEST
	for(i=0; p = Ext[i]; ++i) {
		if(!Ett[i])
			printf("?.'%s'\n", p); }
	return;
#endif
	Function = 0x55;
	fpo = fopen(OUTF, "wvq");
	for(i=0; i < Ftop; ++i) {
		SegGets(Xname, Fname[i]);
		Xno = Fno[i];
		Xda = Fda[i];
		Xti = Fti[i];
		Xsh = Fsh[i];
		Xsl = Fsl[i];
#if 0
		ShowDT(Xda, Xti);
		ShowLN(Xsh, Xsl);
		Sp();
		Ps(Xname);
		Pc('`');
		Ps(Xname+Xno);
		Nl();
		continue;
#endif
		Printf("%u'%s'%u\n", i, Xname, Ftop);
		p = SDRV;
		while(c = *p++) {
			strcpy(Dir, "::\\");
			*Dir = c;
			Dtop = 0;
			Debug(("F'%s'D'%s'\n", Xname+Xno, Dir))
			DoDir(); } }
	fclose(fpo);
ex:	MemTst(0);
}
