// FVT
#include <stdio.h>
#include <dvmvideo.h

#define	While while

#define	HEIGHT	24
#define	WIDTH	80

#define	LMAX	8192

#define	VNORM	0x17	// Normal
#define	VHIL1	0x21	// Lookup
#define	VHIL2	0x24	// Unprintable
#define	VHIL3	0x31	// Selected
#define	VATTN	0x71	// Special notes
#define	VSTAT	0x70	// Status window

#define	VUNP	0xA8	// Unprintable
#define	VSPC	0xB1	// printable Space
#define	VTAB	0xB0	// "" Tab

unsigned
	LineH[LMAX],
	LineL[LMAX],
	Ltop,
	Select = 255,	// Select mode not active
	Column,			// Current column on screen
	Cpos,			// Position in column
	Cend,			// Colum position of end of screen
	Tab = 4,		// Tab width
	Hcol,			// Colum for Hilite
	Hlen,			// Hilite length
	Hpos,			// Position for hilite
	Line[2],		// Line at top of screen
	Fline[2],		// Last find line
	Hline[2],		// Line for hilite
	Slow[2],		// Select range low
	Shigh[2],		// Select range high
	MaxLine[2];		// Maximum Line
FILE
	*fp;
unsigned char
	*Ptr,
	*Stext,			// Status line text
	*FNtext,		// Points to file name
	VcolorN,
	Sch = ' ',
	Tch = ' ',
	Hdisp = 255,	// Help display is not active
	Uprt = VUNP,
	Wider,			// Screen still has wider data
	Sopt,			// Search options
	Tchar,			// Temp char variable
	Buffer[256],	// General buffer
	Temp[128],		// Temp""
	Ftext[60];		// Search text
unsigned
	L1[2]		=	{ 1,			0 },
	Lheight[2]	=	{ HEIGHT-1,		0 };

#include "R:\\help.h"

// Search options
#define	S_CASE	0x01	// Case insensitive
#define	S_SOL	0x02	// At start of line
#define	S_EOL	0x04	// At end of line

//Print error message and terminate
register error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	fputs(buf, stdout);
	exit(-1);
}

void Wcolor(unsigned char c)
{
	Vcolor(VcolorN = c);
}
void Rcolor(void)
{
	Vcolor(VcolorN);
}

// Skip to non-blank
int skip(void)
{
	While(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}
void Sstart(void)
{
	Vgotoxy(0, 0);
	Wcolor(VSTAT);
}
void Send(void)
{
	Vcleol();
	Wcolor(VNORM);
}
register Sprintf(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Vputs(buf);
}

// Display help text
void help(unsigned char *p, int of)
{
	unsigned char c;
	While(c = *p++) {
		if(c & 0x80) {
			While(c-- & 0x7F) {
				if(of)
					Vputc(' ');
				else
					putc(' ', stdout); }
			continue; }
		if(of)
			Vputc(c);
		else
			putc(c, stdout); }
}

void GoLine(unsigned char *ln)
{
	unsigned so, h, l;
	longcpy(Line, ln);
	so = *(unsigned*)(ln+1);
	if(!so)
		h = l = 0;
	else {
		so = so-1;	//?(so - 1) *2;
		if(so >= Ltop)
			error("?line too high %u", so);
		l = LineL[so];
		h = LineH[so]; }
	if(fseek(fp, h, l, 0))
		error("?fseek");
	so = *ln;
	While(so) {
		if(!fgets(Buffer, sizeof(Buffer)-1, fp))
			error("?eof");
		--so; }
}

int Oc(unsigned char c)
{
	int r;
	if(Cpos >= Cend)
		return 15;
	if((c < '!') || (c > 0x7E)) switch(c) {
		case  0 : return 255;
		case VSPC:
		case VTAB:
			if(Tch & 0x80)
				break;
		default :	// Unprintable
			if(Uprt) {
				c = Uprt;
				break; }
			Vcolor(VHIL2);
			if(c < ' ') {
				r = Oc(c+'@');
				goto rr1; }
			if((r = c>>4) > 9)		r += ('A'-'0'-10);
			if(r = Oc(r+'0'))		goto rr1;
			if((r = c & 15) > 9)	r += ('A'-'0'-10);
			r = Oc(r+'0');
	rr1:	Rcolor();
	rr:		return r;
		case'\t':	// Tab
			do {
				if(r = Oc(Tch))
					goto rr; }
			While(Cpos % Tab);
			goto rz;
		case ' ': c = Sch; }
	if(Cpos++ >= Column)
		Vputc(c);
rz:	return 0;
}
void redraw(void)
{
	unsigned i, lh, l[2], ln[2];
	unsigned char va;
	unsigned char d;

	longcpy(l, MaxLine);
	if(longsub(l, Lheight))
		longset(l, 0);
	if(longcmp(l, Line) & 0xFF00)
		longcpy(Line, l);
	d = 0; GoLine(Line);
	Sstart();
	if(Stext) {
		Vcleol();
		Vputs(Stext);
		Stext = 0; }
	else {
		longcpy(l, Line);
		longadd(l, L1);
		ltoa(l, Temp, 10);
		Sprintf("%-7s%3u%3u", Temp, Column+1, Tab);
		if(!Select) {
			ltoa(Slow, Temp, 10);
			ltoa(Shigh, Temp+20, 10);
			Sprintf(" [%s-%s]", Temp, Temp+20); }
		Vputs(" : ");
		Vputs(FNtext); }
	Send();
	longcpy(ln, Line);
	for(Wider = i = 0; i < HEIGHT; ++i) {
		Vgotoxy(Cpos = Hpos = 0, i+1);
		va = VNORM;
		if(!Select) {
			if(!(longcmp(ln, Slow) & 0x8000)) {	// Line >= Sline-Slow
				if(!(longcmp(Shigh, ln) & 0x8000))	// Line <= Sline+Shigh
					va = VHIL3; } }
		Wcolor(va);;
		if(d) {
eof:		if(!(d & 0xF0)) {
				d = 255;
				Vcolor(VATTN);
				Vputs("[EOF]");
				Wcolor(va); }
			Vcleol();
			continue; }
		if(!fgets(Ptr = Buffer, sizeof(Buffer)-1, fp))
			goto eof;
		if(!++*ln)
			++ln[1];
		lh = longcmp(ln, Hline) ? 0 : -1;
		Cend = Column+WIDTH;
a1:		if(lh) {
			if(lh & 0x8000) {
				if(Hpos++ >= Hcol) {
					Wcolor(VHIL1);
					lh = Hlen; } }
			else if(!--lh)
				Wcolor(va); }
		switch(Oc(*Ptr++)) {
		case 0 : goto a1;				// Normal character
		case 15: Wider = 255; break;	// Beyond screen
		default: Vcleol();	} }			// 0(End of text)
	Wcolor(VNORM);
}
// Prompt for and get string
int getstring(unsigned char *prompt, unsigned char *dest, unsigned len)
{
	unsigned i;
	unsigned char ha, buf[80];
	strcpy(buf, dest);
	ha = 0;
a1:	Sstart();
	Vcleol();
	Vputs(prompt);
#ifdef _DVM_
	switch(i = Vgets(buf, len|0x200)) {
#else
	switch(i = wgets(W_OPEN->WINcurx, 0, buf, len)) {
#endif
	case _K1:
		Send();
		Vgotoxy(0, 1); Vcleos();
		help(GShelp, 255);
		ha = 255;
		goto a1; }
	Send();
	if(ha) redraw();
	if(i == '\n')
		strcpy(dest, buf);
	return i;
}
int BegCS(unsigned char *p1, unsigned char *p2)
{
	While(*p2) {
		if(*p1++ != *p2++)
			return 0; }
	Tchar = *p1;
	return 255;
}
int BegCI(unsigned char *p1, unsigned char *p2)
{
	While(*p2) {
		if(toupper(*p1++) != *p2++)
			return 0; }
	Tchar = *p1;
	return 255;
}
// Perform a search
void search(void)
{
	int *cfp;
	unsigned l[2], l1[2];
	unsigned char x, sol;

	Sprintf("\rLooking:%s", Ftext); Send();
	if(!*Ftext)
		return;
	cfp = (Sopt & S_CASE) ? &BegCI : &BegCS;
	longcpy(l, Line);
	GoLine(Fline);
	While(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
		if(!++*Fline)
			++Fline[1];
		sol = Sopt & S_SOL;
		While(*Ptr && --sol) {
			if((*cfp)(Ptr, Ftext)) {
				if((Sopt & S_EOL) && Tchar)	goto sn;
				longcpy(Line, l);	// Assume on same screen
				longcpy(Hline, Fline);
				Hcol = Ptr - Buffer;
				Hlen = strlen(Ftext);
				ltoa(Fline, Temp+100, 10);
				sprintf(Temp, "Found at: %s", Temp+100);
				Stext = Temp;
				longcpy(l, Fline);
				longsub(l, L1);
				if(longcmp(l, Line) & 0xF000)
					goto a1;
				longcpy(l1, Line);
				longadd(l1, Lheight);
				if(longcmp(l1, l) & 0xF000) {
a1:					longcpy(Line, l); }
				return; }
sn:			++Ptr; }
		if(!--x) {
			if(kbtst() == 0x1B) {
				Stext = "Aborted!";
				goto x1; } } }
	Stext = "Not found!";
x1:	longcpy(Line, l);
	*Hline = Hline[1] = 0xFFFF;
}
void Wselect(void)
{
	unsigned l[2];
	FILE *fpo;

	if(Select) {
		Stext = "No lines selected";
		return; }
	*Temp = 0;
	if(getstring("File?", Temp, 64) != '\n')
		return;
	Sstart();
	Vputs("Writing: "); Vputs(Temp);
	Send();
	if(!(fpo = fopen(Temp, "w"))) {
		sprintf(Stext = Buffer, "Can't access: %s", Temp);
		return; }
	longcpy(l, Line);
	GoLine(Slow);
	While(longcmp(Line, Shigh) <= 0) {
		if(!fgets(Buffer, sizeof(Buffer)-1, fp))
			break;
		if(!++*Line)
			++Line[1];
		fputs(Buffer, fpo);
		putc('\n', fpo); }
	fclose(fpo);
	longcpy(Line, l);
}
/*ChtTxt R:\\Help
File View Text

use: FVT filename [starting line]

Large files can take a little while to index, however once you are at the
interactive screen, movement around the file should be very fast.

Use '?' interactive key for help.

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
main(int argc, char *argv[])
{
	unsigned i, j, l[2];

	for(i=1; i < argc; ++i) {
		switch(*(Ptr = argv[i])) {
		case '-':
		case '/':
			if(Tab = atoi(Ptr+1) & 63) continue;
		case '?': goto he;
		default : ; }
		if(!Stext) {
			Stext = Ptr;
			continue; }
		if(!longtst(Line)) {
			atol(Ptr, Line, 10);
			longsub(Line, L1);
			continue; }
		he:	help(Help, 0);
			return; }
	if(!(Ptr = FNtext = Stext)) goto he;
	i = strlen(Ptr); j = 0;
a0:	if((i - j) > 50) switch(Ptr[j++]) {
		case ':':
		case'\\': FNtext = Ptr+j;
		default : goto a0;
		case 0  : ; }

	fp = fopen(Stext, "rvq");
	printf("Indexing: %s", Stext);
	While(fgets(Buffer, sizeof(Buffer)-1, fp)) {
		if(!++*MaxLine)
			++MaxLine[1];
		if(!(*MaxLine & 255)) {
			if(ftell(fp, &i, &j))
				error("?ftell");
			if(Ltop >= LMAX)
				error("?too many lines");
			LineL[Ltop] = j;
			LineH[Ltop++] = i; } }
	ltoa(MaxLine, Buffer, 10);
	printf(" L=%s\n", Buffer);

	Vopen(VNORM);
//?	wcursor_off();
a1:	if(Line[1] == 0xFFFF)	longset(Line, 0);
	if(Column & 0xFC00)		Column = 0;
	redraw();	Hdisp = 255;
/*ChtTxt Ihelp
FCT Interactive commands:

	 U/D/L/R	move around file
	PgUp/PgDn	Move one screen
	  Home		Move to colume 0
   ^Left/^Right	Move column side to size in 25 line increments
   ^PgUp/^PgDn	Move to 1st/last line
	   F1		Go to line number (+/- means adjust current)
		 Press F1 during string entry for more help
	   F2		Search for text from beginning of file
	   F3		Search for text from top of screen
	   F4		Continue last search
	   F5		Select lines (Start to End)
		 if no lines selected, Start and End are set to top of screen
		 if TOS == Start, all lines are deselected
		 if TOS <  Start, Start is set to TOS
		 if TOS >  End, End is set to TOS
		 if TOS>Start & TOS<End, End=End+1 ; (good selecting last screen)
	   F6		Go to Start of selected lines
	   F7		Go to  End  of selected lines
	   F9		Write selected lines to file
	   Tab		Cycle 1/2/4/8/16 tab stops
	   ' '		toggle unprintable		'.'	space/tab display
	   ESC		Exit
*/
a2:	if(Stext) goto a1;
	switch(Vgetk()) {
	default:
		if(!Hdisp) goto a1;
		goto a2;
	case _KUA:	j = 1;	sj:	longset(l, j);	longsub(Line, l);	goto a1;
	case _KDA:	j = 1;	aj: longset(l, j);	longadd(Line, l);	goto a1;
	case _KRA:	j = 1;	rj:	if(Wider) Column += j;				goto a1;
	case _KLA:	j = 1;	lj:	Column -= j;						goto a1;
	case _KPU:	j = HEIGHT-1;			goto sj;
	case _KPD:	j = HEIGHT-1;			goto aj;
	case _KHO:	Column = 0;				goto a1;
	case _CRA:	j = 25;	goto rj;
	case _CLA:	j = 25;	goto lj;
	case _CPU:	longset(Line, 0);		goto a1;
	case _CPD:	*Line=Line[1]=0xFFFE;	goto a1;
	case _K1:		// Goto line
		*Buffer = 0;
		if(getstring("Line?", Ptr=Buffer, 64) == '\n') {
			switch(j=skip()) {
			case '+' :
			case '-' : ++Ptr; skip(); }
			atol(Ptr, l, 10);
			if(longtst(l)) {
				switch(j) {
				case '+': longadd(Line, l);	goto a1;
				case '-': longsub(Line, l);	goto a1;
				default	: longcpy(Line, l); }
				longsub(Line, L1); } }
		goto a1;
	case _K2 :		// Search
		longset(Fline, 0);
		goto f1;
	case _K3:		// Search from top of screem
		longcpy(Fline, Line);
	f1:	*(Ptr = Temp) = '[';
		if(Sopt & S_SOL)	*++Ptr = '<';
		if(Sopt & S_EOL)	*++Ptr = '>';
		strcpy(Ptr+1, (Sopt & S_CASE) ? "CI" : "CS");
		strcpy(Ptr+3, "]Search?");
/*ChtTxt GShelp
FCT String Entry:

  Left/Right	- Position cursor
   Bkspace		- Backup cursor & delete
	 Del		- Delete character under cursor
	 Ins		- Toggle INSERT/OVERWRITE
	Home		- Position cursor at start of string
	 End		- Position cursor at end of string
	PgUp		- Clear entire field
	PgDn		- Clear from cursor to end of field
	Enter		- Accept string
	 F2			- [Search] Toggle Case sensitividy
	 F3			- [Search] Toggle "must be at start of line"
	 F4			- [Search] Toggle "must be at  end  of line"
	 ESC		- Cancel entry
*/
		switch(getstring(Temp, Ftext, sizeof(Ftext)-1)) {
		case _K2 : Sopt ^= S_CASE;	goto f1;
		case _K3 : i = S_SOL;		goto f2;
		case _K4 : i = S_EOL;		f2:
			j = Sopt & i;
			Sopt &= ~(S_SOL|S_EOL);
			if(!j) Sopt |= i;
		default:	goto f1;
		case 0x1B:	goto a1;
		case '\n' : if(Sopt & S_CASE)	strupr(Ftext); }
	case _K4:		// Search again
		search();
		goto a1;
	case _K5:		// Select
		if(Select) {
			Select = 0;
			longcpy(Slow, Line);
			goto a3; }
		if(!(i = longcmp(Line, Slow))) {
			Select = 255;
			goto a1; }
///		if(longcmp(Line, Slow) < 0) {
		if(i & 0x8000) {
			longcpy(Slow, Line);
			goto a1; }
		if(longcmp(Line, Shigh) > 0) {
a3:			longcpy(Shigh, Line);
			goto a1; }
		if(longcmp(Shigh, MaxLine) < 0)
			longadd(Shigh, L1);
		goto a1;
	case _K6 :	longcpy(Line, Slow);	goto a1;
	case _K7 :	longcpy(Line, Shigh);	goto a1;
	case _K9 :	Wselect();				goto a1;
	case '?' :
		Vclscr();
		help(Ihelp, 255);
		Hdisp = 0;
		goto a2;
	case ' ':	Uprt ^= VUNP;			goto a1; //FA
	case '.':
		if(Tch & 0x80) {
			Sch = Tch = ' ';
			goto a1; }
		Sch = VSPC;
		Tch = VTAB;
		goto a1;
	case '\t':
		if((Tab <<= 1) > 16)
			Tab = 1;
	goto a1;
	case 0x1B:
		if(!Hdisp) goto a1; }
	Vclose();
	fclose(fp);
}
