// FVB
#include <stdio.h>
#include <dvmvideo.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	HLINES	24

#define	VNORM	0x17	// Normal
#define	VHIL1	0x31	// Selected
#define	VHIL2	0x24	// EOL
#define	VHIL3	0x34	// Selected EOL
#define	VATTN	0x71	// Special notes
#define	VSTAT	0x70	// Status window

#define	S_UC	0x01	// Search UPPER

unsigned
	Base = 16,
	Sh, Sl,
	Loc[2],
	Slen,
	MaxH,
	MaxL;
FILE
	*fp;
unsigned char
	*Ptr,
	VidMode,
	Sflg,			// Search Flags
	Iflg,
	UPc = 0xA8,
	UPcS,
	Buffer[256],
	Temp[256],
	Stext[128],
	Sbyte[128],
	LUtran[256];

//ChtTxt R:\Help.h
#include "R:\Help.h"

void Pc(unsigned char c)
{
	if(VidMode) {
		Vputc(c);
		return; }
	putc(c, stdout);
}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	if(!VidMode) {
		Ps(buf);
		exit(-1); }
	Vgotoxy(0, HLINES);
	Vputs(buf);
	Vcleol();
a1:	switch(Vgetk()) {
	default	:	goto a1;
	case 0x1B:
		Vclose();
		VidMode = 0;
		Error("?Abort");
	case ' ':
		Vgotoxy(0, HLINES);
		Vcleol(); }
	VidMode = 0x55;
}

register Prompt(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Vgotoxy(0, HLINES);
	Vputs(buf);
	Vcleol();
}

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

void Help(unsigned char *p)
{
	unsigned char c;
	while(c = *p++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				Pc(' ');
			continue; }
		Pc(c); }
}

unsigned Value(unsigned *dh, unsigned *dl)
{
	unsigned C[2], V[2], B[2], c;
	unsigned char *p;

	switch(Skip()) {
	case '%':	Base = 2;	goto a1;
	case '@':	Base = 8;	goto a1;
	case '.':	Base = 10;	goto a1;
	case '$':	Base = 16;
a1:		++Ptr; }
	p = Ptr;
	longset(V, C[1] = 0);
	longset(B, Base);
a2:	c = *Ptr;
	if((c >= '0') && (c <= '9'))	{	c -= '0';		goto a3; }
	if((c >= 'a') && (c <= 'f'))	{	c -= ('a'-10);	goto a3; }
	if((c >= 'A') && (c <= 'F'))	{	c -= ('A'-10);
a3:		Debug(("V:%x%04x B:%x%04x C:%u\n", V[1], *V, B[1], *B, c))
		if(c < Base) {
			longmul(V, B);
			*C = c;
			longadd(V, C);
			++Ptr;
			goto a2; } }
	if(Ptr == p) {
		Error("?BadValue");
		return 255; }
	if(dh)
		*dh = V[1];
	*dl = *V;
	return 0;
}

unsigned GetVS(unsigned char *dst, unsigned l)
{
	unsigned i, c;
	unsigned char *p;
	Vcleol();
	i = 0;
a1:	switch(c = Vgetk()) {
	default:
		if(c & 0xFF80)	goto a1;
		if(i >= l)		goto a1;
		if(Iflg) {
			p = "0123456789abcdefABCDEF%@.$ ";
			while(*p) {
				if(*p++ == c)
					goto a1a; }
			goto a1; }
a1a:	dst[i++] = c;
		if(c < ' ') {
			Vcolor(VHIL1);
			Vputc(c + '@');
			Vcolor(VNORM);
			goto a1; }
		Vputc(c);
		goto a1;
	case _KBS:
		if(i) {
			Vputs("\b \b");
			--i; }
		goto a1;
	case _K7:	Sflg ^= S_UC;
	case _K8:
		Vcolor(VHIL1);
		Vputc((Sflg & S_UC) ? 0x18 : 0x12);
		Vcolor(VNORM);
		Vputc('\b');
		goto a1;
	case _K9:	i = 0;
	case _K10:	dst[i] = 0; }
	return i;
}

unsigned Search(void)
{
	unsigned i, c, s, b, x, y;
	unsigned char e, r, w;
	static unsigned char lul = 0x55;

	if((e= Sflg & S_UC) != lul) {
		for(i=0; i < 256; ++i)
			LUtran[i] = i;
		if(lul = e) {
			for(i='A'; i <= 'Z'; ++i)
				LUtran[i+0x20] = i; } }

	Prompt("Search");
	x = y = 0;

//	rewind(fp);
	fseek(fp, Sh, b = Sl, 0);
	s = w = r = e = 0;
a1:	if(!e) {
		while(s < 256) {
			if((c = getc(fp)) == EOF) {
				e = 255;
				break; }
			Temp[w++] = c;
			++s; } }
	if(s < Slen) {
r0:		return 0; }
	r = (Sl - b) & 255;
	i = 0;
	while(i < Slen) {
//		if(LUtran[Sbyte[i++]] != LUtran[Temp[r++]])
		if(LUtran[Temp[r++]] != Sbyte[i++])
			goto a2; }
	// Found
	Loc[1] = Sh;
	*Loc = Sl;
	return 255;
a2:	++Sl;
	if(!Sl) ++Sh;
	--s;
	if(!--x) {
		if(++y >= 10) {
			if(kbtst() == 0x1B)
				goto r0;
			Vputc('.');
			y = 0; } }
	goto a1;
}

main(int argc, char *argv[])
{
	unsigned c, i, j, k, lh, ll;
	unsigned char e;

#if 0
	if(argc < 2) Error("?args");
	i = 0;
	Ptr = argv[1];
	printf("%u ", Value(0, &i));
	printf("%u %x", i, i);
	return;
#endif

	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
			switch(c = toupper(*Ptr++)) {
			default	:	goto he;
			case 'U':
				if(!(c = atox(Ptr)))
					c = ' ';
			case '.':
				UPc = c;
				continue; } }
/*ChtTxt Mhelp
File View Binary

use:	FVB	filename [startaddress] [options]

opts:	-U[xx]		show Unprintable characters as hex. char xx		[A8]
		-.			"" as '.'

use '?' interactively for help.

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
		if(!*Buffer) {
			strcpy(Buffer, Ptr); 
			continue; }
		if(Loc[1] | *Loc)
			goto he;
		Value(&Loc[1], Loc);
		if(Skip())
			goto he; }
	if(!*Buffer) {
he:		Help(Mhelp);
		return; }
	UPcS = UPc;

	j = find_first(Buffer, 0, Temp, &MaxH, &MaxL, &j, &j, &j);
#ifdef _DVM_
	find_close();
#endif
	fp = fopen(Buffer, "rbvq");
	if(j) goto he;
	Vopen(VNORM);

a0:	VidMode = 255;
	if( (i = 40 - (strlen(Buffer)/2)) & 0x8000)
		i = 0;
	Vgotoxy(i, 0);
	Vputs(Buffer);
	Vgotoxy(40-4, 24);
	Vprintf("%04x%04x", MaxH, MaxL);

a1:	fseek(fp, lh = Loc[1], ll = *Loc, 0);
	i = e = 0;
	while(++i < HLINES) {
		Vgotoxy(0, i);
		if(e)
			goto a1a;
		Vprintf("%04x%04x ", lh, ll);
		k = 16;
		for(j=0; j < 16; ++j) {
			if(!(j & 3))
				Vputc(' ');
			if(k & 0xF0) {
				if((c = getc(fp)) == EOF) {
					k = j;
					e = 7; } }
			if(k & 0xF0)
				Vprintf("%02x ", c);
			else
				Vputs("   ");
			Temp[j] = c; }
		Vputs("  ");
		for(j=0; j < k; ++j) {
			c = Temp[j];
			if((c < ' ') || (c > '~'))
				c = UPc;
			Vputc(c); }
a1a:	Vcleol();
		if((ll += 16) < 16)
			++lh; }
a2:	ll = i = *Loc; lh = Loc[1];
	switch(c = Vgetk()) {
	default	:	goto a2;
/*ChtTxt Ihelp
FVB interactive commands:

	Left/Right	move view by one byte
	  Up/Down	"" line		(16 bytes)
	PgUp/PgDn	"" 16 lines	(256 bytes)
	Home/End	move to start/end
	   F1		prompt for Address			may be preceeded by:	'%'binary
	   F2		find Text											'@'octal
	   F3		find Bytes											'.'decimal
			when entering:	F7	toggle Case sensitivity
							F8	show		""
							F9	cancel
							F10	exit/save
	   F4		repeat ""								[default]	'$'hex
			  Number base will remain in effect until a new one is selected.
	  Space		toggle unprintable character display to/from SPACE
	   ESC		Quit
*/
	case _KLA:	--ll;		goto a3;
	case _KUA:	ll -= 16;	goto a3;
	case _KPU:	ll -= 256;
a3:		if(ll > i) {
			if(--lh == 0xFFFF)
				goto ho; }
		goto a5;
	case _KRA:	++ll;		goto a4;
	case _KDA:	ll += 16;	goto a4;
	case _KPD:	ll += 256;
a4:		if(ll < i)
			++lh;
a4a:	if(lh > MaxH)	goto en;
		if(lh < MaxH)	goto a5;
		if(ll >= MaxL)	goto en;
a5:		Loc[1] = lh;
		*Loc = ll;
		goto a1;
	case _KHO:
	case _CPU:
ho:		lh = ll = 0;
		goto a5;
	case _KEN:
	case _CPD:
en:		lh = MaxH;
		ll = MaxL;
		goto a5;
	case _K1:
		Prompt("Addr? ");
		Iflg = 7;
		i = GetVS(Ptr = Temp, 32);
		Prompt("");
		if(!i)
			goto a2;
		lh = 0;
		if(Value(&lh, &ll))
			goto a2;
		goto a4a;
	case _K2:	Iflg = 0;	goto a6;
	case _K3:	Iflg = 7; Sflg = 0;
a6:		Prompt(Iflg ? "FindByte? " : "FindText? ");
		Slen = GetVS(Ptr = Stext, 65);
		if(Sflg & S_UC) strupr(Stext);
		memcpy(Sbyte, Stext, Slen);
		if(Iflg) {
			Ptr = Stext;
			Slen = 0;
			while(Skip()) {
				if(Value(0, &i))
					goto a0;
				Sbyte[Slen++] = i; } }
		Sh = Loc[1];
		Sl = *Loc;
a7:		if(Slen) {
			if(!Search()) {
				Error("?Nf'%s'", Stext);
				Vputc('\''); } }
		Vclscr();
		goto a0;
	case _K4:
		++Sl;
		if(!Sl) ++Sh;
		goto a7;
	case ' ':
		if(UPc == UPcS) {
			UPc = ' ';
			goto a0; }
		UPc = UPcS;
		goto a0;
	case '?':
		Vclscr();
		Help(Ihelp);
		Error("Press SPACE!");
		Vclscr();
		goto a0;
	case 0x1B:	; }
	Vclose();
	fclose(fp);
}
