// FTIF
#include <stdio.h>
#include <file.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	TEXT	16
#define	POOL	16384

#define	O_VERB	0x01
#define	O_DEBUG	0x02
#define	O_CASE	0x04
#define	O_SUBD	0x08
#define	O_LINE	0x10

unsigned
	Sh, Sl, At, Ti, Da,
	Line,
	Bin = 3,
	Ttop,
	Dtop,
	Ptop;
FILE
	*fp,
	*fpw;
unsigned char
	*Ptr,
	*Text[TEXT],
	Gc,
	Opt = O_LINE|O_CASE,
	Wfile[128],
	Match[128],
	Ctra[256],
	Dir[128],
	Temp[512],
	Pool[POOL];

//ChtTxt R:\Help.H
#include "R:\\Help.H"

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}

void Pc(unsigned char c)	{	putc(c, fpw);		}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Nl(void)				{	Pc('\n');			}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}

register Printf(unsigned args)
{
	unsigned n;
	unsigned char buf[200];
	n = nargs();
	if(Opt & O_VERB) {
		_format_(n*2+&args, buf);
		fputs(buf, stdout); }
}

register Dprintf(unsigned args)
{
	unsigned n;
	unsigned char buf[200];
	n = nargs();
	if(Opt & O_DEBUG) {
		_format_(n*2+&args, buf);
		fputs(buf, stdout); }
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?PoolOverflow"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

unsigned Value(void)
{
	unsigned v, c;
	unsigned char *p;
	v = 0;
	p = Ptr;
	while((c = *Ptr - '0') < 10) {
		v = (v * 10) + c;
		++Ptr; }
	if(Ptr == p)
		Error("?Value");
	return v;
}
	
unsigned ISbin(void)
{
	unsigned i, j;
	fp = fopen(Dir, "rbvq");
	if(i = fget(Temp, sizeof(Temp), fp))
		++i;
	fclose(fp);
	j = 0;
	while(i) {
		if(!Ctra[Temp[--i]])
			++j; }
	return j;
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;


//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
//		if(toupper(*name++) != c)
		if(*name++ != c)
			return 0; }
}

void DoDir(void)
{
	unsigned i, dt, pt;
	pt = Ptop;
	dt = Dtop;
	while(Dir[Dtop]) ++Dtop;
	if(Dir[Dtop-1] != '\\')
		Dir[Dtop++] = '\\';
	strcpy(Dir+Dtop, "*.*");
	Dprintf("D'%s'", Dir);

	if(find_first(Dir, 0x3F, Temp, &Sh, &Sl, &At, &Ti, &Da)) {
		Dprintf("?nf\n");
		goto ex; }
	Dprintf("\n");
	do {
		if(At &= (DIRECTORY|VOLUME|HIDDEN|SYSTEM)) {
			if((At == DIRECTORY) && (*Temp != '.'))
				Pstring(Temp);
			continue; }
		if(!Fmatch(Temp, Match))
			continue;
		strcpy(Dir+Dtop, Temp);
		if((i=ISbin()) >= Bin) {
			Dprintf("B'%s'%u\n", Dir, i);
			continue; }
		Line = Gc = 0;
		fp = fopen(Dir, "rvq");
		Dprintf("[%u]", i);
		Printf("Scan %s\n", Dir);
		while(fgets(Temp, sizeof(Temp)-1, fp)) {
			++Line;
			if(Opt & O_CASE)
				strupr(Temp);
			Ptr = Temp-1;
			while(*++Ptr) {
				i = 0;
				do {
					if(strbeg(Ptr, Text[i]))
						goto a1; }
				while(++i < Ttop); }
			continue;
a1:			if(!Gc) {
				Ps(Dir);
				Nl();
				Gc = 7; }
			if(Opt & O_LINE)
				Pr("%u\t", Line);
			Ps(Temp);
			Nl(); }
		fclose(fp);
	} while !find_next(Temp, &Sh, &Sl, &At, &Ti, &Da);

	if(Opt & O_SUBD) {
		i = pt;
		while(i < Ptop) {
			strcpy(Dir+Dtop, Pool+i);
			while(Pool[i++]);
			DoDir(); } }

ex:	Dtop = dt;
	Ptop = pt;
}
//ChtArg -E@
/*ChtTxt Shelp
Some operating systems disallow certain characters in program arguments
- FTIF accepts the following character substituions in strings:
	~~	~		single
	~(	<		less
	~)	>		greater
	~C	:		Colon
	~'	"		double quote
	~F	/		Forward slash
	~B	\		Backslash
	~V	|		Vertical bar (pipe)
	~Q	?		Question mark
	~S	*		Star
*/
void GetStr(void)
{
	unsigned i;
	unsigned char *p, c;
	static unsigned char
		Xchar1[] = { '~','(',')','C','\'','F','B' ,'V','Q','S' },
		Xchar2[] = { '~','<','>',':','"' ,'/','\\','|','?','*' };
	p = Temp;
	while(c = *Ptr) {
		if(c == '~') {
			c = toupper(*++Ptr);
			for(i=0; i < sizeof(Xchar1); ++i) {
				if(Xchar1[i] == c) {
					c = Xchar2[i];
					goto a1; } }
			Error("?Unknown~%c", c); }
a1:		*p++ = c;
		++Ptr; }
	*p = 0;
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;

	fpw = stdout;
	*Match = '*';
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:					goto he;
			case '?':	Ptr = Shelp;	goto he1;
			case 'B':
				Bin = Value();
				break;
			case 'M':
				strcpy(Match, Ptr);
				strupr(Match);
				continue;
			case 'W':
				strcpy(Wfile, Ptr);
				continue;
/*ChtTxt Mhelp
FindTextInFiles

use:	FTIF	[strings...] [options]

opts:	-C			Case sensitive
		-Bn			set Binary threshold								[3]	*1
		-D			Debug messages
		-L			no Line numbers
		-Mpattern	filenames must Match								[*]
		-S			recurse into Subdirs
		-V			Verbose													*2
		-Wfile		Write output to file					(otherwise stdout)
		-?			"string" help

Scans all non-binary files in the current directory for the text strings.

*1	File is determined to be "binary" of the number of non-printable characters
	in the first 512 bytes is >= -B
*2	-V is reversed if -W
*/
			case 'C':	c = O_CASE;	goto o2;
			case 'D':	c = O_DEBUG;	goto o2;
			case 'L':	c = O_LINE;		goto o2;
			case 'S':	c = O_SUBD;		goto o2;
			case 'V':	c = O_VERB;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		if(Ttop >= TEXT)
			goto he;
		GetStr();
		Text[Ttop++] = Pstring(Temp); }
	if(!Ttop) {
he:		Ptr = Mhelp;
he1:	while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					Pc(' ');
				continue; }
			Pc(c); }
		return; }

	for(i = 0x20; i < 0x7F; ++i)
		Ctra[i] = i;
	Ptr = "\n\r\t\b";
	while(c = *Ptr++)
		Ctra[c] = c;

	if(Opt & O_CASE) {
		i = 'a'-1;
		while(++i <= 'z')
			Ctra[i] = i-('a'-'A');
		i = 0;
		while(i < Ttop)
			strupr(Text[i++]); }

#if 0
	for(i=0; i < 256; ++i) {
		if(!(i & 15)) {
			if(i) Nl();
			printf("%02x  ", i); }
		if(c = Ctra[i]) {
			if(c < 0x21)
				c = 0xA8; }
		else
			c = ' ';
		printf("%02x%c", i, c); }
	printf(" %u\n", Bin);
	return;
#endif
	strcpy(Dir, "::\\");
	*Dir = get_drive() + 'A';
	getdir(Dir+3);

	if(*Wfile) {
		fpw = fopen(Wfile, "wvq");
		Opt ^= O_VERB; }
	DoDir();
	if(*Wfile)	fclose(fpw);
	fpw = stdout;
		
}
