// FRF
#include <stdio.h>
#include <file.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	MemTst(a)

#define	DTE	1	// Earlier
#define	DTL	2	// Later

#define	FILES	1024
#define	POOL	16384

#define	O_LATE	0x01
#define	O_PATH	0x02
#define	O_REV	0x04
#define	O_VERB	0x08

unsigned
	Seg,					// Storage size/name
	DTe=DTE, DTl=DTL,		// DateTime Earlier/Later
	Files,					// #files to show
	Fsize,					// Seg space for each file
	Sh, Sl, At, Ti, Da,		// find...
	SubDirs = -1,			// -Sn levels
	Dlevel,					// Directory LEvel
	Da1, Ti1, DTp,			// Working Date/Time/Position
	Ftop,					// Top of file list
	Dtop, Dbase,			// "" directory name entry
	Ptop,					// String pool
	Fti[FILES], Fda[FILES],	// File times/dates
	Foff[FILES];			// "" seg offset
FILE
	*fpo;
unsigned char
	*Ptr,
	Opt,					// Command line options
	Home[128],				// Home directory
	Temp[128],				// Temp string
	Wfile[128],				// -Wfile
	Pattern[128],			// File match pattern
	Dir[256],				// Current directory/file
	Pool[POOL];				// String pool

unsigned L10[] = { 10, 0 };
extern unsigned Longreg[];

#include "R:\\Help.H"

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

void GoHome(void)
{
	set_drive(*Home - 'A');
	cd(Home);
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	GoHome();
	exit(-1);
}

void Pc(unsigned char c)	{	putc(c, fpo);		}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Nl(void)				{	Pc('\n');			}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

void ShowLN(unsigned h, unsigned l)
{
	unsigned i, lv[2];
	unsigned char buf[13];
	buf[i = sizeof(buf)-1] = 0;
	lv[1] = h;
	*lv = l;
	do {
		longdiv(lv, L10);
		buf[--i] = *Longreg + '0'; }
	while longtst(lv);
	while(i) buf[--i] = ' ';
	Ps(buf);
}

void ShowDT(unsigned da, unsigned ti)
{
	Pr("%04u-%02u-%02u", (da>>9)+1980,	(da>>5)&15,		da&31);
	Pr(" %3u:%02u:%02u", ti>>11, 		(ti>>5)&63,		(ti&31)*2);
}

void SegPS(unsigned o, unsigned char *p)
{
	unsigned i;
	i = o = Foff[o];
	pokew(Seg, o, Sl);
	pokew(Seg, o+2, Sh);
	o += 3;
	do {
		poke(Seg, ++o, *p); }
	while(*p++);
	if((o-i) >= Fsize)
		Error("?NameOver - reduce -n");
}

void SegGS(unsigned o, unsigned char *p)
{
	o = Foff[o];
	Sl = peekw(Seg, o);
	Sh = peekw(Seg, o+2);
	o += 3;
	while(*p++ = peek(Seg, ++o));
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
#ifdef _DVM_
		if(toupper(*name++) != c)
#else
		if(*name++ != c)
#endif
			return 0; }
}

unsigned CmpDT(unsigned d1, unsigned t1, unsigned d2, unsigned t2)
{
	if(d1 < d2) goto re;
	if(d1 > d2) goto rl;
	if(t1 < t2) {
re:		return DTE; }
	if(t1 > t2) {
rl:		return DTL; }
	return 0;
}

void DoDir(void)
{
	unsigned i, dt, pt;
	pt = Ptop;
	dt = Dtop;
	while(Dir[Dtop]) ++Dtop;
	if(Dir[Dtop-1] != '\\')
		Dir[Dtop++] = '\\';
	if((Opt & O_PATH) && !Dbase)
		Dbase = Dtop;
	strcpy(Dir+Dtop, "*.*");
	if(Opt & O_VERB)
		printf("%s\n", Dir);
	if(find_first(Dir, 0x3F, Temp, &Sh, &Sl, &At, &Ti, &Da))
		goto ex;
	do {
		if(At &= (DIRECTORY|VOLUME|HIDDEN|SYSTEM)) {
			if((At == DIRECTORY) && (*Temp != '.'))
				Pstring(Temp);
			continue; }
		if(Fmatch(Temp, Pattern)) {
			strcpy(Dir+Dtop, Temp);
			Debug(("F'%s'\n", Dir))
			if(Ftop < Files) {
				DTp = Ftop++;
//				ShowDT(Da, Ti); printf(" %u\n", DTp);
				Foff[DTp] = DTp * Fsize;
				goto a1; }
			Da1 = Da; Ti1 = Ti;
			DTp = -1;
			for(i = 0; i < Ftop; ++i) {
				if(CmpDT(Da1, Ti1, Fda[i], Fti[i]) == DTl) {
					Da1 = Fda[DTp = i];
					Ti1 = Fti[i]; } }
			if(DTp != -1) {
//				ShowDT(Da,Ti);Pc(' ');ShowDT(Fda[DTp],Fti[DTp]);printf(" %u\n",DTp);
a1:				Fda[DTp] = Da;
				Fti[DTp] = Ti;
				SegPS(DTp, Dir+Dbase); } }
	} while !find_next(Temp, &Sh, &Sl, &At, &Ti, &Da);
	if(++Dlevel <= SubDirs) {
		i = pt;
		while(i < Ptop) {
			strcpy(Dir+Dtop, Pool+i);
			while(Pool[i++]);
			DoDir(); } }
	--Dlevel;
ex:	if(kbtst() == 0x1B)
		Error("?Abort");
	Dtop = dt;
	Ptop = pt;
}

// Divide 64k using 16 bit math
unsigned D64(unsigned n)
{
	unsigned i,  r;
	i = (r = 65535/n) * n;
	do {
		++r;
		if(!(i += n))
			return r; }
	while(i > n);
	return r-1;
}

unsigned Value(void)
{
	unsigned c, v;
	unsigned char *p;
	v = 0;
	p = Ptr;
	while((c = *Ptr - '0') < 10) {
		v = (v*10) + c;
		++Ptr; }
	if((Ptr == p) || *Ptr)
		Error("?Value");
	return v;
}

// Resolve directory and match pattern
void ResolveName(void)
{
	unsigned i, j, k;
	strcpy(Dir, Ptr);
	strcpy(Pattern, "*");
	Dtop = Dbase = i = j = k = 0;
a1:	switch(Dir[i++]) {
	case ':':
	case'\\':
		if(k)
			Error("?* in dir!");
		j = i;
		goto a1;
	case '*':
	case '?':	k = i;
	default	:	goto a1;
	case 0	:	; }
	if(k) {		// Pattern supplied
		strcpy(Pattern, Dir+j);
		strupr(Pattern);
		switch(k = j) {
		case 0	:
			strcpy(Dir, Home);
		case 3 :
			if(Dir[k-2] == ':')
				goto a2;
		default:
			--k;
		case 2 :
		case 1 :
a2:			Dir[k] = 0; } }
	if(Dir[1] == ':') {
		set_drive(j = toupper(*Dir)-'A');
		if(get_drive() != j)
			goto e1; }
		if(cd(Dir)) {
e1:			Error("?%s\n", Dir); }
	strcpy(Dir, "::\\");
	*Dir = get_drive() + 'A';
	getdir(Dir+3);
	GoHome();
	Debug(("R'%s'%s'\n", Dir, Pattern))
}

main(int argc, char *argv[])
{
	unsigned i, j, k;
	unsigned char c;

	MemTst(7);
	fpo = stdout;
	strcpy(Home, "::\\");
	*Home = get_drive()+'A';
	getdir(Home+3);

	i = k = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(c = toupper(*Ptr++)) {
			default	:
				if((c >= '0') && (c <= '9')) {
					--Ptr;
					Files = Value();
					continue; }
he:				Ptr = Help;
				while(c = *Ptr++) {
					if(c & 0x80) {
						while(c-- & 0x7F)
							putc(' ', stdout);
						continue; }
					putc(c, stdout); }
				return;
/*ChtTxt R:\\Help.H
FindRecentFiles

use:	FRF filespec[...] [options]

opts:	-E		show Earliest changed								[latest]
		-P		show only relative Path
		-R		Reverse list order
		-Sn		do not scan deeper than n Subdirectories
		-V		Verbose (show progress)
		-Wfile	Write list to file									[stdout]
		-n		set Nunber to show (1-1024)								[20]

FRF finds and shows a list of the most recent files in a directory/tree.

filespec may contain wildcards  *?  to show only matching files.
  like UNIX:	*.*  shown only files with '.'		use  *  for all!

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'S':
				SubDirs = Value();
				continue;
			case 'W':
				if(*Wfile) goto he;
				strcpy(Wfile, Ptr);
				continue;
			case 'E':	c = O_LATE;	goto o2;
			case 'P':	c = O_PATH;	goto o2;
			case 'R':	c = O_REV;	goto o2;
			case 'V':	c = O_VERB;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		k = 7; }
	if(!k) goto he;

	if(!Files) Files = 20;
	if(Files > FILES) goto he;
	Fsize = D64(Files);
	if(Opt & O_LATE) {
		DTe = DTL;
		DTl = DTE; }

	Seg = alloc_seg(4096);

	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-')
			continue;
		ResolveName();
		DoDir(); }

	if(Opt & O_REV)
		DTl= DTe;

	for(i=0; i < Ftop; ++i) {
		Da = Fda[i];
		Ti = Fti[i];
		k = -1;
		for(j=i+1; j < Ftop; ++j) {
			if(CmpDT(Da, Ti, Fda[j], Fti[j]) == DTl) {
				Da = Fda[k = j];
				Ti = Fti[j]; } }
		if(k != -1) {
			Fda[k] = Fda[i];
			Fti[k] = Fti[i];
			Fda[i] = Da;
			Fti[i] = Ti;
			Da = Foff[k];
			Foff[k] = Foff[i];
			Foff[i] = Da; } }

	if(*Wfile)
		fpo = fopen(Wfile, "wvq");
	for(i=0; i < Ftop; ++i) {
		SegGS(i, Dir);
		ShowDT(Fda[i], Fti[i]);
		ShowLN(Sh, Sl);
		Pc(' ');
		Ps(Dir);
		Nl(); }
	if(*Wfile)
		fclose(fpo);

	MemTst(0);
}
