// File Explorer
#include <stdio.h>
#include <dvmvideo.h>
#include <file.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	//printf a;
#define	Debug2(a)	printf a;
#define MemTst(a)

#define	POOL	32768
#define	FILES	1024

#define	LINES	24
#define	VNOR	0x17
#define	VNOR1	0x13
#define	VHIL	0x71
#define	VHIL1	0x31

#define	O_BEFOR	0x01
#define	O_AFTER	0x02

#define	IFILE		"FEXP.INI"

unsigned
	Vtop,
	Vpos,
	Vsel,
	Vsel1,
	Sh, Sl, At, Ti, Da,
	Fsh[FILES], Fsl[FILES], Fti[FILES], Fda[FILES],
	Dtop,
	Ptop,
	Pend = POOL,
	Pend1;
FILE
	*fp;
unsigned char
	*Ptr,
	*Ptr1,
	*Fname[FILES],
	Esc = '~',
	Opt,
	Vmode,
	Files,
	Dirs,
	Temp[256],
	Pattern[64],
	Dir[128],
	Home[1],
	Dir1[128],
	Pool[POOL];

unsigned
	L10[] = { 10, 0 };
extern unsigned Longreg[];

//ChtTxt R:\\Help.H
#include "R:\\Help.h"

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

void GoHome(void)
{
	if(*Home) {
		set_drive(*Home - 'A');
		cd(Home); }
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
	if(Vmode) Vclose();
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	GoHome();
	MemTst(0);
	exit(-1);
}

void Pc(unsigned char c)
{
	if(Vmode)
		Vputc(c);
	else
		putc(c, stdout);
}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++); }
void Nl(void)				{	Pc('\n');			}

void Help(unsigned char *p)
{
	unsigned char c;
	while(c = *p++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				Pc(' ');
			continue; }
		Pc(c); }
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= Pend)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}
unsigned char *PEstring(unsigned char *p)
{
	if((Pend -= (strlen(p)+1)) < Ptop)
		Error("?Punder[%u %u]", Pend, Ptop);
	strcpy(Pool+Pend, p);
	return Pool+Pend;
}

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

//Trim spaces from string
unsigned Trim(void)
{
	unsigned i;
	i = 0;
	while(Ptr[i])					++i;
	while(i && isspace(Ptr[i-1]))	--i;
	Ptr[i] = 0;
	return i;
}

void ShowLN(unsigned h, unsigned l)
{
	unsigned i, lv[2];
	unsigned char buf[13];
	buf[i = sizeof(buf)-1] = 0;
	lv[1] = h;
	*lv = l;
	do {
		longdiv(lv, L10);
		buf[--i] = *Longreg + '0'; }
	while longtst(lv);
	while(i) buf[--i] = ' ';
	Vputs(buf);
}

void ShowDT(unsigned da, unsigned ti)
{
	Vprintf("%04u-%02u-%02u", (da>>9)+1980,	(da>>5)&15,		da&31);
	Vprintf(" %3u:%02u:%02u", ti>>11, 		(ti>>5)&63,		(ti&31)*2);
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
		if(toupper(*name++) != c)
			return 0; }
}

void DoDir(void)
{
	unsigned i, dt;
	Ptop = Files = Dirs = 0;
	Pend = Pend1;
	Dtop = dt = strlen(Dir);
	if(Dir[Dtop-1] != '\\')
		Dir[dt++] = '\\';
	strcpy(Dir+dt, "*.*");
	Debug1(("DoDir'%s'", Dir))

	i = find_first(Dir, 0x3F, Temp, &Sh, &Sl, &At, &Ti, &Da);
	strcpy(Dir+dt, Pattern);
	if(i) {
		Debug1(("?nf\n"))
		goto ex; }
	Debug1(("\n"))
	do {
		if(At &= (DIRECTORY|VOLUME|HIDDEN|SYSTEM)) {
			if((At == DIRECTORY) && (*Temp != '.')) {
				Debug1(("D'%s'\n", Temp))
				Pstring(Temp);
				++Dirs; }
			continue; }
		Debug1(("F'%s'\n", Temp))
		if(*Pattern) {
			if(!Fmatch(Temp, Pattern))
				continue; }
		Fname[Files]	= PEstring(Temp);
		Fsh[Files]		= Sh;
		Fsl[Files]		= Sl;
		Fti[Files]		= Ti;
		Fda[Files++]	= Da;
	} while !find_next(Temp, &Sh, &Sl, &At, &Ti, &Da);
ex:	Debug1(("F=%u D=%u E=%u\n", Files, Dirs, Pend))
}

unsigned Gfile(unsigned i)
{
	if(i < Files) {
		Sh = Fsh[i];
		Sl = Fsl[i];
		Ti = Fti[i];
		Da = Fda[i];
		strcpy(Temp, Fname[i]);
		return At = 1; }
	i -= Files;
	At = 0;
	for(;;) {
		if(At >= Ptop)
			return At = 0;
		if(!i--)
			break;
		while(Pool[At++]); }
	Sh = Sl = Ti = Da = 0;
	strcpy(Temp, Pool+At);
	return At = 2;
}

void Color(unsigned char c)
{
	if(Vmode != c)
		Vcolor(Vmode = c);
}

unsigned Ktst(unsigned char *p)
{
	unsigned i;
	unsigned char c, d;
	i = 0;
	while(p[i++] != ':');
	Ps(p+i);
a1:	if((c = toupper(kbget())) == 0x1B)
		Error("?Abort");
	i = 0;
	for(;;) {
		if( (d = p[i++]) == ':')
			goto a1;
		if(d == c) {
			Pc(d);
			Nl();
			return i; } }
}

void AP1(unsigned char *p)
{
	strcpy(Ptr1, p);
	while(*Ptr1) ++Ptr1;
}
//ChtArg -E`
void Encode(void)
{
	unsigned i;
	unsigned char c, d, buf[200];;
	i = 0;
	while(c = *Ptr++) {
		if(c == Esc) {
			d = 0;
			switch(c = *Ptr) {
#define	FESC	0xF7
			case 'O':	--d;	//F7
			case 'E':	--d;	//F8
			case 'S':	--d;	//F9
			case '1':	--d;	//FA
			case '2':	--d;	//FB
			case 'A':	--d;	//FC
			case 'B':	--d;	//FD
			case 'C':	--d;	//FE
			case 'D':	--d;	//FF
				c = d;
				break;
			case 0	:	c = Esc;	goto a1;	//Trailing
			case '(':	c = '<';	break;
			case ')':	c = '>';	break;
			case '!':	c = '|';	break;
			case'\'':	c = '"';	break;
			case '_':	c = ' ';	}
			++Ptr; }
/*ChtTxt Ehelp
-+,-- Command definitions:
  First character is activation key, rest are command text, which may include:
	~O		mark boundary between command and Operands
		DOS: command will be performed by: system()
		DVM: 			""				 : exec() - launches another .DVM
	~E		"" always perform: exec()	 		faster, uses less memory
	~S		""		""		 : system()			allows full operands
	~1		insert file1 name	(at selection bar)
	~2			"" file2 ""		(selected with SPACE)
			++Ptr; }
	~A		always pause (to see results) After comnand run
	~B			 ""		 (to confirm) Before command runs
	~C		never pause After
	~D		""		""	Before
	~( ='<'		~) ='>'		~! ='|'		\ No "special" meaning, These chars
	~' ='"'		~_ =' '					/ are hard to enter on command line
	~'anything else'	='anything else'				 (use ~~ for one ~)
(Assuming -E~  - you can change).  If no --, assumes:
		Tfvt~O~1								Cfct~O~1 ~2
		Bfvb~O~1								Kfcb~O~1 ~2
		Ddel~S~1~B
*/
a1:		buf[i++] = c; }
	buf[i] = 0;
#if 0
	i = 0;
	while(c = buf[i++]) {
		if(c & 0x80)
			printf("[%x]", c);
		else
			Pc(c); }
	Nl();
	exit(0);
#endif
	PEstring(buf);
}

unsigned char *DefCmds[] = {
	"TFVT\xF7\xFA",			//"TFVT~=~1"
	"BFVB\xF7\xFA",			//"BFVB~=~1"
	"CFCT\xF7\xFA \xFB",	//"CFCT~=~1~ ~2"
	"KFCB\xF7\xFA \xFB",	//"KFCB~=~1 ~2"
	"DDEL\xF9\xFA\xFD",
	0 };
unsigned Exec(unsigned char *p, unsigned char *o1, unsigned char *o2, unsigned g)
{
	unsigned char *ep, c, e, o;

	Ptr1 = Temp;
	ep = e = 0;
	o = Opt;
a1:	switch(c = *p++) {
	case FESC+0:
	case FESC+1:
	case FESC+2:
		e = c;
		ep = Ptr1;
		c = ' ';
	default	:
		*Ptr1++ = c;
		goto a1;
	case FESC+3:
		if(!*o1) return 1;
		AP1(o1);
		goto a1;
	case FESC+4:
		if(!*o2) return 2;
		AP1(o2);
		goto a1;
	case FESC+5:	o |= O_AFTER;	goto a1;
	case FESC+6:	o |= O_BEFOR;	goto a1;
	case FESC+7:	o &= ~O_AFTER;	goto a1;
	case FESC+8:	o &= ~O_BEFOR;	goto a1;
	case 0	:	*Ptr1 = 0; }

	if(g) {
		Vclose();
		Vmode = 0;
		if(o & O_BEFOR) {
			Ps("> ");
			Ps(Temp);
			if(Ktst("YN: Y/N?") != 1)
				goto rz;
			Nl(); }
		switch(e) {
#ifdef _DVM_
		case FESC+0:
#endif
		case FESC+1:	// EXEC
			*ep = 0;
			exec(Temp, ep+1);
			break;
#ifndef _DVM_
		case FESC+0:
#endif
		case FESC+2:
			system(Temp); }
		if(o & O_AFTER)
			Ktst(" :Press SPACE"); }
rz:	return 0;
}

// Resolve search directory and pattern
void Resolve(void)
{
	unsigned i, j, k;

	strcpy(Home, "::\\");
	getdir(Home+3);
	*Home = get_drive() + 'A';
	Debug1(("H'%s'\n", Home))

	if(*Dir) {
		i = j = 0;
		k = (Dir[1] == ':') && 3;
a1:		switch(Dir[i++]) {
		case ':':
		case'\\':	j = i;
		default	:	goto a1;
		case '?':
		case '*':
			strcpy(Pattern, Dir+j);
			strupr(Pattern);
			if(j > k) --j;
			Dir[j] = 0;
//			Error("D'%s'%s'\n", Dir, Pattern);
			if(!j)
				goto a3; }
		if(k) {
			set_drive(i = toupper(*Dir) - 'A');
			if(get_drive() != i)
				goto a2; }
		if(cd(Dir)) {
a2:			Error("?dir'%s'\n", Dir); }
		strcpy(Dir, "::\\");
		getdir(Dir+3);
		*Dir = get_drive()+'A';
		GoHome();
		goto ex; }
a3:	strcpy(Dir, Home);
ex:	*Home = 0;
}

void Arg(unsigned x)
{
	unsigned char c;
	Debug(("A'%s'\n", Ptr))
	if(*Ptr == '-') {
		++Ptr;
a1:		c = toupper(*Ptr++);
		if(x) switch(c) {
			case '=':
				strcpy(Temp, Ptr);
				return;
		} switch(c) {
		case '?':	c = 0;
a2:			switch(toupper(*Ptr++)) {
			default	:	goto he;
			case '+':	c |= 2;		goto a2;
			case 'I':	c |= 4;		goto a2;
			case '?':	c = 255;
			case 0	:	if(c)		goto he1; }
		default	:
he:			c = 1;
he1:		if(c & 1) Help(Mhelp);
			if(c & 2) Help(Ehelp);
			if(c & 4) Help(Ihelp);
			exit();
/*ChtTxt Mhelp
File Explorer

use:	FEXP [directory][pattern] [options]

opts:	-A			After prompt on all commands
		-B			Before ""
		-=file		more command Options from file							*1
		-+cmd..		add Command							\ see:
		--[cmd..]	clear (predefined) and ""			/	-?+
		-?n..			show help sectioNs..
			+			-+,-- definitions
			I			Interactive keys
			?			all help

*1 if no -=, FEXP looke for:		FEXP.INI	and then	%DDCDATA%\FEXP.INI

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
		case '-':	Pend = POOL;
		case '+':	// Comand
			*Ptr = toupper(*Ptr);
			Encode();
			return;
		case 'B':	c = O_BEFOR;	goto a3;
		case 'A':	c = O_AFTER;
a3:			Opt |= c; }
		if(*Ptr) goto a1;
		return; }
	if(*Dir) goto he;
	strcpy(Dir, Ptr);
}

main(int argc, char *argv[])
{
	unsigned i, j, k;

	MemTst(7);

	i = 0;
	while(Ptr = DefCmds[i++])
		PEstring(Ptr);

	i = 0;
	while(++i < argc) {
		Ptr = argv[i];
		Arg(7); }

	if(*Temp) {
		fp = fopen(Temp, "rvq");
		goto a1; }
	else {
		if(fp = fopen(IFILE, "r"))
			goto a1;
		if(getenv("DDCDATA", Dir1)) {
			if((i = strlen(Dir1)) && (Dir1[i-1] != '\\'))
				Dir1[i++] = '\\';
			strcpy(Dir1+i, IFILE);
			if(fp = fopen(Dir1, "r")) {
a1:				while(fgets(Ptr = Temp, sizeof(Temp)-1, fp)) {
					switch(Skip()) {
					case ';':
					case 0	:	continue; }
					Trim();
					Arg(0); }
				fclose(fp); } } }

	Pend1 = Pend;

	Resolve();

rd:	DoDir();
	Vtop = Files+Dirs;
	if(!Vmode)
		Vopen(Vmode = VNOR);
	Vsel = *Dir1 = 0;
	Vsel1 = -1;
a2:	Vgotoxy(0, 0);
	Vcleol();
	Vgotoxy((80-Dtop)/2, 0);
	Vputs(Dir);
a3:	if(Vsel > 0xFF00)	Vsel = 0;
	if(Vsel > Vtop)		Vsel = Vtop;
	if(Vsel < Vpos)		Vpos = Vsel;
	while((Vpos + LINES) <= Vsel)
		++Vpos;
//Vgotoxy(0, 0); Vprintf("[%u %u %u", Vsel, Vpos, Vtop);
	i = 0;
	while(i < LINES) {
		j = Vpos + i;
		Vgotoxy(0, ++i);
		if(j == Vsel)
			Color((j == Vsel1) ? VHIL1 : VHIL);
		else if(j == Vsel1)
			Color(VNOR1);
		if(j >= Vtop) {
			Vputs("[^^^]");
a4:			Color(VNOR);
			Vcleos();
			break; }
		if(!Gfile(j)) {
			goto a4; }
		k = Dtop-1;
		if(j == Vsel1) {
			strcpy(Dir1, Dir);
			if(Dir1[k] != '\\')
				Dir1[++k] = '\\';
			strcpy(Dir1+k+1, Temp); }
		if(j == Vsel) {
			if(Dir[k] != '\\')
				Dir[++k] = '\\';
			strcpy(Dir+k+1, Temp); }
		if(At == 1) {
			ShowDT(Da, Ti);
			ShowLN(Sh, Sl); }
		else
			Vprintf("%8s", "");
		Vputs("  ");
		Vputs(Temp);
		if(At == 2)
			Vputc('\\');
		Vcleol();
		Color(VNOR); }

a5:		switch(i = Vgetc()) {
		default	:
			k = toupper(i);
			i = Pend1;
			while(i < POOL) {
				if(Pool[i] == k) {
					if(Exec(Pool+i+1, Dir, Dir1, 7))
						goto a5;
					Dir[Dtop] = 0;
					goto rd; }
				while(Pool[i++]); }
			goto a5;
/*ChtTxt Ihelp
Interactive Keys:
	   `^/`v			move	1	  item
	PgUp/PgDn		""		24	  ""s
	Home/End		"" first/last ""
	  Enter			go to directory
	  Space			mark as {F2}
	   Esc			Exit
	  [^^^]			go up level
*/
		case _KUA:	i = 1;
a6:			Vsel -= i;
			goto a3;
		case _KDA:	i = 1;
a7:			Vsel += i;
			goto a3;
		case _KPU:	i = LINES;		goto a6;
		case _KPD:	i = LINES;		goto a7;
		case _KHO:	Vsel = 0;		goto a3;
		case _KEN:	Vsel = Vtop;	goto a3;
		case ' ' :	Vsel1 = Vsel;	goto a3;
		case '\n':
		case '\r':
			if(Vsel < Files)
				goto a2;
			if(Vsel < Vtop)
				goto rd;
			i = Dtop;
			while(i) {
				if(Dir[--i] == '\\') {
					Dir[Dtop = i] = 0;
					goto rd; } }
			goto a5;
		case '?'	:
			Vclscr();
			Help(Ihelp);
#if 0
			i = Pend1;
			while(i < POOL) {
				Vprintf("%7s'", "");
				Vputc(Pool[i]);
				Vprintf("'%10s", "");
				Exec(Pool+i+1, "{F1}", "{F2}", 0);
				Vputs(Temp);
				Vputc('\n');
				while(Pool[i++]); }
#else
			i = POOL-1;
			while(i > Pend1) {
				do { --i; } while Pool[i];
				Vprintf("%7s'", "");
				Vputc(Pool[i+1]);
				Vprintf("'%10s", "");
				Exec(Pool+i+2, "{F1}", "{F2}", 0);
				Vputs(Temp);
				Vputc('\n'); }
#endif
			Vgetk();
			Dir[Dtop] = 0;
			goto rd;
		case 0x1B	:
			Vclose(); }

	Debug1(("='%s'\n", Dir))
	MemTst(0);
}
