// FCT
#include <stdio.h>
#include <dvmvideo.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	MemTst(a)

#define	VNOR1	0x17
#define	VNOR2	0x47
#define	VHIL1	0x71
#define	VHIL2	0x74
#define	VSPEC	0x30

#define	LINES	24
#define	LINES2	12
#define	SLINE	256
#define	FMAXP	39

#define	VSPC	0xB1	// Viewable SPACE
#define	VTAB	0xB0	// "" TAB

unsigned
	Fo1, Fo2,			// Offset to Filename
	Tab = 4,			// Tab width
	Key,				// Last key entered
	Offset1,			// Horz display offset
	Offset2,			// Horz display offset
	Lines=24,
	SAVcol,				// Active color
	Dpre, Dsuf,			// Difference Prefix,Suffix
	Ds1, De1, Ds2, De2,	// Difference Start,End
	Top1,				// Top of file1
	Line1,				// Current line
	Index1[256][2],		// Indexes for file1
	Top2,				// Top of file2
	Line2,				// Current line
	Index2[256][2];		// Indexes for file2
FILE
	*fp,
	*fp1,
	*fp2,
	*fpw;
unsigned char
	*Ptr,
	Opt,
	Sch = ' ',			// Display for SPACE
	Tch = ' ',			// "" TAB
	Lsel = 3,
	Diff,
	Bmode, LBmode,
	F1[128],
	F2[128],
	Fw[128],
	Temp[256],
	Buff1[LINES][SLINE],
	Buff2[LINES][SLINE];

#define	O_SPC	0x01
#define	O_TSPC	0x02
#define	O_LSPC	0x04
#define	O_CASE	0x08
#define	O_LNUM	0x10
unsigned char Otxt[] = "---NCLTS";

//ChtTxt R:\Help.h
#include "R:\\Help.h"

#define	ISneg(a)	(a&0xFC00)==0xFC00

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

void Pc(unsigned char c)
{
	if(SAVcol) {
		Vputc(c);
		return; }
	putc(c, stdout);
}

void help(unsigned char *p)
{
	unsigned char c;
	while(c = *p++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				Pc(' ');
			continue; }
		Pc(c); }
}

unsigned Index(unsigned *top)
{
	unsigned i, h, l, *id;
	i = 0;
	id = top+4;
	while(fgets(Temp,sizeof(Temp)-1, fp)) {
		++i;
		if(!(i & 0xFF)) {
			ftell(fp, &h, &l);
			Debug(("%u: %04x%04x\n", i, h, l))
			*id++ = l;
			*id++ = h; } }
	Debug(("T:%u\n", i))
	return *top = i;
}

unsigned GoTo(unsigned *index, unsigned line)
{
	unsigned i, l;
	if(!(i = line >> 8)) {
		Debug(("0: 00000000 %u\n", line))
		rewind(fp); }
	else {
		Debug(("Tp %04x %u", index, (i-1) * 4))
		index += ((i-1) * 4);
		Debug((" %04x\n", index))
		l = *index++;
		Debug(("%u: %04x%04x %u\n", i, *index, l, line&255))
		fseek(fp, *index, l, 0); }
	while(line & 255) {
		Debug(("[%u %u]", line, line & 255))
		if(!fgets(Temp, sizeof(Temp)-1, fp))
			goto ex;
		--line; }
ex:	return 0xFF;
}

void Color(unsigned c)
{
	if(c != SAVcol)
		Vcolor(SAVcol = c);
}

unsigned Vline(unsigned char *p, unsigned w, unsigned off)
{
	unsigned i, o;
	unsigned char c;
	i = o = 0;
	if(!p) {
		strcpy(Temp, "[EOF]");
		Ptr = "";
		goto a1; }
a0:	switch(c = *p++) {
	case'\t':
		do {
			Temp[o++] = Tch; }
		while(o % Tab);
		goto a0;
	case ' ':	c = Sch;
	default:
		Temp[o++] = c;
		goto a0;
	case 0	:
		Temp[o] = 0; }
	o = 0;
	while(i < off) {
		if(!Temp[i])
			goto a2;
		++i; }
a1:	while(o < w) {
		if(!(c = Temp[i++]))
			break;
		Vputc(c);
		++o; }
a2:	while(o < w) {
		Vputc(' ');
		++o; }
}

void VputF(unsigned char *p)
{
	unsigned i, l;
	unsigned char c;
	if( (i = strlen(p)) < FMAXP)
		goto e1;
	l = (FMAXP/2)-2;
	c = p[l];
	p[l] = 0;
	Vputs(p);
	p[l] = c;
	Vputs(" :: ");
	p += (i-l);
e1:	Vputs(p);
}

void Redraw(void)
{
	unsigned i, l, bt1, bt2;

	fp = fp1;
	GoTo(Index1, Line1);
	bt1 = bt2 = 0;
	while(fgets(Buff1[bt1], SLINE, fp)) {
		if(++bt1 >= Lines)
			break; }
	fp = fp2;
	GoTo(Index2, Line2);
	while(fgets(Buff2[bt2], SLINE, fp)) {
		if(++bt2 >= Lines)
			break; }

	Color(VNOR1);
	Ptr = 0;
	if(Lines & 0x10) {
		for(i = 0; i < LINES; ++i) {
			Vgotoxy(0, i);
			l = Line1 + i;
			Color( ((l < De1) && (l >= Ds1)) ? VHIL1 : VNOR1);
			if(i < bt1) {
				Vline(Buff1[i], 40, Offset1);
				continue; }
			Vline(Ptr, 40, Offset1); }

		Color(VNOR2);
		Ptr = 0;
		for(i = 0; i < LINES; ++i) {
			Vgotoxy(40, i);
			l = Line2 + i;
			Color( ((l < De2) && (l >= Ds2)) ? VHIL2 : VNOR2);
			if(i < bt2) {
				Vline(Buff2[i], 40, Offset2);
				continue; }
			Vline(Ptr, 40, Offset2); }
		return; }

	for(i=0; i < LINES2; ++i) {
		Vgotoxy(0, LINES2+i);
		l = Line1 + i;
		Color( ((l < De1) && (l >= Ds1)) ? VHIL1 : VNOR1);
		if(i < bt1) {
			Vline(Buff1[i], 80, Offset1);
			continue; }
		Vline(Ptr, 80, Offset1); }

	Color(VNOR2);
	Ptr = 0;
	for(i=0; i < LINES2; ++i) {
		Vgotoxy(0, LINES2-i-1);
		l = Line2 + i;
		Color( ((l < De2) && (l >= Ds2)) ? VHIL2 : VNOR2);
		if(i < bt2) {
			Vline(Buff2[i], 80, Offset2);
			continue; }
		Vline(Ptr, 80, Offset2); }
}

void Tspace(unsigned char *p, unsigned char *e)
{
a1:	switch(*p) {
	default	:	e = p;
	case ' ':
	case'\t':	++p;	goto a1;
	case 0	:	*e = 0; }
}

unsigned Compare(unsigned char *p1, unsigned char *p2)
{
	unsigned char c, d;
	if(Opt & O_LSPC) {
		while(isspace(*p1))
			++p1;
		while(isspace(*p2))
			++p2; }
	if(Opt & O_TSPC) {
		Tspace(p1, p1);
		Tspace(p2, p2); }
	do {
		if(isspace(c = *p1++)) {
			if(Opt & O_SPC) {
				c = ' ';
				while(isspace(*p1))
					++p1; } }
		if(isspace(d = *p2++)) {
			if(Opt & O_SPC) {
				d = ' ';
				while(isspace(*p2))
					++p2; } }
		if(Opt & O_CASE) {
			if(toupper(c) != toupper(d))
				return 255;
			continue; }
		if(c != d)
			return 255; }
	while(c);
}

unsigned Fname(unsigned char *p)
{
	unsigned i, j;
	i = j = 0;
a1:	switch(p[i++]) {
	case ':':
	case'\\':	j = i;
	default	:	goto a1;
	case 0	:	; }
	strcpy(p, p+j);
	return i-j-1;
}

void CLstat(void)
{
	Vgotoxy(0, Lines);
	Color(0x70);
	Vcleos();
}
void GetLN(void)
{
	unsigned i, c, v;
	Vcolor(VSPEC);
	SAVcol = v = 0;
a1:	Vgotoxy(40-4, LINES);
	Vprintf("%5u", v);
	switch(c = Vgetk()) {
	case '\b':
	case _KBS:
		v /= 10;
		goto a1;
	default	:
		if((c -= '0') > 9)
			goto a1;
		if( (i = (v*10) + c) <v)
			i = -1;
		v = i;
		goto a1;
	case '\n': --v;
		if(Lsel & 1)	Line1 = (v < Top1) ? v : Top1;
		if(Lsel & 2)	Line2 = (v < Top2) ? v : Top2;
	case 0x1B:	; }
	CLstat();
}

unsigned GetVal(void)
{
	unsigned v, c;
	v = 0;
	while((c = *Ptr - '0') < 10) {
		v = (v*10)+c;
		++Ptr; }
	return v && v-1;
}

void Select(void)
{
	if(Lsel & 0x01) {
		if((Line1 < Ds1) || !De1)	Ds1 = Line1;
		if((Line1+1) > De1)			De1 = Line1+1;
	}
	if(Lsel & 0x02) {
		if((Line2 < Ds2) || !De2)	Ds2 = Line2;
		if((Line2+1) > De2)			De2 = Line2+1;
	}
}

void WFs(unsigned *p)	{ fputs(p, fpw);	}
void WFnl(void)			{ putc('\n', fpw);	}
register WFpr(register args)
{
	unsigned buf[128];
	_format_(nargs()*2+&args, buf);
	WFs(buf);
}

void WriteLines(unsigned i)
{
	while(i--) {
		if(!fgets(Temp, sizeof(Temp), fp))
			break;
		WFs(Temp);
		WFnl(); }
}
void WriteDiff(void)
{
	unsigned i, j, k;
	fpw = fopen(Fw, "wavq");
	fp = fp1;
	if(i = Key - '0') {
		j = De1 ? Ds1 : Line1;
		if((k = j - i) > 65526)
			k = 0;
		WFpr("=%u %u\n", k, j-k);
	 	GoTo(Index1, k);
		WriteLines(j - k); }
	if(De1) {
		WFpr("-%u %u\n", Ds1, i = De1-Ds1);
		fp = fp1;
		GoTo(Index1, Ds1);
		WriteLines(i); }
	if(De2) {
		WFpr("+%u %u\n", De1 ? Ds1 : Line1, i = De2-Ds2);
		fp = fp2;
		GoTo(Index2, Ds2);
		WriteLines(i); }
	fclose(fpw);
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;

	MemTst(7);
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(c = toupper(*Ptr++)) {
			case '?':
				switch(*Ptr) {
				case '=':	Ptr = Dhelp;	goto he1; }
			default	:	goto he;
/*ChtTxt Mhelp
File Compare Text

use:	FCT	file1 file2 [difile] [options]

opts:	-C		ignore differences in letter Case
		-L		ignore Leading whitespace						information
		-N		show line Numbers
		-S		treat multiple whitespace as 1
		-T		ignore Trailing whitespace
		-1n		set line n	(file1)
		-2n			"" 		(file2)
		-0n			""		(both)

Intreactively compare two text files..	 find exactly where (and how) they
differ.			Differences can be written to [difile].		more info: -?=

Use '?' interactive key for help.

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case '2':	Line2 = GetVal();	break;
			case '1':
			case '0':	Line1 = GetVal();
					if(c == '0') Line2 = Line1;
					break;
			case 'C':	c = O_CASE;			goto o2;
			case 'N':	c = O_LNUM;			goto o2;
			case 'L':	c = O_LSPC;			goto o2;
			case 'S':	c = O_SPC;			goto o2;
			case 'T':	c = O_TSPC;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		if(!*F1) {
			strcpy(F1, Ptr);
			continue; }
		if(!*F2) {
			strcpy(F2, Ptr);
			continue; }
		if(*Fw)
			goto he;
		strcpy(Fw, Ptr); }
	if(!*F2) {
he:		Ptr = Mhelp;
he1:		help(Ptr);
		return; }

#if 0
		fp = fopen("R:\\TEST.TXT", "wvq");
		c = '!';
		for(i=0; i < 1000; ++i) {
			fprintf(fp, "%u: ", i);
			for(j = random(50)+1; j; --j)
				putc(c, fp);
			if(++c > '~')
				c = '!';
			fputs("\n", fp); }
		fclose(fp);
		return;
#endif

	fp1 = fp = fopen(F1, "rvq");
	Index(&Top1);
	fp2 = fp = fopen(F2, "rvq");
	Index(&Top2);
	if( (i = strlen(F1)) >= FMAXP)
		i = FMAXP-1;
	Fo1 = ((FMAXP-i)/2)+1;
	if( (i = strlen(F2)) >= FMAXP)
		i = FMAXP-1;
	Fo2 = ((FMAXP-i)/2)+41;

	if(*Fw) {
		fpw = fopen(Fw, "wvq");
		WFs(F1); WFnl();
		WFs(F2); WFnl();
		fclose(fpw); }

	Vopen(SAVcol = 0x70);

a0:	if(Bmode != LBmode) {
a01:	Color(0x70);
		Vclscr(); }
	if(LBmode = Bmode) {
		Vgotoxy(36, LINES);
		Ptr = Otxt;
		for(c=0x80; c; c >>= 1) {
			Vputc((Opt & c) ? *Ptr : '.');
			++Ptr; }
		Bmode = 0;
		goto a2; }
	Vgotoxy(Fo1, LINES);
	Color((Lsel & 1) ? VNOR2 : VHIL2);
	VputF(F1);
	Vgotoxy(Fo2, LINES);
	Color((Lsel & 2) ? VNOR1 : VHIL1);
	VputF(F2);
a1:	if(Bmode != LBmode)
		goto a0;
	if(Opt & O_LNUM) {
		Vgotoxy(0, LINES);
		Color(0x70);
		Vprintf(" %u", Line1+1);
		Vgotoxy(36, LINES);
		Vgotoxy(74, LINES);
		Vprintf("%5u", Line2+1); }

a2:	if(ISneg(Line1))	Line1 = 0;
	if(ISneg(Line2))	Line2 = 0;
	if(Line1 > Top1)	Line1 = Top1;
	if(Line2 > Top2)	Line2 = Top2;
	if(ISneg(Offset1))	Offset1 = 0;
	if(ISneg(Offset2))	Offset2 = 0;
	Redraw();
	switch(toupper(Key = Vgetk())) {
	case ' ':	switch(Lsel) {		// Left/Right/Both
		case 3:	Lsel = 1;	goto a0;
		case 1: Lsel = 2;	goto a0; }
		Lsel = 3;
		goto a0;
	case 'H':						// Horz/Vert
	case 'V':
		Lines = (Lines & 0x10) ? LINES2 : LINES;
		goto a1;
	case 'N':
		CLstat();
		Opt ^= O_LNUM;
		goto a0;
	case 'C':	c = O_CASE;				goto a3;
	case 'L':	c = O_LSPC;				goto a3;
	case 'S':	c = O_SPC;				goto a3;
	case 'T':	c = O_TSPC;
a3:		Bmode = 255;
		LBmode = 0;
		Opt ^= c;
		goto a1;
	case 'D':						// Next diff
		fp = fp1;
		GoTo(Index1, Line1);
		fp = fp2;
		GoTo(Index2, Line2);
		for(;;) {
			if(!fgets(Buff1, SLINE, fp1))
				goto a1;
			if(!fgets(Buff2, SLINE, fp2))
				goto a1;
			if(Compare(Buff1, Buff2))
				goto a1;
			++Line1;
			++Line2; }
	case 'G':
		GetLN();
		goto a0;
	case '\r':
	case '\n':	// Show options
		Bmode = !LBmode;
		goto a0;
	case '\t':
		if((Tab *= 2) > 16)
			Tab = 2;
		goto a1;
	case '.' :
		if(Tch & 0x80) {
			Tch = Sch = ' ';
			goto a1; }
		Sch = VSPC;
		Tch = VTAB;
		goto a1;
	case 0x1B:	goto ex; 
	case '|' :	Ptr = Dhelp;	goto a4;
	case '?' :	Ptr = Ihelp;
a4:		Color(VNOR1);
		Vclscr();
		help(Ptr);
		for(;;) switch(Vgetk()) {
			case 0x1B:
			case '\n':
			case '\r':
			case ' ' :	goto a01; } }
/*ChtTxt Dhelp
                [difile] format
------------------------------------------------
1st line is file1 name
2nd		 "" file2 ""
=n1 n2		prefix (informational) file1 content
 .. text ..		#n2 lines should exist at #1
+n1 n2		add lines at #n1
 .. text ..		#n2 lines to add
-n1 n2		remove lines at #n1
 .. text ..		#n2 lines that should be removed
------------------------------------------------
Shows what has to be done to make file1 into file2.

To make an entry, use '=/+/-' to set up difference marks, then '0-9' to write
that difference to [differences] file (with =prefix if '1'+)

One entry it written for each '0-9' keypress:

If left  side (only) is marked:		'-'		is written
If both	 sides		are marked:	 '-'and'+'	is written
If right side (only) is marked:		'+'		is written ...
	#n1 will indicate the position of top left.
*/
	if(*Fw) switch(Key) {
		case '=':
			Select();
			goto a1;
		case '+':
			if(De1) Line1 = Ds1;
			if(De2) Line2 = Ds2;
			goto a1;
#if 7
		case '~':
			Vclose();
			printf("%02x %u(%u-%u)  %u(%u-%u)",
				Lsel, Line1, Ds1, De1, Line2, Ds2, De2);
			return;
#endif
		case '9':
		case '8':
		case '7':
		case '6':
		case '5':
		case '4':
		case '3':
		case '2':
		case '1':
		case '0':
			if(De1|De2)
				WriteDiff();
		case '-':
			De1 = De2 = 0;
			goto a1; }

/*ChtTxt Ihelp
File Compare Text												(press SPACE)

	  Up/Dn			move 1 line				\
	PgUp/PgDn		move 1 screen			 > Only affects
	Left/Right	 	shift left/right by 1	 > selected file(s)
   ^PgUp/^PgDn		move to start/end		 >							*
   ^Left/^Right		"" by 10				 > (hilighted at bottom)
	  Home			"" to column 1			/
	  Space			select left/right/both file(s)						*
	   Tab			select tab spaceing: 1/2/4/8/16
		.			toggle space/tab printable
	   V/H		"" Vertical/Horizontal view
		C			"" -C	Case sensitivity
		L			"" -L	ignore Leading whitespace
		N			"" -N	line Numbers
		S			"" -S	treat multi Spaces as 1
		T			"" -T	ignore Trailing whitespace
		D			move to next Difference
		G			Goto line
	  Enter			show command [options]
		=			mark difference at top line			difference is extended
		+			move to ""								if already marked
		-			remove  "" marks					'|' for more help
	   0-9			write   "" to -Dfile				(1-9) with = prefix
*/
	if(Lsel & 1) switch(Key) {
		case _KLA:	i = 1;
b1:			Offset1 -= i;
			break;
		case _KRA:	i = 1;
b2:			Offset1 += i;
			break;
		case _CLA:	i = 10;			goto b1;
		case _CRA:	i = 10;			goto b2;
		case _KHO:	Offset1 = 0;	break;
		case _KUA:	i = 1;
b3:			Line1 -= i;
			break;
		case _KDA:	i = 1;
b4:			Line1 += i;
			break;
		case _KPU:	i = Lines;		goto b3;
		case _KPD:	i = Lines;		goto b4;
		case _CPU:	Line1 = 0;		break;
		case _CPD:	Line1 = Top1;	}
	if(Lsel & 2) switch(Key) {
		case _KLA:	i = 1;
c1:			Offset2 -= i;
			break;
		case _KRA:	i = 1;
c2:			Offset2 += i;
			break;
		case _CLA:	i = 10;			goto c1;
		case _CRA:	i = 10;			goto c2;
		case _KHO:	Offset2 = 0;	break;
		case _KUA:	i = 1;
c3:			Line2 -= i;
			break;
		case _KDA:	i = 1;
c4:			Line2 += i;
			break;
		case _KPU:	i = Lines;		goto c3;
		case _KPD:	i = Lines;		goto c4;
		case _CPU:	Line2 = 0;		break;
		case _CPD:	Line2 = Top2;	}
	goto a1;
ex:	Vclose();
	MemTst(0);
}
