/*
 * FDI: create/update FloppyDiskImages
 *
 * Dave Dunfield   -   https://dunfield.themindfactory.com
 */
#include <stdio.h>
#include <file.h>
//#define _DBG_
#define	D_LK	0x0010	//Lookup
#define	D_FF	0x0020	//File
#define	D_FAT	0x0040	//faT
#define	D_AL	0x0080	//Alloc
#define	D_RF	0x0100	//ReadFile
#define	D_DF	0x0200	//Dir
#define	D_WRK	0x0400	//Work
#define	D_SEC	0x0800	//Sector
#define	DBGSET	"1234LFTARDWS"
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#ifdef _DBG_
	#define	DbgPF(a)	a	//parse_filename
	#define	DbgUW(a)	a	//update_work
#else
	#define	DbgPF(a)
	#define	DbgUW(a)
#endif

#define	YC	'/'

/* Misc fixed parameters */
#define	SECTOR_SIZE	512		// Size of a disk sector */
#define	BPB_SIZE	17		// Number of bytes in BIOS Parm Block */
#define	EMPTY		0xE5	// Signals empty directory */
#define	EOF			-1		// End of file indicator */
#define	ERROR		-2		// Report error in file */
#define	READ		0		// File opened for READ */
#define	WRITE		1		// File opened for WRITE */
#define	TB			255		// High byte

#define	M_INJ	0x01
#define	M_EXT	0x02
#define	M_RET	0x04
#define	M_DEL	0x08
#define M_BLD	0x10
#define	M_DFO	0x80

#define	O_VERB	0x01
#define	O_SFNF	0x02
#define	O_SUMM	0x04
#define	O_COMMA	0x08

#define	Dirptr	Gde

/*
 * Structure of MSDOS directory entry
 */
struct Dentry {
	unsigned char	Dname[11];		/* Filename + extension */
	unsigned char	Dattr;			/* File attributes */
	unsigned char	Dreserved[10];	/* Reserved area */
	unsigned		Dtime;			/* Time last modified */
	unsigned		Ddate;			/* Date last modified */
	unsigned		Dcluster;		/* First cluster number */
	unsigned		Dsizel;			/* File size (LOW) */
	unsigned		Dsizeh; }		/* File size (HIGH) */
	*Gde;		// Global Directory Entry

/*
 * Structure of internal file control block
 */
struct Fblock {
	unsigned char 	Fattr;			/* Open attributes */
	unsigned char 	Fsector;		/* Sector within cluster */
	struct Dentry	*Fdirptr;		/* Pointer to directory entry */
	unsigned		Fdirsec;		/* Directory sector */
	unsigned		Ffirstcls;		/* First cluster in file */
	unsigned		Flastcls;		/* Last cluster read/written */
	unsigned		Fnextcls;		/* Next cluster to read/write */
	unsigned		Foffset;		/* Read/Write offset */
	unsigned		Fsizel;			/* File size (LOW) */
	unsigned		Fsizeh;			/* File size (HIGH) */
	unsigned char	Fbuffer[]; }	/* Data transfer buffer */
	*Fb;

unsigned
	EncT,
	Xda = -1,
	Xti = -1,
	Yr, Mo, Dy,
	Hr, Mi, Se,
	Seg,
	Arg,
	Sh, Sl, At, Ti, Da,
	wrksec = -1,			// Current work sector number
	dirsec = 5,				// First sector of directory
	datasec = 12,			// First sector of data area
	Dtop;
HANDLE
	*Dfh;
FILE
	*xfp;
unsigned char
	*Ptr,
	*Ptr1,
	Opt = O_COMMA|O_VERB|O_SFNF,
	Mode,
	Flg,
	wrkchg,					// Indicates work sector changed
	Dfile[128],				// Disk file!
	Dir[128],				// Leads filename
	Temp[128],			
	Temp1[128],
	wrkbuff[SECTOR_SIZE];	/* Work sector buffer */

#include "R:\\Help.h"

unsigned 		L10[] = { 10, 0 };
unsigned		Lss[] = { SECTOR_SIZE, 0 };
extern unsigned	Longreg[];

/* Disk information (from BIOS Parameter Block) */
unsigned int	bytsec	= 512;		/* Bytes / sector */
unsigned char	seccls	= 2;		/* Sectors / cluster */
unsigned int	ressec	= 1;		/* # reserved sectors */
unsigned char	numfat	= 2;		/* Number of FAT's */
unsigned int	dirent	= 112;		/* Number of directory entries */
unsigned int	sectors	= 720;		/* Sectors on disk */
unsigned char	mediaid	= 0xFD;		/* Media ID byte */
unsigned int	secfat	= 2;		/* Sectors / fat */
unsigned int	sectrk	= 9;		/* Sectors / track */
unsigned int	numhead	= 2;		/* Number of heads */

unsigned
	Xtype[] 	= { 160, 180, 200, 320, 360, 400, 720, 1200, 1440, 2880, 0};
	Xaddr[]		= { 0x0400,0x0600,0x0600,0x0600,0x0800,0x0800,0x0C00,
				0x1200, 0x1400, 0x1400 },
	Xsize[]		= {	384, 464, 544, 1024, 1184, 1344, 2624, 4544, 5504, 11264 };
unsigned char
	A0000[]		= { 0xEB,0x3C,0x90,'D' ,'a' ,'v' ,'e' ,'.' ,'D' ,'D' ,'S'  },
	A000C[]		= { 0x02,0x01,0x01 },
	A0010_0160[]= { 0x02,0x38,0x00,0x40,0x01,0xFE,0x01 },
	A0010_0180[]= { 0x02,0x38,0x00,0x68,0x01,0xFC,0x02 },
	A0010_0200[]= { 0x02,0x38,0x00,0x90,0x01,0xFC,0x02 },
	A0010_0320[]= { 0x02,0x70,0x00,0x80,0x02,0xFF,0x02 },
	A0010_0360[]= { 0x02,0x70,0x00,0xD0,0x02,0xFD,0x03 },
	A0010_0400[]= { 0x02,0x70,0x00,0x20,0x03,0xFD,0x03 },
	A0010_0720[]= { 0x02,0x70,0x00,0xA0,0x05,0xF9,0x05 },
	A0010_1200[]= { 0x02,0xE0,0x00,0x60,0x09,0xF9,0x08 },
	A0010_1440[]= { 0x02,0xE0,0x00,0x40,0x0B,0xF0,0x09 },
	A0010_2880[]= { 0x02,0x00,0x02,0x80,0x16,0xF0,0x09 },
	S0018[]		= { 0x08,0x09,0x0A,0x08,0x09,0x0A,0x09,0x0F,0x12,0x24 },
	S001A[]		= { 0x01,0x01,0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02 },
//	A0026[]		= { 0x29,0x7B,0xB2,0x13 },	// Serial
	A002B[]		= { 0x4E,0x4F,0x20,0x4E,0x41,0x4D,0x45,0x20,0x20,
					0x20,0x20,0x46,0x41,0x54,0x31,0x32,0x20,0x20,0x20 },
	A01FE[]		= {	0x55,0xAA,0xF0,0xFF,0xFF };

void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Sp(void)				{	Pc(' ');			}

/*
 * Function Prototypes
 */
extern struct Dentry *lookup(), *create_file();
//Print error message and terminate
register Error(unsigned args)
{
	unsigned char *p, buf[128];
	_format_(nargs()*2+&args, p=buf);
	if(*p == '!') p = buf+1;
//	if(Line) printf("%u: ", Line);
	Ps(p);
	if((p == buf) || (Opt & O_SFNF))
		exit(-1);
}

#ifdef _DBG_
unsigned _DbgF_;
register _dBg_(unsigned df)
{
	unsigned i;
	unsigned char buf[200];
	i = nargs();
	if((df & _DbgF_) || !df) {
		_format_(i*2+&df, buf);
		fputs(buf, stdout); }
}
void DbgSet(unsigned char *p)
{
	unsigned i;
	unsigned char c, d;
	while(c = toupper(*p++)) {
		for(i=0; d=DBGSET[i]; ++i) {
			if(d == c)
				goto a1; }
		Error("?!%c", c);
a1:		printf("(%u)", i);
		_DbgF_ ^= 1 << i; }
	printf("Dbs=[%x]\n", _DbgF_);
}
	#define Dbg(a) _dBg_ a;
#else
	#define	Dbg(a)
#endif

register Printf(unsigned args)
{
	unsigned i;
	unsigned char buf[256];
	i = nargs();
	if(Opt & O_VERB) {
		_format_(i*2+&args, buf);
		if(*buf == ';')
			Ps(Dfile);
		Ps(buf);
		return 255; }
	return 0;
}

void open_drive(void)
{
	if(!Dfh) {
		Dbg(("Opd'%s'\n", Dfile, D_FF))
		if(!(Dfh = open(Dfile, F_READ)))
			Error("NoImage'%s'\n", Dfile);
		close(Dfh);
		if(!(Dfh = open(Dfile, F_READ|F_WRITE)))
			Error("UnableToOpen'%s'\n", Dfile); }
	read_work(0);
	memcpy(&bytsec, wrkbuff+11, BPB_SIZE);
//printf("BySe%u SeCl%u RsSe%u #Ft%u DiEn%u #Se%u Mi%x SeFt%u SeTr%u #hd%u\n"
//,bytsec, seccls, ressec, numfat, dirent, sectors, mediaid, secfat, sectrk, numhead);
	dirsec	= (numfat * secfat) + ressec;
//printf("dirsec= (#Ft*SeFt)+RsSe =%u:%x\n", dirsec, dirsec);
	datasec	= ((((dirent * sizeof(struct Dentry)) + bytsec) - 1) / bytsec) + dirsec;
//printf("datasec= ((((dirent*sizeof(struct Dentry%u))+bytsec)-1)/bytsec)+dirsec =%u:%x\n"
//, sizeof(struct Dentry), datasec, datasec);
}

/*
 * Get a FAT entry for a given cluster number
 */
unsigned get_fat(unsigned cluster)
{
	unsigned sec, fat;
	Dbg(("Get FAT(%x)", cluster, D_FAT))
	sec = (cluster * 3)/2; //*=
	read_work( (sec / bytsec) + 1);
	fat = wrkbuff[sec % bytsec];
	read_work( (++sec / bytsec) + 1);
	fat |= wrkbuff[sec % bytsec] << 8;
	if(cluster & 1)
		fat >>= 4;

	Dbg(("%x\n", fat & 0xFFF, D_FAT))
	return fat & 0xfff;
}

/*
 * Set a FAT entry for a given cluster number
 */
void set_fat(unsigned cluster, unsigned value)
{
	unsigned sec, x;

	Dbg(("Set FAT(%x) =%x\n", cluster, value, D_FAT))

	sec = (cluster *= 3)/2;

	/* Set LOW byte of FAT */
	read_work( (sec / bytsec) + 1);
	x = sec % bytsec;
	if(cluster & 1)
		wrkbuff[x] = (wrkbuff[x] & 0x0F) | (value << 4);
	else
		wrkbuff[x] = value;
	wrkchg = TB;

	/* Set high byte of FAT */
	read_work( (++sec / bytsec) + 1);
	x = sec % bytsec;
	if(cluster & 1)
		wrkbuff[x] = value >> 4;
	else
		wrkbuff[x] = (wrkbuff[x] & 0xF0) | ((value >> 8) & 0x0F);
	wrkchg = TB;
}

/*
 * Allocate a free cluster on disk, and cross connect FAT if necessary
 * mark cluster as used & end of file.
 */
unsigned allocate(unsigned cluster)
{
	unsigned begin, end, i;

	/* Calculate start and end clusters for search */
    /* If we have a "FAT" sector loaded, begin searching from there, */
    /* to attempt to keep allocated sectors in same "FAT" sector */

	begin = ((i = wrksec-1) && (i <= secfat)) ? ((i * (SECTOR_SIZE*2)) / 3) + 1 : 2;
	end = (sectors - datasec) / seccls;

	do {
		Dbg(("Allocate(%x) : Wrk=%x Begin=%x End=%x\n", cluster, wrksec, begin, end, D_AL))
		for(i = begin; i < end; ++i)
			if(!get_fat(i)) {
				Dbg(("Allocated %x(%u)\n", i, i, D_AL))
				set_fat(i, 0xFFF);
				if(cluster)
					set_fat(cluster, i);
				return i; }
		/* Didn't find, reset to start cluster, and try again */
		end = begin;
		begin = 2; }
	while(end != 2);

	Error("DiskFull\n");
//	return 0;
}

/*
 * Release a chain of allocated clusters
 */
void release(unsigned cluster)
{
	unsigned i;
	while(cluster && (cluster < 0xFF8)) {
		i = get_fat(cluster);
		set_fat(cluster, 0);
		cluster = i; }
}

//struct *Fblock *
void MKFblock(unsigned attrs)
{
	/* Allocate buffer for file control block */
	if(!(Fb = malloc(bytsec+sizeof(struct Fblock))))
		Error("OutOfMemory");

	/* Fill in file control block from directory information */
	Fb->Fdirsec		= wrksec;
	Fb->Fdirptr		= Dirptr;
	Fb->Fattr		= attrs;
	Fb->Fnextcls	= Fb->Ffirstcls = Dirptr->Dcluster;
	Fb->Fsizel		= Dirptr->Dsizel;
	Fb->Fsizeh		= Dirptr->Dsizeh;
	Fb->Fsector		= Fb->Foffset = Fb->Flastcls = 0;
//	Dbg(("%04x Ds%04x Dp%04x At%02x", Fb, Fb->Fdirsec, Fb->Fdirptr, Fb->Fattr, D_FF))
//	Dbg((" Nc%x S:%04x%04x\n", Fb->Fnextcls, Fb->Fsizeh, Fb->Fsizel, Fb->Fsector, D_FF))
}

/*
 * Open a file & return a pointer to an allocated file structure
 */
struct Fblock *open_file(unsigned char *name, unsigned attrs)
{
	Dbg(("Of'%s'[%x]", name, attrs, D_FF))
	if(lookup(name)) {					/* File already exists */
		if(attrs == WRITE)						/* Zero size on write */
			Dirptr->Dsizel = Dirptr->Dsizeh = 0; }
	else {
		if(attrs != WRITE) {						/* Not writing file */
			Dbg(("!WRI\n", D_FF))
			return 0; }
		if(!(Dirptr = create_file(name, 0))) {	/* Unable to create */
			Dbg(("F!\n", D_FF))
			return 0; } }

	MKFblock(attrs);
	Dbg(("%04x Ds%04x Dp%04x At%02x", Fb, Fb->Fdirsec, Fb->Fdirptr, Fb->Fattr, D_FF))
	Dbg((" Nc%x S:%04x%04x\n", Fb->Fnextcls, Fb->Fsizeh, Fb->Fsizel, Fb->Fsector, D_FF))
	return Fb;
}

/*
 * Close an open file
 */
void close_file(void)
{
	unsigned sizeh, sizel;

	Dbg(("Cl%04x[%x]", Fb, Fb->Fattr, D_FF))
	if(Fb->Fattr == WRITE) {
		sizel = Fb->Fsizel;
		sizeh = Fb->Fsizeh;
		Dbg((" d%x t%x s%x%x\n", Da, Ti, sizeh, sizel, D_FF))
		/* If there is a partial last sector, fill it with DOS EOF */
		/* characters, which also causes it to be written out */
		while(Fb->Foffset)
			write_byte(0x1A);
		/* Release remaining clusters in file. If any sectors in the */
		/* current cluster are used, begin with the next one. */
		release(Fb->Fsector ? get_fat(Fb->Fnextcls) : Fb->Fnextcls);
		/* Update size entry in file directory */
		read_work(Fb->Fdirsec);
		Dirptr = Fb->Fdirptr;
		Dirptr->Dcluster= Fb->Ffirstcls;
		Dirptr->Dsizel	= sizel;
		Dirptr->Dsizeh	= sizeh;
		Dirptr->Ddate = (Xda == -1) ? Da : Xda;
		Dirptr->Dtime = (Xti == -1) ? Ti : Xti;
		/* Set directory date of modification here - if you wish */
		wrkchg = TB; }

	free(Fb);

	update_work(DbgUW(1));		/* Insure disk is in sync */
}

#if 0
/*
 * Delete a file from the disk
 */
unsigned delete_file(unsigned char *name)
{
//	struct Dentry *dirptr;

	if(lookup(name)) {
		*(Dirptr->Dname) = EMPTY;
		wrkchg = TB;
		release(Dirptr->Dcluster);
		update_work(DbgUW(2));
		return 0; }
	return -1;
}
#endif

/*
 * Read next byte from open file
 */
int read_byte(void)
{
	unsigned cluster, sector;

	/* If all data read, return EOF */
	if(!(Fb->Fsizel || Fb->Fsizeh)) {
		return EOF; }

	/* Decrement file size (32 bit) */
	if((--Fb->Fsizel) == -1)
		--Fb->Fsizeh;

	/* If no data buffered ... read next sector */
	if((Fb->Foffset >= bytsec) || !(Fb->Foffset)) {
		/* If not open for READ, return ERROR */
		if(Fb->Fattr != READ) {
			Dbg(("[RBerr1]", D_RF))
			return ERROR; }

		/* If past last cluster, return EOF */
		if(((cluster = Fb->Fnextcls) >= 0xFF8) || !cluster) {
			Dbg(("[RBeof]", D_RF))
			return EOF; }

		/* Read the sector into memory */
		read_sector(
			(sector = Fb->Fsector) + ((cluster-2)*seccls) + datasec,
			Fb->Fbuffer);

		/* Advance sector in cluster, if past end, get next cluster number */
		if(++sector >= seccls) {
			Fb->Fnextcls = get_fat(cluster);
			sector = 0; }

		/* Update file control block information */
		Fb->Flastcls	= cluster;
		Fb->Fsector		= sector;
		Fb->Foffset		= 0; }

	/* Read character, and advance circular buffer pointer */
	return Fb->Fbuffer[Fb->Foffset++];
}

/*
 * Write a byte to an open file
 */
int write_byte(unsigned c)
{
	unsigned cluster, sector;

	/* Test for writable file */
	if(Fb->Fattr != WRITE)
		return ERROR;

	/* Advance file size */
	if(!++Fb->Fsizel)
		++Fb->Fsizeh;

	/* Write character to buffer */
	Fb->Fbuffer[Fb->Foffset++] = c;

	/* If buffer is full, write it */
	if(Fb->Foffset >= bytsec) {
		/* If no sector allocated, allocate one */
		if(!Fb->Fnextcls)
			Fb->Ffirstcls = Fb->Fnextcls = allocate(0);
		else if(Fb->Fnextcls >= 0xFF8)
			Fb->Fnextcls = allocate(Fb->Flastcls);

		if(!(cluster = Fb->Fnextcls))
			return ERROR;

		/* Write the data to the drive */	
		write_sector(
			(sector = Fb->Fsector) + ((cluster-2)*seccls) + datasec,
			Fb->Fbuffer);

		/* Advance to next sector in cluster */
		if(++sector >= seccls) {
			Fb->Fnextcls = get_fat(cluster);
			sector = 0; }

		/* Update file control block information */
		Fb->Flastcls	= cluster;
		Fb->Fsector		= sector;
		Fb->Foffset		= 0; }

	return c;
}

/*
 * Parse a filename into directory format (12 characters, space filled)
 */
void parse_filename(unsigned char buffer[], unsigned char *name)
{
	unsigned i;
	DbgPF(unsigned char c;)

	i = 0;
	DbgPF(Pc('`'));
	while(i < 8) {
		buffer[i++] = DbgPF(c =) (*name && (*name != '.')) ? toupper(*name++) : ' 'DbgPF(+0x11);
		DbgPF(Pc(c);)
	} if(*name == '.')
		++name;
	DbgPF(Pc('`');)
	while(i < 11) {
		buffer[i++] DbgPF(= c) = *name ? toupper(*name++) : ' 'DbgPF(+0x12);
		DbgPF(Pc(c);)
	} buffer[i] = 0;
	DbgPF(Pc('`');)
}

int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
//		if(toupper(*name++) != c)
		if(*name++ != c)
			return 0; }
}

unsigned char *Ename(unsigned char *n)
{
	unsigned i;
	unsigned char *p, c;
	i = 0;
	p = Temp;
	while(i < 11) {
		if(++i == 9)
			*p++ = '.';
		if(( (c = *n++) > ' ') && (c <= '~'))
			*p++ = c; }
	*p = 0;
	return Temp;
}

unsigned Di, Dj, Dk;
struct Dentry *Gnd(unsigned fn)
{
	unsigned i;
	if(fn) {
		Di = Flg = 0;
		Dj = bytsec;
		Dk = dirsec; }
	while(Di++ < dirent) {
		if(Dj >= bytsec) {
			read_work(Dk++);
			Dj = 0; }
		i = Dj;
		Dj += sizeof(struct Dentry);
		switch(wrkbuff[i]) {
		default	:
			Dbg(("Gnd%04x\n", wrkbuff+i, D_DF))
			return Gde = wrkbuff+i;
		case EMPTY:
		case 0	:	; } }
	Dbg(("GndNF\n", D_DF))
	return 0;
}
void Gne(void)
{
	if(!Flg)
		Error("!NotFound'%s'\n", Ptr);
}

struct Dentry *lookup(unsigned char *file)
{
	unsigned char fbuf[12];
	parse_filename(fbuf, file);
	if(Gnd(7)) do {
		if(!memcmp(Gde, fbuf, 11)) {
			Dbg(("Lk'%s'%s'1\n", file, fbuf, D_LK))
			return Gde; } }
		while Gnd(0);
	Dbg(("Lk'%s'%s'0\n", file, fbuf, D_LK))
	return 0;
}

/*
 * Create a file with the specified name
 * NOTE: Does NOT check for duplicates. It is assumed that "lookup()"
 * has been called first, to verify that the file does not already
 * exist on the disk.
 */
struct Dentry *create_file(unsigned char *file, unsigned attrs)
{
	unsigned i, j, k;
	unsigned char fbuffer[12];
//	struct Dentry *dirptr;

	parse_filename(fbuffer, file);

	Dbg(("Create '%s' ", fbuffer, D_FF))

	j = bytsec;
	k = dirsec;
	for(i=0; i < dirent; ++i) {
		if(j >= bytsec) {
			read_work( k++);
			j = 0; }
		if((*(Dirptr = wrkbuff+j)->Dname == EMPTY) || !*Dirptr->Dname) {
			Dbg(("Dir entry #%u\n", i, D_FF))
			memset(Dirptr, 0, sizeof(struct Dentry));
			strcpy(Dirptr, fbuffer);
			Dirptr->Dattr = attrs;
			/* Set directory date of creation here - if you wish */
			wrkchg = TB;
			return wrkbuff+j; }
	j += sizeof(struct Dentry); }

	Dbg(("NoDirEnt!\n", D_FF))

	return 0;
}

/*
 * Internal "work" sector manipulation functions:
 *
 *	read_work(sector)		- Read sector into work buffer (if necessary)
 *		sector	- Sector number to read.
 *
 *	update_work()			- Write work sector back to disk if changed
 */

/*
 * Read a work sector into memory if it is not already in memory.
 */
read_work(unsigned sector)
{
	if(wrksec != sector) {
		Dbg(("R%u\n", sector, D_WRK))
		update_work(DbgUW(3));
		read_sector(wrksec = sector, wrkbuff); }
}

/*
 * Write the work sector if it has been marked as modified
 */
update_work(DbgUW(unsigned s))
{
	if(wrkchg) {
		Dbg(("Uw%x(%u) %x(%u)", wrksec, wrksec, s, s, D_WRK))
		write_sector(wrksec, wrkbuff);
		wrkchg = 0; }
}


/*
 * Low level disk I/O functions:
 *
 *	disk_error(code)		- Called if unrecoverable disk error
 *		code	- Disk failure code (system dependent)
 *
 *	read_sector(d, s, b)	- Read a sector from the disk
 *		d		- Drive to read (0=A, 1=B ...)
 *		s		- Sector number to read (1-n)
 *		b		- Pointer to buffer to receive data
 *
 *	write_sector(d, s, b)	- Write a sector to the disk
 *		d		- Drive to write (0=A, 1=B ...)
 *		s		- Sector number to write (1-n)
 *		b		- Pointer to buffer containing the data
 *
 * These functions make use of the IBM PC BIOS, and are compatible
 * with Microsoft MASM assembler. Use these if you are compiling the
 * demo program with the MICRO-C DOS compiler.
 */

/*
 * Report a disk error
 */
register DSKerr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps("DiskError: ");
	Ps(buf);
	Pc('\n');
	exit(-1);
}

void Seek(unsigned s)
{
	if(lseek(Dfh, s >> (16-9), s << 9, 0))
		DSKerr("SK%u", s);
}
/*
 * Read a sector from the disk drive
 */
read_sector(unsigned sector, unsigned char buffer[])
{
	Dbg(("Rs(%x)%04x%04x\n", sector, sector >> (16-9), sector << 9, D_SEC))
//	lseek(Dfh, sector >> (16-9), sector << 9, 0);
	Seek(sector);
	if(read(buffer, SECTOR_SIZE, Dfh) != SECTOR_SIZE)
		DSKerr("RD%u", sector);
}

write_sector(unsigned sector, unsigned char buffer[])
{
	Dbg(("Ws(%x)%04x%04x\n", sector, sector >> (16-9), sector << 9, D_SEC))
//	lseek(Dfh, sector >> (16-9), sector << 9, 0);
	Seek(sector);
	if(write(buffer, SECTOR_SIZE, Dfh))
		DSKerr("WR%u", sector);
}

void DirFile(void)
{
	unsigned i;
	strcpy(Dir, Ptr);
	Dtop = i = 0;
a1:	switch(Dir[i++]) {
	case ':':
	case'\\':	Dtop = i;
	default	:	goto a1;
	case 0	:	; }
	Dbg(("D'%s'%u\n", Dir, Dtop, 1))
}

unsigned char LSbuf[14];
unsigned char *StrLong(unsigned ln[2])
{
	unsigned i, j, l[2];

	LSbuf[i = (Opt & O_COMMA) ? sizeof(LSbuf)-1 : sizeof(LSbuf)-4] = 0;
	longcpy(l, ln);
	j = 4;
	do {
		if((Opt & O_COMMA) && !--j) {
			LSbuf[--i] = ',';
			j = 3; }
		longdiv(l, L10);
		LSbuf[--i] = *Longreg + '0'; }
	while(longtst(l));
	j = i;
	while(i) LSbuf[--i] = ' ';
	return LSbuf+j;
}

unsigned char SHsum = 7;
void ListDir(void)
{
	unsigned i, l1[2], l2[2];

	Dbg(("Lst'%s'\n", Ptr, 1))
	longset(l2, i=0);
	if(Gnd(7)) do {
		Ename(Gde);
		if(Fmatch(Temp, Ptr)) {
			++i;
			Da	= Gde->Ddate;
			Ti	= Gde->Dtime;
			l1[1]= Gde->Dsizeh;
			*l1 = Gde->Dsizel;
			longadd(l2, l1);
			printf("%04u-%02u-%02u", (Da>>9)+1980,	(Da>>5)&15,		Da&31);
			printf(" %3u:%02u:%02u", Ti>>11, 		(Ti>>5)&63,		(Ti&31)*2);
			StrLong(l1); Ps(LSbuf);
			Sp(); Ps(Temp);
			Pc(Flg = '\n'); } }
	while Gnd(0);
	if(Opt & O_SUMM) {
		printf("  %u file(s) %s bytes\n", i, StrLong(l2));
		SHsum = 0; }
	else
		Gne();
}
#if 0
void ShowSumm(void)
{
	unsigned i, j, l1[2], l2[2];
	if(!SHsum) {
		j = (sectors - datasec) / seccls;
		longset(l1, i=0);
		while(i < j) {
			if(!get_fat(i++))
				++*l1; }
		longset(l2, sectors);
		longmul(l2, Lss);
		printf("  Disk %s ", StrLong(l2));
		longset(l2, seccls); longmul(l1, l2);
		longmul(l1, Lss);
		printf("- %s free\n", StrLong(l1)); }
}
#else
void ShowSumm(void)
{
	unsigned i, j, k, l1[2];
	if(!SHsum) {
		j = 0;
		k = 2;
		for(i = datasec+k; i < sectors; ++i) {
			if(get_fat(k++))
				++j; }
		longset(l1, sectors);	longmul(l1, Lss);
		printf("  Disk %s",	StrLong(l1));
		longset(l1, sectors-k);			longmul(l1, Lss);
		printf(" - %s sys",	StrLong(l1));
		longset(l1, j);			longmul(l1, Lss);
		printf(" - %s files",	StrLong(l1));
		longset(l1, k-j);		longmul(l1, Lss);
		printf(" = %s free\n",	StrLong(l1)); }
}
#endif

void PutSeg(unsigned a, unsigned char *p, unsigned l)
{
	do {
		poke(Seg, a++, *p++); }
	while(--l);
}

void MKimage(unsigned i)
{
	unsigned j;
	unsigned char *p;
	if(i == 9) {
		A000C[1] = 2;
/*		A0026[1] = 0x28;
		A0026[2] = 0x87;
		A0026[3] = 0x0A; */ }
	PutSeg(0x0000, A0000, sizeof(A0000));
	PutSeg(0x000C, A000C, sizeof(A000C));
	p = (i * sizeof(A0010_0160)) + A0010_0160;
	PutSeg(0x0010, p, sizeof(A0010_0160));
	poke(Seg, 0x0018, S0018[i]);
	poke(Seg, 0x001A, S001A[i]);
//	PutSeg(0x0026, A0026, sizeof(A0026));
	PutSeg(0x002B, A002B, sizeof(A002B));
	PutSeg(0x01FE, A01FE, sizeof(A01FE));
	PutSeg(Xaddr[i], "\xF0\xFF\xFF", 3);
	j = 0;
	do {
		putc(peek(Seg, j++), xfp); }
	while(j);
	i = Xsize[i];
	do {
		j = 256;
		do {
			putc(0, xfp); }
		while(--j); }
	while(--i);
}

unsigned Gtime(void)
{
	unsigned c, v, i, n1, n2, n3, *dn, *vp;
	unsigned char *p, *p1, e;
	static unsigned	Vt[] = {	0, 0, 0,	23,	 60, 60 };
	static unsigned Vd[] = {	0, 1, 1,	9999,12, 31 };
	Dbg(("[%s", Ptr, 2))
	p = Ptr;
	i = 0;
a1:	p1 = p;
	v = 0;
	while((c = *p-'0') < 10) {
		v = (v * 10) + c;
		++p; }
	if(!i) {
		switch(e = *p) {
		case ':':
			dn = &Hr;
			vp = Vt;
			Dbg(("(%u:%u:%u)", dn[0], dn[1], dn[2], 2))
			Dbg(("{%u:%u:%u}", vp[3], vp[4], vp[5], 2))
			goto a3;
		case YC:
			dn = &Yr;
			vp = Vd;
			Dbg(("(%u-%u-%u)", dn[0], dn[1], dn[2], 2))
			Dbg(("{%u-%u-%u}", vp[3], vp[4], vp[5], 2))
			goto a3;	}
		Dbg((" -:]", 2))
rz:		return -1; }
a3:	if(p == p1)
		v = dn[i];
	if(vp[i] > v)	{ Dbg((" %u < %u]", v, vp[i], 2))	goto rz; }
	if(vp[i+3] < v)	{ Dbg((" %u > %u]", v, vp[i+3], 2)) goto rz; }
	(&n1)[i++] = v;
	if(i < 3) {
		if(*p++ != e) {
			Dbg((" %x-%x]", *(p-1), e, 2))
			goto rz; }
		goto a1; }
	if(*p) {
		Dbg((" !0]", 2))
		goto rz; }
	Dbg(("%u%c%u%c%u\n", n1, e, n2, e, n3, 2))
	if(e == ':')
		EncT = (n1 << 11) | (n2 << 5) | (n3 >> 1);
	else {
		if(n1 < 100)
			n1 += (n1 < 80) ? 2000 : 1900;
		EncT = ((n1-1980) << 9)  | (n2 << 5) | n3; }
	Dbg(("]", 2))
	return e;
}

void ClnDrive(void)
{
	unsigned i, j, k, s, es;
	unsigned char z0[SECTOR_SIZE], z1[SECTOR_SIZE];
	open_drive();
#define	Ds	s	// DirSec
#define	Do	es	// DirOff
	Dk = Ds = dirsec;
	Do = k = 0;
	while(Dk < datasec) {
		Dbg(("[%u:%x]\n", Dk, Dk*512, 1))
		read_work(Dk++);
		for(Dj = 0; Dj < bytsec; Dj += sizeof(struct Dentry)) {
			switch(wrkbuff[Dj]) {
			default	:	// Remove deleted dir entries
				memcpy(z0+Do, wrkbuff+Dj, sizeof(struct Dentry));
				if( (Do += sizeof(struct Dentry)) >= SECTOR_SIZE) {
					write_sector(Ds++, z0);
					Do = 0;
				} break;
			case EMPTY:
				Dbg(("\n%04x '%s'", Dj, wrkbuff+Dj, 1))
//?				memset(wrkbuff+Dj+1, 0, sizeof(struct Dentry)-1);
//?				wrkchg = TB;
				++k;
			case 0	:	; } } }
	Printf("%u dirEntries", k);
//?	update_work(DbgUW(4));
	while(Ds < datasec) {
		memset(z0+Do, 0, SECTOR_SIZE-Do);
		write_sector(Ds++, z0);
		Do = 0; }
#forget Ds
	es = (sectors - datasec) / seccls;
	memset(z0, k = 0, SECTOR_SIZE);
	for(s = 2; s < es; ++s) {
		if(!get_fat(s)) {
			j = ((s-2)*seccls)+datasec;
			for(i=0; i < seccls; ++i) {
				read_sector(j++, z1);
				if(memcmp(z1, z0, SECTOR_SIZE)) {
					write_sector(j-1, z0);
					++k; } } } }
	Printf(", %u emptyClusters\n", k);
}
main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;

	get_date(&Dy, &Mo, &Yr);
a0:	i = Dy;
	get_time(&Hr, &Mi, &Se);
	get_date(&Dy, &Mo, &Yr);
	if(Dy != i) goto a0;

	while(++Arg < argc) {
		if(*(Ptr = argv[Arg]) == '-') {
			Dbg(("o'%s'\n", Ptr, 1))
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
/*ChtTxt R:\Help.h
FloppyDiskImage

use:	FDI		[options] imagefile command [filespec...]

opts:	y/m/d		set Date of -W files 	{leave element(s)}		[from file]
		h:m:s		set Time of -W files	{  blank for NOW }		[from file]
		-Q			Quiet 	(less output)
		-S			Summary (list)
		-C			no Comma in numbers
		-N			no stop on Non-critical
cmds:	-Bsize		BuildBlank(160,180,200,320,360,400,720,1200,1440,2880)k
		-B0			clean existing image: eliminate deleted data!
		-D			Delete file(s) in image
		-R			Retrieve file(s) from image
		-W			Write file(s) to image
		none		list file(s) in image

Does the above on "floppy disk" images:
  simple binary files containing raw sector data, exactly as actual disk!
which :		Used with virtual machine: VirtualBox, VMWARE, 86box, DosBox ...
can be:		Written to real disks with: ImageDisk, XDISK, DSKWRITE ...

Dave Dunfield   -   https://dunfield.themindfactory.com~
*/
#ifdef _DBG_
			case '!':
				DbgSet(Ptr);
				continue;
#endif
			case 'C':	c = O_COMMA;	goto o2;
			case 'Q':	c = O_VERB;		goto o2;
			case 'S':	c = O_SUMM;		goto o2;
			case 'N':	c = O_SFNF;
o2:				Opt ^= c;
				if(*Ptr) goto o1;
				continue;
			case 'B':	Mode = M_BLD;	break;
			case 'D':	Mode = M_DEL;	break;
			case 'R':	Mode = M_RET;	break;
			case 'W':	Mode = M_INJ;	 }
			if(!*Ptr)
				continue; }

		switch(Gtime()) {
		case ':':	Xti = EncT;	continue;
		case YC:	Xda = EncT;	continue; }
		Dbg(("f'%s'%u\n", Ptr, Mode, 1))
		if(!*Dfile) {
			strcpy(Dfile, Ptr);
			continue; }

		if(Mode == M_BLD) {
			if(!(i = atoi(Ptr))) {
				Printf(";Cln ", i);
				ClnDrive();
				goto ex; }
			Dbg(("B'%s'%s'%u\n", Dfile, Ptr, i, 1));
			Sh = 0;
			while(Sl = Xtype[Sh++]) {
				if(Sl == i)
					goto a1; }
			goto he;
a1:			Printf(";Build %uk\n", i);
			Seg = alloc_seg(4096);
			i = 0;
			do {
				pokew(Seg, i -= 2, 0); }
			while(i);
			xfp = fopen(Dfile, "wbvq");
			MKimage(Sh-1);
			fclose(xfp);
			return; }
		strupr(Ptr);
		open_drive();
		switch(Mode) {
		case 0	:	// List
			ListDir();
			continue;
		case M_DEL:
			Printf(";Delete %s\n", Ptr);
			if(Gnd(7)) do {
				Ename(Gde);
				if(Fmatch(Temp, Ptr)) {
					Printf(" '%s'\n", Temp);
					*Gde->Dname = EMPTY;
					wrkchg = Flg = TB;
					release(Gde->Dcluster);
					update_work(DbgUW(5)); } }
				while Gnd(0);
			Gne();
			continue;
		case M_RET:
			Printf(";Retrieve %s\n", Ptr);
			DirFile();
			strcpy(Temp1, Dir+Dtop);
			if(Gnd(7)) do {
				Ename(Gde);
				if(Fmatch(Temp, Temp1)) {
					strcpy(Dir+Dtop, Temp);
					Printf(" '%s'->'%s'\n", Temp, Dir);
					MKFblock(READ);
					xfp = fopen(Dir, "wbvq");
					while(!((i = read_byte()) & 0xFF00))
						putc(i, xfp);
					fclose(xfp);
					close_file();
					read_work(Dk-1);
					Flg = TB;
				} }
				while Gnd(0);
			Gne();
			continue;
		case M_INJ:
			Printf(";Write");
			DirFile();
			Printf(" %s\n", Dir);
			if(find_first(Dir, 0, Temp, &Sh, &Sl, &At, &Ti, &Da)) {
				Error("!NotFound'%s'\n", Dir);
				continue; }
			do {
				strcpy(Dir+Dtop, Temp);
				Printf(" '%s'->'%s'\n", Dir, Temp);
				xfp = fopen(Dir, "rvbq");
				if(!open_file(Temp, WRITE))
					abort("Couldn't write MDCFS file");
				while(!( (i = getc(xfp)) & 0xFF00))
					write_byte(i);
				close_file();
				fclose(xfp);
			} while !find_next(Temp, &Sh, &Sl, &At, &Ti, &Da);
			continue;
	} }
	if(!*Dfile) {
he:		Ptr = Help;
		while(i = *Ptr++) {
			if(i & 0x80) {
				while(i-- & 0x7F)
					Pc(' ');
				continue; }
			Pc(i); }
		return; }
	if(!Dfh) {
		if(Mode)
			goto he;
		open_drive();
		Ptr = "*";
		ListDir(); }
	ShowSumm();
ex:	Dbg(("Close(%u)\n", Dfh, 1))
	close(Dfh);
}
//ChtCmd cc fdi -pof
