// FESP
#include <stdio.h>
#include <file.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	POOL	8192

#define	PDIR	"\x01"
#define	PFIL	"\x04"

#define	O_BARE	0x01
#define	O_ERR	0x02
#define	O_SUBD	0x04

unsigned
	Sh, Sl, At, Ti, Da,		// Find info
	Seg,					// Extern segment
	Stop,					// Top of ""
	Dtop,					// "" Dir
	Ptop,					// StringPool
	L10[] = { 10, 0 };		// Long 10
FILE
	*fp;
unsigned char
	*Ptr,					// General pointer
	Opt = O_BARE|O_SUBD,	// Command options
	Prt,					// Printf output flags
	Mark = 0xA0+7,			// So my BLD utility doesn't think it CONTAINS ESP
	Siz[11],				// ESP sizes
	Home[128],				// Home directrory
	Dir[128],				// Working ""
	Temp[128],				// Temp storage
	Pool[POOL];				// String pool
#include "R:\\Help.h"
extern unsigned Longreg[];

// Return to Home directory
void GoHome(void)
{
	if(*Home) {
		set_drive(*Home - 'A');
		cd(Home); }
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	GoHome();
	exit(-1);
}

register Printf(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
	if(*buf & Prt)
		fputs(buf+1, stdout);
}

// General console output
void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Nl(void)				{	Pc('\n');			}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

// Show file Data and Time
void ShowDT(unsigned da, unsigned ti)
{
	Pr("%04u-%02u-%02u",	(da>>9)+1980,	(da>>5)&15,		da&31);
	Pr(" %3u:%02u:%02u ",	ti>>11, 		(ti>>5)&63,		(ti&31)*2);
}

// Show a Long number
void ShowLN(unsigned h, unsigned l)
{
	unsigned i, lv[2];
	unsigned char buf[13];
	buf[i = sizeof(buf)-1] = 0;
	lv[1] = h;
	*lv = l;
	do {
		longdiv(lv, L10);
		buf[--i] = *Longreg + '0'; }
	while longtst(lv);
	while(i) buf[--i] = ' ';
	Ps(buf);
	Pc(' ');
}

unsigned Val16(void)
{
	unsigned v, c;
	unsigned char *p;
	v = 0;
	p = Ptr;
	for(;;) {
		if(((c=*Ptr) >= '0') && (c <= '9'))	c -= '0';
		else if((c >= 'A') && (c <= 'F'))	c -= ('A'-10);
		else if((c >= 'a') && (c <= 'f'))	c -= ('a'-10);
		else break;
		v = (v << 4) | c;
		++Ptr; }
	if((Ptr == p) || (v & 0xFF00))
		Error("?BadHexValue use 00-FF");
	Debug(("HexVal:%02x\n", v))
	return v;
}

// Examine a file to see if it has ESP
unsigned FindEsp(void)
{
	unsigned i, j, s, o, o1;
	fp = fopen(Dir, "rbvq");
	Stop = 0;
	while((i = getc(fp)) != EOF) {
		poke(Seg, Stop++, i);
		if(!Stop) {		// More than 64k
			if(Opt & O_ERR) {
				Pc('?');
				if(Opt & O_BARE) {
					ShowDT(Da, Ti);
					ShowLN(Sh, Sl); }
				Ps(Dir);
				Nl();
				fclose(fp);
				goto rz; } } }
	fclose(fp);
	o = 0;
	while(o < Stop) {
		if(peek(Seg, o++) != Mark)	// Not possible start of ESP
			continue;
		o1 = o;
		s = 0;						// Read string sizes
		while(Siz[s] = peek(Seg, o++)) {
			if(++s >= sizeof(Siz))	// To many .. not ESP
				goto ne; }
		if(!s)						// No strings // not ESP
			goto ne;
		for(i=0; i < s; ++i) {		// Check that each string has zero
			if(peek(Seg, (j = Siz[i])+o-1))
				goto ne;
			o += j; }
		if(peek(Seg, o) != Mark)	// Must end with Mark byte
			goto ne;
		return 7;
ne:		o = o1; }
rz:	return 0;
}

// Scan directory and examine relavent files
void DoDir(void)
{
	unsigned i, dt, pt;
	pt = Ptop;
	dt = Dtop;
	while(Dir[Dtop]) ++Dtop;
	if(Dir[Dtop-1] != '\\')
		Dir[Dtop++] = '\\';
	strcpy(Dir+Dtop, "*.*");
	Printf(PDIR"D'%s'", Dir);

	if(find_first(Dir, 0x3F, Temp, &Sh, &Sl, &At, &Ti, &Da)) {
		Printf(PDIR"\x01?nf\n");
		goto ex; }
	Printf(PDIR"\n");
	do {
		if(At &= (DIRECTORY|VOLUME|HIDDEN|SYSTEM)) {
			if((At == DIRECTORY) && (*Temp != '.'))
				Pstring(Temp);
			continue; }
		Ptr = Temp;
a1:		switch(*Ptr++) {	// Find .EXTension
		default	:	goto a1;
		case '.':
			if(!strcmp(Ptr, "COM")) goto a2;	// These are the
			if(!strcmp(Ptr, "EXE")) goto a2;	// executable types
			if(!strcmp(Ptr, "DVM")) {			// that ESP supports
a2:				strcpy(Dir+Dtop, Temp);
				Printf(PFIL"F'%s'\n", Dir);
				if(FindEsp()) {
					if(Opt & O_BARE) {
						ShowDT(Da, Ti);
						ShowLN(Sh, Sl); }
					Ps(Dir);
					Nl(); } }
		case 0	:	; }
	} while !find_next(Temp, &Sh, &Sl, &At, &Ti, &Da);
	if(Opt & O_SUBD) {
		i = pt;
		while(i < Ptop) {
			strcpy(Dir+Dtop, Pool+i);
			while(Pool[i++]);
			DoDir(); } }
ex:	if(kbtst() == 0x1B)
		Error("?abort");
	Dtop = dt;
	Ptop = pt;
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;

	i = 0;
	while(++i < argc) {
		switch(*(Ptr = argv[i])) {
		case '?':
		case '*':	goto he;
		case '/':
		case '-':
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:
he:				Ptr = Help;
				while(c = *Ptr++) {
					if(c & 0x80) {
						while(c-- & 0x7F)
							Pc(' ');
						continue; }
					Pc(c); }
				return;
/*ChtTxt R:\Help.H
FindESP

use:	FESP	[path]	[options]

opts:	-B		output in Bare format
		-D		show Directories scanned
		-F		"" Files ""
		-L		"" not tested (too Large - >64k)
		-Mxx	set Mark value											[A7]
		-S		do not return into Subdirectories

Examines executable (.COM .EXE & .DVM) files under specified path [current]
to see if they contain Executable String Patch data.

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'M':
				Mark = Val16();
				continue;
			case 'D':	c = *PDIR;	goto o2;
			case 'F':	c = *PFIL;
o2:				Prt ^= c;
				if(*Ptr) goto o1;
				continue;
			case 'B':	c = O_BARE;	goto o3;
			case 'L':	c = O_ERR;	goto o3;
			case 'S':	c = O_SUBD;
o3:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		if(*Temp) goto he;
		strcpy(Temp, Ptr); }

	strcpy(Home, "::\\");
	*Home = get_drive() + 'A';
	getdir(Home+3);
	Debug(("H'%s'\n", Home))
	strcpy(Dir, Home);

	if(*Temp) {
		if(Temp[1] == ':') {
			set_drive(i = toupper(*Temp)-'A');
			if(get_drive() != i) goto nd; }
		if(cd(Temp)) {
nd:			Error("?dir'%s'\n", Temp); }
		strcpy(Dir, "::\\");
		*Dir = get_drive() + 'A';
		getdir(Dir+3);
		GoHome();
		*Home = 0; }

	Seg = alloc_seg(4096);
	DoDir();
}
