// ESP
#include <stdio.h>
#include <dvmvideo.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	MemTst(a)
#define	DEBUG	0

#define	FILL		' '

#define	VNORM		0x17
#define	VHIL1		0x71
#define	VHIL2		0x31

#define	BMAX		10
#define	WIDTH		70
#define	POOL		4096

#define	O_INSERT	0x01
#define	O_HEX		0x02
#define	O_VIEW		0x04
#define	O_SAVE		0x08
#define	O_DRY		0x10

unsigned
	Base,				// Segment ESP base address
	Seg, Stop,			// External segment
	Nc, Scolor,			// New/Saved color
	Xpos, Ypos,			// X/Y position
	Xoff,				// Display offset
	Btop,				// Block top
	Ptop,
	Bwid[BMAX],			// Block Widths (current size)
	Blen[BMAX];			// Block length (max sizr)
FILE
	*fp;
unsigned char
	*Ptr,				// General
	*Cpatch[BMAX],		// Command pathes
	Mark = 0xA7,
	Esc = '~',
	Opt,				// Command options
	Flag,
	Hf,
	Vmode,				// Visual mode
	Ifile[128],			// Filename to change
	Ofile[128],
	Temp[256],			// Temp location
	Btext[BMAX][256],	// Block texts
	Pool[POOL];

//ChtTxt R:\Help.h
#include "R:\\Help.h"
//	&Khelp, &Help, &Hstr, &Hfmt, &Hcex;

void Pc(unsigned char c)
{
	if(!Vmode) {
		putc(c, stdout);
		return; }
	if(Nc != Scolor)
		Vcolor(Scolor = Nc);
	Vputc(c);
}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}

#if 0
void Dbg(unsigned char c)
{
	Pc(c);
	delay(500);
	Pc('\b');
}
#endif

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

//Print Error message and terminate
register Error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

//Trim spaces from string
unsigned Trim(void)
{
	unsigned i;
	i = 0;
	while(Ptr[i])					++i;
	while(i && isspace(Ptr[i-1]))	--i;
	Ptr[i] = 0;
	return i;
}


#if DEBUG&1
void Add(unsigned char *p, unsigned l)
{
	unsigned i;
	if(Btop >= BMAX)
		Error("?Bover");
	Ptr = Btext[Btop];
	Debug(("A%04x'%s'", Ptr, p))
	i = 0;
	do {
		if(i >= 255)
			Error("?Aover"); }
	while(Ptr[i++] = *p++);
	Debug(("%u %u %u\n", i, l, i+l))
	Bwid[Btop] = i-1;
	Blen[Btop++] = i + l;
	while(i < 256)
		Ptr[i++] = 0;
}
#endif

unsigned char Hex(unsigned char c)
{
	if((c += '0') > '9')
		return c + ('A'-'9'-1);
	return c;
}

void Dline(unsigned l)
{
	unsigned co, xp, w, X;
	unsigned char c;
	Vgotoxy(0, l+l+1);
	Nc = co = VNORM;
	w = Xoff + WIDTH;
	memset(Temp, 0, sizeof(Temp));
	if(l >= Btop) {
		if(l == Btop) {
			Nc = VHIL1;
			Ps("[END"); }
		goto a3; }
	Ptr = Btext[l];
	X = 0;
	if(l == Ypos) {
		Nc = co = VHIL1;
		xp = Xpos; }
	else
		xp = -1;
	Pr("%-2u", (l+1)%10);
	Nc = VNORM;
	Ps("  ");
	Nc = co;
	while(X < Xoff) {
		if(!Ptr[X]) {
			X = Xoff;
			goto a1; }
		++X; }
	while(X < w) {
		if(!(c = Ptr[X]))
			break;
		if(X == xp)
			Nc = VHIL2;
		if((c < ' ') || (c > '~') || (Opt & O_HEX)) {
			Temp[X] = c;
			Nc = (X == xp) ? VNORM : VHIL2;
			c = Hex(c>>4); }
		Pc(c);
		Nc = co;
		++X; }
a1:	Vcolor(Scolor = Nc = VNORM);
	Vcleol();
	while(X < w) {
		Pc(FILL);
		++X; }
	Vgotoxy(0, l+l+2);
	Pr(" %-3u", Blen[l]);
	for(X = Xoff; X < w; ++X) {
		if(c = Temp[X]) {
			Nc = VHIL2;
			Pc(Hex(c & 15));
			Nc = VNORM;
			continue; }
		Pc(FILL); }
a3:	Vcolor(Scolor = Nc = VNORM);
	Vcleol();
}

void Delete(void)
{
	unsigned l;
	unsigned char c, d;
	if(l = Bwid[Ypos]) {
		if(Xpos >= l)
			return;
		Bwid[Ypos] = l-1;
		Ptr = Btext[Ypos];
		d = 0;
		while(l > Xpos) {
			c = Ptr[--l];
			Ptr[l] = d;
			d = c; }
		Flag = 0x55; }
}

unsigned Insert(unsigned char c)
{
	unsigned i, s, w;
	Ptr = Btext[Ypos];
	s = Blen[Ypos];
	w = Bwid[Ypos];
	if((w+1) >= s)
		return 0;
	i = 255;
	while(i > Xpos) {
		Ptr[i] = Ptr[i-1];
		--i; }
	Bwid[Ypos] = w+1;
	Ptr[Xpos++] = c;
	return Flag = 0x55;
}

register Prompt(unsigned args)
{
	unsigned char *p, buf[128];
	_format_(nargs()*2+&args, p=buf);
	if(!*p)
		p = (Opt & O_INSERT) ? "Insert" : "Overwrite";
	Vgotoxy(0, 24);
	Ps(p);
	Vcleol();
}

unsigned ToHex(unsigned c)
{
	if((c >= '0') && (c <= '9'))	return c-'0';
	if((c >= 'a') && (c <= 'f'))	return c-('a'-10);
	if((c >= 'A') && (c <= 'F'))	return c-('A'-10);
	return 0xFFFF;
}
unsigned Ghex(void)
{
	unsigned i, c, d, v;
	Prompt("Hex (2 digits, ESC=cancel)? ");
	v = i = 0;
a1:	switch(c = d = Vgetc()) {
	case 0x1B:	v = 0;	goto ex;
	case _KBS:
		if(i) {
			Ps("\b \b");
			v >>= 4;
			--i; }
		goto a1; }
	if((c = ToHex(c)) &0xFFF0)	goto a1;
	Pc(d);
	v = (v << 4) | c;
	if(++i < 2)
		goto a1;
ex:	Prompt("");
	return v;
}

unsigned Gseg(unsigned i)
{
	return peek(Seg, Base + i);
}
unsigned Gstr(unsigned char *p, unsigned o)
{
	unsigned i;
	i = 0;
	while(p[i++] = Gseg(o++)) {
		if(i > 255)
			return -1; }
	return i-1;
}
void Load(void)
{
	unsigned i, j, k;
	unsigned char c;

	fp = fopen(Ifile, "rbvq");
	while((i = getc(fp)) != EOF) {
		poke(Seg, Stop++, i);
		if(!Stop)
			Error("?SegOver"); }
	fclose(fp);
	Debug(("Ltop %u\n", Stop))
	Base = 0;
a1:	while(Base < Stop) {
		if(peek(Seg, Base++) != Mark)
			continue;
		Debug(("%04x:", Base-1))
		Btop = i = 0;
		while(c = Gseg(i++)) {
			if(Btop >= BMAX) {
				Debug((">BMAX\n"))
				goto a1; }
			Blen[Btop++] = c; }
		Debug(("Btop %u", Btop))
		for(k=0; k < Btop; ++k) {
			if((j = Gstr(Btext[k], i)) & 0xFF00) {
				Debug(("!len\n"))
				goto a1; }
			Bwid[k] = j;
			i += Blen[k];
			if(Gseg(i-1)) {
				Debug(("!0\n"))
				goto a1; } }
		if(Gseg(i) != Mark) {
			Debug(("!Mark1"))
			continue; }
		Debug(("F[%04x]\n", Base))
		return; }
	Error("?NoPatch");
}

void Save(void)
{
	unsigned i, j, l;
	for(j = 0; j < Btop; ++j) {
		if(Gseg(j) != Blen[j])
			Error("?Save1"); }
	if(Gseg(j++))
		Error("?Save2");
	for(i=0; i < Btop; ++i) {
		l = Blen[i];
		if(Gseg(j+l-1))
			Error("?Save3");
		Debug(("%04x %u\n", Base + j, l))
		Ptr = Btext[i];
//		j += l; }
		while(l) {
			poke(Seg, j++ + Base, *Ptr);
			if(*Ptr) ++Ptr;
			--l; } }

	if(!(Opt & O_DRY)) {
		fp = fopen(Ofile, "wbvq");
		i = 0;
		while(i < Stop)
			putc(peek(Seg, i++), fp);
		fclose(fp); }
}

void Psc(unsigned y, unsigned char *p)
{
	Vgotoxy(40-(strlen(p)/2), y);
	Ps(p);
}

void CmdPatch(unsigned x)
{
	unsigned i, l, a, b;
	unsigned char *p, c;
	l = Blen[x];
	p = Btext[x];
	i = 0;
	while(c = *Ptr++) {
		if(c == Esc) switch(c = *Ptr++) {
			case 0	:	Error("?esc'%c'nul", Esc);
			case '_':	c = ' ';	break;
			case '-':	c = '\t';	break;
			case'\'':	c = '"';	break;
			case '(':	c = '<';	break;
			case ')':	c = '>';	break;
			case '!':	c = '|';	break;
			default	:
				if( (a = ToHex(c)) < 16) {
					if( (b = ToHex(*Ptr++)) & 0xFFF0)
						Error("Bad ~hex value!");
					c = (a << 4) | b; } }
		p[i++] = c; }
	p[i] = 0;
	if(i >= l)
		Error("?String too long!");
	Bwid[x] = i;
}

void ShowBlock(void)
{
	unsigned i, j;
	unsigned char c;
	for(i=0; i < Btop; ++i) {
		if((c = i + '1') > '9')
			c = '0';
		j = printf("%c[%u]", c, Blen[i]);
		while(j++ < 6) Pc(' ');
		Pc('\'');
		Ptr = Btext[i];
		while(c = *Ptr++) {
			if((c < ' ') || (c > '~') || (Opt & O_HEX)) {
				Pr("{%02x}", c);
				continue; }
			Pc(c); }
		Ps("'\n"); }
}

void help(unsigned char *p)
{
	unsigned char c;
	if(Hf & 1) {
		while(c = *p++) {
			if(c & 0x80) {
				if(c == 0x80) {
					Pr("%x", Mark);
					continue; }
				while(c-- & 0x7F)
					Pc(' ');
				continue; }
			Pc(c); }
		if(Hf & 0xFE) {
			Pc('\n');
			c = 79;
			do Pc('-'); while --c;
			Ps("\n\n"); } }
	Hf >>= 1;
}

//void Vcenter(unsigned y, unsigned char *p)
//{
//	Vgotoxy((WIDTH-strlen(p))/2, y);
//	Vputs(p);
//}
void HEattr(void)
{
	unsigned i;
	Vopen(0x07);
	Psc(0, "ESP is often used to patch video attribes.\n");
	Psc(1, "Here are the attribute values as they appear on your monitor:");
	for(i = 0; i < 256; ++i) {
		Vgotoxy(((i & 15) << 2)+9, (i >> 4)+4);
		Vcolor(i);
		Vprintf("%02x", i); }
	Vcolor(0x07);
	Psc(HEIGHT-1, "Use -H option when viewing current values!\n");
	Psc(HEIGHT, "Press any key");
	Vgetc();
	Vclose();
	exit(0);
}

void Arg(unsigned f)
{
	unsigned char c;
	switch(*Ptr) {
	case '?':	++Ptr;	goto h0;
	case '-':
		++Ptr;
/*ChtTxt Help
Executable String Patcher

use:	ESP	file [outfile] [-1string .. -0string] [options]

opts:	-D		Dry run - don't write changed
		-Ec		set Escape character									[~~]
		-H		show strings in Hex only
		-I		start in Insert mode
		-Lhh	set Lead-in byte	(hex hh)							[~$80]
		-Ofile	read more Options	(one per line)
		-S		no Save prompt		(always save changed)
		-V		View only

Patches strings in .COM, .EXE or .DVM files.  Only "patchable" strings can
be changed.  Files are patched in memory leading to a maximum 64k size.
	Up to 10 strings may be patched, ranging from -1 to -9 and -0 being 10.
	If "outfile" is not given, patchs are written back to "file".

More	ESP	?S	specifying -1..-0		?F	binary Format for patchable strings
help:		?V	Video attribute values	?C	example "" encoded in C
			?A	All help

Dave Dunfield   -   https://dunfield.themindfactory.com~
*/
o1:		switch(c = toupper(*Ptr++)) {
		case '?':
h0:			switch(toupper(*Ptr)) {
			default	:			goto he;
			case 'S':	Hf = 2;	goto he1;
			case 'F':	Hf = 4;	goto he1;
			case 'C':	Hf = 8;	goto he1;
			case 'A':	Hf = 15; goto he1;
			case 'V':	HEattr(); }
		default	:	c -= '1';
			if(c >= 9) goto he;
o2:			if(!Cpatch[c])
				Cpatch[c] = Pstring(Ptr);
			return;
		case 'O':
			strcpy(Temp, Ptr);
			return;
		case '0':	c = 9;			goto o2;
		case 'E':
			if(!(Esc = *Ptr++))
				goto he;
			break;
		case 'L':
			if((Mark = (ToHex(*Ptr++) << 4) | ToHex(*Ptr++)) & 0xFF00)
				goto he;
			break;
		case 'D':	c = O_DRY;		goto o3;
		case 'H':	c = O_HEX;		goto o3;
		case 'I':	c = O_INSERT;	goto o3;
		case 'S':	c = O_SAVE;		goto o3;
		case 'V':	c = O_VIEW;
o3:			Debug(("O:%02x |= %02x\n", Opt, c))
			Opt ^= c; }
		if(*Ptr) goto o1;
		return; }
	if(!*Ifile) {
		strcpy(Ifile, Ptr);
		return; }
	if(*Ofile) {
		if(f) return;
he:		Hf = 1;
he1:	help(Help);
		help(Hstr);
		help(Hfmt);
		help(Hcex);
		exit(0); }
	strcpy(Ofile, Ptr);
}

void Fext(unsigned char *fn, unsigned char *e)
{
	unsigned i, j;
	i = 0;
a1:	j = 0;
a2:	switch(fn[i++]) {
	case ':':
	case'\\':	goto a1;
	case '.':	j = i;
	default	:	goto a2;
	case 0	:	; }
	if(!j)
		strcpy(fn+i-1, e);
}

main(int argc, char *argv[])
{
	unsigned i;
	MemTst(7);
	i = 0;
	while(++i < argc) {
		Ptr = argv[i];
		Arg(0); }
	if(*Temp) {
		Fext(Temp, ".ESP");
		fp = fopen(Temp, "rvq");
		while(fgets(Ptr = Temp, sizeof(Temp)-1, fp)) {
			switch(Skip()) {
			case ';':
			case 0	:	continue; }
			Trim();
			Arg(7); }
		fclose(fp); }

	Debug(("L'%02x' E'%02x'\n", Mark, Esc))
	if(!*Ifile) {
		Ptr = "?";
		Arg(0); }
	if(!*Ofile)
		strcpy(Ofile, Ifile);
	Debug(("I'%s'\n", Ifile))
	Debug(("O'%s'\n", Ofile))

#if 0
	Pr("F'%s'\n", Fname);
	for(i=0; i < BMAX; ++i) {
		if(Ptr = Cpatch[i])
			Pr("%u'%s'\n", i, Ptr); }
	return;
#endif

	Seg = alloc_seg(4096);
#if DEBUG&1
	Add("1ABC", 120);
	Add("2Dave was here (a bit)", 10);
	Add("3Dave was here\ttoo", 10);
	Add("4Dave was here\xEE(a bit more)", 10);
	Add("5", 9);
	Add("6", 9);
	Add("7", 9);
	Add("8", 9);
//	Add("", 9);
//	Add("0", 9);
#else
	Load();
#endif

	for(i=0; i < BMAX; ++i) {
		if(Ptr = Cpatch[i]) {
			if(i >= Btop)
				Error("?-%u out of range!", i);
			CmdPatch(i);
			Flag = 0x55; } }

	if(Opt & O_VIEW) {
		ShowBlock();
		goto ex; }
	Vopen(VNORM); Vmode = 255;
a0:	Prompt("");
	Vgotoxy(20, 0);
	Psc(0, "Executable String Patch");
	Psc(22, "Dave Dunfield ::: https://dunfield.themindfactory.com");
	Psc(23, "F1=help");
a1:	if(Ypos & 0x8000)	Ypos = 0;
	if(Ypos >= Btop)	Ypos = Btop-1;
	if(Xpos & 0x8000)	Xpos = 0;
//	if((i = Bwid[Ypos]) <= Xpos)
//		Xpos = i-1;
	if((i = Bwid[Ypos]) < Xpos)
		Xpos = i;
	if(Xpos < Xoff)
		Xoff = Xpos;
	while((Xoff + (WIDTH-1)) < Xpos)
		++Xoff;
	for(i=0; i < BMAX; ++i) {
		Dline(i); }
#if DEBUG&2
	Prompt("%Y:%u X:%u O:%u W:%u L:%u", Ypos, Xpos, Xoff, Bwid[Ypos], Blen[Ypos]);
#endif
b1:	switch(i = Vgetk()) {
	default	:
		if(i > '~')
			goto b1;
b2:		if(Opt & O_INSERT) {
b3:			if(Insert(i))
				goto b4;
			goto b1; }
		if(Blen[Ypos] <= Xpos)
			goto b1;
		if(Bwid[Ypos] <= Xpos)
			goto b3;
		Btext[Ypos][Xpos++] = i;
//	Ptr = Btext[Ypos];
//	Ptr[Xpos++] = i;
		Flag = 0x55;
b4:		if(Xpos < Xoff)					goto a1;
		if((Xoff + (WIDTH-2)) < Xpos)	goto a1;
		Dline(Ypos);
		goto b1;
/*ChtTxt Khelp
Keys:

		Up/Down			Select item
	  Left/Right		"" column
	   Home/End			start/end of item
		 Del			delete char
		Bksp			backspace and ""
		 Ins			toggle Insert/Overwrite							(*)
		  F2			toggle AlllHex display on/off
		  F3			enter hex value

		 ESC			Quit

	Any other character will:	Overwrite the one under the cursor
					or(*)		be Inserted before ""

Patchable strings are shown in 2-line format:
	1st line is  StringNumber  followed by string data.
	2nd line is       MaxSize  followed by 2nd character if shown in hex.
		(characters shown in hex are hilighted)

Selected string and cursor position are hilited.
*/
	case _KUA:	--Ypos;		goto a1;
	case _KDA:	++Ypos;		goto a1;
	case _KLA:	--Xpos;		goto a1;
	case _KHO:	Xpos = 0;	goto a1;
	case _KEN:
		Xpos = Bwid[Ypos];
		goto a1;
	case _KRA:	++Xpos;		goto a1;
	case _KBS:
		if(!Xpos)
			goto b1;
		--Xpos;
	case _KDL:	Delete();	goto b4;
	case _KIN:
		Opt ^= O_INSERT;;
		Prompt("");
		goto b1;
	case _K1:
		Vclscr();
		Hf = 1;
		help(Khelp);
		Prompt("Press KEY");
		Vgetc();
		Vclscr();
		goto a0;
	case _K2 :
		Opt ^= O_HEX;
		goto a1;
	case _K3 :
		if(i = Ghex())
			goto b2;
		goto b1;
//	case '\t':
//	case '\r':
//	case '\n':	goto b2;
	case _CLA:
		if(Xoff) --Xoff;
		goto a1;
	case _CRA:
		++Xoff;
		goto a1;
	case 0x1B:	; }
	Vclose(); Vmode = 0;
ex:	if(Flag == 0x55) {
		if(Opt & O_SAVE)
			goto x2;
		Ps("Save| ");
		Ps(Ofile);
		Ps(" | (Y/N)?");
x1:		switch(kbget()) {
		default:	goto x1;
		case 0x1B:
		case 'n':
		case 'N':	Ps("No\n");
			goto x3;
		case 'y':
		case 'Y':	Ps("Y\n"); }
x2:
#if !(DEBUG&1)
		Save();
#endif
		}
x3:	MemTst(0);
}
//ChtCmd cc esp -pof

/*ChtTxt Hstr
New strings may contain certain special characters.
These are preceeded by '~~' (which can be changed with -E option):

	~~_		becomes ' '			\
	~~-		becomes '\t'		>	These are all characters
	~~'		becomes '"'			>	which can be difficult to	
	~~(		becomes '<'			>	enter on the DOS/Windows
	~~)		becomes '>'			>	command line.
	~~!		becomes '|'			/

	~~hh	becomes character with hex value: hh (00-FF)
	~~?		'~~' followed by any other character becomes just that character
			(dropping the first '~~')	-	useful to include '~~' in string.
*/
/*ChtTxt Hfmt
String binary format required to identify strings patchable by ESP:

		DB	0~$80h,n1,n2,n3,...,0
Str1:	DB	{n1-1}CharactersOfStringData,0
Str2:	DB	{n2-1}CharactersOfStringData,0
Str3:	DB	{n3-1}CharactersOfStringData,0
		DB	0~$80h

This makes the strings patchable by ESP with a byte overhead of only
3bytes + 1byte/string

The Lead-in byte value of ~$80 was chosen by examining a large selection
of .COM, .EXE and .DVM executables and picking the value which occured the
least.  ESP will also not choose *any* ~$80 byte as the start of patchable
strings.  It will check using the 'n' values to make sure all 0 values and
the trailing ~$80 are where they should be.  Only one set of patchable strings
may occur in a given executable.

For an example on how to code this in C, use: ESP ?C
*/
/*ChtTxt Hcex
Example patchable strings coded in C:

unsigned char
	___1[] = { 0x~$80, 11, 21, 31, 0 },
	Str1[11] = "One",
	Str2[21] = "Two",
	Str3[31] = "Three",
	___2 = 0x~$80;

The "___n" symbols are not used and can be anything you like.
These are needed to store the initial values in the image.

This works in my own Micro-C which stores sequentially defined initialized
global values of the same element size sequentially in memory. This is NOT
required behaviour and other compilers may choose to store them in different
places.
*/
