#include <stdio.h>

#define	O_MC	0x01
#define	O_TC	0x02

FILE
	*fpo;
unsigned char
	*Ptr,
	Opt;

//							80		 81		 82		83		84 85
unsigned char *Msub[] = { "DGRP",  "DSEG", "CSEG", "IDATA","6","4" };
unsigned char *Tsub[] = { "DGROUP","_DATA","_TEXT","DATA", "4","6" };

unsigned char *Vtxt[] = {
";",
"; Lowest level console keyboard/video interface routines.",
";",
"\x80	GROUP	\x81	; Set up data group",
"; Define video screen attributes",
"NORMAL	EQU	07h    	; Normal mode video attributes",
"REVERSE	EQU	70h	; Special effect video attribute",
"CBASE	EQU	0B800h	; Color video screen segment",
"MBASE	EQU	0B000h	; Monochrome video screen segment",
";",
"\x81	segment	word public '\x83'",
"_V_BASE DW	0b800h	; Mono=B000h, Cga=B800h",
"_V_PAGE	DB	0	; Current video page",
"_V_ATTR DB	0	; Current video attribute",
"_V_XY	DW	0	; X & Y Cursor position",
"\x81	ends",
";",
"\x82	segment byte public 'CODE'",
"	assume	cs:\x82, ds:\x80",
";",
"; Initialize the video display",
";",
"_v_init	PROC	NEAR",
"	MOV	AH,0Fh	    ; Get video mode",
"	INT	10h	    ; Issue BIOS call",
"	MOV	\x80:_V_PAGE,BH; Save video page",
"	MOV	BX,CBASE    ; Assume COLOR address",
"	CMP	AL,07h	    ; Monochrome?",
"	JNZ	VINIT1	    ; No, assumption correct",
"	MOV	BX,MBASE    ; Get MONOCHROME address",
"VINIT1:	MOV	\x80:_V_BASE,BX; Set video base address",
"	MOV	\x80:_V_ATTR,NORMAL; Set for normal video",
"	MOV	AX,85h	    ; Clear screen code",
"	PUSH	AX	    ; Pass to subroutine",
"	CALL	_v_putc	    ; Clear the screen",
"	ADD	SP,2	    ; Clean up stack",
"	RET",
"_v_init	ENDP",
"	PUBLIC	_v_init",
";",
"; Get a key from the keyboard with translations: c = vgetc();",
";",
"_v_getc PROC	NEAR",
"; Position cursor on video display",
"	MOV	AH,02h	    ; Position cursor",
"	MOV	BH,\x80:_V_PAGE; Get page id",
"	MOV	DX,\x80:_V_XY; Get 'X' and 'Y' position",
"	INT	10h	    ; Call BIOS",
"; Call BIOS to read key",
"k0:	XOR	AH,AH	; Get key",
"	INT	16h	; Call BIOS",
"	CALL	k1",
"; Special key table - General keys",
"	DB	00h,48h	; KUA	Up arrow",
"	DB	00h,50h	; KDA	Down arrow",
"	DB	00h,4Bh	; KLA	Left arrow",
"	DB	00h,4Dh	; KRA	Right arrow",
"	DB	00h,49h	; KPU	PageUp",
"	DB	00h,51h	; KPD	PageDn",
"	DB	00h,47h	; KHO	Home",
"	DB	00h,4Fh	; KEN	End",
"	DB	2Bh,4Eh	; KKP	Keypad '+'",
"	DB	2Dh,4Ah	; KKM	Keypad '-'",
"	DB	00h,52h	; KIN 	Ins",
"	DB	00h,53h	; KDL	Del",
"	DB	08h,0Eh	; KBS	Backspace",
"; Function keys",
"	DB	00h,3Bh	; K1",
"	DB	00h,3Ch	; K2",
"	DB	00h,3Dh	; K3",
"	DB	00h,3Eh	; K4",
"	DB	00h,3Fh	; K5",
"	DB	00h,40h	; K6",
"	DB	00h,41h	; K7",
"	DB	00h,42h	; K8",
"	DB	00h,43h	; K9",
"	DB	00h,44h	; K10",
"; Special control keys",
"	DB	00h,84h	; CPU	CTRL-PageUp",
"	DB	00h,76h	; CPD	CTRL-PageDn",
"	DB	00h,77h	; CHO	CTRL-Home",
"	DB	00h,75h	; CEN	CTRL-End",
"	DB	00h,73h	; CLA	CTRL-Left arrow",
"	DB	00h,74h	; CRA	CTRL-Right arrow",
"; ALT letter keys",
";	DB	00h,1Eh	; AltA",
";	DB	00h,30h	; AltB",
";	DB	00h,2Eh	; AltC",
";	DB	00h,20h	; AltD",
";	DB	00h,12h	; AltE",
";	DB	00h,21h	; AltF",
";	DB	00h,22h	; AltG",
";	DB	00h,23h	; AltH",
";	DB	00h,17h	; AltI",
";	DB	00h,24h	; AltJ",
";	DB	00h,25h	; AltK",
";	DB	00h,26h	; AltL",
";	DB	00h,32h	; AltM",
";	DB	00h,31h	; AltN",
";	DB	00h,18h	; AltO",
";	DB	00h,19h	; AltP",
";	DB	00h,10h	; AltQ",
";	DB	00h,13h	; AltR",
";	DB	00h,1Fh	; AltS",
";	DB	00h,14h	; AltT",
";	DB	00h,16h	; AltU",
";	DB	00h,2Fh	; AltV",
";	DB	00h,11h	; AltW",
";	DB	00h,2Dh	; AltX",
";	DB	00h,15h	; AltY",
";	DB	00h,2Ch	; AltZ",
"	DW	0h",
"; Search table & see if it code exists",
"k1:	POP	BX	; Get table address",
"	MOV	CX,7Fh	; 80-1",
"k2:	MOV	DX,CS:[BX]; Get entry",
"	AND	DX,DX	; Test for at end",
"	JZ	k3	; Eot - not found!",
"	ADD	BX,2	; Advance to next",
"	INC	CL	; Advance code",
"	CMP	AX,DX	; Is this is?",
"	JNZ	k2	; No, keeo looking",
"	MOV	AX,CX	; Return code",
"	RET",
"k3:	AND	AL,AL	; Ascii?",
"	JZ	k5	; No, leave scancode",
"	CMP	AX,1C0Dh",
"	JNZ	k4",
"	MOV	AL,0Ah",
"k4:	XOR	AH,AH	; Zero high byte",
"k5:	RET",
"_v_getc ENDP",
"	PUBLIC	_v_getc",
";",
"; Write a character to the video display: vputc(char c);",
";",
"_v_putc	PROC	NEAR",
"	PUSH	BP	    ; Save callers stack frame",
"	MOV	BP,SP	    ; Set up addressability to args",
"	PUSH	DI	    ; Save callers DI",
"	PUSH	SI	    ; Save callers SI",
"	PUSH	ES	    ; Save callers Extra segment",
"	PUSH	DS	    ; Save callers Data segment",
"; Set up addresability to the video display, and",
"; Establish the current cursor position.",
"	MOV	ES,\x80:_V_BASE; Point to video base",
"	MOV	DX,_V_XY    ; Get 'X' and 'Y' position",
"	MOV	AL,DH	    ; Copy 'Y'",
"	MOV	BL,160	    ; Size of line (in bytes)",
"	MUL	BL	    ; Calculate 'Y' offset",
"	MOV	BL,DL	    ; Copy 'X'",
"	XOR	BH,BH	    ; Zero high byte",
"	ADD	BX,BX	    ; * 2 for two byte entries",
"	ADD	BX,AX	    ; BX = character position",
"	MOV	AL,4[BP]    ; Get character to display",
"	MOV	AH,\x80:_V_ATTR; restore attribute",
"; Hsndle BELL",
"TSTBEL:	CMP	AL,'G'-40h  ; BELL code?",
"	JNZ	TSTSP1	    ; No, try next",
"	MOV	AX,0E07h    ; Write BELL code",
"	XOR	BX,BX	    ; Write to page 0",
"	INT	10h	    ; Call BIOS",
"	JMP	SHORT VEXIT1; and exit",
"; Handle special effects ON",
"TSTSP1:	CMP	AL,88h	    ; Special effects on?",
"	JNZ	TSTSP0	    ; No, try next",
"	MOV	AH,REVERSE  ; Set for reverse video",
"	JMP	SHORT SEXIT ; Set mode & exit",
"; Handle special effects OFF",
"TSTSP0:	CMP	AL,89h	    ; Special effects off?",
"	JNZ     TSTHO	    ; No, try next",
"	MOV	AH,NORMAL   ; Set for normal mode",
"SEXIT:	MOV	\x80:_V_ATTR,AH; Set new video mode",
"	JMP	SHORT VEXIT1; and proceed",
"; Handle HOME",
"TSTHO:	CMP	AL,84h	    ; Home?",
"	JNZ	TSTCR	    ; No, try next",
"	XOR	DX,DX	    ; Reset cursor",
"	JMP	SHORT VEXIT1; and proceed",
"; Handle CARRIAGE RETURN",
"TSTCR:	CMP	AL,'M'-40h  ; Is it carriage return",
"	JNZ	TSTBS	    ; No, try next",
"	XOR	DL,DL	    ; Reset 'X' position",
"	JMP	SHORT VEXIT1; and proceed",
"; Handle BACKSPACE & CURSOR LEFT",
"TSTBS:	CMP	AL,82h	    ; Cursor left?",
"	JZ	DOBS	    ; Yes, handle it",
"	CMP	AL,'H'-40h  ; Is it backspace",
"	JNZ	TSTUC	    ; No, try line-feed",
"DOBS:	AND	DL,DL	    ; Already at first col?",
"	JZ	VEXIT1	    ; Yes, don't backup",
"	DEC	DL	    ; Reduce 'X' position",
"VEXIT1:	JMP	SHORT VEXIT ; And exit",
"; Handle CURSOR UP",
"TSTUC:	CMP	AL,80h	    ; Up code?",
"	JNZ	TSTCL	    ; No, try next",
"	AND	DH,DH	    ; Already at first row?",
"	JZ	VEXIT	    ; Yes, ignore code",
"	DEC	DH	    ; Go up a line",
"	JMP	SHORT VEXIT ; and proceed",
"; Handle CLEAR SCREEN",
"TSTCL:	CMP	AL,85h	    ; Clear screen",
"	JNZ	TSTCD	    ; No, try next",
"	XOR	DX,DX	    ; Reset cursor position",
"	MOV	AH,02h	    ; Set cursor position",
"	MOV	BH,\x80:_V_PAGE; Get current page",
"	INT	10h	    ; Call BIOS",
"	MOV	CX,80*25    ; # entries to clear",
"	MOV	DI,DX	    ; Start of display",
"	JMP	SHORT DOCLR ; Perform the clear",
"; Handle CLEAR TO END OF SCREEN",
"TSTCD:	CMP	AL,86h	    ; Clear to end of screen?",
"	JNZ	TSTCE	    ; No, try clear to end of line",
"	MOV	CX,80*25    ; Get end of screen",
"	MOV	DI,BX	    ; Start from here",
"	SHR	BX,1	    ; Calculate cursor character position",
"	SUB	CX,BX	    ; Calculate # remaining",
"	JMP	SHORT DOCLR ; Perform the clear",
"; Handle CLEAR TO END OF LINE",
"TSTCE:	CMP	AL,87h	    ; Clear to end of line?",
"	JNZ	TSTLF	    ; No, try next",
"	MOV	CX,80	    ; Get length",
"	SUB	CL,DL	    ; Calculate # remaining",
"	MOV	DI,BX	    ; Start here",
"	JMP	SHORT DOCLR ; perform the clear",
"; Handle CURSOR DOWN",
"TSTLF:	CMP	AL,81h	    ; Cursor down?",
"	JZ	ADVY	    ; Yes, handle it",
"; Handle NEWLINE",
"	CMP	AL,'J'-40h  ; Is it newline?",
"	JNZ	TSTND	    ; Yes, advance line",
"	XOR	DL,DL	    ; Reset cursor",
"	JMP	ADVY	    ; And goto a new line",
"; Handle CURSOR FORWARD",
"TSTND:	CMP	AL,83h	    ; Non-destructive?",
"	JZ	ADVX	    ; Yes, advance cursor",
"; Normal Character, output it",
"NORCHR:	MOV	ES:[BX],AX  ; Write to video display",
"; Advance 'X' position",
"ADVX:	INC	DL	    ; Advance 'X'",
"	CMP	DL,80	    ; Are we over?",
"	JB	VEXIT	    ; No, its ok",
"	DEC	DL",
"	JMP SHORT VEXIT",
";	XOR	DL,DL	    ; Reset 'X' posotion",
"; Advance 'Y' position",
"ADVY:	MOV	SI,160	    ; Copy second line...",
"	MOV	DI,0	    ; into first line",
"	INC	DH	    ; Advance # lines",
"	CMP	DH,25	; are we over?",
"	JB	VEXIT	    ; No, Its OK",
"	DEC	DH	    ; Reset it",
"	MOV	CX,80*24    ; # characters to move",
"	MOV	BX,ES	    ; Get video address",
"	MOV	DS,BX	    ; Set source display",
"    REP	MOVSW		    ; Scroll screen",
"	MOV	CX,80	    ; Size of one line",
"DOCLR:	MOV	AX,0720h    ; clear with blank",
"    REP	STOSW		    ; Clear line",
"; Restore parameters & exit",
"VEXIT:	POP	DS	    ; Restore callers Data seg",
"	POP	ES",
"	POP	SI",
"	POP	DI",
"	MOV	\x80:_V_XY,DX	; Resave 'X' and 'Y'",
"	POP BP		    ; Restore callers stack frame",
"	RET",
"_v_putc ENDP",
"	PUBLIC	_v_putc",
";",
"; Position the cursor on the video display: gotoxy(int x, int y);",
";",
"_v_gotoxy PROC	NEAR",
"	PUSH	BP	    ; Save callers stack frame",
"	MOV	BP,SP	    ; Set up addressability to args",
"	MOV	DL,\x84[BP]    ; Get 'X' value",
"	MOV	DH,\x85[BP]    ; Get 'Y' value",
"	MOV	\x80:_V_XY,DX; Set X/Y values",
"; Position cursor on video display",
"	MOV	AH,02h	    ; Position cursor",
"	MOV	BH,\x80:_V_PAGE; Get page id",
"	INT	10h	    ; Call BIOS",
"	POP	BP	    ; Restore callers stack frame",
"vh2:	RET",
"_v_gotoxy ENDP",
"	PUBLIC	_v_gotoxy",
"	EXTRN	_putchr:near",
";",
"; Help text and display function, takes text from code segment, so that",
"; available data segment (edit buffer) is not reduced.",
";",
"_x_help:MOV BX,offset xh",
"	JMP	SHORT vh1",
"_v_help:MOV	BX,OFFSET eh",
"vh1:	MOV	AL,CS:[BX]",
"	INC	BX",
"	XOR	AH,AH",
"	AND	AL,AL",
"	JZ	vh2",
"	PUSH	BX",
"	PUSH	AX",
"	CALL	_putchr",
"	POP	AX",
"	POP	BX",
"	JMP SHORT vh1",
"	PUBLIC	_v_help, _x_help",
"; store help txt in CODE segment to free up DATA space",
"eh: DB	'Special keys                   Commands                   Line ranges',0Ah",
"    DB	'------------                   --------                   -----------',0Ah",
"    DB	'PgDn  = Page forward             C = Copy line(s)          * = Current line',0Ah",
"    DB	'PgUp  = Page backward            D = Delete line(s)        / = Entire file',0Ah",
"    DB	'^PgUp = Start of file            F = File info             n = line # (1+)',0Ah",
"    DB	'^PgDn = End of file             nH = Set Htab size         0 = End of file',0Ah",
"    DB	'Home  = Start of line            I = Insert new line(s)    = = Tagged lines',0Ah",
"    DB	'End   = End of line              L = List (unformatted)  r,r = range to range',0Ah",
"    DB	'^Home = Redraw screen            M = Move line(s)',0Ah",
"    DB	'^->   = Word right               P = Print (formatted)',0Ah",
"    DB	'^<-   = Word left                Q = Quit editor',0Ah",
"    DB	'INS   = Insert/Overwrite        QQ = Quit with no save',0Ah",
"    DB	'DEL   = Delete character     Rfile = Read & insert file   Examples:',0Ah",
"    DB	'BKSPC = Delete previous  S/old/new = Substitute text      ---------',0Ah",
"    DB	'F1    = EOL display              T = Tag lines             D',0Ah",
"    DB	'F2    = Cursor position          V = Visual mode       1,10C',0Ah",
"    DB	'F3    = Move line to top   W[file] = Write file           =M',0Ah",
"    DB	'F4    = Tag line(s)        X[file] = eXit/write file      0R my.fil',0Ah",
"    DB	'F5    = Del to end of line   ?text = Search for text      /W my.fil',0Ah",
"    DB	'F6    = Del end of line     $[cmd] = Execute DOS command',0Ah",
"    DB	'F7    = Insert deleted line (null) = Move to line range',0Ah",
"    DB	'F10/K+= Line mode command',0Ah",
"    DB	' F9/K-= Re-execute command',0Ah,0",
"; Command line help",
"xh: DB	0Ah,'Use: edt <file> [c=initial_cmd -video_inhibit]',0Ah,0Ah",
"    DB	\"for interactive help:   F10 'H' F10\",0Ah,0Ah",
"    DB	'?COPY.TXT 1983-2008 Dave Dunfield',0Ah",
"    DB	' -- see COPY.TXT --.', 0Ah, 0",
";",
"\x82	ENDS",
"	END",
	0 };

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}

void Pc(unsigned char c)	{	putc(c, fpo); }

/*ChtTxt R:\Help.h
Generate Edt Video.Asm suitable for Micro-C or Turbo-C

use:	GEVA [options]

opts:	-M		generate for Micro-C
		-T		generate for Turbo-C

VIDEO.ASM differs slightly because of different "segment" names and
parameter offsets between the two compilers.

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
unsigned char Help[] = {
	71,101,110,101,114,97,116,101,32,69,100,116,32,86,105,100,101,111,46,65,
	115,109,32,115,117,105,116,97,98,108,101,32,102,111,114,32,77,105,99,
	114,111,45,67,32,111,114,32,84,117,114,98,111,45,67,10,10,117,115,101,
	58,132,71,69,86,65,32,91,111,112,116,105,111,110,115,93,10,10,111,
	112,116,115,58,131,45,77,134,103,101,110,101,114,97,116,101,32,102,
	111,114,32,77,105,99,114,111,45,67,10,136,45,84,134,103,101,110,101,
	114,97,116,101,32,102,111,114,32,84,117,114,98,111,45,67,10,10,86,
	73,68,69,79,46,65,83,77,32,100,105,102,102,101,114,115,32,115,108,105,
	103,104,116,108,121,32,98,101,99,97,117,115,101,32,111,102,32,100,
	105,102,102,101,114,101,110,116,32,34,115,101,103,109,101,110,116,
	34,32,110,97,109,101,115,32,97,110,100,10,112,97,114,97,109,101,116,
	101,114,32,111,102,102,115,101,116,115,32,98,101,116,119,101,101,110,
	32,116,104,101,32,116,119,111,32,99,111,109,112,105,108,101,114,115,
	46,10,10,68,97,118,101,32,68,117,110,102,105,101,108,100,131,45,131,
	104,116,116,112,115,58,47,47,100,117,110,102,105,101,108,100,46,116,
	104,101,109,105,110,100,102,97,99,116,111,114,121,46,99,111,109,10,
	0 };
main(int argc, char *argv[])
{
	unsigned i;
	unsigned char *p, c;
	fpo = stdout;

	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
			case 'M':	c = O_MC;	goto o2;
			case 'T':	c = O_TC;
o2:				Opt |= c; }
			if(*Ptr) goto o1;
			continue; }
		goto he; }

	switch(Opt) {
	default:
he:		Ptr = Help;
		while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					Pc(' ');
				continue; }
			Pc(c); }
		return;
	case O_MC:
	case O_TC:	; }

	fpo = fopen("VIDEO.ASM", "wvq");
	i = 0;
	while(Ptr = Vtxt[i++]) {
		while(c = *Ptr++) {
			if(c & 0x80) {
				if(Opt & O_MC)
					p = Msub[c & 7];
				else
					p = Tsub[c & 7];
				while(c = *p++)
					Pc(c);
				continue; }
			Pc(c); }
		Pc('\n'); }
	fclose(fpo);
}
