extern const char Help[];

// Skip to non-blank
int skip(void)
{
	while((*Ptr == ' ') || (*Ptr == '\t'))
		++Ptr;
	return *Ptr;
}

void error(const char *format, ...)
{
	char buffer[128];
	va_list a;
	va_start(a, format);
	_format_(buffer, 149, format, a);
	va_end(a);
	Putc('\n');
	Puts(buffer);
	longjmp(jmpsav, 0);
}

// Get a number from the input
unsigned value(unsigned base, unsigned max)
{
	unsigned v, c;
	unsigned char f;
	switch(skip()) {
	case '%' : base = 2;	goto setb;
	case '.' : base = 10;	goto setb;
	case '$' : base = 16;	setb: ++Ptr; }
	v = f = 0;
	for(;;) {
		c = *Ptr;
		if((c >= '0') && (c <= '9'))
			c -= '0';
		else if((c >= 'A') && (c <= 'F'))
			c -= ('A'-10);
		else
			break;
		if(c >= base)
			break;
		v = (v * base) + c;
		++Ptr;
		++f; }
	if(!f)
		error("?number");
	if(v > max)
		error("?%u too large (max %u)", v, max);
	return v;
}

// Perform a memory dump
void dump(unsigned a, unsigned d, unsigned s)
{
	unsigned i, j;
	char c, buf[16];
	while(s) {
		Printf("\n%08x", d);	// Display address
		d += 16;
		j = s;
		for(i=0; i < 16; ++i) {
			if(!(i & 3))
				Putc(' ');
			if(j) {
				--j;
				Printf(" %02x", buf[i] = *(unsigned char*)a++);
				continue; }
			Puts("   "); }
		Puts("  ");
		for(i=0; (i < 16) && s; ++i) {
			--s;
			c = buf[i];
			if((c < ' ') || (c >= 0x7F))
				c = '.';
			Putc(c); } }
}

void monitor(void)
{
	unsigned c, i, j, k, l;

#ifdef XDEBUG
	DBout = 0;
#endif
	setjmp(jmpsav);
top:
	for(;;) {
		Puts("\n>");
		Gets(Ptr = Buffer, sizeof(Buffer)-1);
		if(!skip())
			continue;
		i = j = 0;
		do {
			c = *Ptr;
			if((c < 'A') || (c > 'Z'))
				break;
			i = (i << 8) | c;
			++Ptr; }
		while(++j < 4);
		skip();
		c = 255;		// Bit designator
		switch(i) {
		default:
			Puts("\n?cmd");
/*			while(i) {
				if((c = i >> 24))
					Putc(c);
				i <<= 8; }
			puts("' type 'HELP' for a list."); */
			continue;
		case ('R'<<8)|'A' :
		case ('R'<<8)|'B' :
		case ('R'<<8)|'C' :
		case ('R'<<8)|'D' :
		case ('R'<<8)|'E' :
			c = value(10, 15);
			switch(i & 255) {
			case 'A' : setio(A, c);	break;
			case 'B' : setio(B, c);	break;
			case 'C' : setio(C, c);	break;
			case 'D' : setio(D, c);	break;
			case 'E' : setio(E, c);	}
			goto xview;
		case ('D'<<8)|'A' :
		case ('D'<<8)|'B' :
		case ('D'<<8)|'C' :
		case ('D'<<8)|'D' :
		case ('D'<<8)|'E' :
			c = value(10, 15);
			switch(i & 255) {
			case 'A' : clrio(A, c);	break;
			case 'B' : clrio(B, c);	break;
			case 'C' : clrio(C, c);	break;
			case 'D' : clrio(D, c);	break;
			case 'E' : clrio(E, c);	}
			goto xview;
		case ('W'<<8)|'A' :
		case ('W'<<8)|'B' :
		case ('W'<<8)|'C' :
		case ('W'<<8)|'D' :
		case ('W'<<8)|'E' :
			j = value(16, 0xFFFFFFFF);
			switch(i & 255) {
			case 'A' : GPIOA_ODR = j;	break;
			case 'B' : GPIOB_ODR = j;	break;
			case 'C' : GPIOC_ODR = j;	break;
			case 'D' : GPIOD_ODR = j;	break;
			case 'E' : GPIOE_ODR = j;	}
			goto xview;
		case ('V'<<8)|'A' :
		case ('V'<<8)|'B' :
		case ('V'<<8)|'C' :
		case ('V'<<8)|'D' :
		case ('V'<<8)|'E' :
			if(skip())
				c = value(10, 15);
	xview:	switch(i &= 255) {
			case 'A' : j = GPIOA_IDR; k = GPIOA_CRL; l = GPIOA_CRH;	goto sc;
			case 'B' : j = GPIOB_IDR; k = GPIOB_CRL; l = GPIOB_CRH;	goto sc;
			case 'C' : j = GPIOC_IDR; k = GPIOC_CRL; l = GPIOC_CRH;	goto sc;
			case 'D' : j = GPIOD_IDR; k = GPIOD_CRL; l = GPIOD_CRH;	goto sc;
			case 'E' : j = GPIOE_IDR; k = GPIOE_CRL; l = GPIOE_CRH;	sc: ; }
			Printf("\nGPIO%c CR=%08x:%08x ID=%08x %016b", i, l, k, j, j);
			if(c < 16) {
				k = (((c >= 8) ? l : k) >> ((c&7)*4)) & 0xF;
				Printf(" B%u(%u-%u)=%u", c, k>>2, k & 3, (j>>c)&1); }
			continue;
		case ('C'<<8)|'A' :
		case ('C'<<8)|'B' :
		case ('C'<<8)|'C' :
		case ('C'<<8)|'D' :
		case ('C'<<8)|'F' :
			j = value(10, 15);	// Pin
			k = value(10, 3);	// Mode
			l = value(10, 3);	// Cnf
			k = ((l<<2)|k) << ((j&7)*4);		// CNF:MODE
			l = ~(0xF << ((j&7)*4));			// Mask
			if(j < 8) switch(i & 255) {
				case 'A' : GPIOA_CRL = (GPIOA_CRL & l) | k;	break;
				case 'B' : GPIOB_CRL = (GPIOB_CRL & l) | k;	break;
				case 'C' : GPIOC_CRL = (GPIOC_CRL & l) | k;	break;
				case 'D' : GPIOD_CRL = (GPIOD_CRL & l) | k;	break;
				case 'E' : GPIOE_CRL = (GPIOE_CRL & l) | k;	}
			else switch(i & 255) {
				case 'A' : GPIOA_CRH = (GPIOA_CRH & l) | k;	break;
				case 'B' : GPIOB_CRH = (GPIOB_CRH & l) | k;	break;
				case 'C' : GPIOC_CRH = (GPIOC_CRH & l) | k;	break;
				case 'D' : GPIOD_CRH = (GPIOD_CRH & l) | k;	break;
				case 'E' : GPIOE_CRH = (GPIOE_CRH & l) | k;	}
			goto xview;

		case ('M'<<8)|'D' :		// Memory dump
			j = value(16, 0xFFFFFFFF);
			dump(j, j, skip() ? value(10, 4096) : 256);
			continue;
		case ('M'<<16)|('R'<<8)|'B' :
			j = value(16, 0xFFFFFFFF);
			i = *(unsigned char*)j;
			Printf("\n%08x = %02x  .%u", j, i, i);
			continue;
		case ('M'<<16)|('R'<<8)|'H' :
			j = value(16, 0xFFFFFFFF);
			i = *(unsigned short*)j;
			Printf("\n%08x = %04x  .%u", j, i, i);
			continue;
		case ('M'<<16)|('R'<<8)|'W' :
			j = value(16, 0xFFFFFFFF);
			i = *(unsigned*)j;
			Printf("\n%08x = %08x  .%u", j, i, i);
			continue;
		case ('M'<<16)|('W'<<8)|'B' :
			j = value(16, 0xFFFFFFFF);
			while(skip())
				*(unsigned char*)(j++) = value(16, 0xFF);
			continue;
		case ('M'<<16)|('W'<<8)|'H' :
			j = value(16, 0xFFFFFFFF);
			while(skip()) {
				*(unsigned short*)j = value(16, 0xFFFF);
				j += 2; }
			continue;
		case ('M'<<16)|('W'<<8)|'W' :
			j = value(16, 0xFFFFFFFF);
			while(skip()) {
				*(unsigned*)j = value(16, 0xFFFFFFFF);
				j += 4; }
			continue;

		case ('A'<<16)|('D'<<8)|'R' :		// ADC read
			i = ADCread(value(10, 17));
			printf("\n %08x %u", i, i);
			continue;

		case ('D'<<16)|('B'<<8)|'G' :		// Debug outpuy
			if(skip())
				DBmask = value(16, 0xFFFF);
			printf("\nDBG: %04x", DBmask);
			continue;

		case 'S':							// Select
			j = value(10, 2);
			stepselect(j);
			continue;
		case 'G':							// Go
			i = value(10, 9999);				// Position
			j=k=l=0;
			if(skip()) j = value(10, 31);		// End mask bit
			if(skip()) k = value(10, 100);		// start speed
			if(skip()) l = value(10, 100);		// End speed
			if(!k) {
				k = SLOW;
				if(!l)
					l = FULL; }
			stepgo(i, j, k, l);
			continue;
		case 'C':							// Calibrate
			j = 9999;
			k = CSTEP;
			if(skip()) j = value(10, 25000);
			if(skip()) k = value(10, 100);
			Sposition = j;
			stepgo(0, 0, k, 0);
			continue;
		case 'W':							// Wait
			stepwait();
			if(Slimit)
				putc(Slimit);
			continue;
		case 'P':							// Show position
			printf("\n%u", Sposition);
			continue;
		case 'V':							// View
			printf("\nTick: %u", Tick);
			printf("\nActive=%u State=%u Dir=%d Mirror=%016b Rate=%u Ramp=%u/%u/%u Rp=%u",
				Sactive, Sstate, Sdir, Smirror, Srate, RampUp, RampLevel, RampDown,
				StepPos);
			printf("\nPos=%u Pos1=%u Pos2=%u Limit=%c",
				Sposition, Sposition1, Sposition2, Slimit);
			printf("\nDriveMask=%016b ZeroMask=%016b", SdriveMask, SzeroMask);
			continue;
		case 'H':						// Halt
			if(Sstate)
				Sstate = 4;
			continue;
		case 'R':							// Reset
			Sposition = Sposition1 = Sposition2 = Sstate = 0;
			GPIOB_ODR = Smirror & ~(0xFF << 3);
			continue;
		case 'N':							// On
			j = value(10, 31);
			GPIOB_ODR = (Smirror |= (1<<j));
			continue;
		case 'F':							// Off
			j = value(10, 31);
			GPIOB_ODR = (Smirror &= ~(1<<j));
			continue;

		case ('Q'<<24)|('U'<<16)|('I'<<8)|'T':
			return;
		case ('H'<<24)|('E'<<16)|('L'<<8)|'P':
			Ptr = (unsigned char *)Help;
			for(;;) switch(i = *Ptr++) {
				case 0 : goto top;
				case '~':
					Puts("<SPC=more ENT=stop>");
				w1:	switch(Getc()) {
					default: goto w1;
					case '\r': goto top;
					case ' ' :
						Putc('\r');
						for(j=0; j < 20; ++j)
							Putc(' ');
						Putc('\r');
						continue; }
				default:
					Putc(i); }
	} }
}

const char Help[] = { "\n\n\
S m		Select motor		(m=1-2)\n\
G p [e s f]	Go position		(p=0-9999 e=0-6 s=1-100 f=1-100)\n\
C m s		Calibrate		(m=0-9999 s=1-100)\n\
W		Wait for completion\n\
H		Halt current motion\n\
P		show Position\n\
V		View step subsystem\n\
R		Reset step subsystem\n\
N i		turn i/o oN		(i=0-15)\n\
F i		turn i/o oFf		(i=0-15)\n\
Rp b		Raise GPIO bit		(p=A-E, b=0-15)\n\
Dp b		Drop  GPIO bit\n\
Wp v		Write GPIO		(v=0-FFFFFFFF)\n\
Cp b m c	Config GPIO		(m=0-3 c=0-3)\n\
Vp [b]		View GPIO		(if b show that bit)\n\
MD a [size]	Memory Dump		(a=0-FFFFFFFF)\n\
MRB a		Memory Read Byte	(shows in HEX and decimal)\n\
MRH a		Memory Read Halfword\n\
MRW a		Memory Read Word\n\
MWB a b...	Memory Write Byte	(b=00-FF)\n\
MWH a h...	Memory Write Halfword	(h=0000-FFFF)\n\
MWW a w...	Memory Write Word	(w=00000000-FFFFFFFF)\n\
ADR c		ADC read		(c=0-17)\n\
QUIT		restart\n\
\nAny value can be preceeded by %/./$ to force binary/decimal/hex.\
\nSpace between command and operand only needed if operand starts with A-Z.\
\n" };

