// FDTS
#include <stdio.h>
#include <comm.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	DebugC(a)	//printf a;

#define	SOH	0x90
#define	ACK	0x95
#define	NAK	0x9A

#define	O_VERB		0x01
#define	O_PROMPT	0x02
#define	O_ACKA		0x04
#define	O_READ		0x40
#define	O_WRITE		0x80

unsigned
	Crc,
	Cport = -1,
	Cspeed = 1,
	Timeout = 10,
	Psize = 512,
	Cylinders,
	Tracks,
	Sectors,
	CrcTable[256];
FILE
	*fp;
unsigned char
	*Ptr,
	*Ptr1,
	Opt = O_VERB,
	Cactive = 255,
	Drive,
	Buffer[1024];

unsigned
	Dtype[]		= {	360,	720,	1200,	1440,	0 };
unsigned char
	Dcylinder[]	= {	40, 	80,		80,		80	},
	Dtrack[]	= {	2,		2,		2,		2	},
	Dsector[]	= {	9,		9,		15,		18	};

#include "R:\Help.h"

#if 0
unsigned AX, BX, CX, DX, SI, DI, ES;
void ShowReg(void)
{
	printf("\nAX=%04x BX=%04x CX=%04x DX=%04x SI=%04x DI=%04x ES=%04x\n",
		AX, BX, CX, DX, SI, DI);
}
asm {
_SR_:	MOV	DGRP:_AX,AX
		MOV	DGRP:_BX,BX
		MOV	DGRP:_CX,CX
		MOV	DGRP:_DX,DX
		MOV	DGRP:_SI,SI
		MOV	DGRP:_DI,DI
		MOV	DGRP:_ES,ES
		RET
}
#endif

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	if(!Cactive)
		Cclose();
	exit(-1);
}

void Abort(void)
{
	Error("?Abort");
}

register Printf(unsigned args)
{
	unsigned i;
	unsigned char buf[200];
	i = nargs();
	if(Opt & O_VERB) {
		_format_(i*2+&args, buf);
		fputs(buf, stdout); }
}
void Putc(unsigned char c)
{
	if(Opt & O_VERB)
		putc(c, stdout);
}

void CputC(unsigned char c)
{
	Debug(("[%04x-%02x", Crc, c))
	Cputc(c);
	Crc = CrcTable[Crc >> 8] ^ (Crc << 8) ^ c;
	Debug(("-%04x]", Crc))
}

unsigned CgetC(void)
{
	unsigned c, tu, i;
	unsigned char tc, tf;
	tf = tc = 0;
a1:	do {
		if((c = Ctestc()) != -1) {
			Debug(("[%04x-%02x", Crc, c))
			Crc = CrcTable[Crc >> 8] ^ (Crc << 8) ^ c;
			Debug(("-%04x]", Crc))
			return c; } }
	while(--tc);
	if(!tf) {
		tu = peekw(0x40, tf = 0x6C);
		i = Timeout;
		goto a1; }
	if(peekw(0x40, 0x6C) == tu)
		goto a1;
	tu = nargs();
	DebugC(("."))
	if(--i)
		goto a1;
	DebugC(("!"))
	if(kbtst() == 0x1B)
		Abort();
	return -1;
}

void SendPacket(unsigned char *p, unsigned id)
{
	unsigned i;
	DebugC(("Tx%u", id))
	Cputc(SOH);
	Crc = -1;
	CputC(id & 255);
	CputC(id >> 8);
	i = 0;
	do {
		CputC(p[i]); }
	while ++i < Psize;
	DebugC(("(%u)=%04x\n", i, Crc))
	Cputc(Crc & 255);
	Cputc(Crc >> 8);
}

unsigned GetPacket(unsigned char *p)
{
	unsigned c, i, j, id;
a1:	DebugC(("Rx"))
	while(CgetC() != SOH);
	DebugC(("S"))
	Crc = -1;
	if((c = CgetC()) == -1) {
		DebugC(("!1\n"))
		goto a1; }
	if((i = CgetC()) == -1)	{
		DebugC(("!2\n"))
		goto a1; }
	id = (i << 8) | c;
	DebugC((":%u", id))
	i = 0;
	do {
		if((c = CgetC()) == -1) {
			DebugC(("!3\n"))
			goto a1; }
//if(i > 555) Error("?555");
		p[i++] = c; }
	while(i < Psize);
	DebugC(("(%u)", i))
	j = Crc;
	if((c = CgetC()) == -1) {
		DebugC(("!4\n"));
		goto a1; }
	if((i = CgetC()) == -1) {
		DebugC(("!5\n"))
		goto a1; }
	DebugC(("=%04x,%02x%02x", j, i << 8, c))
	if( ((i << 8) | c) != j) {
		DebugC(("!CRC\n"))
		Cputc(NAK);
		goto a1; }
	DebugC(("\n"))
	return id;
}

unsigned Dreset(void) asm
{
		MOV		DL,DGRP:_Drive
		XOR		AH,AH			// Reset
		INT		13h
		JC		e1
		XOR		AX,AX
e1:
}
#if 0
unsigned Dinfo(void) asm
{
		MOV		DL,DGRP:_Drive
		XOR		AH,AH
		INT		13h
		MOV		AX,-1
		JC		e2
		MOV		DL,DGRP:_Drive
		MOV		AH,8
		INT		13h
		CALL	_SR_
		XOR		AX,AX
e2:
}
#endif

unsigned Dread(dest, t, h, s) asm
{
		MOV		AX,DS
		MOV		ES,AX
		MOV		CL,4[BP]		// s
		MOV		DH,6[BP]		// h
		MOV		CH,8[BP]		// t
		MOV		BX,10[BP]		// dest
		MOV		DL,DGRP:_Drive
		MOV		AX,0201h		// Read
		INT		13h
		JC		e3
		XOR		AX,AX
e3:
}

void Prompt(unsigned char *p)
{
	if(Opt & O_PROMPT) {
		fputs(p, stdout);
		fputs(", press SPACE", stdout);
a1:		switch(kbget()) {
		default	:	goto a1;
		case 0x1B:	Abort();
		case ' ':	putc('\n', stdout); } }
}

void Bvalue(void)
{
	Error("?BadValue\"%s\"", Ptr1);
}
unsigned Value(unsigned *r, unsigned char e)
{
	unsigned c, v;
	unsigned char d;
	Ptr1 = Ptr;
	v = 0;
	while((c = *Ptr - '0') < 10) {
		v =  (v * 10) + c;
		++Ptr; }
	if(Ptr == Ptr1)
		Bvalue();
	if(d = *Ptr) {
		if(d != e)
			Bvalue();
		++Ptr; }
	Debug(("{%u}", v))
	*r = v;
	return d;
}

main(unsigned argc, unsigned char *argv[])
{
	unsigned i, j, k, c;
	unsigned char r;

	i = j = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
/*ChtTxt R:\Help.h
Floppy Disk Transfer over Serial

	1:	FDTS <com> <drive> <type>
	2:	FDTS <com> <file>

Opts:	-A				send ACK After saving sector to file
			slower, better serial timing - try if you have timeouts
		-P				Prompt (allow disk change)
		-Q				Quiet (less output)
		-Sbaudrate		set Speed									[115200]
			rounds to: integer(115200/(115200/speed))
		-Tmilliseconds	set serial Timeout							[500]

1:	sends content of a floppy disk to another system over a serial link.
2:	reads "" into an image file

<com>		Dos COM port number											(1-4)
<drive>		drive to read										   (A: or B:)
<type>		type of floppy drive/disk				   (360,720,1200 or 1440)k
								or:					 cylinders,tracks,sectors

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'S':
				Value(&k, 0);
				switch(k) {
				case 38400:	Cspeed = _38400;	break;
				case 57600:	Cspeed = _57600;	break;
				case 49664:	Cspeed = _115200;	break;
				default	:	Cspeed = (57600/k)*2; }
				Debug(("[S%u %u]", k, Cspeed))
				continue;
			case 'T':
				Value(&k, 0);
				Timeout = (k / 55) || 1;
				continue;
			case 'A':	r = O_ACKA;		goto o2;
			case 'P':	r = O_PROMPT;	goto o2;
			case 'Q':	r = O_VERB;
o2:				Opt ^= r; }
			if(*Ptr) goto o1;
			continue; }
		switch(++j) {
		default	:	goto he;
		case 1	:
			Value(&Cport, 0);
			continue;
		case 2	:
			if((Ptr[1] == ':') && !Ptr[2]) {
				if( (Drive = toupper(*Ptr) - 'A') >= 26)
					Error("?BadDrive\"%s\"\n", Ptr);
				Opt |= O_WRITE;
				continue; }
			strcpy(Buffer, Ptr);
			Opt ^= O_READ;
			continue;
		case 3:
			if(Opt & O_READ)
				goto he;
			if(Value(&Cylinders, ',')) {
				if(!Value(&Tracks, ','))
					Bvalue();
				Value(&Sectors, 0);
				continue; }
			Debug(("[%u", Cylinders, Ptr))
			for(c=0; k = Dtype[c]; ++c) {
				if(k == Cylinders)
					goto a1; }
			Error("?BadDriveType\"%s\"", Ptr1);
a1:			Cylinders = Dcylinder[c];
			Tracks	= Dtrack[c];
			Sectors	= Dsector[c]; } }
	switch(Opt & (O_READ|O_WRITE)) {
	default	:
he:		Ptr = Help;
		while(r = *Ptr++) {
			if(r & 0x80) {
				while(r-- & 0x7F)
					putc(' ', stdout);
				continue; }
			putc(r, stdout); }
		return;
	case O_WRITE:
		if(!Sectors)
			goto he;
	case O_READ: ; }

#if 0
	Debug1(("%02x Cp%u D%u B'%s'", Opt, Cport, Drive, Buffer))
	Debug1((" %u/%u/%u\n", Cylinders, Tracks, Sectors))
	return;
#endif

	for(i=0; i < 256; ++i) {	// Build CRC table
		c = i << 8;
		for(j=0; j < 8; ++j)
			c = ((c & 0x8000) ? 0x1021 : 0) ^ (c << 1);
		CrcTable[i] = c; }

	if(Copen(Cport, Cspeed, PAR_NO|DATA_8|STOP_1, SET_DTR|SET_RTS|OUTPUT_2))
		Error("?Can'tOpen\"COM%u\"", Cport);
	Cflags |= TRANSPARENT;
	Cactive = 0;

	if(Opt & O_WRITE) {
		Prompt("Swap disk");
		Printf("%c: %u/%u/%u\n", Drive+'A', Cylinders, Tracks, Sectors);
		if(Dreset())
			Error("?FloppyDriveFail");
		--Cylinders;
		--Tracks;
		--Sectors;
		for(i=c=0; i <= Cylinders; ++i) {
			for(j = 0; j <= Tracks; ++j) {
				Printf("C:%-3uH:%u", i, j);
				for(k=0; k <= Sectors; ++k) {
					r = 3;
c1:					if(Dread(Buffer, i, j, k+1)) {
						Putc('!');
						if(--r) {
							Dreset();
							goto c1; } }
					if((i == Cylinders) && (j == Tracks) && (k == Sectors))
						c = -1;
					r = 3;
c2:					SendPacket(Buffer, c);
					switch(CgetC()) {
					default	:	goto c2;
					case NAK:
					case -1	:
						if(--r) goto c2;
						Error("?CommFail");
					case ACK	:	++c; } }
				Putc('\n'); }
			if(kbtst() == 0x1B)
				Abort(); }
		Cclose();
		Prompt("DONE");
		return; }

	fp = fopen(Buffer, "wbvq");
	Printf("RecvTo\"%s\"", Buffer);
	c = 0;
	do {
		i = GetPacket(Buffer);
		Debug(("R(%u %u)\n", i, c))
		if((i != c) && (i != -1))
			Error("?WrongSectorID(%u %u)", j, i);
		if(!(Opt & O_ACKA))
			Cputc(ACK);
		fput(Buffer, Psize, fp);
		if(Opt & O_ACKA)
			Cputc(ACK);
		if(!(++c & 127))
			Putc('.'); }
	while i != -1;
	Putc('\n');
	fclose(fp);
	Cclose();
}
