********************************************************************
*                             STTY                                 *
*------------------------------------------------------------------*
* This is the standard DOS STTY command which functions with  6551 *
* uarts. It makes the assumption that the device  driver  for  the *
* 6551 begins with an 'LDX #<addr>' instruction that indicates the *
* base address of the device.                                      *
*------------------------------------------------------------------*
*                ?COPY.TXT 1983-2004 Dave Dunfield                 *
********************************************************************
	ORG	OSUTIL		DOS UTILITY SPACE
*
STTY	CMPA	#'?'		TEST FOR HELP REQUEST?
	BNE	MAIN		NO, CHECK FOR QUALIFIERS
	SSR	25		OUTPUT MESSAGE
	FCCZ	'Use: STTY <device> [SPEED=<speed> PARITY=<parity> BITS=5|6|7|8  STOP=1|2]'
ABORT	RTS			RETURN TO CALLER
* PARSE FOR DEVICE TYPE & OPERANDS
MAIN	SSR	6		GET TTY ID FROM COMMAND LINE
	BNE	ABORT		INVALID OPERAND, EXIT
	TFR	X,D		DEVICE ID IN ACCUMULATOR TO ACCESS LOWER EIGHT
	CMPD	#7		IF IT A VALID DEVICE VECTOR(0-7)?
	LBHI	BADOPR		IF SO, ITS NOT A TTY DEVICE
	TFR	B,A		GET DEVICE ID IN 'A' FOR SSR
	STA	>TTYNO		SAVE TTY # FOR LATER REFERENCE
	SSR	102		GET INPUT VECTOR
	CMPD	#0		TEST FOR NO DRIVER
	LBEQ	NODEV		INDICATE NOT VALID
	TFR	D,U		POINT TO FIRST INSTUCT. OF DRIVER
	LDA	,U+		GET OPCODE BYTE
	CMPA	#$8E		TEST FOR 'LDX #'
	LBNE	BADEV		NO, INVALID
	LDU	,U		GET ADDRESS OF DEVICE
* UNLESS COMM. FORMAT PARMS ARE GIVEN, DISPLAY TTY DATA
	SSR	4		MORE OPERANDS?
	LBNE	SETTTY		SET UP TTY'S
* DISPLAY TTY ID & FLOW CONTROL STATE
	SSR	24		OUTPUT MESSAGE
	FCCZ	'TTY '
	LDB	>TTYNO		RECOVER TTY ID
	CLRA			ZERO HIGH BYTE
	SSR	26		DISPLAY IN DECIMAL
* DISPLAY TTY SPEED
	SSR	24		OUTPUT MESSAGE, NO LFCR
	FCCZ	' : Speed='
	LDA	3,U		READ 6551 CONTROL REGISTER
	ANDA	#%00001111	MASK OFF EVERYTHING BUT SPEED
	LDX	#SPDTAB		POINT TO SPEED TABLE
	SSR	32		DISPLAY SPEED FROM TABLE
* DISPLAY TTY PARITY
	SSR	24		OUTPUT A MESSAGE
	FCCZ	', Parity='
	LDA	2,U		READ CONTROL REGISTER
	BITA	#%00100000	IS PARITY ENABLED?
	BNE	SHOW1		YES, OBTAIN PROPER PARITY BITS
	LDA	#4		INDICATE NO PARITY
	BRA	SHOW2		AND CONTINUE DISPLAY
SHOW1	LSRA			SHIFT
	LSRA			PARITY
	LSRA			BITS
	LSRA			INTO
	LSRA			LOWEST
	LSRA			ORDER BITS
SHOW2	LDX	#PARTAB		POINT TO PARITY TABLE
	SSR	32		DISPLAY PARITY FROM TABLE
* DISPLAY TTY BITS PER CHARACTER
	SSR	24		OUTPUT MESSAGE
	FCCZ	', Bits/Char='
	LDA	3,U		READ CONTROL MESSAGE
	LSRA			SHIFT
	LSRA			BITS/CHAR
	LSRA			INTO
	LSRA			LOWEST
	LSRA			ORDER BITS
	COMA			REVERSE ORDER OF BITS
	ANDA	#%00000011	AND REMOVE ANYTHING ELSE
	ADDA	#'5'		CONVERT TO A PRINTABLE CHARACTER
	SSR	33		OUTPUT TO CONSOLE
* DISPLAY TTY STOP BITS
	SSR	24		OUTPUT MESSAGE
	FCCZ	', Stop bits='
	LDA	3,U		READ CONTROL REGISTER
	ROLA			SHIFT IT OUT INTO CARRY
	ROLA			BRING IT BACK IN LOWEST ORDER BIT
	ANDA	#%00000001	REMOVE EVERYTHING ELSE
	ADDA	#'1'		CONVERT TO A PRINTABLE CHARACTER
	SSR	33		OUTPUT TO CONSOLE
	SSR	22		NEW LINE
	CLRA			ZERO RETURN CODE
	RTS			RETURN TO CALLER
*
* TTY SETTINGS WERE SUPPLIED, ALTER THISE SETTINGS
*
SETTTY	LDD	2,U		GET TTY COMMAND & CONTROL REGISTES
	STD	>SAVURT		SAVE IT FOR LATER REFERENCE
SETT1	LDX	#TTYTAB		POINT TO OPTION TABLE
	SSR	18		LOOK UP OPERAND IN TABLE
	LDA	,Y+		AND GET FOLLOWING CHARACTER
	CMPA	#'='		INSURE ITS AN EQUALS SIGN
	LBNE	BADOPR		IF NOT, ITS INVALID
* SET TTY PARITY
	TSTB			SETTING PARITY?
	BNE	SETT3		NO, TRY NEXT
	LDX	#PARTAB		POINT TO PARITY TABLE
	SSR	18		LOOK IT UP
	CMPB	#4		IN RANGE?
	BHI	BADOPR		NO, REPORT ERROR
	BEQ	SETT2		'NO' PARITY HAS BEEN SELECTED
	LDA	#64		SHIFT 'B'
	MUL			OVER BY 6
	ORB	#%00100000	ENABLE PARITY
SETT2	ANDB	#%11100000	REMOVE ALL OTHER TRASH
	PSHS	B		SAVE SO WE CAN 'OR' IN WITH ACC
	LDB	>SAVURT		GET SAVED COMMAND REGISTER
	ANDB	#%00011111	MASK OUT PARITY
	ORB	,S+		INCLUDE NEW PARITY
	STB	>SAVURT		RESAVE COMMAND REGISTER
	BRA	SETT7		LOOK FOR ANOTHER PARAMETER
* SET TTY BITS/CHAR
SETT3	DECB			SETTING BITS/CHAR ?
	BNE	SETT4		NO, TRY NEXT
	SSR	6		GET # BITS
	TFR	X,D		COPY IN ACCUMULATOR FOR ARITHMETICS
	SUBD	#5		CONVERT TO ZERO OFFSET
	CMPD	#4		IN RANGE OF (5-8)?
	BHS	BADOPR		NO, REPORT ERROR
	COMB			CONVERT TO REVERSE SENSE (8-5)
	LDA	#32		SHIFT 'B' OVER BY
	MUL			FIVE BITS
	ANDB	#%01100000	REMOVE EVERYTHING ELSE
	PSHS	B		SAVE SO WE CAN 'OR' IN WITH ACC
	LDB	>SAVURT+1	GET SAVED CONTROL REGISTER
	ANDB	#%10011111	REMOVE BITS/CHAR
	BRA	SETT6		SAVE NEW VALUE & CONTINUE
* SET TTY STOP BITS
SETT4	DECB			SETTING STOP BITS ?
	BNE	SETT5		NO, TRY NEXT
	SSR	6		GET NUMBER
	TFR	X,D		COPY TO ACCUMULATOR FOR ARITHMETICS
	SUBD	#1		CONVERT TO ZERO OFFSET
	CMPD	#1		IS IT IN RANGE?
	BHI	BADOPR		NO, REPORT ERROR
	RORB			SHIFT IT OUT TO CARY
	RORB			SHIFT IT IN TO HIGHEST BIT
	ANDB	#%10000000	REMOVE EVERYTHING ELSE
	PSHS	B		SAVE SO WE CAN 'OR' IN WITH ACC
	LDB	>SAVURT+1	GET SAVED CONTROL REGISTER
	ANDB	#%01111111	REMOVE STOP BITS
	BRA	SETT6		SAVE NEW VALUE & CONTINUE
* SET TTY SPEED
SETT5	DECB			SETTING SPEED?
	BNE	BADOPR		NO, REPORT ERROR
	LDX	#SPDTAB		POINT TO SPEED TABLE
	SSR	18		LOOK IT UP
	CMPB	#16		IN RANGE?
	BHS	BADOPR		NO, REPORT ERROR
	PSHS	B		SAVE SO WE CAN 'OR' WITH ACC
	LDB	>SAVURT+1	GET SAVED CONTROL REGISTER
	ANDB	#%11110000	REMOVE SPEED
SETT6	ORB	,S+		INCLUDE PREVIOUSLY SAVED VALUE
	STB	>SAVURT+1	RESAVE CONTROL REGISTER
* CONTINUE PARSING FOR MORE OPERANDS
SETT7	SSR	4		MORE OPERANDS?
	LBNE	SETT1		YES, EVALUATE THEM
	LDD	>SAVURT		GET NEW COMMAND & CONTROL
	CLR	1,U		RESET UART
	STD	2,U		WRITE NEW FORMAT & CONTROL REGISTERS
	CLRA			ZERO RETURN CODE
	RTS			RETURN TO CALLER
* INVALID OPERAND, REPORT ERROR & RETURN
BADOPR	SSR	43		ISSUE CANNED MESSAGE
	RTS			RETURN TO CALLER
* DEVICE IS NOT INSTALLED
NODEV	SSR	25		OUTPUT MESSAGE
	FCCZ	'Device not installed.'
	SSR	50		INDICATE INVALID DEVICE
	RTS
* CANNOT ACCESS DEVICE ADDRESS
BADEV	SSR	25		OUTPUT MESSAGE
	FCCZ	'Device has fixed communication format.'
	SSR	50		INDICATE INVALID DEVICE
	RTS
* DEVICE IS NOT MODIFIABLE
*
* STANDARD DOS FORMAT TABLES
*
* OPTIONS TABLE
TTYTAB	FCB	$81
	FCC	'PARITY'
	FCB	$81
	FCC	'BITS'
	FCB	$82
	FCC	'STOP'
	FCB	$82
	FCC	'SPEED'
	FCB	$80
* PARITY TABLE
PARTAB	FCB	$81
	FCB	'ODD'
	FCB	$81
	FCC	'EVEN'
	FCB	$81
	FCC	'MARK'
	FCB	$81
	FCC	'SPACE'
	FCB	$81
	FCC	'NONE'
	FCB	$80
* SPEED TABLE
SPDTAB	FCB	$81
	FCC	'EXTERNAL'
	FCB	$82
	FCC	'50'
	FCB	$82
	FCC	'75'
	FCB	$83
	FCC	'110'
	FCB	$83
	FCC	'134.5'
	FCB	$83
	FCC	'150'
	FCB	$83
	FCC	'300'
	FCB	$83
	FCC	'600'
	FCB	$84
	FCC	'1200'
	FCB	$84
	FCC	'1800'
	FCB	$84
	FCC	'2400'
	FCB	$84
	FCC	'3600'
	FCB	$84
	FCC	'4800'
	FCB	$84
	FCC	'7200'
	FCB	$84
	FCC	'9600'
	FCB	$85
	FCC	'19200'
	FCB	$80
* MISC LOCAL VARIABLES
TTYNO	RMB	1	TTY NUMBER
SAVURT	RMB	2	SAVED UART REGISTERS
