	TITLE	CUBIX QUALIFIER PARSING
*
* This is a sample program which demonstrates the parsing of
* '/' qualifiers, which are recognized by many of the CUBIX
* utility programs.
*
* ?COPY.TXT 1983-2004 Dave Dunfield
*
	ORG	$2000		PROGRAM LOAD ADDRESS
* EXECUTION BEGINS HERE
ENTRY	CMPA	#'?'		HELP REQUEST?
	BNE	QUAL		NO, LOOK FOR QUALIFIERS
	SSR	25		DISPLAY MESSAGE
	FCCZ	'Use: PGMNAME[/FIRST/SECOND ...] <OPERANDS>'
	SSR	0		EXIT TO DOS
* EVALUATE COMMAND LINE QUALIFIERS
QUAL	LDA	,Y		GET CHAR FROM COMMAND LINE
	CMPA	#'/'		QUALIFIER INDICATOR?
	BNE	MAIN		NO, CONTINUE WITH MAIN PGM
	LDX	#QTABLE		POINT TO QUALIFIER TABLE
	SSR	18		LOOK IT UP IN TABLE
	CMPB	#QMAX		DID WE FIND IT?
	BHS	QERR		NO, REPORT ERROR
	LDX	#QFLAGS		POINT TO FLAGS
	CLR	B,X		SET FLAG
	BRA	QUAL		CONTINUE PARSING
* QUALIFIER WAS NOT FOUND, ISSUE ERROR MESSAGE
QERR	SSR	24		ISSUE MESSAGE
	FCCZ	/Invalid qualifier: '/
	LDA	,Y+		GET FIRST CHAR ('/')
QERR1	SSR	33		OUTPUT
	SSR	5		GET NEXT CHAR
	BEQ	QERR2		END, EXIT
	CMPA	#'/'		NEXT QUALIFIER?
	BNE	QERR1		NO, KEEP DISPLAYHING
QERR2	SSR	25		ISSUE MESSAGE
	FCCZ	/'/		CLOSING QUOTE & NEWLINE
	LDA	#1		RC=1 (INVALID OPERAND)
	SSR	0		EXIT TO DOS
*
* MAIN APPLICATION PROGRAM OCCURS HERE
* THIS IS A SAMPLE PROGRAM TO DEMONSTRATE TESTING THE QUALIFIER
* FLAGS SET BY THE "ENTRY" ROUTINE.
*
MAIN	TST	FIRST		WAS FIRST QUALIFIER GIVEN?
	BNE	MAIN1		NO, IT WASN'T
	SSR	25		DISPLAY MESSAGE
	FCCZ	'First qualifier was given'
MAIN1	TST	SECOND		WAS SECOND QUALIFIER GIVEN?
	BNE	MAIN2		NO, IT WASN'T
	SSR	25		DISPLAY MESSAGE
	FCCZ	'Second qualifier was given'
MAIN2	CLRA			ZERO RETURN CODE
	SSR	0		EXIT TO DOS
*
* QUALIFIER TABLE
*
QTABLE	FCB	$81		REQUIRE AT LEAST '/F'
	FCC	'/FIRST'	FIRST QUALIFIER
	FCB	$81		REQUIRE AT LEAST '/S'
	FCC	'/SECOND'	SECOND QUALIFIER
	FCB	$80		END OF TABLE
QMAX	EQU	2		NUMBER OF QUALIFIERS SUPPORTED
*
* THE FOLLOWING VARIABLES ARE CALCULATED AS AN OFFSET FROM
* "QFLAGS", AND ARE SET TO ZERO WHENEVER THE CORRESPONDING
* QUALIFIER FROM "QTABLE" WAS PASSED TO THE COMMAND
*
QFLAGS	EQU	*		QUALIFIER FLAGS GO HERE
FIRST	FCB	-1		FIRST QUALIFIER FLAG
SECOND	FCB	-1		SECOND QUALIFIER FLAG
