**************************************************************
*                           INTIO                            *
*------------------------------------------------------------*
* This is the standard DOS INTIO utility, which installs  an *
* interrupt input driver for a 6551 serial port. In addition *
* to buffered input, a complete software flow control scheme *
* employing XON/XOFF (DC1/DC3) characters is implemented.    *
*------------------------------------------------------------*
*             ?COPY.TXT 1983-2004 Dave Dunfield              *
**************************************************************
	ORG	OSUTIL
* INTERRUPT HARDWARE ADDRESSES
UART1	EQU	$0000		FIRST UART ADDRESS
UART2	EQU	$0004		SECOND UART ADDRESS
* MISC CONSTANTS
WINDOW	EQU	10		FLOW CONTROL WINDOW
XOFF	EQU	'S'-$40		XOFF CODE
XON	EQU	'Q'-$40		XON CODE
*
INTIO	CMPA	#'?'		QUERY?
	BNE	QUAL		SHOW HOW IT'S DONE
	SSR	25		DISPLAY MESSAGE
	FCCZ	'Use: INTIO[/OFF] [<device>]'
	RTS
* PARSE FOR COMMAND QUALIFIERS
QUAL	LDA	,Y		GET CHAR FROM COMMAND LINE
	CMPA	#'/'		IS IT A QUALIFIER?
	BNE  	MAIN		NO, GET PARAMETERS
	LDX	#QTABLE		POINT TO QUALIFIER TABLE
	SSR	18		LOOK IT UP
	CMPB	#QMAX		IS IT IN RANGE
	BHS	QERR		IF SO, IT'S INVALID
	LDX  	#QFLAGS		POINT TO QUALIFIER FLAGS
	CLR	B,X		SET THE FLAG
	BRA	QUAL		LOOK FOR ANOTHER QUALIFIER
QERR	SSR	24		DISPLAY MESSAGE
	FCCZ	/Invalid qualifier: '/
	LDA	,Y+		GET CHARACTER
DSQU1   SSR	33		DISPLAY
	LDA	,Y+		GET NEXT CHAR
	BEQ	GOABO		NULL IS DELIMITER
	CMPA	#'/'		START OF ANOTHER QUALIFIER?
	BEQ	GOABO		IF SO, QUIT
	CMPA	#' '		SPACE?
	BEQ	GOABO		IF SO, QUIT
	CMPA	#$0D		END OF LINE?
	BNE	DSQU1		NO, KEEP DUMPING
GOABO   SSR	25		DISPLAY MESSAGE
	FCB	$27,0		CHARACTERS TO DISPLAY
	LDA	#1		INVALID OPERAND RETURN CODE
	RTS
* MAINLINE CODE
MAIN	LDA	ACTIVE		GET ACTIVE COUNT
	INC	ACTIVE		ADVANCE COUNT
	CMPA	#16		PAST I/O DRIVERS?
	BHS	MAIN1		IF SO, WE ARE FINISHED
	SSR	102		LOOKUP ENTRY
	CMPD	#DRIVER		ALREADY INSTALLED?
	BNE	MAIN		NO, ITS NOT
	CLR	ACTIVE		INDICATE INSTALLED
MAIN1	LDA	OFF		CLOSING FILE?
	BEQ	DOCLOSE		YES, CLOSE IT
	SSR	4		MORE OPERANDS?
	BNE	MAIN2		YES, TAKE THEM
* NO DEVICE SPECIFIED, USE CONSOLE
	SSR	40		GET CURRENT CONSOLE
	BRA	MAIN3		AND CONTINUE
* DEVICE IS SPECIFIED
MAIN2	SSR	6		GET DEVICE ID
	TFR	B,A		COPY TO 'A'
MAIN3	CMPA	#8		IN RANGE?
	BLO	OPEN		YES, ITS OK
* INVALID DEVICE SPECIFIED
	SSR	50		OUTPUT 'INVALID DEVICE' MESSAGE
ABORT	RTS
*
* REMOVE INTERRUPT DRIVEN I/O
*
DOCLOSE	TST	ACTIVE		ALREADY ACTIVE?
	BNE	ERROR1		NO, REPORT ERROR
DOCL1	LDX	SIDRIVE		GET OLD INPUT DRIVER
	LDA	DEVICE		GET VECTOR ID
	SSR	103		REPLACE VECTOR
	LDX	SODRIVE		GET OLD OUTPUT DRIVER
	LDA	DEVICE		GET VECTOR ID
	ADDA	#8		OFFSET TO OUTPUT DRIVERS
	SSR	103		REPLACE VECTOR
	LDX	DRIVER+1	GET DEVICE ADDRESS
	LDA	2,X		GET COMMAND REGISTER
	ORA	#%00000010	DISABLE RECEIVE INTERRUPT
	STA	2,X		RESAVE
	ORCC	#%00010000	MASK 'IRQ'
	LDX	SVECTOR		GET OLD IRQ VECTOR
	LDA	#23		IRQ VECTOR
	SSR	103		RESTORE IRQ VECTOR
	CLRA			ZERO RETURN CODE
	RTS
* INTIO IS NOT ACTIVE, CANNOT CLOSE
ERROR1	SSR	25		OUTPUT MESSAGE
	FCCZ	'INTIO is not active.'
	LDA	#101		RETURN CODE
	RTS
*
* ESTABLISH INTERRUPT DRIVEN I/O
*
OPEN	TST	ACTIVE		ALREADY ACTIVE?
	LBEQ	ERROR2		YES, REPORT ERROR
* READ OPERATION, INSTALL INPUT DRIVER
	STA	DEVICE		SAVE DEVICE ID
	LDX	#IDRIVER	POINT TO INPUT DRIVER
* COPY DRIVER OVER
INSTALL	LDY	#DRIVER		POINT TO DRIVER
	LDB	#DRSIZE		SIZE OF DRIVERS
INST1	LDA	,X+		GET CHAR
	STA	,Y+		COPY IT OVER
	DECB			DECREMENT COUNT
	BNE	INST1		CONTINUE
* TAKE OVER DEVICE INPUT VECTOR
	LDA	DEVICE		GET DEVICE ID
	SSR	102		READ VECTOR
	TFR	D,X		POINT TO DRIVER
	LDA	,X+		GET FIRST INSTRUCTION
	CMPA	#$8E		IS IT 'LDX'
	LBNE	ERROR3		NO, REPORT ERROR
	LDX	,X		GET DEVICE ADDRESS
	STX	DRIVER+1	SET DEVICE INPUT ADDRESS
	STX	DRIVER+IDSIZE+1	SET DEVICE OUTPUT ADDRESS
* ENABLE DEVICE INTERRUPTS
	LDA	2,X		GET COMMAND REGISTER
	ANDA	#%11111101	ALLOW RECEIVE IRQ
	STA	2,X		RE-WRITE
* PATCH INTO OPERATING SYSTEM DRIVERS
	LDX	#DRIVER		POINT TO INPUT DRIVER
	LDA	DEVICE		GET DEVICE ID
	SSR	103		SET DEVICE DRIVER
	STD	SIDRIVE		SAVED DRIVER ADDRESS
	LEAX	IDSIZE,X	OFFSET TO OUTPUT DRIVER
	LDA	DEVICE		GET DEVICE ID
	ADDA	#8		OFFSET TO OUTPUT DRIVERS
	SSR	103		SET DEVICE DRIVER
	STD	SODRIVE		SAVE OUTPUT DRIVER
	LEAX	ODSIZE,X	OFFSET TO IRQ HANDLER
	LDA	#23		'IRQ' VECTOR
	SSR	103		SET VECTOR
	STD	SVECTOR		SAVED IRQ VECTOR
* MISC. INIT OF DRIVERS
	CLRA			ZERO HIGH
	CLRB			ZERO LOW
	STD	RDPTR		ZERO POINTERS
	LDD	#XON+=XON	GET DOUBLE XON
	STD	SPCSND		SET SPECIAL CHARS TO SEND
* CLEAR OUT ANY PENDING INTERRUPTS FROM THE SERIAL PORTS
* THIS SHOULD ACCESS ALL 6551'S WHICH MAY BE WIRE-OR'ED
* TOGETHER ON A COMMON INTERRUPT LINE.
	LDB	#10		LOOP 10 TIMES
CLUART	LDA	>UART1+1	CLEAR UART1 DATA
	LDA	>UART2+1	CLEAR UART2 DATA
	DECB			REDUCE COUNT
	BNE	CLUART		LOOP 'B' TIMES
	CLR	FLOW		ZERO FLOW CONTROL FLAG
	ANDCC	#%11101111	ALLOW INTERRUPTS
	RTS
* INTIO IS ALREADY ACTIVE, REPORT ERROR
ERROR2	SSR	25		OUTPUT MESSAGE
	FCCZ	'INTIO is already active.'
	LDA	#100		RETURN CODE
	RTS
* NOT A SERIAL DEVICE
ERROR3	SSR	25		OUTPUT MESSAGE
	FCCZ	'Not a serial device.'
	LDA	#103		RETURN CODE
	RTS
*
* INPUT DRIVER
*
IDRIVER	LDX	#0		GET DEVICE ADDRESS
	LDB	RDPTR		GET READ POINTER
	CMPB	WRPTR		SAME AS WRITE POINTER?
	BEQ	IDRIV2		NO DATA TO SEND
	LDX	#BUFFER		POINT TO BUFFER
	LDA	B,X		GET CHAR
	INCB			ADVANCE 'B'
	ANDB	#%00111111	MASK FOR CIRCULAR BUFFER
	STB	RDPTR		RESAVE READ POINTER
	CMPB	WRPTR		ARE WE BACK TO ZERO?
	BNE	IDRIV1		NO, ITS OK
	LDB	#XON		GET XON CHARACTER
	STB	SPCSND		SPECIAL TO SEND	
IDRIV1	ORCC	#%00000100	SET 'Z'
	RTS
IDRIV2	LDA	#$FF		INDICATE NO CHAR READY
	RTS
IDSIZE	EQU	*-IDRIVER	SIZE OF INPUT DRIVER
*
* OUTPUT DRIVER
*
ODRIVER	LDX	#0		GET DEVICE ADDRESS
ODRI1	ORCC	#%00010000	MASK INTERRUPTS
	LDB	1,X		READ STATUS REGISTER
	PSHS	A,B,U		SAVE REGS
	BSR	RDSTAT		HANDLE RECEIVED CHARACTERS
	PULS	A,B,U		RESTORE REGS
	ANDCC	#%11101111	ALLOW INTERRUPTS
	BITB	#%00010000	OK TO TRANSMIT?
	BEQ	ODRI1		NO, WAIT FOR IT
	LDB	FLOW		ARE WE FLOW CONTROLLED?
	BNE	ODRI1		YES, WAIT FOR IT
	STA	,X		WRITE DATA
	RTS
* READ UART STATUS, & HANDLE RECEIVED CHARACTERS
* IF ANY FLOW CONTROL, HANDLE IT
RDSTAT	LDA	SPCSND		SPECIAL TO SEND
	CMPA	SPCOLD		SAME AS OLD?
	BEQ	RDST0		NO, ITS OK
	BITB	#%00010000	XMITTER READY?
	BEQ	RDST0		NO, SKIP IT
	STA	,X		WRITE TO UART
	STA	SPCOLD		SAVE LAST SENT
	ANDB	#%11101111	INDICATE XMITTER BUSY
RDST0	BITB	#%00001000	TEST FOR RECEIVER READY
	BEQ	RDST3		NOT READY, IGNORE
	LDA	,X		READ RECEIVER DATA
	CMPA	#XOFF		XOFF CODE?
	BNE	RDST1		NO, TRY XOFF
	STA	FLOW		SET FLAG
	RTS			AND CONTINUE
RDST1	CMPA	#XON		XON CODE?
	BNE	RDST2		NO, NORMAL DATA
	CLR	FLOW		ZERO FLAG
	RTS			AND CONTINUE
* NORMAL DATA RECEIVED, BUFFER IT
RDST2	LDU	#BUFFER		POINT TO BUFFER
	LDB	WRPTR		GET WRITE POINTER
	STA	B,U		SAVE DATA
	INCB			ADVANCE TO NEXT
	ANDB	#%00111111	MASK FOR CIRCULAR BUFFER
	STB	WRPTR		RESAVE
	ADDB	#WINDOW		OFFSET BY WINDOW
	ANDB	#%00111111	MASK FOR CIRCULAR BUFFER
	CMPB	RDPTR		ARE WE CATCHING UP?
	BNE	RDST3		NO, WE ARE OK
* NEARING BUFFER FULL, SEND XOFF TO HOST
	LDA	#XOFF		GET 'XOFF'
	STA	SPCSND		SPECIAL CHAR TO SEND
RDST3	RTS
ODSIZE	EQU	*-ODRIVER	SIZE OF OUTPUT DRIVER
*
* INTERRUPT HANDLER
*
IRQ	LDX	DRIVER+1	GET DEVICE ADDRESS
	LDB	1,X		READ UART STATUS
	BSR	RDSTAT		HANDLE RECEIVED CHARS
	RTI
DRSIZE	EQU	*-IDRIVER	SIZE OF ALL DRIVERS
* QUALIFIER TABLE
QTABLE	FCB	$82
	FCC	'/OFF'
	FCB	$80		END OF TABLE
QMAX	EQU	1
QFLAGS	EQU	*
OFF	FCB	$FF		ASSIGN FOR WRITE
ACTIVE	FCB	0		ACTIVE COUNT
* GLOBAL LOCATIONS
	ORG	OSEND-DSIZE	1K FROM TOP OF RAM
DEVICE	RMB	1		INPUT DEVICE
SIDRIVE	RMB	2		SAVED INPUT DRIVER VECTOR
SODRIVE	RMB	2		SAVED OUTPUT DRIVER VECTOR
SVECTOR	RMB	2		SAVED IRQ ADDRESS
FLOW	RMB	1		FLOW CONTROL FLAG
SPCSND	RMB	1		SPECIAL CHARACTER TO SEND
SPCOLD	RMB	1		LAST SPECIAL CHARACTER SENT
RDPTR	RMB	1		READ POINTER
WRPTR	RMB	1		WRITE POINTER
BUFFER	RMB	64		INPUT BUFFER
DRIVER	RMB	DRSIZE		DRIVER GOES HERE
DSIZE	EQU	*-DEVICE	SIZE OF LOCAL STORAGE
