	TITLE	SAMPLE CUBIX I/O DRIVERS
***************************************************************
*     Sample I/O drivers for the CUBIX operating system.      *
*-------------------------------------------------------------*
* The drivers are designed to deal with four 6551 type serial *
* devices, and a 765 type floppy disk controller controlling  *
* up to four standard 40 track single or double sided floppy  *
* diskette drives.                                            *
*-------------------------------------------------------------*
* Although these drivers are fully functional and may be used *
* in a port of the system, their primary purpose is intended  *
* to be as an example of CUBIX to I/O driver interfaceing. As *
* such the device control side of the drivers (Which will be  *
* VERY system specific) has been kept very simple and easy to *
* follow. In particular, no interrupt lines are used, and all *
* I/O operations are accomplished via software polling.       *
*-------------------------------------------------------------*
*             ?COPY.TXT 1983-2004 Dave Dunfield               *
***************************************************************
*
* CUBIX SYSTEM ADDRESSES
*
DRIVERS	EQU	$F99F		FIRST FREE LOCATION IN ROM
SSR	EQU	$E00B		ADDRESS OF SSR HANDLER
*
* HARDWARE I/O ADDRESSES
*
UART1	EQU	$0000		SERIAL PORT 1
UART2	EQU	$0100		SERIAL PORT 2
UART3	EQU	$0200		SERIAL PORT 3
UART4	EQU	$0300		SERIAL PORT 4
FDCS	EQU	$0400		FDC STATUS REG
FDCD	EQU	$0401		FDC COMMAND/DATA REG
FDCTC	EQU	$0500		FDC TERMINAL COUNT & RESET
*
* DISK CONTROL BLOCK FORMAT
*
	ORG	0
DRIVE	RMB	1		DRIVE ID (ADDRESS)
NCYL	RMB	1		NUMBER OF CYLINDERS
NHEAD	RMB	1		NUMBER OF HEADS
NSEC	RMB	1		NUMBER OF SECTORS/TRACK
CYL	RMB	1		CURRENT CYLINDER
HEAD	RMB	1		CURRENT HEAD
SEC	RMB	1		CURRENT SECTOR
*
	ORG	DRIVERS
*
* INITIALIZE SYSTEM HARDWARE. ON ENTRY 'Y'
* POINTS TO SYSTEM TABLE TO BE FILLED IN.
*
* INITIALIZE CUBIX SYSTEM TABLE
HWINIT	CLR	>FDCTC		RESET FDC
	LDX	#RITAB		POINT TO OUR TABLE
	LDB	#RISIZ		SIZE OF TABLE
HWIN1	LDA	,X+		GET A BYTE FROM TABLE
	STA	,Y+		WRITE IT TO CUBIX RAM
	DECB			REDUCE COUNT
	BNE	HWIN1		MOVE ENTIRE TABLE
* INITIALIZE THE DISK SYSTEM
	LDA	>FDCTC		UN-RESET FDC
	LDA	#$03		SPECIFY COMMAND
	JSR	WRFDC		OUTPUT TO FDC
	LDA	#$DF		6 MS STEP, 480 MS HEAD UNLOAD
	JSR	WRFDC		OUTPUT TO FDC
	LDA	#$FF		508 MS HEAD LOAD, NON-DMA MODE
	JSR	WRFDC		OUTPUT TO FDC
* INITIALIZE SERIAL PORTS
	LDD	#$AB3E		9600, MARK PARITY, 7 DATA, 1 STOP
	LDX	#UART1		POINT TO FIRST UART
HWIN2	CLR	1,X		RESET UART
	STD	2,X		INITIALIZE CONTROL REGISTERS
	LEAX	4,X		ADVANCE TO NEXT
	CMPX	#UART4		ARE WE AT END?
	BLS	HWIN2		DO THEM ALL
	LDA	#$0A		LINE FEED
	BSR	WRSER1		OUTPUT TO CONSOLE DEVICE
	LDA	#$0D		CARRIAGE RETURN
* NOTE: HWINIT FALLS INTO WRSER1, CAUSING ITS LAST OPERATION
*       TO BE AN OUTPUT TO THIS DEVICE (THE CONSOLE).
*
* SERIAL PORT WRITE DRIVERS
*
WRSER1	LDX	#UART1		ADDRESS OF UART 1
	BRA	WRSER		OUTPUT ROUTINE
WRSER2	LDX	#UART2		ADDRESS OF UART 2
	BRA	WRSER		OUTPUT ROUTINE
WRSER3	LDX	#UART3		ADDRESS OF UART 3
	BRA	WRSER		OUTPUT ROUTINE
WRSER4	LDX	#UART4		ADDRESS OF UART 4
* WRITE CHARACTER(A) TO UART(X)
WRSER	LDB	1,X		GET STATUS
	BITB	#%00010000	IS TX READY
	BEQ	WRSER		NO, WAIT FOR IT
	STA	,X		WRITE DATA
	RTS
*
* SERIAL PORT READ DRIVERS
*
RDSER1	LDX	#UART1		ADDRESS OF UART 1
	BRA	RDSER		INPUT ROUTINE
RDSER2	LDX	#UART2		ADDRESS OF UART 2
	BRA	RDSER		INPUT ROUTINE
RDSER3	LDX	#UART3		ADDRESS OF UART 3
	BRA	RDSER		INPUT ROUTINE
RDSER4	LDX	#UART4		ADDRESS OF UART 4
* READ CHARACTER FROM UART(X)
RDSER	LDA	1,X		GET STATUS REGISTER
	BITA	#%00001000	IS RX READY
	BEQ	RDNULL		NO, INDICATE NO CHAR
	LDA	,X		GET DATA CHAR
	ORCC	#%00000100	SET 'Z'
	RTS
* NULL DEVICE DRIVERS
RDNULL	LDA	#$FF		INDICATE NO CHARACTER
WRNULL	RTS			IGNORE OPERATION
*
* FORMAT DISK ('U' POINTS TO DCB), INTERLEAVE FACTOR IN 'A'
*
DFORMAT	PSHS	A		SAVE INTERLEAVE FACTOR
	JSR	DHOME		INSURE HEAD ON REAL TRACK 0
* CALCULATE INTERLEAVE SPACEING: 'N'=(NSEC+1)/INTERLEAVE
	LDA	NSEC,U		GET NUMBER SECTORS
	INCA			+1 FOR EVEN
	LDB	#-1		START WITH -1
FORM1	INCB			ADVANCE RESULT
	SUBA	,S		SUBTRACT INTERLEAVE
	BPL	FORM1		KEEP GOING
	PSHS	A,B		TWO BYTES TEMP SPACE
	CLR	CYL,U		START WITH CYLINDER 0
* FORMAT ONE CYLINDER
FORCYL	JSR	DSEEK		MOVE TO THE CYLINDER
	CLR	HEAD,U		START WITH BOTTOM HEAD
* FORMAT ONE HEAD
FORHED	CLR	SEC,U		START WITH SECTOR ZERO
	CLR	2,S		INIT TO SECTOR ZERO
	LDA	#$4D		FORMAT COMMAND
	JSR	WRFDC		OUTPUT TO FDC
	LDA	HEAD,U		GET CURRENT HEAD
	ASLA			SHIFT INTO...
	ASLA			PROPER POSITION
	ORA	DRIVE,U		INCLUDE DRIVE
	JSR	WRFDC		OUTPUT TO FDC
	LDA	#$02		512 BYTES/SECTOR
	JSR	WRFDC		OUTPUT TO FDC
	LDA	NSEC,U		SECTORS/TRACK
	STA	,S		SET COUNT
	JSR	WRFDC		OUTPUT TO FDC
	LDA	#$50		GAP LENGTH ($38 FOR 10 S/TRK)
	JSR	WRFDC		OUTPUT TO FDC
	LDA	#$E5		FILLER BYTE
	JSR	WRFDC		OUTPUT TO FDC
* FORMAT ONE SECTOR
FORSEC	LDB	CYL,U		GET CYLINDER ID
FORS1	LDA	>FDCS		READ FDC STATUS
	BPL	FORS1		WAIT TILL READY FOR DATA
	STB	>FDCD		WRITE TRACK TO FDC
	LDB	HEAD,U		GET HEAD ID
FORS2	LDA	>FDCS		READ FDC STATUS
	BPL	FORS2		WAIT TILL READY FOR DATA
	STB	>FDCD		WRITE HEAD TO FDC
	LDB	SEC,U		GET SECTOR ID
FORS3	LDA	>FDCS		READ FDC STATUS
	BPL	FORS3		WAIT TILL READY FOR DATA
	STB	>FDCD		WRITE SECTOR TO FDC
	ADDB	1,S		ADD 'N' (INTERLEAVE SPACEING)
	CMPB	NSEC,U		OVER?
	BLO	FORS4		NO, ITS OK
	INC	2,S		NEXT STARTING SECT
	LDB	2,S		GET IN CURRENT
FORS4	STB	SEC,U		RESAVE CURRENT
	LDB	#$02		512 BYTES/SECTOR
FORS5	LDA	>FDCS		READ FDC STATUS
	BPL	FORS5		WAIT TILL READY FOR DATA
	STB	>FDCD		WRITE DATA BYTE
	DEC	,S		REDUCE COUNT OF SECTORS
	BNE	FORSEC		MORE, DO NEXT
	BSR	RESULT		EVERYTHING OK?
	INC	HEAD,U		MOVE TO NEXT HEAD
	LDA	HEAD,U		GET VALUE
	CMPA	NHEAD,U		HAVE WE DONE EM ALL?
	BLO	FORHED		NO, DO NEXT HEAD
	INC	CYL,U		MOVE TO NEXT CYLINDER
	LDA	CYL,U		GET VALUE
	CMPA	NCYL,U		HAVE WE DONE EM ALL?
	BLO	FORCYL		NO, DO NEXT CYLINDER
	LEAS	3,S		CLEAN UP STACK
	RTS
*
* HOME HEAD ON DRIVE ('U' POINTS TO DCB)
*
DHOME	LDA	#$07		GET RESYNC COMMAND
	JSR	WRFDC		OUTPUT TO FDC
	LDA	DRIVE,U		GET DRIVE ID
	BRA	DSEE1		WRITE AND WAIT FOR COMPLETE
*
* SEEK TO CYLINDER ON DRIVE ('U' POINTS TO DCB)
*
DSEEK	LDA	#$0F		SEEK COMMAND
	JSR	WRFDC		OUTPUT TO FDC
	LDA	DRIVE,U		GET DRIVE
	JSR	WRFDC		OUTPUT TO FDC
	LDA	CYL,U		GET CYLINDER ID
DSEE1	JSR	WRFDC		OUTPUT TO FDC
* WAIT FOR SEEK TO COMPLETE
DSEE2	LDA	#$08		SENSE INTERRUPT COMMAND
	JSR	WRFDC		OUTPUT TO FDC
	JSR	RESULT		CLEAR OUT RESULT(S)
	LDB	>FDCS		READ SEEK STATUS
	BITB	#%00001111	ANY DRIVES SEEKING?
	BNE	DSEE2		YES, WAIT FOR THEM
	RTS
*
* READ A SECTOR, FROM DISK ('U' POINTS TO DCB) TO MEMORY(X)
*
DRDSEC	BSR	DSEEK		PERFORM SEEK
	LDA	#$46		READ DATA COMMAND
	BSR	WRHEAD		OUTPUT INFO
RDS1	LDA	>FDCS		GET STATUS
	BPL	RDS1		NOT READY
	BITA	#%00100000	EXECUTION MODE?
	BEQ	WRS3		NO, ERROR
	LDA	>FDCD		GET DATA
	STA	,X+		WRITE IT
	LEAY	-1,Y		REDUCE COUNT
	BNE	RDS1		KEEP GOING
	BRA	WRS3		HIT 'TC' & GET RESULTS
*
* WRITE A SECTOR TO DISK ('U' POINTS TO DCB) FROM MEMORY(X)
*
DWRSEC	BSR	DSEEK		PERFORM SEEK
	LDA	#$45		WRITE DATA COMMAND
	BSR	WRHEAD		OUTPUT
WRS1	LDB	,X+		GET DATA
WRS2	LDA	>FDCS		GET STATUS
	BPL	WRS2		NOT READY
	BITA	#%00100000	EXECUTION MODE?
	BEQ	WRS3		NO, ERROR
	STB	>FDCD		WRITE TO FDC
	LEAY	-1,Y		BACKUP COUNT
	BNE	WRS1		DO NEXT
WRS3	LDA	>FDCTC		INDICATE TRANSFER COMPLETE
*
* OBTAIN RESULTS FROM FDC
*
RESULT	CLR	,-S		ZERO RESULT CODE
	BSR	RDFDC		GET ERROR TYPE
	TFR	A,B		'B' = FDC RESULTS
	BSR	RDFDC		READ STATUS REG#2
	BEQ	RESUL4		NO SECOND REGISTER
* ERROR CODES DETECTED, TRANSLATE
	LDY	#RESTAB		GET TABLE
RESUL1	LSLA			SHIFT OUT
	BCS	RESUL2		FOUND ERROR
	BEQ	RESUL3		NO MORE LEFT
	LEAY	1,Y		ADVANCE 'Y'
	BRA	RESUL1		CONTINUE
RESUL2	LDA	,Y		GET RESULT CODE
	STA	,S		SET RESULT CODE
* CLEAR OUT ANY REMAINING DATA
RESUL3	BSR	RDFDC		READ BYTE FROM FDC
	BNE	RESUL3		CLEAR THEM ALL
RESUL4	BITB	#%11000000	TEST FOR ANY ERRORS
	PULS	A,PC		RESTORE & RETURN
*
* READ DATA BYTE FROM FDC
*
RDFDC	LDA	>FDCS		GET STATUS
	BPL	RDFDC		NOT READY, WAIT
	ANDA	#%01000000	ANY DATA FOR US?
	BEQ	RDFDC1		NO, SKIP IT
	LDA	>FDCD		GET FDC DATA
	ANDCC	#%11111011	INSURE 'Z' CLEAR
RDFDC1	RTS
*
* OUTPUT READ/WRITE HEADER INFO
*
WRHEAD	LDY	#512		BYTES/SECTOR COUNT
	BSR	WRFDC		OUTPUT COMMAND TO FDC
	LDA	HEAD,U		GET HEAD
	ASLA			SHIFT INTO...
	ASLA			PROPER POSITION
	ORA	DRIVE,U		INCLUDE DRIVE
	BSR	WRFDC		OUTPUT TO FDC
	LDA	CYL,U		GET CYLINDER
	BSR	WRFDC		OUTPUT TO FDC
	LDA	HEAD,U		GET HEAD INFO
	BSR	WRFDC		OUTPUT TO FDC
	LDA	SEC,U		GET SECTOR NUMBER
	BSR	WRFDC		OUTPUT TO FDC
	LDA	#$02		512 BYTE SECTORS
	BSR	WRFDC		OUTPUT TO FDC
	LDA	NSEC,U		GET # SECTORS
	DECA			COMPUTE FINAL SECTOR
	BSR	WRFDC		OUTPUT TO FDC
	LDA	#$2A		CAP LENGTH
	BSR	WRFDC		OUTPUT TO FDC
	LDA	#$FF		GET DATA SIZE
*
* WRITE A BYTE TO THE FDC
*
WRFDC	PSHS	A		SAVE DATA BYTE
WRF1	LDA	>FDCS		READ FDC STATUS
	BPL	WRF1		FDC IS NOT READY, WAIT FOR IT
	BITA	#%01000000	TEST DIO BIT
	BNE	WRF2		FDC IS OUT OF SYNC
	PULS	A		RESTORE DATA
	STA	>FDCD		WRITE TO FDC
	RTS
* FDC IS OUT OF SYNC CLEAR IT OUT AND RE-TRY
WRF2	LDA	>FDCD		READ DATA REGISTER
	BRA	WRF1		AND CONTINUE
* IGNORE ANY UNUSED INTERRUPTS
IGNORE	RTI
* RESULT CODES FOR FDC OPERATIONS
RESTAB	FCB	3,0,2,0,0,3,4,1
*
* INITIALIZATION TABLE FOR CUBIX RAM
*
RITAB	EQU	*
* DEFAULT DRIVE CHARACTISTICS
	FCB	0,40,2,9,0,0,0	ADR 0, 40 CYL, 2 HEAD, 9 SEC/TRK
	FCB	1,40,2,9,0,0,0	ADR 1, 40 CYL, 2 HEAD, 9 SEC/TRK
	FCB	2,40,1,9,0,0,0	ADR 2, 40 CYL, 1 HEAD, 9 SEC/TRK
	FCB	3,40,1,9,0,0,0	ADR 3, 40 CYL, 1 HEAD, 9 SEC/TRK
* CONSOLE DEVICE ASSIGNMENTS
	FCB	1		CONSOLE INPUT DEVICE
	FCB	1		CONSOLE OUTPUT DEVICE
* SERIAL DEVICE DRIVERS
	FDB	RDNULL,RDSER1,RDSER2,RDSER3,RDSER4,0,0,0
	FDB	WRNULL,WRSER1,WRSER2,WRSER3,WRSER4,0,0,0
* DISK DEVICE DRIVERS
	FDB	DHOME,DRDSEC,DWRSEC,DFORMAT
* 6809 HARDWARE VECTORS
	FDB	SSR		SWI VECTOR (USED FOR SSR'S)
	FDB	IGNORE		SWI2 VECTOR
	FDB	IGNORE		SWI3 VECTOR
	FDB	IGNORE		IRQ  VECTOR
	FDB	IGNORE		FIRQ VECTOR
	FDB	IGNORE		NMI VECTOR
* MISC FLAGS & VARIABLES
	FCB	$FF		ERROR MESSAGES ENABLED
	FCB	0		TRACE DISABLED
	FCB	0		DEBUG DISABLED
	FCB	0		DEFAULT DRIVE (A)
	FCC	'MAIN'		DEFAULT DIRECTORY
	FCB	0,0,0,0		(FILLER)
	FCB	0		SYSTEM DRIVE (A)
	FCC	'SYSTEM'	SYSTEM DIRECTORY
	FCB	0,0		(FILLER)
RISIZ	EQU	*-RITAB		SIZE OF INITILAIZED RAM
