#include <stdio.h>

char HEADER[] = "CAM 1.6 - ?COPY.TXT 1982-2005 Dave Dunfield.\n";

struct {
	unsigned debounce_count;
	unsigned COM_port;
	unsigned KPD_port;
	unsigned LPT_port;
	unsigned LPT_mask; } *cvars;

char pgm_buffer[32700];
unsigned pgm_size;

unsigned
	debounce_count,
	COM_port,
	KPD_port,
	LPT_port,
	LPT_mask;
char fB, fI, fK, fP1, fP2;
char *cmdptr, debug;

char help[] = { "\nCAMSET - ?COPY.TXT 1998-2005 Dave Dunfield.\n\n\
Use: CAMSET [/Bcount /D /Icom /Kadr /Padr,inv]\n\n\
/Bcount		- Set debounce count\n\
/D		- Enable DEBUG messages (CAMSET only)\n\
/Icom		- Set I/R COM port (0=Disable)\n\
/Kadr		- Set Keypad port address (0=Disable)\n\
/Padr,inv	- Set parallel port address and invert mask\n" };

/*
 * Get a number from the input buffer
 */
unsigned get_dec()
{
	unsigned value;
	char c;
	value = 0;
	while(isdigit(c = *cmdptr)) {
		++cmdptr;
		value = (value * 10) + (c - '0'); }
	return value;
}
unsigned get_hex()
{
	unsigned value;
	char c;
	value = 0;
	for(;;) {
		if(isdigit(c = toupper(*cmdptr)))
			c -= '0';
		else if((c >= 'A') && (c <= 'F'))
			c -= ('A'-10);
		else
			break;
		++cmdptr;
		value = (value << 4) + c; }
	return value;
}

main(int argc, char *argv[])
{
	unsigned i;
	char buffer[50];
	FILE *fp;

	for(i=1; i < argc; ++i) {
		cmdptr = argv[i];
		switch((toupper(*cmdptr++)<<8) | toupper(*cmdptr++)) {
			case '/B' : debounce_count = get_dec();	fB=-1;		break;
			case '/D' : debug = -1;								break;
			case '/I' : COM_port = get_dec();		fI=-1;
				if(COM_port > 4)
					abort("\n/I must be 0(disable) or 1-4\n");	break;
			case '/K' : KPD_port = get_hex();		fK=-1;		break;
			case '/P' : LPT_port = get_hex();		fP1=-1;
				if(*cmdptr++ == ',') {
					LPT_mask = get_hex();
					fP2=-1; }
				break;
			default:
				printf("Bad operand: %s\n", argv[i]);
			case '/?' :
			case '?'<<8 :
				abort(help); } }

	fp = fopen("CAM.COM", "rvqb");
	pgm_size = fget(pgm_buffer, sizeof(pgm_buffer), fp);
	fclose(fp);

	if(debug) printf("Read %u bytes\n", pgm_size);

	for(i=0; i < pgm_size; ++i)
		if(!strcmp(pgm_buffer+i, HEADER))
			goto found;

	abort("\nSignature not found!\n");

found:
	if(debug) printf("Found signature at offset: %04x\n", i);
	cvars = pgm_buffer + (strlen(HEADER)+1) + i;

	if(fB)
		cvars->debounce_count = debounce_count;
	if(fI)
		cvars->COM_port = COM_port;
	if(fK)
		cvars->KPD_port = KPD_port;
	if(fP1) {
		cvars->LPT_port = LPT_port;
		if(fP2)
			cvars->LPT_mask = LPT_mask; }

	printf("\n%-21s: %u\n",  "Debounce count", cvars->debounce_count);
	if(cvars->COM_port)
		itoa(cvars->COM_port, buffer, 10);
	else
		strcpy(buffer, "Disabled");
	printf("%-21s: %s\n",  "I/R COM port", buffer);
	if(cvars->KPD_port)
		itoa(cvars->KPD_port, buffer, 16);
	else
		strcpy(buffer, "Joystick");
	printf("%-21s: %s\n","Keypad port", buffer);
	printf("%-21s: %x\n","Parallel output port", cvars->LPT_port);
	printf("%-21s: %x\n","Parallel invert mask",  cvars->LPT_mask);

	if(fB | fI | fK | fP1) {
		if(debug) printf("Rewriting file.\n");
		fp = fopen("CAM.COM", "wvqb");
		if(fput(pgm_buffer, pgm_size, fp) != pgm_size)
			printf("Write error!");
		fclose(fp);
		printf("Program updated!\n"); }
}
