/*
 * Pen based interface functions
 */
#define	TICK	peekw(0x40,0x6C)

#define	wputs	Wputs
#define	wprintf	Wprintf

unsigned
	X,		// Current X position
	Y,		// Current Y position
	C_Hold;	// Tap-and-Hold configuration
unsigned char
	C_left;	// Scroll left

/*
 * Replacement wputs() function to avoid including the entire
 * high level Micro-c windowing library
 */
void Wputs(unsigned char *p)
{
	while(*p)
		wputc(*p++);
}

/*
 * Replacement wprintf() function to avoid including the entire
 * high level Micro-c windowing library
 */
register Wprintf(unsigned args)
{
	unsigned char temp[81];
	_format_(nargs() * 2 + &args, temp) + 2;
	wputs(temp);
}

/*
 * Initializes the mouse driver, returns with -1 if successful.
 */
init_mouse(void) asm
{
; Initialize & test for mouse
		XOR		AX,AX			; Init functions.
		INT		33h				; Call mouse driver
		AND		AX,AX			; Mouse present
		JZ		initm1			; No, skip it
; Set mouse limits (some drivers do not do it properly on reset)
		XOR		CX,CX			; Lower limit is zero
		MOV		DX,639			; Upper horizontal limit
		MOV		AX,7			; Set horizontal limit
		INT		33h				; Call mouse driver
		MOV		DX,479			; Upper vertical limit
		MOV		AX,8			; Set vertical limit
		INT		33h				; Call mouse driver
		MOV		AX,-1			; Indicate mouse ok
initm1:
}

/*
 * Report on mouse status:
 *
 * Returns:
 *	0xFF01	= Tap
 *  0xFF02	= Tap and Hold
 *  xxxx	= Keypress
 */
unsigned mouse_status()
{
	unsigned lx, ly, t;
	unsigned char C_value, C_value1;
	unsigned b, x, y;
	static unsigned
		C_offset = 1,		// Calculated video offset to cursor
		C_timer;			// Timer for cursor flash
	static unsigned char
		flag = 0,			// Button press flag
		C_step;				// Step for cursor flash

	C_value = peek(W_BASE, C_offset);
	C_value1 = (C_value >> 4) | (C_value << 4);
	for(;;) {
		asm {
			MOV		AX,0003h	; Mouse status function
			INT		33h			; Call mouse driver
			MOV		-6[BP],BX	; Save B
			MOV		-4[BP],CX	; Save X
			MOV		-2[BP],DX	; Save Y
		}
		x /= 8;
		y /= 19;

		if((x != lx) || (y != ly)) {		// Cursor has moved
			poke(W_BASE, C_offset, C_value);
			C_value = peek(W_BASE, C_offset = (((y*80)+x)*2)+1);
			poke(W_BASE, C_offset, C_value1 = (C_value << 4) | (C_value >> 4));
			C_step =  0;
			C_timer = TICK;
			lx = x;
			ly = y;
			continue; }

		if(x = wtstc()) {
			poke(W_BASE, C_offset, C_value);
			return x; }

		if(b) {							// Buttom pressed
			poke(W_BASE, C_offset, C_value1);
			switch(flag) {
			case 0xFF : continue;		// Expired
			case 0 :					// First click
				X = lx;
				Y = ly;
				t = TICK;
				flag = b;
				continue; }
			if(C_Hold) {
				if((TICK-t) > C_Hold) {		// Tap and hold expired
					flag = 0xFF;
					if((abs(lx-X) < 2) && (ly == Y)) {
						poke(W_BASE, C_offset, C_value);
						return 0xFF02; } } }
			continue; }

		switch(flag) {
		default:
			if((abs(lx-X) < 2) && (ly == Y) && (flag != 0xFF)) {
				b = flag;
				poke(W_BASE, C_offset, C_value);
				flag = 0;
				return (b == 2) ? 0xFF02 : 0xFF01; }
		case 0xFF : flag = 0;
		case 0x00 : }

		if((TICK - C_timer) > 5) {
			if(C_Hold)
				poke(W_BASE, C_offset, C_value);
			else
				poke(W_BASE, C_offset, (++C_step & 1) ? C_value : C_value1);
			C_timer = TICK; }
	}
}

/*
 * Display a message box (formatted output).
 */
register message(unsigned args)
{
	unsigned x, y, l, c;
	unsigned char temp[80];
	l = _format_(nargs() * 2 + &args, temp) + 2;
	x = (Width - l) / 2;
	wopen(x, y = (Height/2) - 2, l, 3, WSAVE|WCOPEN|0x4E);
	wcursor_off();
	wgotoxy(1, 1); wputs(temp);
	for(;;) switch(c = mouse_status()) {
	case 0xFF01 :
	case 0xFF02 :
		if((X >= x) && (X < (x+l)) && (Y >= y) && (Y < (y+3))) {
	case 0x1B :
		wclose();
		return c; } }
}

/*
 * Display a Yes/No prompt box (formatted output)
 */
register yesno(unsigned args)
{
	unsigned x, y, l;
	unsigned char temp[80];
	if((l = _format_(nargs() * 2 + &args, temp) + 2) < 13)
		l = 13;
	x = (Width - l) / 2;
	wopen(x, y = (Height/2) - 3, l, 5, WSAVE|WCOPEN|0x70);
	wcursor_off();
	wgotoxy(1, 1); wputs(temp);
	*W_OPEN = 0x07;
	wgotoxy(1, 3); wputs(" YES ");
	wgotoxy(8, 3); wputs(" NO ");
	for(;;) switch(mouse_status()) {
	case 0xFF01 :
	case 0xFF02 :
		if(Y == (y+3)) {
			if((X >= (x+1)) && (X <= (x+5))) {
	case '\n' :
				wclose();
				return -1; }
		if((X >= (x+8)) && (X <= (x+11))) {
	case 0x1B :
				wclose();
				return 0; } } }
}

/*
 * Process a menu:
 *
 * Input:
 *	x		= base x coordinate
 *	y		= base y coordinate
 *	w		= Width of window
 *	h		= Maximum height of window
 *	color	= Window colors
 *	menu 	= List of menu items to present on title bar
 *	func	= size of list, -1 == zero terminated char list
 *	items	= &function call for display, or zero term char list (if func==-1)
 * Returns:
 *	FFFF	= 'X' selected by tap
 *	FEFF	= 'X' selected by tap and hold
 *  FFnn	= Menu item 'n' selected by tap
 *  xxnn	= Item 'n' selected at offset 'x' by tap
 *	8xnn	= Item 'n' selected at offset 'x' by tab-and-hold
 */
unsigned pen_menu(unsigned x, unsigned y, unsigned w, unsigned h,
	unsigned color, unsigned char menu[], unsigned func, unsigned char *items[])
{
	unsigned c, i, j, k, l, position, last, cx, cy, hh;
	unsigned char *p, rev, f;

	rev = (color >> 4) | (color << 4);
	if((l = func) == -1)
		for(l=0; items[l]; ++l);	// Determine # items
	if(l < h) h = l;
	last = l - h;
	wopen(x, y, w--, h+1, color);
	*W_OPEN = rev;
	position = f = 0;
	hh = (h+1) / 2;
redraw_all:
	wcursor_off();
	if(!f) {
		wgotoxy(0, 0);
		if(C_left) wputs("  ");
		p = menu; while(c = *p++) {
			if(c != '|')
				wputc(c); }
		wcleol(); }
redraw:
	if(f) {
		wgotoxy(0, 0); wputs("  ");
		wprintf("%u-%u of %u", position+1, position+h, l);
		wcleol(); }
	if(h) { wgotoxy(0, 1); *W_OPEN = color; /* wcleow(); */ }
//	j = C_left && 1;
//	k = C_left ? 0 : w;
	for(i=0; i < h; ++i) {
		wgotoxy(0, i+1);
		wcleol();
		if(C_left && (h < l)) {
			*W_OPEN = rev;
			wputc(' ');
			*W_OPEN = color; }
		if(func != -1) {
			position+i;
			asm {
				PUSH	AX
				SAL		AX,1
				MOV		BX,4[BP]
				CALL	BX
				POP		AX
			} } else wputs(items[position+i]);
		if((h < l) && !C_left) {
			wgotoxy(w, i+1);
			*W_OPEN = rev;
			wputc(' ');
			*W_OPEN = color; } }
	*W_OPEN = rev;
	wgotoxy(k = C_left ? 0 : w, 0);	wputc('X');
	if(h < l) {
		wgotoxy(k, 1);	wputc(0x1E);
		wgotoxy(k, h);	wputc(0x1F);
		if(h > 2) { wgotoxy(k, hh);		wputc('_'); } }
	for(;;) switch(c = mouse_status()) {
	default: continue;
	case 0x001B :	wclose(); return 0xFFFF;
	case _KUA :	c = 0xFF01; cy = 1; goto domove;
	case _KHO : c = 0xFF02; cy = 1; goto domove;
	case _KDA : c = 0xFF01; cy = h; goto domove;
	case _KEN : c = 0xFF02; cy = h; goto domove;
	case _KPU : cy = 2;				goto domove;
	case _KPD : cy = h-1;			goto domove;
	case 0xFF01 :		// Left click
	case 0xFF02 :		// Right click
		cx = X - x;
		cy = Y - y;
		if((cx > w) || (cy > h))		// Out of bounds
			continue;
		if(!cy) {						// Title bar
			if(cx == k) {				// Exit
				wclose();
				return (c == 0xFF02) ? 0xFEFF : 0xFFFF; }
		toggle_f:
			if(f) { f = 0; goto redraw_all; }
			if(c == 0xFF02) { f = 255; goto redraw_all; }
			if(C_left) cx -= 2;
			for(i=j=0; menu[i]; ++i) {
				if(menu[i] == '|') break;
				if(menu[i] == ' ') { ++j; continue; }
				if(i == cx) {
					wclose();
					return 0xFF00 + j; } }
			continue; }
		if((cx == k) && (h < l)) {		// Movement bar
domove:		if(cy == 1) {
				if(c == 0xFF02) { position = 0; goto redraw; }
				if(position) --position; goto redraw; }
			if(cy == h) {
				if(c == 0xFF02) { position = last; goto redraw; }
				if(position < last) ++position; goto redraw; }
			if(c == 0xFF02) goto toggle_f;
			if(cy <= hh) {
				position = (position > h) ? position-h : 0; goto redraw; }
			if(cy > hh) {
				position = ((position+h) < last) ? position+h : last;
				goto redraw; }
			message("%u-%u of %u", position+1, position+h, l);
			continue; }
		if(c == 0xFF02) position += 0x8000;
		wclose();
		return (cy-1) + position; }
}

/*
 * Text entry box
 */
unsigned input(unsigned char *prompt, unsigned char *dest, unsigned length)
{
	unsigned
		i,				// General int.
		x,				// x position of window
		y,				// y position of window
		w,				// width of window
		c,				// Input character
		width,			// width of display line
		line,			// Current length of line
		base,			// Starting position of display
		end,			// Ending position of display
		position;		// Current position
	unsigned char
		expand,			// Indicate line exceeds display
		rep,			// Reposition required flag
		temp[80];		// Temporary working buffer
	static unsigned char Ins;

	expand = base = rep = position = 0;
	strcpy(temp, dest);
	// Determine best window width
	w = line = strlen(temp);
	if(length > w) x = length;
	if(w < 32) w = 23;
	if((w += 2) > Width) { expand = 255; w = Width; }
	wopen(x = (Width-w)/2, y = (Height/2) - 4, w, 7, WSAVE|WCOPEN|0x70);
	wgotoxy(1, 1); wputs(prompt);
	width = (length < w) ? length : (w - 2);
	--w;
	*W_OPEN = 0x07;
//	012345678901234567890123456789
//   _OK_  _CANCEL_  _CLEAR_
	wgotoxy(1, 5); wputs(" OK ");
	wgotoxy(7, 5); wputs(" CANCEL ");
	wgotoxy(17,5); wputs(" CLEAR ");
redraw:
	if((base + width) >= line)
		base = (line > width) ? (line - width) : 0;
redraw1:
	end = base + width;
	*W_OPEN = 0x07;
	wgotoxy(1, 3);
	for(i=line=0; i <= length; ++i) {	// EOL fix
		c = temp[line] ? temp[line++] : ' ';
		if((i >= base) && (i < end))
			wputc(c); }
	*W_OPEN = 0x70;
	wgotoxy(0, 3); wputc(base ? 0x11 : 0x1B);
	wgotoxy(w, 3); wputc(((base+width) < line) ? 0x10 : 0x1A);

reposition:
	if(position > line) position = line;
	if((position >= base) && (position < end)) {		// On screen
		wgotoxy((position-base)+1, 3);
		(Ins) ? wcursor_block() : wcursor_line(); }
	else {
		if(c = rep) {
			rep = 0;
			base = (position < base) ? position : (position - width) + 1;
			if((position < length) && (c == 15)) goto redraw1;	// EOL fix
			goto redraw; }
		wcursor_off(); }
recmd:
	switch(c = mouse_status()) {
	case 0xFF02 : c=0;	// Tap-Hold
	case 0xFF01 :		// Tap
		if(Y == (y+5)) {		// Command bar
			if( (X >= (x+1)) && (X <= (x+4)) ) {			// Ok
	case '\n' :
				strcpy(dest, temp);
				wclose(); return -1; }
			if( (X >= (x+7)) && (X <= (x+14)) ) {			// Cancel
	case 0x1B :
				wclose(); return 0; }
			if( (X >= (x+17)) && (X <= (x+23)) ) {			// Clear
				temp[position=base=line=0] = 0; goto redraw; }
			goto recmd; }
		if(Y == (y+3)) {									// Set position
			i = x + w;
			if((X < x) || (X > i)) goto recmd;
			if(X == x) {			// left arrow
				if(base && c) { --base; goto redraw; }
				goto XHOME; }
			if(X == i) {			// Right arrow
				if(((base + width) < line) && c) { ++base; goto redraw; }
				goto XEND; }
			position = (X - (x+1)) + base; rep = 255;
			goto reposition; }
		goto recmd;
	case _KIN : Ins = Ins ? 0 : 255; goto repo;
	case _KLA : if(position) --position; goto repo;
	case _KRA : if(position < line) ++position; goto repo;
	case _KHO :	XHOME: position = 0; goto repo;
	case _KEN :	XEND: position = line;
	repo:		rep = 255;
				goto reposition;
	case _KBS : if(!position) goto recmd;
		--position;
	case _KDL :
		for(i=position; i < line; ++i)
			temp[i] = temp[i+1];
		rep = 255;
		goto redraw; }

	if((c & 0xFF00) || (c < ' ')) goto recmd;
	if(position < length) {
		if(Ins) {
			for(i=length; i > position; --i)
				temp[i] = temp[i-1]; }
		if(!temp[position])
			temp[position+1] = 0;
		temp[position++] = c;
		temp[length] = 0;
		rep = 15; }
	goto redraw;
}
