;
; Sample NorthStar DOS I/O drivers for my VECTOR 1+ which
; has a Processor Technology 3P+S serial board, addressed as:
;
;  00	= Console Status  B7=TxReady  B6=RxReady  B5-0=Unused
;  01	= Console Data
;
; First - ORG to the I/O vector addresses within NorthStar DOS,
; and Patch in jumps to our routines
	ORG	200Dh
	JP	COUT		; Jump to console output
	JP	CIN		; Jump to console input
	JP	TINIT		; Jump to system init
	JP	CONTC		; Jump to control C
;
; Next - ORG to the I/O space, and provide the actual functions
;
	ORG	2900h
;
; Read character from console & return it in A
; - May only modify register A.
;
; NOTE: N*DOS passes the device number to read in A, however for
;	these simple "bootstrap" I/O functions, we will ignore it
;	and implement only the console (Device 0).
;
CIN:	IN	A,(0)		; Read console status
	AND	40h		; Is receiver ready?
	JR	Z,CIN		; No, wait for it
CIN1:	IN	A,(1)		; Read data
	AND	7Fh		; Remove parity (if present)
	CP	'A'		; Lower case?
	JR	C,CIN2		; Yes - it's OK
	AND	5Fh		; convert to upper
CIN2:	CP	3		; Set 'Z' if control-C
	RET
;
; Write character in B to console
; - May only modify A (which must return character from B)
;
; NOTE: N*DOS passes the device number to write in A, however for
;	these simple "bootstrap" I/O functions, we will ignore it
;	and implement only the console (Device 0).
;
COUT:	IN	A,(0)		; Read console status
	RLA			; C = bit-8
	JR	NC,COUT		; Not ready to TX
	LD	A,B		; Get valueto write
	OUT	(1),A		; Send to console
	RET
;
; Test for control-C at the console
; - If character found, return with caracter in A, and Z
;   set if it was Control-C
; - May modify only A
;
CONTC:	IN	A,(0)		; Read console status
	AND	40h		; Is receiver ready?
	JR	NZ,CIN1		; Yes, get and test
	OR	0FFh		; Clear 'Z', return no char
	RET
;
; The 3P+S card in the Vector requires no initialization, so the
; 'TINIT' function is just a RETURN - this is where you would
; perform any hardware initialization required by your system.
;
TINIT:	RET				; Do nothing
