;
; This is an example of a simulator command-option file (this simply
; contains command line options for the HORIZON simulator which are
; all processed as if they had been entered on the command line).
;
; This command-option file contains options to:
;
;  - Regulate CPU performance to approximate the real hardware.
;
;  - Pre-mount NorthStar 5.0 Double Density DOS on drive 1
;
;  - Auto 'G'o, booting the mounted disk
;
;  - Configure the virtual Horizon console uart (8251 at 2-3) to
;    communicate with the PC serial port at 9600 - This means that
;    the simulator will boot up and communicate with a REAL console
;    terminal attached to COM1.
;
;  - Configure the virtual Horizon AUX uart (8251 at 4-5) to
;    communicate with the PC keyboard/video display.
;
R=NSDOS50D                      ; Mount NSDOS50D as ReadOnly #1
/G                              ; Auto-Go
/P                              ; Regulate CPU performance

;
; Set up Horizon I/O ports: I|O <address> <type> <options...>
;  type 1 = Video/Keyboard status       2 = Video/Keyboard data
;       3 = COM port status/control     4 = COM/Parallel data
;       5 = Virtual file status         6 = Virtual file data
;       7 = Ignore
; In this case, we will reverse the normal configuration,
; and setup the console on PC COM1, and the AUX port on
; the screen/keyboard
;
; The 'S' type simply sets up the PC COM port with the specified parameters
P=S 3F8 9600 N81                ; 9600 BPS, NoParity, 8-data, 1-stop bit

; Console 8251 Uart data ports simply read/write the PC uart data port
P=I 02 4 3F8                    ; Console data (COM1)
P=O 02 4 3F8                    ; Console data (COM1)

; For 8251 status, we begin with zero, and toggle appropriate
; bits to translate the PC COM status into the 8251 status register
; (See HORIZON online-help)
P=I 03 3 3F8 00 05 02 00 20 08 10 80    ; Console status (COM 1)

; For 8251 control, we translate DTR+RTS into PC DTR+RTS
P=O 03 3 3F8 00 02 20           ; Console control (COM 1)

; Aux 8251 Uart data port simply reads/write PC keyboard/video
P=I 04 2                        ; AUX data
P=O 04 2                        ; AUX data

; Aux 8251 status, here we begin with 5 (TXrdy), and implement
; only the RX-Ready bit for Keyboard data ready.
P=I 05 1 5 2                    ; AUX status
; The are no controllable options on the keyboard/video.
P=O 05 1                        ; AUX control (ignore)

;
; The following are Horizon I/O ports that we simply want to ignore
; in the simulation.
P=O 00 7                        ; Parallel output
P=I 00 7 0                      ; Parallel input (return 0)
P=O 01 7                        ; mirror of Parallel output
P=I 01 7 0                      ; mirror Parallel input (return 0)
P=O 06 7                        ; Main board control (ignore)
P=I 06 7 0                      ; Main board status (return 0)
P=O 07 7                        ; mirror of Main board control (ignore)
P=I 07 7 0                      ; mirror of Main board status (return 0)
P=O C0 7                        ; RAM control
