;
; Dunfield MicroScope - Target Kernel for: 68HC08
;
; Copyright 2001-2005 Dave Dunfield - All rights reserved.
;
; ** Untested **
;
ROM	EQU	$6E00		; Code goes here
RAM	EQU	$0080		; Data goes here
STACK	EQU	RAM+$1F		; Stack goes here
; Command codes from host to target monitor
CQUERY	EQU	$A0		; Query command
CBREAK	EQU	$A1		; Break command
CEXEC	EQU	$A2		; Execute command
CSTEP	EQU	$A3		; Single-step command
CREAD	EQU	$B0		; Read Program memory
CWRITE	EQU	$B8		; Write program memory
; Response codes from target monitor to host
RESP1	EQU	$AA		; Query response 1
RESP2	EQU	$55		; Query response 2
BRKF1	EQU	$90		; Break leadin-1
BRKF2	EQU	$A5		; Break leadin-2
BRKF3	EQU	$B9		; Break leadin-3
KID	EQU	$6811		; Kernel ID
;
SCC1	EQU	$0013		; SCI control 1
SCC2	EQU	$0014		; SCI control 2
SCC3	EQU	$0015		; SCI control 3
SCS1	EQU	$0016		; SCI status 1
SCS2	EQU	$0017		; SCI status 2
SCDR	EQU	$0018		; SCI data
SCBR	EQU	$0019		; SCI baudrate
;
	ORG	ROM
RESET:	LDHX	#STACK		; Set initial stack
	TXS			; Set it up
	MOV	#$40,SCC1	; SCI: Enable, 8 bits, No parity
	MOV	#$0C,SCC2	; SCI: No interrupts
	CLR	SCC3		; SCI: No DMA
	MOV	#$03,SCBR	; SCI: Set baud rate
; Loop, reading data till it times out
flush:	BSR	getchr		; Get data
	BRA	flush		; till timeout
;
; Software interrupt handler
;
SWIHND:	LDX	#1		; Adjust by 1 for breakpoint
	LDA	#BRKF1		; Breakpoint response 1
	BSR	wrchr		; Send it
	LDA	#BRKF2		; Breakpoint response 2
	BSR	wrchr		; Send it
	LDA	#BRKF3		; Breakpoint response 3
	BSR	wrchr		; Send it
	TXA			; Get adjust
	BSR	wrchr		; Send it
; Send 68HC08 registers to host
	PULA			; Get CC
	BSR	wrchr		; Send to host
	PULA			; Get A
	BSR	wrchr		; Send A to host
	PSHH			; Get H
	PULA			; Into A
	BSR	wrchr		; Send H to host
	PULA			; Get X
	BSR	wrchr		; Send X to host
	PULA			; Get PCH
	BSR	wrchr		; Send PCH to host
	PULA			; Get PCL
	BSR	wrchr		; Send PCL to host
	TSX			; Get stack
	AIX	#-1		; Adjust for TSX +1
	PSHH			; Get H (SP high)
	PULA			; Into A
	BSR	wrchr		; Send SPH to host
	TXA			; Get X (SP low)
	BSR	wrchr		; Send SPL to host
	BRA	main		; re-enter monitor
;
; Write character to serial port
;
WRCHR	BRCLR	7,SCS1,wrchr	; Wait for TX ready
	STA	SCDR		; Write to SCI
	RTS
;
; Get an address into H:X
;
getaddr	BSR	getchr		; Read LOW
	TAX			; Set LOW byte
	BSR	getchr		; Read HIGH
	PSHA			; Stack
	PULH			; Set HIGH byte
	RTS
;
; Get a character from the serial port with timeout
; Re-enter monitor if timeout
;
getchr	PSHX			; Save X
	PSHH			; Save H
	LDHX	#0		; Initial timeout value
getch1:	BRCLR	5,SCS1,getch2	; Not ready yet
	LDA	SCDR		; Read SCI data register
	PULH			; Restore H
	PULX			; Restore X
	RTS
getch2:	AIX	#-1		; Decrement count
	CPHX	#0		; End of count
	BNE	getch1		; No, try next
;
; Main monitor command loop
;
main:	LDHX	#STACK		; Reset stack...
	TXS			; incase restart
main1:	BSR	getchr		; Get command
	CBEQA	#CQUERY,query	; Handle query
	CBEQA	#CREAD,mread	; Handle memory read
	CBEQA	#CWRITE,mwrite	; Handle memory write
	CBEQA	#CBREAK,break	; Handle breakpoint
	CBEQA	#CEXEC,exec	; Handle execute
	BRA	main		; Unknown - ignore
;
; Query command
;
query:	LDHX	#QRESP		; Point to response
qloop	LDA	,X		; Read data byte
	BEQ	main1		; End, exit
	BSR	wrchr		; Send to host
	AIX	#1		; Skip to next
	BRA	qloop		; Do them all
qresp:	FCB	RESP1,RESP2,=KID,KID,1,0
;
; Read memory
;
mread:	BSR	getaddr		; Get address into H:X
	BSR	getchr		; Get size
mread1:	PSHA			; Save size
	LDA	,X		; Read memory
	BSR	wrchr		; Write it
	AIX	#1		; Skip to next
	PULA			; Restore size
	DBNZA	mread1		; Do them all
	BRA	main		; And exit
;
; Write memory
;
mwrite:	BSR	getaddr		; Get address into H:X
	BSR	getchr		; Get size
mwrit1:	PSHA			; Save size
	BSR	getchr		; Read data byte
	STA	,X		; Write to memory
	PULA			; Restore size
	DBNZA	mwrit1		; Do them all
	BRA	main		; And exit
;
; Set a breakpoint
;
break:	BSR	getaddr		; Get address into H:X
	LDA	,X		; Read current content
	BSR	wrchr		; Send to host
	LDA	#$83		; 'SWI' = breakpoint
	STA	,X		; Write to memory
	SUB	,X		; Test for success
	BSR	wrchr		; Write it
	BRA	main		; And exit
;
; Execute program
;
exec:	BSR	getaddr		; Get stack
	AIX	#1		; Adjust for TXS -1
	TXS			; Set stack pointer
; Load 68HC08 registers from host
	BSR	getchr		; Get PCL
	PSHA			; Stack PCL for RTI
	BSR	getchr		; Get PCH
	PSHA			; Stack PCL for RTI
	BSR	getchr		; Get X
	PSHA			; Stack X for RTI
	BSR	getchr		; Get H
	PSHA			; Stack for xfer to H
	PULH			; Set H before transfer
	BSR	getchr		; Get A
	PSHA			; Stack A for RTI
	BSR	getchr		; Get CC
	PSHA			; Stack CC for RTI
	RTI
;
; Any interrupt vectors required by the user program must be added here
;
	ORG	$FF00		; Beginning of vector table
; SWI and RESET are used by DMS kernel
	ORG	$FFFC
	FDB	SWIHND		; Breakpoint handler
	FDB	RESET		; Reset vector
