;
; This is a SMALL "dumb" bootloader - it simply copyis 256 bytes from a
; system serial port to memory and jumps there
;
; It is "simple and small" as this will have to be manually entered and
; executed by Altair front panel
;
; I place it at $3000 in memory as that just above where NorthStar DOS goes,
; is easy to set up on the switches, and leaves lots of memory for user code.
;
; Note - there is NO error detection.
; If a "garbage" byte happens to be in the UART before you send the 2nd space
; bootloaded code - it won't load correctly.
; It's a good idea to toggle this in, RUN at $3000 - STOP and RUN at $3000
; This will clear the UART
USTAT	EQU	$08		Uart STATUS port
UDATA	EQU	$09		Uart DATA port
;
	ORG	$3000
; The MITS serial board does not require initial setup
; Mine is jumpered in hardware for 9600bps, 8-Data, 1-stop bits and NO PAITY
; If your UART requires initialzation - do it HERE
	LXI	H,*+256		Initial Load address
x1	IN	USTAT		Read status
	ANI	$01		Byte ready?
	JZ	x1		No, wait
	IN	UDATA		Read byte
	MOV	M,A		Write
	INR	L		256 bytes
	JNZ	x1		More
; 2nd state bit MUST be ORGed exactly 250 bytes above ($3100 in this case)
	PCHL			Execute
